/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.WindowTableFunctionHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.RowKind;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001E\u0011adV5oI><H+\u00192mK\u001a+hn\u0019;j_:D\u0015M\u001d8fgN$Vm\u001d;\u000b\u0005\r!\u0011a\u00025be:,7o\u001d\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u001f!\u000b'O\\3tgR+7\u000f\u001e\"bg\u0016D\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\bE\u0006\u001c7.\u001a8e!\tIrF\u0004\u0002\u001bY9\u00111D\u000b\b\u00039%r!!\b\u0015\u000f\u0005y9cBA\u0010'\u001d\t\u0001SE\u0004\u0002\"I5\t!E\u0003\u0002$!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002,\t\u0005)Q\u000f^5mg&\u0011QFL\u0001\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/\u001a\u0006\u0003W\u0011I!\u0001M\u0019\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'BA\u0017/\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014!D:iS\u001a$H+[7f5>tW\r\u0005\u00026u5\taG\u0003\u00028q\u0005!A/[7f\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\ri{g.Z%e\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q\u0019q\bQ!\u0011\u0005M\u0001\u0001\"B\f=\u0001\u0004A\u0002\"B\u001a=\u0001\u0004!\u0004bB\"\u0001\u0005\u0004%I\u0001R\u0001\f+R\u001buLW(O\u000b~KE)F\u00015\u0011\u00191\u0005\u0001)A\u0005i\u0005aQ\u000bV\"`5>sUiX%EA!9\u0001\n\u0001b\u0001\n\u0013I\u0015\u0001C1tg\u0016\u0014Ho\u001c:\u0016\u0003)\u0003\"aS(\u000e\u00031S!!\u0014(\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b!I!\u0001\u0015'\u0003-I{w\u000fR1uC\"\u000b'O\\3tg\u0006\u001b8/\u001a:u_JDaA\u0015\u0001!\u0002\u0013Q\u0015!C1tg\u0016\u0014Ho\u001c:!\u0011\u0015!\u0006\u0001\"\u0011V\u0003\u0019\u0011WMZ8sKR\ta\u000b\u0005\u0002X56\t\u0001LC\u0001Z\u0003\u0015\u00198-\u00197b\u0013\tY\u0006L\u0001\u0003V]&$\bFA*^!\tqV-D\u0001`\u0015\t\u0001\u0017-A\u0002ba&T!AY2\u0002\u000f),\b/\u001b;fe*\u0011AMD\u0001\u0006UVt\u0017\u000e^\u0005\u0003M~\u0013!BQ3g_J,W)Y2i\u0011\u0015A\u0007\u0001\"\u0001V\u0003y!Xm\u001d;Qe>\u001cWm]:j]\u001e$\u0016.\\3Uk6\u0014G.Z,j]\u0012|w\u000f\u000b\u0002hUB\u0011al[\u0005\u0003Y~\u0013A\u0002V3tiR+W\u000e\u001d7bi\u0016DQA\u001c\u0001\u0005\u0002U\u000b1\u0004^3tiB\u0013xnY3tg&tw\rV5nK\"{\u0007oV5oI><\bFA7k\u0011\u0015\t\b\u0001\"\u0001V\u0003\u0001\"Xm\u001d;Qe>\u001cWm]:j]\u001e$\u0016.\\3Dk6,H.\u0019;f/&tGm\\<)\u0005AT\u0007\"\u0002;\u0001\t\u0013)\u0018AC5oO\u0016\u001cH\u000fR1uCR\u0011aK\u001e\u0005\u0006oN\u0004\r\u0001_\u0001\fi\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0003z{~|X\"\u0001>\u000b\u00055[(B\u0001?\u000b\u0003%\u0019HO]3b[&tw-\u0003\u0002\u007fu\n\tsJ\\3J]B,Ho\u0015;sK\u0006lw\n]3sCR|'\u000fV3ti\"\u000b'O\\3tgB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006!\tA\u0001Z1uC&!\u0011\u0011BA\u0002\u0005\u001d\u0011vn\u001e#bi\u0006Dq!!\u0004\u0001\t\u0013\ty!\u0001\u0004sK\u000e|'\u000f\u001a\u000b\u0005\u0003#\ty\u0002E\u0003\u0002\u0014\u0005mq0\u0004\u0002\u0002\u0016)!\u0011qCA\r\u00031\u0019HO]3b[J,7m\u001c:e\u0015\t)10\u0003\u0003\u0002\u001e\u0005U!\u0001D*ue\u0016\fWNU3d_J$\u0007\u0002CA\u0011\u0003\u0017\u0001\r!a\t\u0002\t\u0005\u0014xm\u001d\t\u0006/\u0006\u0015\u0012\u0011F\u0005\u0004\u0003OA&A\u0003\u001fsKB,\u0017\r^3e}A\u0019q+a\u000b\n\u0007\u00055\u0002LA\u0002B]fDq!!\r\u0001\t\u0013\t\u0019$\u0001\u0006m_\u000e\fG.T5mYN$B!!\u000e\u0002<A!\u0011\u0011AA\u001c\u0013\u0011\tI$a\u0001\u0003\u001bQKW.Z:uC6\u0004H)\u0019;b\u0011!\ti$a\fA\u0002\u0005}\u0012\u0001\u00033bi\u0016$\u0016.\\3\u0011\t\u0005\u0005\u0013\u0011\n\b\u0005\u0003\u0007\n)\u0005\u0005\u0002\"1&\u0019\u0011q\t-\u0002\rA\u0013X\rZ3g\u0013\u0011\tY%!\u0014\u0003\rM#(/\u001b8h\u0015\r\t9\u0005\u0017\u0005\b\u0003#\u0002A\u0011BA*\u0003\u0015i\u0017\u000e\u001c7t)\u0011\t)$!\u0016\t\u0011\u0005u\u0012q\na\u0001\u0003\u007fAs\u0001AA-\u0003K\n9\u0007\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\tyfX\u0001\nKb$XM\\:j_:LA!a\u0019\u0002^\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005%4EAA6!\u0011\ti'! \u000e\u0005\u0005=$\u0002BA9\u0003g\nQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BA;\u0003o\n!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\r!\u0017\u0011\u0010\u0006\u0004\u0003wR\u0011!\u0003;fgR,H/\u001b7t\u0013\u0011\ty(a\u001c\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\b\u000f\u0005\r%\u0001#\u0001\u0002\u0006\u0006qr+\u001b8e_^$\u0016M\u00197f\rVt7\r^5p]\"\u000b'O\\3tgR+7\u000f\u001e\t\u0004'\u0005\u001deAB\u0001\u0003\u0011\u0003\tIi\u0005\u0003\u0002\b\u0006-\u0005cA,\u0002\u000e&\u0019\u0011q\u0012-\u0003\r\u0005s\u0017PU3g\u0011\u001di\u0014q\u0011C\u0001\u0003'#\"!!\"\t\u0011\u0005]\u0015q\u0011C\u0001\u00033\u000b!\u0002]1sC6,G/\u001a:t)\t\tY\n\u0005\u0004\u0002\u001e\u0006\u0005\u0016QU\u0007\u0003\u0003?S!!\u0014\u001d\n\t\u0005\r\u0016q\u0014\u0002\u000b\u0007>dG.Z2uS>t\u0007#B,\u0002(\u0006-\u0016bAAU1\n)\u0011I\u001d:bsB!\u0011QVAZ\u001b\t\tyKC\u0002\u00022b\nA\u0001\\1oO&!\u0011QWAX\u0005\u0019y%M[3di\"B\u0011QSA]\u0003\u007f\u000b\t\r\u0005\u0003\u0002n\u0005m\u0016\u0002BA_\u0003_\u0012!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005\r\u0017AH*uCR,')Y2lK:$Wh\u001f\u0019~Y\u0001\"\u0016.\\3[_:,Wh_\u0019~\u0001")
public class WindowTableFunctionHarnessTest
extends HarnessTestBase {
    private final ZoneId shiftTimeZone;
    private final ZoneId UTC_ZONE_ID;
    private final RowDataHarnessAssertor assertor;

    @Parameters(name="StateBackend={0}, TimeZone={1}")
    public static Collection<Object[]> parameters() {
        return WindowTableFunctionHarnessTest$.MODULE$.parameters();
    }

    private ZoneId UTC_ZONE_ID() {
        return this.UTC_ZONE_ID;
    }

    private RowDataHarnessAssertor assertor() {
        return this.assertor;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().getConfig().setLocalTimeZone(this.shiftTimeZone);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(551).append("\n                       |CREATE TABLE T1 (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `double` DOUBLE,\n                       | `float` FLOAT,\n                       | `bigdec` DECIMAL(10, 2),\n                       | `string` STRING,\n                       | `name` STRING,\n                       | proctime AS PROCTIME()\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testProcessingTimeTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE T1, DESCRIPTOR(proctime), INTERVAL '5' SECOND))\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createHarnessTesterForNoState(package$.MODULE$.tableConversions(t1).toDataStream(), "WindowTableFunction");
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20"), this.mills("1970-01-01T00:00:19.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        this.assertor().assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    @TestTemplate
    public void testProcessingTimeHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM TABLE(\n        |  HOP(TABLE T1, DESCRIPTOR(proctime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createHarnessTesterForNoState(package$.MODULE$.tableConversions(t1).toDataStream(), "WindowTableFunction");
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:10"), this.localMills("1970-01-01T00:00:20"), this.mills("1970-01-01T00:00:19.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25"), this.mills("1970-01-01T00:00:24.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:25"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:25"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        this.assertor().assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    @TestTemplate
    public void testProcessingTimeCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM TABLE(\n        |  CUMULATE(TABLE T1, DESCRIPTOR(proctime), INTERVAL '5' SECOND, INTERVAL '15' SECOND))\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createHarnessTesterForNoState(package$.MODULE$.tableConversions(t1).toDataStream(), "WindowTableFunction");
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20"), this.mills("1970-01-01T00:00:19.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25"), this.mills("1970-01-01T00:00:24.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:30"), this.mills("1970-01-01T00:00:29.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:45"), this.mills("1970-01-01T00:00:44.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:45"), this.mills("1970-01-01T00:00:44.999")})));
        this.assertor().assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    private void ingestData(OneInputStreamOperatorTestHarness<RowData, RowData> testHarness) {
        testHarness.setProcessingTime(1000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null})));
        testHarness.setProcessingTime(2000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(3000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(4000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null})));
        testHarness.setProcessingTime(6000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null})));
        testHarness.setProcessingTime(7000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null})));
        testHarness.setProcessingTime(8000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null})));
        testHarness.setProcessingTime(16000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null})));
        testHarness.setProcessingTime(32000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null})));
        testHarness.setProcessingTime(34000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(50000L);
    }

    private StreamRecord<RowData> record(Seq<Object> args) {
        Object[] objs = (Object[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object2);
                object = BoxesRunTime.boxToLong((long)l);
            } else if (object2 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object2);
                object = BoxesRunTime.boxToDouble((double)d);
            } else {
                object = object2;
            }
            return object;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
        return StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])objs);
    }

    private TimestampData localMills(String dateTime) {
        ZonedDateTime windowDateTime = LocalDateTime.parse(dateTime).atZone(this.UTC_ZONE_ID());
        return TimestampData.fromEpochMillis((long)TimeWindowUtil.toUtcTimestampMills((long)windowDateTime.toInstant().toEpochMilli(), (ZoneId)this.shiftTimeZone));
    }

    private TimestampData mills(String dateTime) {
        ZonedDateTime windowDateTime = LocalDateTime.parse(dateTime).atZone(this.UTC_ZONE_ID());
        return TimestampData.fromEpochMillis((long)windowDateTime.toInstant().toEpochMilli());
    }

    public WindowTableFunctionHarnessTest(StreamingWithStateTestBase.StateBackendMode backend, ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        super(backend);
        this.UTC_ZONE_ID = ZoneId.of("UTC");
        this.assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType()}));
    }
}

