/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.runtime.stream.FiniteTestSource;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=240L, unit=TimeUnit.SECONDS)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g!B\u0001\u0003\u0003\u0003\t\"!\u0007$t'R\u0014X-Y7j]\u001e\u001c\u0016N\\6J)\u000e\u000b7/\u001a\"bg\u0016T!a\u0001\u0003\u0002\rM$(/Z1n\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011%q\u0002\u00011AA\u0002\u0013Eq$\u0001\u0006sKN,H\u000e\u001e)bi\",\u0012\u0001\t\t\u0003C)r!A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\u0002\u0012A\u0002\u001fs_>$hHC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIc%\u0001\u0004Qe\u0016$WMZ\u0005\u0003W1\u0012aa\u0015;sS:<'BA\u0015'\u0011%q\u0003\u00011AA\u0002\u0013Eq&\u0001\bsKN,H\u000e\u001e)bi\"|F%Z9\u0015\u0005A\"\u0004CA\u00193\u001b\u00051\u0013BA\u001a'\u0005\u0011)f.\u001b;\t\u000fUj\u0013\u0011!a\u0001A\u0005\u0019\u0001\u0010J\u0019\t\u0013]\u0002\u0001\u0019!A!B\u0013\u0001\u0013a\u0003:fgVdG\u000fU1uQ\u0002BQ!\u000f\u0001\u0005\u0002i\nqaZ3u\t\u0006$\u0018-F\u0001<!\ra\u0014\t\u0012\b\u0003{}r!a\t \n\u0003\u001dJ!\u0001\u0011\u0014\u0002\u000fA\f7m[1hK&\u0011!i\u0011\u0002\u0004'\u0016\f(B\u0001!'!\t)\u0005*D\u0001G\u0015\t9%\"A\u0003usB,7/\u0003\u0002J\r\n\u0019!k\\<\t\u000b-\u0003A\u0011\u0001'\u0002\u0011\u001d,G\u000fR1uCJ*\u0012!\u0014\t\u0004\u001dF#U\"A(\u000b\u0005A3\u0013AC2pY2,7\r^5p]&\u0011!i\u0014\u0005\u0006'\u0002!\t\u0005V\u0001\u0007E\u00164wN]3\u0015\u0003AB#A\u0015,\u0011\u0005]sV\"\u0001-\u000b\u0005eS\u0016aA1qS*\u00111\fX\u0001\bUV\u0004\u0018\u000e^3s\u0015\tif\"A\u0003kk:LG/\u0003\u0002`1\nQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000b\u0005\u0004A\u0011\u00012\u0002)\u0005$G-\u001b;j_:\fG\u000e\u0015:pa\u0016\u0014H/[3t)\u0005\u0019\u0007cA\u0019eA%\u0011QM\n\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006O\u0002!\t\u0001V\u0001\fi\u0016\u001cHOT8o!\u0006\u0014H\u000f\u000b\u0002gSB\u0011qK[\u0005\u0003Wb\u0013A\u0001V3ti\")Q\u000e\u0001C\u0001)\u0006AA/Z:u!\u0006\u0014H\u000f\u000b\u0002mS\")\u0001\u000f\u0001C\u0001)\u0006\u0019B/Z:u\u001b\u0016$\u0018m\u001d;pe\u0016\u0004v\u000e\\5ds\"\u0012q.\u001b\u0005\u0006g\u0002!\t\u0001^\u0001\u000fO\u0016$H)\u0019;b'R\u0014X-Y73)\t)X\u0010E\u0002ww\u0012k\u0011a\u001e\u0006\u0003OaT!!W=\u000b\u0005iT\u0011!C:ue\u0016\fW.\u001b8h\u0013\taxO\u0001\u0006ECR\f7\u000b\u001e:fC6DQA :A\u0002}\f1AZ;o!\u0019\t\u0014\u0011\u0001#\u0002\u0006%\u0019\u00111\u0001\u0014\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u0019\u0002\b%\u0019\u0011\u0011\u0002\u0014\u0003\t1{gn\u001a\u0005\u0007\u0003\u001b\u0001A\u0011\u0001+\u00025Q,7\u000f\u001e)beRLG/[8o/&$\bNQ1tS\u000e$\u0015\r^3)\u0007\u0005-\u0011\u000eC\u0004\u0002\u0014\u0001!\t!!\u0006\u0002\u001b\u001d,G\u000fR1uCN#(/Z1n)\r)\u0018q\u0003\u0005\u0007}\u0006E\u0001\u0019A@\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e\u0005iB/Z:u!\u0006\u0014H/\u001b;j_:\u001cUo\u001d;p[\u001a{'/\\1u\t\u0006$X\rF\u00031\u0003?\tI\u0003\u0003\u0005\u0002\"\u0005e\u0001\u0019AA\u0012\u0003%\u0001\u0018M\u001d;ji&|g\u000eE\u00022\u0003KI1!a\n'\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u000b\u0002\u001aA\u0005\t\u0019\u0001\u0011\u0002\rA|G.[2z\u0011\u001d\ty\u0003\u0001C\u0005\u0003c\tA\u0001^3tiR)\u0002'a\r\u00028\u0005m\u0012qHA\"\u0003\u000b\nI%!\u0014\u0002R\u0005M\u0003bBA\u001b\u0003[\u0001\r!^\u0001\u000bI\u0006$\u0018m\u0015;sK\u0006l\u0007bBA\u001d\u0003[\u0001\r\u0001I\u0001\u0012i&lW-\u0012=ue\u0006\u001cGo\u001c:LS:$\u0007bBA\u001f\u0003[\u0001\r\u0001I\u0001\u001ei&lW-\u0012=ue\u0006\u001cGo\u001c:G_Jl\u0017\r\u001e;feB\u000bG\u000f^3s]\"9\u0011\u0011IA\u0017\u0001\u0004\u0001\u0013\u0001\u0006;j[\u0016,\u0005\u0010\u001e:bGR|'\u000fU1ui\u0016\u0014h\u000eC\u0004\u0002\"\u00055\u0002\u0019\u0001\u0011\t\u000f\u0005\u001d\u0013Q\u0006a\u0001A\u0005i1m\\7nSR$&/[4hKJDq!a\u0013\u0002.\u0001\u0007\u0001%A\u0006d_6l\u0017\u000e\u001e#fY\u0006L\bbBA(\u0003[\u0001\raO\u0001\tI\u0006$\u0018\rV3ti\"I\u00111FA\u0017!\u0003\u0005\r\u0001\t\u0005\n\u0003+\ni\u0003%AA\u0002\u0001\nqb];dG\u0016\u001c8OR5mK:\u000bW.\u001a\u0005\b\u00033\u0002A\u0011AA.\u0003\u00199W\r\u001e#E\u0019R\t\u0002%!\u0018\u0002`\u0005\u0005\u00141MA3\u0003O\nI'a\u001b\t\u000f\u0005e\u0012q\u000ba\u0001A!9\u0011QHA,\u0001\u0004\u0001\u0003bBA!\u0003/\u0002\r\u0001\t\u0005\b\u0003C\t9\u00061\u0001!\u0011\u001d\t9%a\u0016A\u0002\u0001Bq!a\u0013\u0002X\u0001\u0007\u0001\u0005C\u0004\u0002,\u0005]\u0003\u0019\u0001\u0011\t\u000f\u0005U\u0013q\u000ba\u0001A!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0014!B2iK\u000e\\G#\u0002\u0019\u0002t\u0005]\u0004bBA;\u0003[\u0002\r\u0001I\u0001\tgFd\u0017+^3ss\"9\u0011\u0011PA7\u0001\u0004Y\u0014AD3ya\u0016\u001cG/\u001a3SKN,H\u000e\u001e\u0005\n\u0003{\u0002\u0011\u0013!C\u0001\u0003\u007f\nq\u0005^3tiB\u000b'\u000f^5uS>t7)^:u_64uN]7bi\u0012\u000bG/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0011\u0016\u0004A\u0005\r5FAAC!\u0011\t9)!%\u000e\u0005\u0005%%\u0002BAF\u0003\u001b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=e%\u0001\u0006b]:|G/\u0019;j_:LA!a%\u0002\n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005]\u0005!%A\u0005\n\u0005}\u0014A\u0004;fgR$C-\u001a4bk2$H%\u000f\u0005\n\u00037\u0003\u0011\u0013!C\u0005\u0003\u007f\nq\u0002^3ti\u0012\"WMZ1vYR$\u0013\u0007\r\u0015\f\u0001\u0005}\u0015QUAT\u0003S\u000bY\u000bE\u0002X\u0003CK1!a)Y\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\"\u0001\u0001y\u0002\tUt\u0017\u000e\u001e\u0013\u0003\u0003[KA!a,\u00022\u000691+R\"P\u001d\u0012\u001b&\u0002BAZ\u0003k\u000b\u0001\u0002V5nKVs\u0017\u000e\u001e\u0006\u0005\u0003o\u000bI,\u0001\u0006d_:\u001cWO\u001d:f]RTA!a/\u0002>\u0006!Q\u000f^5m\u0015\t\ty,\u0001\u0003kCZ\f\u0007")
public abstract class FsStreamingSinkITCaseBase
extends StreamingTestBase {
    private String resultPath;

    public String resultPath() {
        return this.resultPath;
    }

    public void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    public Seq<Row> getData() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{1, "a", "b", "05-03-2020", "07"}), Row.of((Object[])new Object[]{2, "p", "q", "05-03-2020", "08"}), Row.of((Object[])new Object[]{3, "x", "y", "05-03-2020", "09"}), Row.of((Object[])new Object[]{4, "x", "y", "05-03-2020", "10"}), Row.of((Object[])new Object[]{5, "x", "y", "05-03-2020", "11"})}));
    }

    public Seq<Row> getData2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{1, "a", "b", "20200503", "07"}), Row.of((Object[])new Object[]{2, "p", "q", "20200503", "08"}), Row.of((Object[])new Object[]{3, "x", "y", "20200503", "09"}), Row.of((Object[])new Object[]{4, "x", "y", "20200504", "10"}), Row.of((Object[])new Object[]{5, "x", "y", "20200504", "11"})}));
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().setParallelism(1);
        this.env().enableCheckpointing(100L);
        this.env().getCheckpointConfig().setCheckpointingMode(CheckpointingMode.EXACTLY_ONCE);
    }

    public String[] additionalProperties() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    @Test
    public void testNonPart() {
        this.testPartitionCustomFormatDate(false, this.testPartitionCustomFormatDate$default$2());
    }

    @Test
    public void testPart() {
        this.testPartitionCustomFormatDate(true, this.testPartitionCustomFormatDate$default$2());
        File basePath = new File(new URI(this.resultPath()).getPath(), "d=05-03-2020");
        Assertions.assertThat((Object[])basePath.list()).hasSize(5);
        Assertions.assertThat((File)new File(new File(basePath, "e=07"), "_MY_SUCCESS")).exists();
        Assertions.assertThat((File)new File(new File(basePath, "e=08"), "_MY_SUCCESS")).exists();
        Assertions.assertThat((File)new File(new File(basePath, "e=09"), "_MY_SUCCESS")).exists();
        Assertions.assertThat((File)new File(new File(basePath, "e=10"), "_MY_SUCCESS")).exists();
        Assertions.assertThat((File)new File(new File(basePath, "e=11"), "_MY_SUCCESS")).exists();
    }

    @Test
    public void testMetastorePolicy() {
        Assertions.assertThatThrownBy(() -> this.testPartitionCustomFormatDate(true, "metastore")).hasMessage("Can not configure a 'metastore' partition commit policy for a file system table. You can only configure 'metastore' partition commit policy for a hive table.");
    }

    public org.apache.flink.streaming.api.scala.DataStream<Row> getDataStream2(Function1<Row, Object> fun) {
        return new org.apache.flink.streaming.api.scala.DataStream((DataStream)this.env().getJavaEnv().addSource((SourceFunction)new FiniteTestSource((Iterable<Row>)this.getData2(), fun), (TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.INT, Types.STRING, Types.STRING, Types.STRING, Types.STRING})));
    }

    @Test
    public void testPartitionWithBasicDate() {
        Function1 & Serializable & scala.Serializable fun = (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)FsStreamingSinkITCaseBase.$anonfun$testPartitionWithBasicDate$1(t));
        this.test(this.getDataStream2((Function1<Row, Object>)fun), "default", "yyyyMMdd", "$d", "d", "partition-time", "1d", this.getData2(), this.test$default$9(), this.test$default$10());
        File basePath = new File(new URI(this.resultPath()).getPath());
        Assertions.assertThat((Object[])basePath.list()).hasSize(2);
        Assertions.assertThat((File)new File(new File(basePath, "d=20200503"), "_MY_SUCCESS")).exists();
        Assertions.assertThat((File)new File(new File(basePath, "d=20200504"), "_MY_SUCCESS")).exists();
    }

    public org.apache.flink.streaming.api.scala.DataStream<Row> getDataStream(Function1<Row, Object> fun) {
        return new org.apache.flink.streaming.api.scala.DataStream((DataStream)this.env().getJavaEnv().addSource((SourceFunction)new FiniteTestSource((Iterable<Row>)this.getData(), fun), (TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.INT, Types.STRING, Types.STRING, Types.STRING, Types.STRING})));
    }

    public void testPartitionCustomFormatDate(boolean partition, String policy) {
        Function1 & Serializable & scala.Serializable fun = (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)FsStreamingSinkITCaseBase.$anonfun$testPartitionCustomFormatDate$1(t));
        this.test(this.getDataStream((Function1<Row, Object>)fun), "default", "MM-dd-yyyy HH:mm:ss", "$d $e:00:00", partition ? "d,e" : "", "process-time", "1h", this.getData(), policy, this.test$default$10());
    }

    private void test(org.apache.flink.streaming.api.scala.DataStream<Row> dataStream, String timeExtractorKind, String timeExtractorFormatterPattern, String timeExtractorPattern, String partition, String commitTrigger, String commitDelay, Seq<Row> dataTest, String policy, String successFileName) {
        this.resultPath_$eq(TempDirUtils.newFolder((Path)this.tempFolder()).toURI().toString());
        this.tEnv().createTemporaryView("my_table", dataStream);
        String ddl = this.getDDL(timeExtractorKind, timeExtractorFormatterPattern, timeExtractorPattern, partition, commitTrigger, commitDelay, policy, successFileName);
        this.tEnv().executeSql(ddl);
        this.tEnv().sqlQuery("select * from my_table").executeInsert("sink_table").await();
        this.check("select * from sink_table", dataTest);
    }

    public String testPartitionCustomFormatDate$default$2() {
        return "success-file";
    }

    private String test$default$9() {
        return "success-file";
    }

    private String test$default$10() {
        return "_MY_SUCCESS";
    }

    public String getDDL(String timeExtractorKind, String timeExtractorFormatterPattern, String timeExtractorPattern, String partition, String commitTrigger, String commitDelay, String policy, String successFileName) {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(444).append("\n         |create table sink_table (\n         |  a int,\n         |  b string,\n         |  c string,\n         |  d string,\n         |  e string\n         |)\n         |").append((Object)(new StringOps(Predef$.MODULE$.augmentString(partition)).nonEmpty() ? new StringBuilder(18).append("partitioned by (").append(partition).append(") ").toString() : " ")).append("\n         |with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(this.resultPath()).append("',\n         |  '").append(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_KIND.key()).append("' = '").append(timeExtractorKind).append("',\n         |").append((Object)(new StringOps(Predef$.MODULE$.augmentString(timeExtractorFormatterPattern)).nonEmpty() ? new StringBuilder(2).append(" '").append(new StringBuilder(4).append(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_FORMATTER.key()).append("' = ").toString()).append(new StringBuilder(3).append("'").append(timeExtractorFormatterPattern).append("',").toString()).toString() : "")).append("\n         |\n         |  '").append(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_PATTERN.key()).append("' =\n         |      '").append(timeExtractorPattern).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_TRIGGER.key()).append("' = '").append(commitTrigger).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_DELAY.key()).append("' = '").append(commitDelay).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_POLICY_KIND.key()).append("' = '").append(policy).append("',\n         |  '").append(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_SUCCESS_FILE_NAME.key()).append("' = '").append(successFileName).append("',\n         |  ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.additionalProperties())).mkString(",\n")).append("\n         |)\n       ").toString())).stripMargin();
        return ddl;
    }

    public void check(String sqlQuery, Seq<Row> expectedResult) {
        CloseableIterator iter = this.tEnv().sqlQuery(sqlQuery).execute().collect();
        List result = CollectionUtil.iteratorToList((Iterator)iter);
        iter.close();
        Assertions.assertThat((Object)((SeqLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).map((Function1 & Serializable & scala.Serializable)x$1 -> TestSinkUtil$.MODULE$.rowToString((Row)x$1, TestSinkUtil$.MODULE$.rowToString$default$2()), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(((SeqLike)expectedResult.map((Function1 & Serializable & scala.Serializable)x$2 -> TestSinkUtil$.MODULE$.rowToString((Row)x$2, TestSinkUtil$.MODULE$.rowToString$default$2()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$testPartitionWithBasicDate$1(Row t) {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.parse((CharSequence)t.getFieldAs(3), DateTimeFormatter.BASIC_ISO_DATE), LocalTime.MIDNIGHT);
        return TimestampData.fromLocalDateTime((LocalDateTime)localDateTime).getMillisecond();
    }

    public static final /* synthetic */ long $anonfun$testPartitionCustomFormatDate$1(Row t) {
        LocalDateTime localDateTime = LocalDateTime.parse(new StringBuilder(7).append(t.getField(3)).append(" ").append(t.getField(4)).append(":00:00").toString(), DateTimeFormatter.ofPattern("MM-dd-yyyy HH:mm:ss"));
        return TimestampData.fromLocalDateTime((LocalDateTime)localDateTime).getMillisecond();
    }
}

