/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.AsyncLookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.InMemoryLookupableTableSource$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestAddWithOpen$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestExceptionThrown$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestMod$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestWrapperUdf$;
import org.apache.flink.table.runtime.functions.table.lookup.LookupCacheManager;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t5f\u0001B\u0001\u0003\u0001M\u0011Q#Q:z]\u000edun\\6va*{\u0017N\\%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0012Y\u0016<\u0017mY=UC\ndWmU8ve\u000e,\u0007CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"a\u0002\"p_2,\u0017M\u001c\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u00059!-Y2lK:$\u0007CA\u0013:\u001d\t1sG\u0004\u0002(m9\u0011\u0001&\u000e\b\u0003SQr!AK\u001a\u000f\u0005-\u0012dB\u0001\u00172\u001d\ti\u0003'D\u0001/\u0015\ty##\u0001\u0004=e>|GOP\u0005\u0002#%\u0011q\u0002E\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t9b!\u0003\u00029-\u0005Q2\u000b\u001e:fC6LgnZ,ji\"\u001cF/\u0019;f)\u0016\u001cHOQ1tK&\u0011!h\u000f\u0002\u0011'R\fG/\u001a\"bG.,g\u000eZ'pI\u0016T!\u0001\u000f\f\t\u0011u\u0002!\u0011!Q\u0001\nq\t1b\u001c2kK\u000e$(+Z;tK\"Aq\b\u0001B\u0001B\u0003%\u0001)A\bbgft7mT;uaV$Xj\u001c3f!\t\tEJ\u0004\u0002C\u0013:\u00111I\u0012\b\u0003S\u0011K!!\u0012\u0006\u0002\u0007\u0005\u0004\u0018.\u0003\u0002H\u0011\u000611m\u001c8gS\u001eT!!\u0012\u0006\n\u0005)[\u0015AF#yK\u000e,H/[8o\u0007>tg-[4PaRLwN\\:\u000b\u0005\u001dC\u0015BA'O\u0005=\t5/\u001f8d\u001fV$\b/\u001e;N_\u0012,'B\u0001&L\u0011!\u0001\u0006A!A!\u0002\u0013a\u0012aC3oC\ndWmQ1dQ\u0016DQA\u0015\u0001\u0005\u0002M\u000ba\u0001P5oSRtDC\u0002+W/bK&\f\u0005\u0002V\u00015\t!\u0001C\u0003\u001c#\u0002\u0007A\u0004C\u0003$#\u0002\u0007A\u0005C\u0003>#\u0002\u0007A\u0004C\u0003@#\u0002\u0007\u0001\tC\u0003Q#\u0002\u0007A\u0004C\u0004]\u0001\t\u0007I\u0011A/\u0002\t\u0011\fG/Y\u000b\u0002=B\u0019q\f\u001a4\u000e\u0003\u0001T!!\u00192\u0002\u0013%lW.\u001e;bE2,'BA2\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003K\u0002\u0014A\u0001T5tiB\u0011qM[\u0007\u0002Q*\u0011\u0011\u000eD\u0001\u0006if\u0004Xm]\u0005\u0003W\"\u00141AU8x\u0011\u0019i\u0007\u0001)A\u0005=\u0006)A-\u0019;bA!9q\u000e\u0001b\u0001\n\u0003i\u0016\u0001C;tKJ$\u0015\r^1\t\rE\u0004\u0001\u0015!\u0003_\u0003%)8/\u001a:ECR\f\u0007\u0005C\u0003t\u0001\u0011\u0005C/\u0001\u0004cK\u001a|'/\u001a\u000b\u0002kB\u0011QD^\u0005\u0003oz\u0011A!\u00168ji\"\u0012!/\u001f\t\u0004u\u0006\u0005Q\"A>\u000b\u0005\u0015c(BA?\u007f\u0003\u001dQW\u000f]5uKJT!a \t\u0002\u000b),h.\u001b;\n\u0007\u0005\r1P\u0001\u0006CK\u001a|'/Z#bG\"Da!a\u0002\u0001\t\u0003\"\u0018!B1gi\u0016\u0014\b\u0006BA\u0003\u0003\u0017\u00012A_A\u0007\u0013\r\tya\u001f\u0002\n\u0003\u001a$XM]#bG\"Dq!a\u0005\u0001\t\u0013\t)\"A\tde\u0016\fG/\u001a'p_.,\b\u000fV1cY\u0016$r!^A\f\u0003W\ti\u0004\u0003\u0005\u0002\u001a\u0005E\u0001\u0019AA\u000e\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0005\u0003\u0002\u001e\u0005\u0015b\u0002BA\u0010\u0003C\u0001\"!\f\u0010\n\u0007\u0005\rb$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\tIC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Gq\u0002b\u0002/\u0002\u0012\u0001\u0007\u0011Q\u0006\t\u0006\u0003_\tID\u001a\b\u0005\u0003c\t)DD\u0002.\u0003gI\u0011aH\u0005\u0004\u0003oq\u0012a\u00029bG.\fw-Z\u0005\u0004K\u0006m\"bAA\u001c=!Q\u0011qHA\t!\u0003\u0005\r!!\u0011\u0002\u001f1|wn[;q)\"\u0014Xm\u001d5pY\u0012\u00042!HA\"\u0013\r\t)E\b\u0002\u0004\u0013:$\bbBA%\u0001\u0011%\u00111J\u0001\u0018O\u0016$\u0018i]=oGJ+GO]=M_>\\W\u000f\u001d%j]R$b!a\u0007\u0002N\u0005E\u0003\u0002CA(\u0003\u000f\u0002\r!a\u0007\u0002\u00171|wn[;q)\u0006\u0014G.\u001a\u0005\t\u0003'\n9\u00051\u0001\u0002B\u0005YQ.\u0019=BiR,W\u000e\u001d;t\u0011\u001d\t9\u0006\u0001C\u0005\u00033\nqb\u0019:fCR,7kY1o)\u0006\u0014G.\u001a\u000b\u0006k\u0006m\u0013Q\f\u0005\t\u00033\t)\u00061\u0001\u0002\u001c!9A,!\u0016A\u0002\u00055\u0002BBA1\u0001\u0011\u0005A/\u0001\u0016uKN$\u0018i]=oG*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$\u0018nS3z\r&,G\u000eZ:)\t\u0005}\u0013Q\r\t\u0004u\u0006\u001d\u0014bAA5w\naA+Z:u)\u0016l\u0007\u000f\\1uK\"1\u0011Q\u000e\u0001\u0005\u0002Q\f!\u0004^3ti\u0006\u001b\u0018P\\2K_&tG+Z7q_J\fG\u000eV1cY\u0016DC!a\u001b\u0002f!1\u00111\u000f\u0001\u0005\u0002Q\fa\u0005^3ti\u0006\u001b\u0018P\\2K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5QkNDGi\\<oQ\u0011\t\t(!\u001a\t\r\u0005e\u0004\u0001\"\u0001u\u00031\"Xm\u001d;Bgft7MS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\bNT8o\u000bF,\u0018\r\u001c$jYR,'\u000f\u000b\u0003\u0002x\u0005\u0015\u0004BBA@\u0001\u0011\u0005A/\u0001\u0019uKN$\u0018i]=oG2+g\r\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b'pG\u0006d\u0007K]3eS\u000e\fG/\u001a\u0015\u0005\u0003{\n)\u0007\u0003\u0004\u0002\u0006\u0002!\t\u0001^\u0001(i\u0016\u001cH/Q:z]\u000eTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/\u001b$jK2$7\u000f\u000b\u0003\u0002\u0004\u0006\u0015\u0004BBAF\u0001\u0011\u0005A/\u0001\u0018uKN$\u0018i]=oG*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$\u0018NR5fY\u0012\u001cx+\u001b;i+\u00124\u0007\u0006BAE\u0003KBa!!%\u0001\t\u0003!\u0018a\n;fgR\f5/\u001f8d\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i+\u00124g)\u001b7uKJDC!a$\u0002f!1\u0011q\u0013\u0001\u0005\u0002Q\fA\u0005^3ti\u0006;w-\u00118e\u0003NLhn\u0019'fMRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.\u001a\u0015\u0005\u0003+\u000b)\u0007\u0003\u0004\u0002\u001e\u0002!\t\u0001^\u0001*i\u0016\u001cH/Q4h\u0003:$\u0017i]=oG2+g\r\u001e&pS:<\u0016\u000e\u001e5Uef\u0014Vm]8mm\u0016lu\u000eZ3)\t\u0005m\u0015Q\r\u0005\u0007\u0003G\u0003A\u0011\u0001;\u0002=Q,7\u000f^!ts:\u001cG*\u001a4u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,\u0007\u0006BAQ\u0003KBa!!+\u0001\t\u0003!\u0018!\f;fgR,\u0005pY3qi&|g\u000e\u00165s_^tgI]8n\u0003NLhn\u0019&pS:$V-\u001c9pe\u0006dG+\u00192mK\"\"\u0011qUA3\u0011\u0019\ty\u000b\u0001C\u0001i\u0006!C/Z:u\u0019>|7.\u001e9DC\u000eDWm\u00155be&tw-Q2s_N\u001c8+\u001e2uCN\\7\u000f\u000b\u0003\u0002.\u0006\u0015\u0004bBA[\u0001\u0011\u0005\u0011qW\u0001\u0003U&$B!!/\u0002JB!\u00111XAc\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017\u0001\u00027b]\u001eT!!a1\u0002\t)\fg/Y\u0005\u0005\u0003\u000f\fiLA\u0004J]R,w-\u001a:\t\u0011\u0005-\u00171\u0017a\u0001\u0003\u0003\n\u0011!\u001b\u0005\b\u0003\u001f\u0004A\u0011AAi\u0003\tQG\u000e\u0006\u0003\u0002T\u0006e\u0007\u0003BA^\u0003+LA!a6\u0002>\n!Aj\u001c8h\u0011!\tY.!4A\u0002\u0005u\u0017!\u00017\u0011\u0007u\ty.C\u0002\u0002XzAa!a9\u0001\t\u0003!\u0018a\t;fgR\f5/\u001f8d\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i%\u0016$(/\u001f\u0015\u0005\u0003C\f)\u0007\u0003\u0004\u0002j\u0002!\t\u0001^\u0001Ci\u0016\u001cH/Q:z]\u000eTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"dun\\6vaRC'/Z:i_2$w+\u001b;i\u0013:\u001cXO\u001a4jG&,g\u000e\u001e*fiJL\b\u0006BAt\u0003KBa!a<\u0001\t\u0003!\u0018\u0001\u0011;fgR\f5/\u001f8d\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0019>|7.\u001e9UQJ,7\u000f[8mI^KG\u000f[*vM\u001aL7-[3oiJ+GO]=)\t\u00055\u0018Q\r\u0005\n\u0003k\u0004\u0011\u0013!C\u0005\u0003o\f1d\u0019:fCR,Gj\\8lkB$\u0016M\u00197fI\u0011,g-Y;mi\u0012\u001aTCAA}U\u0011\t\t%a?,\u0005\u0005u\b\u0003BA\u0000\u0005\u0013i!A!\u0001\u000b\t\t\r!QA\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0002\u001f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0017\u0011\tAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Ds\u0001\u0001B\b\u00057\u0011i\u0002\u0005\u0003\u0003\u0012\t]QB\u0001B\n\u0015\r\u0011)b_\u0001\nKb$XM\\:j_:LAA!\u0007\u0003\u0014\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\t}1E\u0001B\u0011!\u0011\u0011\u0019Ca\r\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0005S\tQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002\u0002B\u0016\u0005[\t!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\ry(q\u0006\u0006\u0004\u0005ca\u0011!\u0003;fgR,H/\u001b7t\u0013\u0011\u0011)D!\n\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\b\u000f\te\"\u0001#\u0001\u0003<\u0005)\u0012i]=oG2{wn[;q\u0015>Lg.\u0013+DCN,\u0007cA+\u0003>\u00191\u0011A\u0001E\u0001\u0005\u007f\u0019BA!\u0010\u0003BA\u0019QDa\u0011\n\u0007\t\u0015cD\u0001\u0004B]f\u0014VM\u001a\u0005\b%\nuB\u0011\u0001B%)\t\u0011Y\u0004\u0003\u0006\u0003N\tu\"\u0019!C\u0001\u0005\u001f\n1\u0003T#H\u0003\u000eKv\fV!C\u0019\u0016{6kT+S\u0007\u0016+\"A!\u0015\u0011\t\u0005m&1K\u0005\u0004C\u0005u\u0006\"\u0003B,\u0005{\u0001\u000b\u0011\u0002B)\u0003QaUiR!D3~#\u0016I\u0011'F?N{UKU\"FA!Q!1\fB\u001f\u0005\u0004%\tAa\u0014\u0002)\u0011Kf*Q'J\u0007~#\u0016I\u0011'F?N{UKU\"F\u0011%\u0011yF!\u0010!\u0002\u0013\u0011\t&A\u000bE3:\u000bU*S\"`)\u0006\u0013E*R0T\u001fV\u00136)\u0012\u0011\t\u0015\t\r$Q\bb\u0001\n\u0003\u0011y%A\nF\u001d\u0006\u0013E*R0P\u0005*+5\tV0S\u000bV\u001bV\tC\u0005\u0003h\tu\u0002\u0015!\u0003\u0003R\u0005!RIT!C\u0019\u0016{vJ\u0011&F\u0007R{&+R+T\u000b\u0002B!Ba\u001b\u0003>\t\u0007I\u0011\u0001B(\u0003Q!\u0015jU!C\u0019\u0016{vJ\u0011&F\u0007R{&+R+T\u000b\"I!q\u000eB\u001fA\u0003%!\u0011K\u0001\u0016\t&\u001b\u0016I\u0011'F?>\u0013%*R\"U?J+UkU#!\u0011)\u0011\u0019H!\u0010C\u0002\u0013\u0005!qJ\u0001\r\u000b:\u000b%\tT#`\u0007\u0006\u001b\u0005*\u0012\u0005\n\u0005o\u0012i\u0004)A\u0005\u0005#\nQ\"\u0012(B\u00052+ulQ!D\u0011\u0016\u0003\u0003B\u0003B>\u0005{\u0011\r\u0011\"\u0001\u0003P\u0005iA)S*B\u00052+ulQ!D\u0011\u0016C\u0011Ba \u0003>\u0001\u0006IA!\u0015\u0002\u001d\u0011K5+\u0011\"M\u000b~\u001b\u0015i\u0011%FA!A!1\u0011B\u001f\t\u0003\u0011))\u0001\u0006qCJ\fW.\u001a;feN$\"Aa\"\u0011\r\t%%q\u0012BJ\u001b\t\u0011YI\u0003\u0003\u0003\u000e\u0006\u0005\u0017\u0001B;uS2LAA!%\u0003\f\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u000bu\u0011)J!'\n\u0007\t]eDA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002<\nm\u0015\u0002\u0002BO\u0003{\u0013aa\u00142kK\u000e$\b\u0006\u0003BA\u0005C\u00139K!+\u0011\t\t\r\"1U\u0005\u0005\u0005K\u0013)C\u0001\u0006QCJ\fW.\u001a;feN\fAA\\1nK\u0006\u0012!1V\u0001_\u0019\u0016<\u0017mY=UC\ndWmU8ve\u000e,Wh\u001f\u0019~Y\u0001\u001aF/\u0019;f\u0005\u0006\u001c7.\u001a8e{m\fT\u0010\f\u0011PE*,7\r\u001e*fkN,Wh\u001f\u001a~Y\u0001\n5/\u001f8d\u001fV$\b/\u001e;N_\u0012,Wh_\u001a~Y\u0001*e.\u00192mK\u000e\u000b7\r[3>wRj\b")
public class AsyncLookupJoinITCase
extends StreamingWithStateTestBase {
    private final boolean legacyTableSource;
    private final boolean objectReuse;
    private final ExecutionConfigOptions.AsyncOutputMode asyncOutputMode;
    private final boolean enableCache;
    private final List<Row> data;
    private final List<Row> userData;

    @Parameters(name="LegacyTableSource={0}, StateBackend={1}, ObjectReuse={2}, AsyncOutputMode={3}, EnableCache={4}")
    public static Collection<Object[]> parameters() {
        return AsyncLookupJoinITCase$.MODULE$.parameters();
    }

    public static Boolean DISABLE_CACHE() {
        return AsyncLookupJoinITCase$.MODULE$.DISABLE_CACHE();
    }

    public static Boolean ENABLE_CACHE() {
        return AsyncLookupJoinITCase$.MODULE$.ENABLE_CACHE();
    }

    public static Boolean DISABLE_OBJECT_REUSE() {
        return AsyncLookupJoinITCase$.MODULE$.DISABLE_OBJECT_REUSE();
    }

    public static Boolean ENABLE_OBJECT_REUSE() {
        return AsyncLookupJoinITCase$.MODULE$.ENABLE_OBJECT_REUSE();
    }

    public static Boolean DYNAMIC_TABLE_SOURCE() {
        return AsyncLookupJoinITCase$.MODULE$.DYNAMIC_TABLE_SOURCE();
    }

    public static Boolean LEGACY_TABLE_SOURCE() {
        return AsyncLookupJoinITCase$.MODULE$.LEGACY_TABLE_SOURCE();
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> userData() {
        return this.userData;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        if (this.legacyTableSource) {
            InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().set(0);
        } else {
            TestValuesTableFactory.RESOURCE_COUNTER.set(0);
        }
        ExecutionConfig executionConfig = this.objectReuse ? this.env().getConfig().enableObjectReuse() : this.env().getConfig().disableObjectReuse();
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_OUTPUT_MODE, (Object)this.asyncOutputMode);
        this.createScanTable("src", this.data());
        this.createLookupTable("user_table", this.userData(), this.createLookupTable$default$3());
        this.createLookupTable("user_table_with_lookup_threshold2", this.userData(), 2);
        this.createLookupTable("user_table_with_lookup_threshold3", this.userData(), 3);
    }

    @Override
    @AfterEach
    public void after() {
        super.after();
        if (this.legacyTableSource) {
            Assertions.assertThat((AtomicInteger)InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER()).hasValue(0);
        } else {
            Assertions.assertThat((AtomicInteger)TestValuesTableFactory.RESOURCE_COUNTER).hasValue(0);
        }
    }

    private void createLookupTable(String tableName, List<Row> data, int lookupThreshold) {
        if (this.legacyTableSource) {
            TableSchema userSchema = TableSchema.builder().field("age", Types.INT()).field("id", Types.LONG()).field("name", Types.STRING()).build();
            InMemoryLookupableTableSource$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), true, data, userSchema, tableName, InMemoryLookupableTableSource$.MODULE$.createTemporaryTable$default$6());
        } else {
            String dataId = TestValuesTableFactory.registerData(data);
            String cacheOptions = this.enableCache ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n             |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin() : "";
            String lookupThresholdOption = lookupThreshold > 0 ? new StringBuilder(28).append("'start-lookup-threshold'='").append(lookupThreshold).append("',").toString() : "";
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(453).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  ").append(lookupThresholdOption).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'async' = 'true'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private int createLookupTable$default$3() {
        return -1;
    }

    private String getAsyncRetryLookupHint(String lookupTable, int maxAttempts) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(239).append("\n       |/*+ LOOKUP('table'='").append(lookupTable).append("', \n       | 'async'='true', \n       | 'time-out'='300s',\n       | 'retry-predicate'='lookup_miss',\n       | 'retry-strategy'='fixed_delay',\n       | 'fixed-delay'='1 ms',\n       | 'max-attempts'='").append(maxAttempts).append("')\n       |*/").toString())).stripMargin();
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(386).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` BIGINT,\n                       |  `len` INT,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testAsyncJoinTemporalTableOnMultiKeyFields() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.id, t1.len, D.name\n        |FROM (select content, id, len, proctime FROM src AS T) t1\n        |JOIN user_table for system_time as of t1.proctime AS D\n        |ON t1.content = D.name AND t1.id = D.id\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAsyncJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAsyncJoinTemporalTableWithPushDown() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAsyncJoinTemporalTableWithNonEqualFilter() {
        String sql = "SELECT T.id, T.len, T.content, D.name, D.age FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark,22", "3,15,Fabian,Fabian,33"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAsyncLeftJoinTemporalTableWithLocalPredicate() {
        String sql = "SELECT T.id, T.len, T.content, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.len > 1 AND D.age > 20 AND D.name = 'Fabian' WHERE T.id > 1";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,null,null", "3,15,Fabian,Fabian,33", "8,11,Hello world,null,null", "9,12,Hello world!,null,null"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAsyncJoinTemporalTableOnMultiFields() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAsyncJoinTemporalTableOnMultiFieldsWithUdf() {
        this.tEnv().createTemporarySystemFunction("mod1", (UserDefinedFunction)UserDefinedFunctionTestUtils$TestMod$.MODULE$);
        this.tEnv().createTemporarySystemFunction("wrapper1", (UserDefinedFunction)UserDefinedFunctionTestUtils$TestWrapperUdf$.MODULE$);
        String sql = "SELECT T.id, T.len, wrapper1(D.name) as name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON mod1(T.id, 4) = D.id AND T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAsyncJoinTemporalTableWithUdfFilter() {
        this.tEnv().createTemporarySystemFunction("add", (UserDefinedFunction)new UserDefinedFunctionTestUtils.TestAddWithOpen());
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE add(T.id, D.id) > 3 AND add(T.id, 2) > 3 AND add (D.id, 2) > 3";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        Assertions.assertThat((AtomicInteger)UserDefinedFunctionTestUtils$TestAddWithOpen$.MODULE$.aliveCounter()).hasValue(0);
    }

    @TestTemplate
    public void testAggAndAsyncLeftJoinTemporalTable() {
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().createTemporaryView("t1", table1);
        String sql2 = "SELECT t1.id, D.name, D.age FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON t1.id = D.id";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Fabian,33", "8,null,null", "9,null,null"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggAndAsyncLeftJoinWithTryResolveMode() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().createTemporaryView("t1", table1);
        String sql2 = "SELECT t1.id, D.name, D.age FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON t1.id = D.id";
        TestingRetractSink sink = new TestingRetractSink();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> {
            package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
            this.env().execute();
            Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Fabian,33", "8,null,null", "9,null,null"}));
            Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        }).hasMessageContaining("Required sync lookup function by planner") instanceof TableException;
    }

    @TestTemplate
    public void testAsyncLeftJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,11", "2,15,Jark,22", "3,15,Fabian,33", "8,11,null,null", "9,12,null,null"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testExceptionThrownFromAsyncJoinTemporalTable() {
        this.tEnv().createTemporarySystemFunction("errorFunc", (UserDefinedFunction)UserDefinedFunctionTestUtils$TestExceptionThrown$.MODULE$);
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id where errorFunc(D.name) > cast(1000 as decimal(10,4))";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        Assertions.assertThatThrownBy(() -> this.env().execute()).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(NumberFormatException.class, (String)"Cannot parse")});
    }

    @TestTemplate
    public void testLookupCacheSharingAcrossSubtasks() {
        if (!this.enableCache) {
            return;
        }
        LookupCacheManager.keepCacheOnRelease((boolean)true);
        try {
            String sourceDdl = new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE T (\n           |  id BIGINT,\n           |  proc AS PROCTIME()\n           |) WITH (\n           |  'connector' = 'datagen',\n           |  'fields.id.kind' = 'sequence',\n           |  'fields.id.start' = '1',\n           |  'fields.id.end' = '6'\n           |)\n           |")).stripMargin();
            this.tEnv().executeSql(sourceDdl);
            String sql = new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT T.id, D.name, D.age FROM T \n          |LEFT JOIN user_table FOR SYSTEM_TIME AS OF T.proc AS D \n          |ON T.id = D.id\n          |")).stripMargin();
            TestingAppendSink sink = new TestingAppendSink();
            package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
            this.env().execute();
            Map managedCaches = LookupCacheManager.getInstance().getManagedCaches();
            Assertions.assertThat((int)managedCaches.size()).isEqualTo(1);
            LookupCache cache = ((LookupCacheManager.RefCountedCache)managedCaches.get(managedCaches.keySet().iterator().next())).getCache();
            Assertions.assertThat((long)cache.size()).isEqualTo(6L);
            Assertions.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(1L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(1L), BinaryStringData.fromString((String)"Julian")})});
            Assertions.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(2L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(22), this.jl(2L), BinaryStringData.fromString((String)"Jark")})});
            Assertions.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(3L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(33), this.jl(3L), BinaryStringData.fromString((String)"Fabian")})});
            Assertions.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(4L)}))).isEmpty();
        }
        finally {
            LookupCacheManager.getInstance().checkAllReleased();
            LookupCacheManager.getInstance().clear();
            LookupCacheManager.keepCacheOnRelease((boolean)false);
        }
    }

    public Integer ji(int i) {
        return new Integer(i);
    }

    public Long jl(long l) {
        return new Long(l);
    }

    @TestTemplate
    public void testAsyncJoinTemporalTableWithRetry() {
        String maxRetryTwiceHint = this.getAsyncRetryLookupHint("D", 2);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n                   |SELECT ").append(maxRetryTwiceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAsyncJoinTemporalTableWithLookupThresholdWithInsufficientRetry() {
        String maxRetryOnceHint = this.getAsyncRetryLookupHint("D", 1);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(maxRetryOnceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold3 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = this.legacyTableSource ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"})) : (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAsyncJoinTemporalTableWithLookupThresholdWithSufficientRetry() {
        String maxRetryTwiceHint = this.getAsyncRetryLookupHint("D", 2);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(maxRetryTwiceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold2 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public AsyncLookupJoinITCase(boolean legacyTableSource, StreamingWithStateTestBase.StateBackendMode backend, boolean objectReuse, ExecutionConfigOptions.AsyncOutputMode asyncOutputMode, boolean enableCache) {
        this.legacyTableSource = legacyTableSource;
        this.objectReuse = objectReuse;
        this.asyncOutputMode = asyncOutputMode;
        this.enableCache = enableCache;
        super(backend);
        this.data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)12), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)15), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)11), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"})), (List)Nil$.MODULE$)))));
        this.userData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)Nil$.MODULE$)));
    }
}

