/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.typeutils.Types$;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendRowDataSink;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingAppendTableSink;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.MapDataSerializerTest;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001M\u0011!bQ1mG&#6)Y:f\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\n\u0011aX\u000b\u0002EA\u00191\u0005\u000b\u0016\u000e\u0003\u0011R!!\n\u0014\u0002\u0013Q,7\u000f^;uS2\u001c(BA\u0014\r\u0003\u0011\u0019wN]3\n\u0005%\"#aE#bG\"\u001c\u0015\r\u001c7cC\u000e\\wK]1qa\u0016\u0014\bCA\u0016.\u001b\u0005a#BA\f\u000b\u0013\tqCF\u0001\nMK\u001e\f7-\u001f*po\u0016CH/\u001a8tS>t\u0007B\u0002\u0019\u0001A\u0003%!%\u0001\u0002`A!\u0012qF\r\t\u0003gqj\u0011\u0001\u000e\u0006\u0003kY\n\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\u0005]B\u0014aA1qS*\u0011\u0011HO\u0001\bUV\u0004\u0018\u000e^3s\u0015\tY\u0004#A\u0003kk:LG/\u0003\u0002>i\t\t\"+Z4jgR,'/\u0012=uK:\u001c\u0018n\u001c8\t\u000b}\u0002A\u0011\u0001!\u0002CQ,7\u000f^*fY\u0016\u001cGoV5uQ2+w-Y2z\u0007\u0006\u001cH/\u00138u)>$\u0015\r^3\u0015\u0003\u0005\u0003\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013A!\u00168ji\"\u0012a\b\u0013\t\u0003\u0013*k\u0011AN\u0005\u0003\u0017Z\u0012A\u0001V3ti\")Q\n\u0001C\u0001\u0001\u0006\u0019C/Z:u\u0007\u0006\u001cHOT;nKJL7\rV8C_>dW-\u00198J]\u000e{g\u000eZ5uS>t\u0007F\u0001'I\u0011\u0015\u0001\u0006\u0001\"\u0001A\u0003a!Xm\u001d;HK:,'/[2S_^\fe\u000e\u001a*po\u0012\u000bG/\u0019\u0015\u0003\u001f\"CQa\u0015\u0001\u0005\u0002\u0001\u000b\u0011\u0003^3tiJ{w/\u00118e%><H)\u0019;bQ\t\u0011\u0006\nC\u0003W\u0001\u0011\u0005\u0001)\u0001\u000buKN$x)\u001a8fe&\u001c'k\\<B]\u0012\u0014vn\u001e\u0015\u0003+\"CQ!\u0017\u0001\u0005\u0002\u0001\u000bQ\u0002^3tiJ{w/\u00118e%><\bF\u0001-I\u0011\u0015a\u0006\u0001\"\u0001A\u0003Q!Xm\u001d;Qe&l\u0017\u000e^5wK6\u000b\u0007\u000fV=qK\"\u00121\f\u0013\u0005\u0006?\u0002!\t\u0001Q\u0001\u0018i\u0016\u001cHOT8o!JLW.\u001b;jm\u0016l\u0015\r\u001d+za\u0016D#A\u0018%\t\u000b\t\u0004A\u0011\u0001!\u0002;Q,7\u000f^*fY\u0016\u001cGo\u0015;be\u001a\u0013x.\u001c(fgR,G\rV1cY\u0016D#!\u0019%\t\u000b\u0015\u0004A\u0011\u0001!\u0002\rQ,7\u000f^%oQ\t!\u0007\nC\u0003i\u0001\u0011\u0005\u0001)A\u0005uKN$hj\u001c;J]\"\u0012q\r\u0013\u0005\u0006W\u0002!\t\u0001Q\u0001\u0017i\u0016\u001cH\u000fT8oOB\u0013xN[3di&|g\u000eT5ti\"\u0012!\u000e\u0013\u0005\u0006]\u0002!\t\u0001Q\u0001\u000fi\u0016\u001cH/\u00134Gk:\u001cG/[8oQ\ti\u0007\nC\u0003r\u0001\u0011\u0005\u0001)\u0001\u0011uKN$8k\\;sG\u0016<\u0016\u000e\u001e5DkN$x.\\%oi\u0016\u0014h.\u00197ECR\f\u0007F\u00019I\u0011\u0015!\b\u0001\"\u0001A\u0003E!Xm\u001d;TS6\u0004H.\u001a)s_*,7\r\u001e\u0015\u0003g\"CQa\u001e\u0001\u0005\u0002\u0001\u000b\u0011\u0003^3ti:+7\u000f^3e!J|'.Z2uQ\t1\b\nC\u0003{\u0001\u0011\u0005\u0001)\u0001\u0014uKN$H)Z2j[\u0006d\u0017I\u001d:bs^KG\u000f\u001b#jM\u001a,'/\u001a8u!J,7-[:j_:D#!\u001f%\t\u000bu\u0004A\u0011\u0001!\u0002IQ,7\u000f\u001e#fG&l\u0017\r\\'ba^KG\u000f\u001b#jM\u001a,'/\u001a8u!J,7-[:j_:D#\u0001 %\t\r\u0005\u0005\u0001\u0001\"\u0001A\u0003Q!Xm\u001d;DkJ\u0014XM\u001c;XCR,'/\\1sW\"\u0012q\u0010\u0013\u0005\u0007\u0003\u000f\u0001A\u0011\u0001!\u0002UQ,7\u000f^\"veJ,g\u000e^,bi\u0016\u0014X.\u0019:l\r>\u0014hj\u001c8S_^$\u0018.\\3BiR\u0014\u0018NY;uK\"\u001a\u0011Q\u0001%\t\r\u00055\u0001\u0001\"\u0001A\u0003\u001d\"Xm\u001d;DkJ\u0014XM\u001c;XCR,'/\\1sW^KG\u000f[8vi\u0006s\u00170\u0011;ue&\u0014W\u000f^3)\u0007\u0005-\u0001\n\u0003\u0004\u0002\u0014\u0001!\t\u0001Q\u0001'i\u0016\u001cHo\u0011:fCR,G+Z7q_J\f'/\u001f+bE2,gI]8n\t\u0016\u001c8M]5qi>\u0014\bfAA\t\u0011\"1\u0011\u0011\u0004\u0001\u0005\u0002\u0001\u000b!\u0002^3tiN+\u0017M]2iQ\r\t9\u0002\u0013\u0005\u0007\u0003?\u0001A\u0011\u0001!\u0002+Q,7\u000f^'vYRL\u0007\u000f\\3D_\u0006dWm]2fg\"\u001a\u0011Q\u0004%\t\r\u0005\u0015\u0002\u0001\"\u0001A\u0003M!Xm\u001d;DkJ\u0014XM\u001c;ECR\f'-Y:fQ\r\t\u0019\u0003\u0013\u0005\u0007\u0003W\u0001A\u0011\u0001!\u0002aQ,7\u000f\u001e'jW\u0016<\u0016\u000e\u001e5D_:$\u0017\u000e^5p]\u000e{g\u000e^1j]N$u.\u001e2mKF+x\u000e^1uS>tW*\u0019:lQ\r\tI\u0003\u0013\u0005\u0007\u0003c\u0001A\u0011\u0001!\u00021Q,7\u000f\u001e(p]6+'oZ3bE2,'+\u00198e\u0007\u0006dG\u000eK\u0002\u00020!\u0003")
public class CalcITCase
extends StreamingTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testSelectWithLegacyCastIntToDate() {
        this.tEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_LEGACY_CAST_BEHAVIOUR, (Object)ExecutionConfigOptions.LegacyCastBehaviour.ENABLED);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT CASE WHEN true THEN CAST(2 AS INT) ELSE CAST('2017-12-11' AS DATE) END")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1970-01-03", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCastNumericToBooleanInCondition() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT * FROM MyTableRow WHERE b = CAST(1 AS BOOLEAN)\n         | UNION ALL\n         | SELECT * FROM MyTableRow WHERE b = CAST(0 AS BOOLEAN)\n         |")).stripMargin();
        GenericRowData rowData1 = new GenericRowData(2);
        rowData1.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData1.setField(1, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        GenericRowData rowData2 = new GenericRowData(2);
        rowData2.setField(0, (Object)BoxesRunTime.boxToInteger((int)2));
        rowData2.setField(1, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        .colon.colon data = new .colon.colon((Object)rowData1, (List)new .colon.colon((Object)rowData2, (List)Nil$.MODULE$));
        InternalTypeInfo dataType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BooleanType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)dataType);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BooleanType()});
        Table result = this.tEnv().sqlQuery(sqlQuery);
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        this.tEnv().toDataStream(result, (AbstractDataType)outputType.getDataType()).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(1,true)", (List)new .colon.colon((Object)"+I(2,false)", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGenericRowAndRowData() {
        String sqlQuery = "SELECT * FROM MyTableRow";
        GenericRowData rowData = new GenericRowData(3);
        rowData.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(1, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(2, (Object)BoxesRunTime.boxToLong((long)1L));
        .colon.colon data = new .colon.colon((Object)rowData, (List)Nil$.MODULE$);
        InternalTypeInfo tpe = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        Table result = this.tEnv().sqlQuery(sqlQuery);
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        this.tEnv().toDataStream(result, (AbstractDataType)outputType.getDataType()).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(1,1,1)", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowAndRowData() {
        String sqlQuery = "SELECT * FROM MyTableRow WHERE c < 3";
        .colon.colon data = new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Worlds", BoxesRunTime.boxToInteger((int)1)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Hiden", BoxesRunTime.boxToInteger((int)5)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello again", "Worlds", BoxesRunTime.boxToInteger((int)2)}), (List)Nil$.MODULE$)));
        RowTypeInfo tpe = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE, VarCharType.STRING_TYPE, new IntType()});
        Table result = this.tEnv().sqlQuery(sqlQuery);
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        this.tEnv().toDataStream(result, (AbstractDataType)outputType.getDataType()).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(Hello,Worlds,1)", (List)new .colon.colon((Object)"+I(Hello again,Worlds,2)", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGenericRowAndRow() {
        String sqlQuery = "SELECT * FROM MyTableRow";
        GenericRowData rowData = new GenericRowData(3);
        rowData.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(1, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(2, (Object)BoxesRunTime.boxToLong((long)1L));
        .colon.colon data = new .colon.colon((Object)rowData, (List)Nil$.MODULE$);
        InternalTypeInfo tpe = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,1", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowAndRow() {
        String sqlQuery = "SELECT * FROM MyTableRow WHERE c < 3";
        .colon.colon data = new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Worlds", BoxesRunTime.boxToInteger((int)1)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Hiden", BoxesRunTime.boxToInteger((int)5)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello again", "Worlds", BoxesRunTime.boxToInteger((int)2)}), (List)Nil$.MODULE$)));
        RowTypeInfo tpe = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"Hello,Worlds,1", (List)new .colon.colon((Object)"Hello again,Worlds,2", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPrimitiveMapType() {
        String sqlQuery = "SELECT MAP[b, 30, 10, a] FROM MyTableRow";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{1=30, 10=1}", (List)new .colon.colon((Object)"{2=30, 10=2}", (List)new .colon.colon((Object)"{2=30, 10=3}", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNonPrimitiveMapType() {
        String sqlQuery = "SELECT MAP[a, c] FROM MyTableRow";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$11 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{1=Hi}", (List)new .colon.colon((Object)"{2=Hello}", (List)new .colon.colon((Object)"{3=Hello world}", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSelectStarFromNestedTable() {
        String sqlQuery = "SELECT * FROM MyTable";
        Table table = this.tEnv().fromDataStream(this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)"0"), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)"1"), new Tuple2((Object)new Tuple2.mcII.sp(2, 2), (Object)"2")})), (TypeInformation)new CaseClassTypeInfo<Tuple2<Tuple2<Object, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Tuple2<Object, Object>, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>>(this, fieldSerializers){

                    public Tuple2<Tuple2<Object, Object>, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((Tuple2)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Tuple2<Object, Object>, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$12 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2"))}));
        this.tEnv().createTemporaryView("MyTable", table);
        Table result = this.tEnv().sqlQuery(sqlQuery);
        TestingAppendTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingAppendTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        table.executeInsert("MySink").await();
        .colon.colon expected = new .colon.colon((Object)"0,0,0", (List)new .colon.colon((Object)"1,1,1", (List)new .colon.colon((Object)"2,2,2", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testIn() {
        String sqlQuery = "SELECT * FROM MyTable WHERE b in (1,3,4,5,6)";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$15 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTable", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "4,3,Hello world, how are you?", "5,3,I am fine.", "6,3,Luke Skywalker", "7,4,Comment#1", "8,4,Comment#2", "9,4,Comment#3", "10,4,Comment#4", "11,5,Comment#5", "12,5,Comment#6", "13,5,Comment#7", "14,5,Comment#8", "15,5,Comment#9", "16,6,Comment#10", "17,6,Comment#11", "18,6,Comment#12", "19,6,Comment#13", "20,6,Comment#14", "21,6,Comment#15"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNotIn() {
        String sqlQuery = "SELECT * FROM MyTable WHERE b not in (1,3,4,5,6)";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$16 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTable", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,2,Hello world", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLongProjectionList() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$17 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTable", t);
        String selectList = ((Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)200), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)i -> CalcITCase.$anonfun$testLongProjectionList$1(BoxesRunTime.unboxToInt((Object)i)), Stream$.MODULE$.canBuildFrom())).mkString(",");
        String sqlQuery = new StringBuilder(20).append("select ").append(selectList).append(" from MyTable").toString();
        DataStream result2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result2.addSink((SinkFunction)sink);
        this.env().execute();
        String expected = ((Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)200), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$1 -> CalcITCase.$anonfun$testLongProjectionList$2(BoxesRunTime.unboxToInt((Object)x$1)), Stream$.MODULE$.canBuildFrom())).mkString(",");
        Assertions.assertThat((int)TestData$.MODULE$.smallTupleData3().size()).isEqualTo(sink.getAppendResults().size());
        sink.getAppendResults().foreach((Function1 & Serializable & scala.Serializable)result -> Assertions.assertThat((String)result).isEqualTo(expected));
    }

    @Test
    public void testIfFunction() {
        String testDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.data1());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(224).append("\n         |CREATE TABLE t (\n         |  a int,\n         |  b varchar,\n         |  c int\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(testDataId).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        .colon.colon expected = new .colon.colon((Object)"false,1", (List)new .colon.colon((Object)"false,2", (List)new .colon.colon((Object)"false,3", (List)new .colon.colon((Object)"true,4", (List)new .colon.colon((Object)"true,5", (List)new .colon.colon((Object)"true,6", (List)Nil$.MODULE$))))));
        List actual = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().executeSql("SELECT IF(a > 3, 'true', 'false'), a from t").collect()).map((Function1 & Serializable & scala.Serializable)r -> r.toString()).toList();
        Assertions.assertThat((Object)actual.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSourceWithCustomInternalData() {
        GenericRowData rowData1 = new GenericRowData(2);
        rowData1.setField(0, (Object)BoxesRunTime.boxToLong((long)1L));
        rowData1.setField(1, (Object)CalcITCase.createMapData$1(1L, 2L));
        GenericRowData rowData2 = new GenericRowData(2);
        rowData2.setField(0, (Object)BoxesRunTime.boxToLong((long)2L));
        rowData2.setField(1, (Object)CalcITCase.createMapData$1(4L, 5L));
        .colon.colon values = new .colon.colon((Object)rowData1, (List)new .colon.colon((Object)rowData2, (List)Nil$.MODULE$));
        String myTableDataId = TestValuesTableFactory.registerRowData((Seq<RowData>)values);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(274).append("\n         |CREATE TABLE CustomTable (\n         |  a bigint,\n         |  b map<bigint, bigint>\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'register-internal-data' = 'true',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.env().getConfig().disableObjectReuse();
        this.tEnv().executeSql(ddl);
        TableResult result = this.tEnv().executeSql("select a, b from CustomTable");
        .colon.colon expected = new .colon.colon((Object)"1,{1=2}", (List)new .colon.colon((Object)"2,{4=5}", (List)Nil$.MODULE$));
        Buffer actual = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(CollectionUtil.iteratorToList((Iterator)result.collect())).map((Function1 & Serializable & scala.Serializable)r -> r.toString(), Buffer$.MODULE$.canBuildFrom());
        Assertions.assertThat((Object)actual.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleProject() {
        String myTableDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(233).append("\n         |CREATE TABLE SimpleTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("select a, c from SimpleTable")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,Hi", (List)new .colon.colon((Object)"2,Hello", (List)new .colon.colon((Object)"3,Hello world", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNestedProject() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HI", BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)111), BoxesRunTime.boxToBoolean((boolean)true)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hi", BoxesRunTime.boxToInteger((int)1111)})), "tom"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HELLO", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)222), BoxesRunTime.boxToBoolean((boolean)false)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello", BoxesRunTime.boxToInteger((int)2222)})), "mary"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HELLO WORLD", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)333), BoxesRunTime.boxToBoolean((boolean)true)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello world", BoxesRunTime.boxToInteger((int)3333)})), "benji"}))}));
        String myTableDataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(448).append("\n         |CREATE TABLE NestedTable (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |                 nested2 row<num int, flag boolean>>,\n         |  nested row<name string, `value` int>,\n         |  name string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'false',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |from NestedTable\n        |")).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,HI,1111,true,111", (List)new .colon.colon((Object)"2,HELLO,2222,false,222", (List)new .colon.colon((Object)"3,HELLO WORLD,3333,true,333", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalArrayWithDifferentPrecision() {
        String sqlQuery = "SELECT ARRAY[0.12, 0.5, 0.99]";
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"[0.12, 0.50, 0.99]", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalMapWithDifferentPrecision() {
        String sqlQuery = "SELECT Map['a', 0.12, 'b', 0.5]";
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{a=0.12, b=0.50}", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCurrentWatermark() {
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Instant.ofEpochSecond(644326662L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Instant.ofEpochSecond(1622466300L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), Instant.ofEpochSecond(1622466300L)}))}));
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        this.tEnv().getConfig().set("table.local-time-zone", "Europe/Berlin");
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n                       |CREATE TABLE T (\n                       |  id INT,\n                       |  ts TIMESTAMP_LTZ(3),\n                       |  WATERMARK FOR ts AS ts\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(tableId).append("',\n                       |  'bounded' = 'true'\n                       |)\n       ").toString())).stripMargin());
        List result1 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().from("T").select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.$("id"), org.apache.flink.table.api.package$.MODULE$.currentWatermark(org.apache.flink.table.api.package$.MODULE$.$("ts"))}).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result1), (String)new StringOps(Predef$.MODULE$.augmentString("1,null\n        |2,1990-06-02T11:37:42Z\n        |3,2021-05-31T13:05:00Z\n        |")).stripMargin());
        List result2 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT id, CURRENT_WATERMARK(ts) FROM T").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result2), (String)new StringOps(Predef$.MODULE$.augmentString("1,null\n        |2,1990-06-02T11:37:42Z\n        |3,2021-05-31T13:05:00Z\n        |")).stripMargin());
        List result3 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT id FROM T WHERE CURRENT_WATERMARK(ts) IS NULL OR ts > CURRENT_WATERMARK(ts)\n          |")).stripMargin()).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result3), (String)new StringOps(Predef$.MODULE$.augmentString("1\n        |2\n        |")).stripMargin());
        List result4 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                  |SELECT\n                  |  TUMBLE_END(ts, INTERVAL '1' SECOND),\n                  |  CURRENT_WATERMARK(ts)\n                  |FROM T\n                  |GROUP BY\n                  |  TUMBLE(ts, INTERVAL '1' SECOND),\n                  |  CURRENT_WATERMARK(ts)\n                  |")).stripMargin()).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result4), (String)new StringOps(Predef$.MODULE$.augmentString("1990-06-02T13:37:43,null\n        |2021-05-31T15:05:01,1990-06-02T11:37:42Z\n        |2021-05-31T15:05:01,2021-05-31T13:05:00Z\n        |")).stripMargin());
    }

    @Test
    public void testCurrentWatermarkForNonRowtimeAttribute() {
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n                       |CREATE TABLE T (\n                       |  ts TIMESTAMP_LTZ(3)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(tableId).append("',\n                       |  'bounded' = 'true'\n                       |)\n       ").toString())).stripMargin());
        Assertions.assertThatThrownBy(() -> this.tEnv().sqlQuery("SELECT CURRENT_WATERMARK(ts) FROM T")).hasMessage("SQL validation failed. Invalid function call:\nCURRENT_WATERMARK(TIMESTAMP_LTZ(3))");
    }

    @Test
    public void testCurrentWatermarkWithoutAnyAttribute() {
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n                       |CREATE TABLE T (\n                       |  ts TIMESTAMP_LTZ(3)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(tableId).append("',\n                       |  'bounded' = 'true'\n                       |)\n       ").toString())).stripMargin());
        Assertions.assertThatThrownBy(() -> this.tEnv().sqlQuery("SELECT ts, CURRENT_WATERMARK() FROM T")).hasMessage("SQL validation failed. From line 1, column 12 to line 1, column 30: No match found for function signature CURRENT_WATERMARK().\nSupported signatures are:\nCURRENT_WATERMARK(<TIMESTAMP_WITHOUT_TIME_ZONE *ROWTIME*>)\nCURRENT_WATERMARK(<TIMESTAMP_WITH_LOCAL_TIME_ZONE *ROWTIME*>)");
    }

    @Test
    public void testCreateTemporaryTableFromDescriptor() {
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)42)}))}));
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        this.tEnv().createTemporaryTable("T", TableDescriptor.forConnector((String)"values").schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build()).option("data-id", tableId).option("bounded", "true").build());
        List result = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT * FROM T").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result), (String)"42");
    }

    @Test
    public void testSearch() {
        DataStream stream = this.env().fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HC809", "H389N     "}), (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        this.tEnv().createTemporaryView("SimpleTable", stream, Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT upper(f0) from SimpleTable where upper(f0) in (\n        |'CTNBSmokeSensor',\n        |'H388N',\n        |'H389N     ',\n        |'GHL-IRD',\n        |'JY-BF-20YN',\n        |'HC809',\n        |'DH-9908N-AEP',\n        |'DH-9908N'\n        |)\n        |")).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"HC809", (List)new .colon.colon((Object)"H389N     ", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMultipleCoalesces() {
        List result = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT COALESCE(1),\nCOALESCE(1, 2),\nCOALESCE(cast(NULL as int), 2),\nCOALESCE(1, cast(NULL as int)),\nCOALESCE(cast(NULL as int), cast(NULL as int), 3),\nCOALESCE(4, cast(NULL as int), cast(NULL as int), cast(NULL as int)),\nCOALESCE('1'),\nCOALESCE('1', '23'),\nCOALESCE(cast(NULL as varchar), '2'),\nCOALESCE('1', cast(NULL as varchar)),\nCOALESCE(cast(NULL as varchar), cast(NULL as varchar), '3'),\nCOALESCE('4', cast(NULL as varchar), cast(NULL as varchar), cast(NULL as varchar)),\nCOALESCE(1.0),\nCOALESCE(1.0, 2),\nCOALESCE(cast(NULL as double), 2.0),\nCOALESCE(cast(NULL as double), 2.0, 3.0),\nCOALESCE(2.0, cast(NULL as double), 3.0),\nCOALESCE(cast(NULL as double), cast(NULL as double))").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result), (String)"1,1,2,1,3,4,1,1,2,1,3,4,1.0,1.0,2.0,2.0,2.0,null");
    }

    @Test
    public void testCurrentDatabase() {
        List result1 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT CURRENT_DATABASE()").execute().collect()).toList();
        Assertions.assertThat((Object)result1).isEqualTo((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tEnv().getCurrentDatabase()}))})));
        ((Catalog)this.tEnv().getCatalog(this.tEnv().getCurrentCatalog()).get()).createDatabase("db1", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), "db1"), false);
        this.tEnv().useDatabase("db1");
        List result2 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT CURRENT_DATABASE()").execute().collect()).toList();
        Assertions.assertThat((Object)result2).isEqualTo((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tEnv().getCurrentDatabase()}))})));
    }

    @Test
    public void testLikeWithConditionContainsDoubleQuotationMark() {
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)42), "abc"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "cbc\"ddd"}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(207).append("\n         |CREATE TABLE MyTable (\n         |  a int,\n         |  b string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                  | SELECT * FROM MyTable WHERE b LIKE '%\"%'\n                  |")).stripMargin())).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,cbc\"ddd", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNonMergeableRandCall() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$18 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("SimpleTable", t);
        Table result = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                   |SELECT b - a FROM (\n                   |  SELECT r + 5 AS a, r + 7 AS b FROM (\n                   |    SELECT RAND() AS r FROM SimpleTable\n                   |  ) t1\n                   |) t2\n                   |")).stripMargin());
        TestingAppendSink sink = new TestingAppendSink();
        this.tEnv().toDataStream(result, (AbstractDataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE()})).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2.0", (List)new .colon.colon((Object)"2.0", (List)new .colon.colon((Object)"2.0", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ String $anonfun$testLongProjectionList$1(int i) {
        return new StringBuilder(67).append("CASE WHEN a IS NOT NULL AND a > ").append(i).append(" THEN 0 WHEN a < 0 THEN 0 ELSE ").append(i).append(" END").toString();
    }

    public static final /* synthetic */ String $anonfun$testLongProjectionList$2(int x$1) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
    }

    private static final MapData createMapData$1(long k, long v) {
        HashMap<Long, Long> mapData = new HashMap<Long, Long>();
        mapData.put(BoxesRunTime.boxToLong((long)k), BoxesRunTime.boxToLong((long)v));
        return new MapDataSerializerTest.CustomMapData(mapData);
    }
}

