/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.ChangelogSourceITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithMiniBatchTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t]g\u0001B\u0001\u0003\u0001M\u0011Qc\u00115b]\u001e,Gn\\4T_V\u00148-Z%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011ad\u0015;sK\u0006l\u0017N\\4XSRDW*\u001b8j\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\t\u0011m\u0001!\u0011!Q\u0001\nq\t!b]8ve\u000e,Wj\u001c3f!\ti\u0002I\u0004\u0002\u001fc9\u0011q\u0004\r\b\u0003A=r!!\t\u0018\u000f\u0005\tjcBA\u0012-\u001d\t!3F\u0004\u0002&U9\u0011a%K\u0007\u0002O)\u0011\u0001FE\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u0004\t\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u00119QA\r\u0002\t\u0002M\nQc\u00115b]\u001e,Gn\\4T_V\u00148-Z%U\u0007\u0006\u001cX\r\u0005\u00025k5\t!AB\u0003\u0002\u0005!\u0005ag\u0005\u00026oA\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001aDQAP\u001b\u0005\u0002}\na\u0001P5oSRtD#A\u001a\u0007\t\u0005+\u0004I\u0011\u0002\u000b'>,(oY3N_\u0012,7\u0003\u0002!8\u0007\u001a\u0003\"\u0001\u000f#\n\u0005\u0015K$a\u0002)s_\u0012,8\r\u001e\t\u0003q\u001dK!\u0001S\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011)\u0003%Q3A\u0005\u0002-\u000bA!\\8eKV\tA\n\u0005\u0002N#:\u0011aj\u0014\t\u0003MeJ!\u0001U\u001d\u0002\rA\u0013X\rZ3g\u0013\t\u00116K\u0001\u0004TiJLgn\u001a\u0006\u0003!fB\u0001\"\u0016!\u0003\u0012\u0003\u0006I\u0001T\u0001\u0006[>$W\r\t\u0005\u0006}\u0001#\ta\u0016\u000b\u00031j\u0003\"!\u0017!\u000e\u0003UBQA\u0013,A\u00021CQ\u0001\u0018!\u0005Bu\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002\u0019\"9q\fQA\u0001\n\u0003\u0001\u0017\u0001B2paf$\"\u0001W1\t\u000f)s\u0006\u0013!a\u0001\u0019\"91\rQI\u0001\n\u0003!\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0002K*\u0012AJZ\u0016\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\\\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002oS\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fA\u0004\u0015\u0011!C!c\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012A\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fA\u0001\\1oO*\tq/\u0001\u0003kCZ\f\u0017B\u0001*u\u0011\u001dQ\b)!A\u0005\u0002m\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012\u0001 \t\u0003quL!A`\u001d\u0003\u0007%sG\u000fC\u0005\u0002\u0002\u0001\u000b\t\u0011\"\u0001\u0002\u0004\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0003\u0003\u0017\u00012\u0001OA\u0004\u0013\r\tI!\u000f\u0002\u0004\u0003:L\b\u0002CA\u0007\u007f\u0006\u0005\t\u0019\u0001?\u0002\u0007a$\u0013\u0007C\u0005\u0002\u0012\u0001\u000b\t\u0011\"\u0011\u0002\u0014\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0016A1\u0011qCA\u000f\u0003\u000bi!!!\u0007\u000b\u0007\u0005m\u0011(\u0001\u0006d_2dWm\u0019;j_:LA!a\b\u0002\u001a\tA\u0011\n^3sCR|'\u000fC\u0005\u0002$\u0001\u000b\t\u0011\"\u0001\u0002&\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002(\u00055\u0002c\u0001\u001d\u0002*%\u0019\u00111F\u001d\u0003\u000f\t{w\u000e\\3b]\"Q\u0011QBA\u0011\u0003\u0003\u0005\r!!\u0002\t\u0013\u0005E\u0002)!A\u0005B\u0005M\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003qD\u0011\"a\u000eA\u0003\u0003%\t%!\u000f\u0002\r\u0015\fX/\u00197t)\u0011\t9#a\u000f\t\u0015\u00055\u0011QGA\u0001\u0002\u0004\t)aB\u0005\u0002@U\n\t\u0011#\u0001\u0002B\u0005Q1k\\;sG\u0016lu\u000eZ3\u0011\u0007e\u000b\u0019E\u0002\u0005Bk\u0005\u0005\t\u0012AA#'\u0015\t\u0019%a\u0012G!\u0019\tI%!\u0014M16\u0011\u00111\n\u0006\u0003\u000feJA!a\u0014\u0002L\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\t\u000fy\n\u0019\u0005\"\u0001\u0002TQ\u0011\u0011\u0011\t\u0005\n9\u0006\r\u0013\u0011!C#\u0003/\"\u0012A\u001d\u0005\u000b\u00037\n\u0019%!A\u0005\u0002\u0006u\u0013!B1qa2LHc\u0001-\u0002`!1!*!\u0017A\u00021C!\"a\u0019\u0002D\u0005\u0005I\u0011QA3\u0003\u001d)h.\u00199qYf$B!a\u001a\u0002nA!\u0001(!\u001bM\u0013\r\tY'\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005=\u0014\u0011MA\u0001\u0002\u0004A\u0016a\u0001=%a!Q\u00111OA\"\u0003\u0003%I!!\u001e\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003o\u00022a]A=\u0013\r\tY\b\u001e\u0002\u0007\u001f\nTWm\u0019;\t\u0013\u0005}TG1A\u0005\u0002\u0005\u0005\u0015\u0001E\"I\u0003:;U\tT(H?N{UKU\"F+\u0005A\u0006bBACk\u0001\u0006I\u0001W\u0001\u0012\u0007\"\u000bejR#M\u001f\u001e{6kT+S\u0007\u0016\u0003\u0003\"CAEk\t\u0007I\u0011AAA\u0003\u0019\u001a\u0005*\u0011(H\u000b2{uiX*P+J\u001bUiX,J)\"{VIV#O)N{F)\u0016)M\u0013\u000e\u000bE+\u0012\u0005\b\u0003\u001b+\u0004\u0015!\u0003Y\u0003\u001d\u001a\u0005*\u0011(H\u000b2{uiX*P+J\u001bUiX,J)\"{VIV#O)N{F)\u0016)M\u0013\u000e\u000bE+\u0012\u0011\t\u0013\u0005EUG1A\u0005\u0002\u0005\u0005\u0015!D+Q'\u0016\u0013FkX*P+J\u001bU\tC\u0004\u0002\u0016V\u0002\u000b\u0011\u0002-\u0002\u001dU\u00036+\u0012*U?N{UKU\"FA!I\u0011\u0011T\u001bC\u0002\u0013\u0005\u0011\u0011Q\u0001\u0011\u001d>{V\u000b\u0015#B)\u0016{6kT+S\u0007\u0016Cq!!(6A\u0003%\u0001,A\tO\u001f~+\u0006\u000bR!U\u000b~\u001bv*\u0016*D\u000b\u0002Bq!!)6\t\u0003\t\u0019+\u0001\u0006qCJ\fW.\u001a;feN$\"!!*\u0011\r\u0005\u001d\u0016QVAY\u001b\t\tIKC\u0002\u0002,Z\fA!\u001e;jY&!\u0011qVAU\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0006q\u0005M\u0016qO\u0005\u0004\u0003kK$!B!se\u0006L\b\u0006CAP\u0003s\u000b\t.a5\u0011\t\u0005m\u0016QZ\u0007\u0003\u0003{SA!a0\u0002B\u0006i\u0001/\u0019:b[\u0016$XM]5{K\u0012TA!a1\u0002F\u0006QQ\r\u001f;f]NLwN\\:\u000b\t\u0005\u001d\u0017\u0011Z\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0004\u0003\u0017d\u0011!\u0003;fgR,H/\u001b7t\u0013\u0011\ty-!0\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\u0003oC6,\u0017EAAk\u0003-\u001av.\u001e:dKvZ\b' \u0017!\u001b&t\u0017NQ1uG\"l40M?-AM#\u0018\r^3CC\u000e\\WM\u001c3>wJj\bBCAm\u0001\t\u0005\t\u0015!\u0003\u0002\\\u0006IQ.\u001b8j\u0005\u0006$8\r\u001b\t\u0005\u0003;\f9O\u0004\u0003\u0002`\u0006\rhb\u0001\u0011\u0002b&\u0011qCB\u0005\u0004\u0003K4\u0012AH*ue\u0016\fW.\u001b8h/&$\b.T5oS\n\u000bGo\u00195UKN$()Y:f\u0013\u0011\tI/a;\u0003\u001b5Kg.\u001b\"bi\u000eDWj\u001c3f\u0015\r\t)O\u0006\u0005\u000b\u0003_\u0004!\u0011!Q\u0001\n\u0005E\u0018!B:uCR,\u0007\u0003BAz\u0003stA!a8\u0002v&\u0019\u0011q\u001f\f\u00025M#(/Z1nS:<w+\u001b;i'R\fG/\u001a+fgR\u0014\u0015m]3\n\t\u0005m\u0018Q \u0002\u0011'R\fG/\u001a\"bG.,g\u000eZ'pI\u0016T1!a>\u0017\u0011\u0019q\u0004\u0001\"\u0001\u0003\u0002QA!1\u0001B\u0003\u0005\u000f\u0011I\u0001\u0005\u00025\u0001!11$a@A\u0002qA\u0001\"!7\u0002\u0000\u0002\u0007\u00111\u001c\u0005\t\u0003_\fy\u00101\u0001\u0002r\"I!Q\u0002\u0001C\u0002\u0013%!qB\u0001\u0002?V\u0011!\u0011\u0003\t\u0007\u0005'\u0011YBa\b\u000e\u0005\tU!\u0002BAf\u0005/Q1A!\u0007\r\u0003\u0011\u0019wN]3\n\t\tu!Q\u0003\u0002\u0014\u000b\u0006\u001c\u0007nQ1mY\n\f7m[,sCB\u0004XM\u001d\t\u0005\u0005C\u0011)#\u0004\u0002\u0003$)\u0011qCC\u0005\u0005\u0005O\u0011\u0019C\u0001\nMK\u001e\f7-\u001f*po\u0016CH/\u001a8tS>t\u0007\u0002\u0003B\u0016\u0001\u0001\u0006IA!\u0005\u0002\u0005}\u0003\u0003\u0006\u0002B\u0015\u0005_\u0001BA!\r\u0003B5\u0011!1\u0007\u0006\u0005\u0005k\u00119$A\u0005fqR,gn]5p]*!!\u0011\bB\u001e\u0003\r\t\u0007/\u001b\u0006\u0005\u0005{\u0011y$A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u001d\u0007#\u0003\u0003\u0003D\tM\"!\u0005*fO&\u001cH/\u001a:FqR,gn]5p]\"9!q\t\u0001\u0005B\t%\u0013A\u00022fM>\u0014X\r\u0006\u0002\u0003LA\u0019\u0001H!\u0014\n\u0007\t=\u0013H\u0001\u0003V]&$\b\u0006\u0002B#\u0005'\u0002BA!\u0016\u0003X5\u0011!qG\u0005\u0005\u00053\u00129D\u0001\u0006CK\u001a|'/Z#bG\"DqA!\u0018\u0001\t\u0003\u0011I%A\nuKN$Hk\u001c*fiJ\f7\r^*ue\u0016\fW\u000e\u000b\u0003\u0003\\\t\u0005\u0004\u0003\u0002B+\u0005GJAA!\u001a\u00038\taA+Z:u)\u0016l\u0007\u000f\\1uK\"9!\u0011\u000e\u0001\u0005\u0002\t%\u0013\u0001\u0005;fgR$v.\u00169tKJ$8+\u001b8lQ\u0011\u00119G!\u0019\t\u000f\t=\u0004\u0001\"\u0001\u0003J\u0005iA/Z:u\u0003\u001e<'/Z4bi\u0016DCA!\u001c\u0003b!9!Q\u000f\u0001\u0005\u0002\t%\u0013!\u0007;fgR\fum\u001a:fO\u0006$X\rV8VaN,'\u000f^*j].DCAa\u001d\u0003b!9!1\u0010\u0001\u0005\u0002\t%\u0013\u0001\u0007;fgR<%o\\;q\u0005ftuN\u001c)sS6\f'/_&fs\"\"!\u0011\u0010B1\u0011\u001d\u0011\t\t\u0001C\u0001\u0005\u0013\n!\u0002^3ti\u001aKG\u000e^3sQ\u0011\u0011yH!\u0019\t\u000f\t\u001d\u0005\u0001\"\u0001\u0003J\u0005yA/Z:u%\u0016<W\u000f\\1s\u0015>Lg\u000e\u000b\u0003\u0003\u0006\n\u0005\u0004b\u0002BG\u0001\u0011%!\u0011J\u0001\u0018e\u0016<\u0017n\u001d;fe\u000eC\u0017M\\4fY><7k\\;sG\u0016DqA!%\u0001\t\u0013\u0011I%\u0001\u0016sK\u001eL7\u000f^3s\u0007\"\fgnZ3m_\u001e\u001cv.\u001e:dK^KG\u000f[#wK:$8\u000fR;qY&\u001c\u0017\r^3\t\u000f\tU\u0005\u0001\"\u0003\u0003J\u0005!\"/Z4jgR,'/\u00169tKJ$8k\\;sG\u0016DqA!'\u0001\t\u0013\u0011I%\u0001\fsK\u001eL7\u000f^3s\u001d>,\u0006\u000fZ1uKN{WO]2f\u0011\u001d\u0011i\n\u0001C\u0005\u0005?\u000bQcY8om\u0016\u0014H\u000fV8O_V\u0003H-\u0019;f\t\u0006$\u0018\r\u0006\u0003\u0003\"\n}\u0006C\u0002BR\u0005[\u0013\u0019L\u0004\u0003\u0003&\n%fb\u0001\u0014\u0003(&\t!(C\u0002\u0003,f\nq\u0001]1dW\u0006<W-\u0003\u0003\u00030\nE&aA*fc*\u0019!1V\u001d\u0011\t\tU&1X\u0007\u0003\u0005oS1A!/\r\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0011iLa.\u0003\u0007I{w\u000f\u0003\u0005\u0003B\nm\u0005\u0019\u0001BQ\u0003\u0011!\u0017\r^1)\u000f\u0001\u0011)Ma3\u0003NB!!\u0011\u0007Bd\u0013\u0011\u0011IMa\r\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\r\f\u0002\u0003P\u000e\u0012!\u0011\u001b\t\u0005\u0003w\u0013\u0019.\u0003\u0003\u0003V\u0006u&A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>t\u0007")
public class ChangelogSourceITCase
extends StreamingWithMiniBatchTestBase {
    private final SourceMode sourceMode;
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _;

    @Parameters(name="Source={0}, MiniBatch={1}, StateBackend={2}")
    public static Collection<Object[]> parameters() {
        return ChangelogSourceITCase$.MODULE$.parameters();
    }

    public static SourceMode NO_UPDATE_SOURCE() {
        return ChangelogSourceITCase$.MODULE$.NO_UPDATE_SOURCE();
    }

    public static SourceMode UPSERT_SOURCE() {
        return ChangelogSourceITCase$.MODULE$.UPSERT_SOURCE();
    }

    public static SourceMode CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE() {
        return ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE();
    }

    public static SourceMode CHANGELOG_SOURCE() {
        return ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE();
    }

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        String orderDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.ordersData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(351).append("\n                       |CREATE TABLE orders (\n                       |  amount BIGINT,\n                       |  currency STRING\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(orderDataId).append("',\n                       | 'changelog-mode' = 'I'\n                       |)\n                       |").toString())).stripMargin());
        SourceMode sourceMode = this.sourceMode;
        SourceMode sourceMode2 = ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE();
        SourceMode sourceMode3 = sourceMode;
        if (!(sourceMode2 != null ? !((Object)sourceMode2).equals(sourceMode3) : sourceMode3 != null)) {
            this.registerChangelogSource();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            SourceMode sourceMode4 = ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE();
            SourceMode sourceMode5 = sourceMode;
            if (!(sourceMode4 != null ? !((Object)sourceMode4).equals(sourceMode5) : sourceMode5 != null)) {
                this.registerChangelogSourceWithEventsDuplicate();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                SourceMode sourceMode6 = ChangelogSourceITCase$.MODULE$.UPSERT_SOURCE();
                SourceMode sourceMode7 = sourceMode;
                if (!(sourceMode6 != null ? !((Object)sourceMode6).equals(sourceMode7) : sourceMode7 != null)) {
                    this.registerUpsertSource();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    SourceMode sourceMode8 = ChangelogSourceITCase$.MODULE$.NO_UPDATE_SOURCE();
                    SourceMode sourceMode9 = sourceMode;
                    if (!(sourceMode8 != null ? !((Object)sourceMode8).equals(sourceMode9) : sourceMode9 != null)) {
                        this.registerNoUpdateSource();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)sourceMode);
                    }
                }
            }
        }
    }

    @TestTemplate
    public void testToRetractStream() {
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT * FROM users")).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        TestingRetractSink sink = new TestingRetractSink();
        result.addSink((SinkFunction)sink).setParallelism(result.parallelism());
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user1,Tom,tom123@gmail.com,8.10,16.20", "user3,Bailey,bailey@qq.com,9.99,19.98", "user4,Tina,tina@gmail.com,11.30,22.60"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testToUpsertSink() {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE user_sink (\n         |  user_id STRING PRIMARY KEY NOT ENFORCED,\n         |  user_name STRING,\n         |  email STRING,\n         |  balance DECIMAL(18,2),\n         |  balance2 DECIMAL(18,2)\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |")).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO user_sink\n         |SELECT * FROM users\n         |")).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user1,Tom,tom123@gmail.com,8.10,16.20", "user3,Bailey,bailey@qq.com,9.99,19.98", "user4,Tina,tina@gmail.com,11.30,22.60"}));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("user_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        SourceMode sourceMode = this.sourceMode;
        SourceMode sourceMode2 = ChangelogSourceITCase$.MODULE$.CHANGELOG_SOURCE_WITH_EVENTS_DUPLICATE();
        SourceMode sourceMode3 = sourceMode;
        if (!(sourceMode2 != null ? !((Object)sourceMode2).equals(sourceMode3) : sourceMode3 != null)) {
            List<String> rawResult = TestValuesTableFactory.getRawResultsAsStrings("user_sink");
            boolean hasUB = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rawResult).exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)r.startsWith("-U")));
            Assertions.assertThat((boolean)hasUB).isFalse();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @TestTemplate
    public void testAggregate() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT count(*), sum(balance), max(email)\n         |FROM users\n         |")).stripMargin();
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        TestingRetractSink sink = new TestingRetractSink();
        result.addSink((SinkFunction)sink).setParallelism(result.parallelism());
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,29.39,tom123@gmail.com"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggregateToUpsertSink() {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE user_sink (\n         |  `scope` STRING,\n         |  cnt BIGINT,\n         |  sum_balance DECIMAL(18,2),\n         |  max_email STRING,\n         |  PRIMARY KEY (`scope`) NOT ENFORCED\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |")).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO user_sink\n         |SELECT 'ALL', count(*), sum(balance), max(email)\n         |FROM users\n         |GROUP BY 'ALL'\n         |")).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALL,3,29.39,tom123@gmail.com"}));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("user_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testGroupByNonPrimaryKey() {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE user_sink (\n         |  balance DECIMAL(18,2),\n         |  cnt BIGINT,\n         |  max_email STRING,\n         |  PRIMARY KEY (balance) NOT ENFORCED\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |")).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO user_sink\n         |SELECT balance2, count(*), max(email)\n         |FROM users\n         |GROUP BY balance2\n         |")).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"16.20,1,tom123@gmail.com", "19.98,1,bailey@qq.com", "22.60,1,tina@gmail.com"}));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("user_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testFilter() {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE user_sink (\n         |  user_id STRING PRIMARY KEY NOT ENFORCED,\n         |  user_name STRING,\n         |  email STRING,\n         |  balance DECIMAL(18,2),\n         |  balance2 DECIMAL(18,2)\n         |) WITH (\n         | 'connector' = 'values',\n         | 'sink-insert-only' = 'false'\n         |)\n         |")).stripMargin();
        String dml = new StringOps(Predef$.MODULE$.augmentString("\n         |INSERT INTO user_sink\n         |SELECT * FROM users WHERE balance > 9\n         |")).stripMargin();
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql(dml).await();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user3,Bailey,bailey@qq.com,9.99,19.98", "user4,Tina,tina@gmail.com,11.30,22.60"}));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("user_sink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testRegularJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT o.currency, o.amount, r.rate, o.amount * r.rate\n         |FROM orders AS o JOIN rates AS r\n         |ON o.currency = r.currency\n         |")).stripMargin();
        TestingRetractSink sink = new TestingRetractSink();
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink).setParallelism(result.parallelism());
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Euro,2,119,238", "Euro,3,119,357", "US Dollar,1,102,102", "US Dollar,5,102,510"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private void registerChangelogSource() {
        String userDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.userChangelog());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(552).append("\n                       |CREATE TABLE users (\n                       |  user_id STRING,\n                       |  user_name STRING,\n                       |  email STRING,\n                       |  balance DECIMAL(18,2),\n                       |  balance2 AS balance * 2\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(userDataId).append("',\n                       | 'changelog-mode' = 'I,UA,UB,D',\n                       | 'disable-lookup' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        String ratesDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.ratesHistoryData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(394).append("\n                       |CREATE TABLE rates (\n                       |  currency STRING,\n                       |  rate BIGINT\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(ratesDataId).append("',\n                       |  'changelog-mode' = 'I,UB,UA,D',\n                       |  'disable-lookup' = 'true'\n                       |)\n      ").toString())).stripMargin());
    }

    private void registerChangelogSourceWithEventsDuplicate() {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SOURCE_CDC_EVENTS_DUPLICATE, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Seq userChangelog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{TestValuesTableFactory.changelogRow("+I", "user1", "Tom", "tom@gmail.com", new BigDecimal("10.02")), TestValuesTableFactory.changelogRow("+I", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("+I", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("-U", "user1", "Tom", "tom@gmail.com", new BigDecimal("10.02")), TestValuesTableFactory.changelogRow("+U", "user1", "Tom", "tom123@gmail.com", new BigDecimal("8.1")), TestValuesTableFactory.changelogRow("-U", "user1", "Tom", "tom@gmail.com", new BigDecimal("10.02")), TestValuesTableFactory.changelogRow("+U", "user1", "Tom", "tom123@gmail.com", new BigDecimal("8.1")), TestValuesTableFactory.changelogRow("+I", "user3", "Bailey", "bailey@gmail.com", new BigDecimal("9.99")), TestValuesTableFactory.changelogRow("-D", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("-D", "user2", "Jack", "jack@hotmail.com", new BigDecimal("71.2")), TestValuesTableFactory.changelogRow("+I", "user4", "Tina", "tina@gmail.com", new BigDecimal("11.3")), TestValuesTableFactory.changelogRow("-U", "user3", "Bailey", "bailey@gmail.com", new BigDecimal("9.99")), TestValuesTableFactory.changelogRow("+U", "user3", "Bailey", "bailey@qq.com", new BigDecimal("9.99"))}));
        String userDataId = TestValuesTableFactory.registerData((Seq<Row>)userChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(620).append("\n                       |CREATE TABLE users (\n                       |  user_id STRING,\n                       |  user_name STRING,\n                       |  email STRING,\n                       |  balance DECIMAL(18,2),\n                       |  balance2 AS balance * 2,\n                       |  PRIMARY KEY (user_name, user_id) NOT ENFORCED\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(userDataId).append("',\n                       | 'changelog-mode' = 'UA,D',\n                       | 'disable-lookup' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        Seq ratesChangelog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{TestValuesTableFactory.changelogRow("+I", "US Dollar", 102L), TestValuesTableFactory.changelogRow("+I", "Euro", 114L), TestValuesTableFactory.changelogRow("+I", "Euro", 114L), TestValuesTableFactory.changelogRow("+I", "Yen", 1L), TestValuesTableFactory.changelogRow("-U", "Euro", 114L), TestValuesTableFactory.changelogRow("+U", "Euro", 116L), TestValuesTableFactory.changelogRow("-U", "Euro", 116L), TestValuesTableFactory.changelogRow("+U", "Euro", 119L), TestValuesTableFactory.changelogRow("-U", "Euro", 116L), TestValuesTableFactory.changelogRow("+U", "Euro", 119L), TestValuesTableFactory.changelogRow("-D", "Yen", 1L), TestValuesTableFactory.changelogRow("-D", "Yen", 1L)}));
        String ratesDataId = TestValuesTableFactory.registerData((Seq<Row>)ratesChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(452).append("\n                       |CREATE TABLE rates (\n                       |  currency STRING,\n                       |  rate BIGINT,\n                       |  PRIMARY KEY (currency) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(ratesDataId).append("',\n                       |  'changelog-mode' = 'UA,D',\n                       |  'disable-lookup' = 'true'\n                       |)\n      ").toString())).stripMargin());
    }

    private void registerUpsertSource() {
        String userDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.userUpsertlog());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(620).append("\n                       |CREATE TABLE users (\n                       |  user_id STRING,\n                       |  user_name STRING,\n                       |  email STRING,\n                       |  balance DECIMAL(18,2),\n                       |  balance2 AS balance * 2,\n                       |  PRIMARY KEY (user_name, user_id) NOT ENFORCED\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(userDataId).append("',\n                       | 'changelog-mode' = 'UA,D',\n                       | 'disable-lookup' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        String ratesDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.ratesUpsertData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(452).append("\n                       |CREATE TABLE rates (\n                       |  currency STRING,\n                       |  rate BIGINT,\n                       |  PRIMARY KEY (currency) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(ratesDataId).append("',\n                       |  'changelog-mode' = 'UA,D',\n                       |  'disable-lookup' = 'true'\n                       |)\n      ").toString())).stripMargin());
    }

    private void registerNoUpdateSource() {
        Seq<Row> userChangelog = this.convertToNoUpdateData(TestData$.MODULE$.userChangelog());
        String userDataId = TestValuesTableFactory.registerData(userChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(546).append("\n                       |CREATE TABLE users (\n                       |  user_id STRING,\n                       |  user_name STRING,\n                       |  email STRING,\n                       |  balance DECIMAL(18,2),\n                       |  balance2 AS balance * 2\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(userDataId).append("',\n                       | 'changelog-mode' = 'I,D',\n                       | 'disable-lookup' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        Seq<Row> ratesChangelog = this.convertToNoUpdateData(TestData$.MODULE$.ratesHistoryData());
        String ratesDataId = TestValuesTableFactory.registerData(ratesChangelog);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n                       |CREATE TABLE rates (\n                       |  currency STRING,\n                       |  rate BIGINT\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(ratesDataId).append("',\n                       |  'changelog-mode' = 'I,D',\n                       |  'disable-lookup' = 'true'\n                       |)\n      ").toString())).stripMargin());
    }

    private Seq<Row> convertToNoUpdateData(Seq<Row> data) {
        return (Seq)data.map((Function1 & Serializable & scala.Serializable)row -> {
            Row row2;
            RowKind rowKind = row.getKind();
            boolean bl = RowKind.INSERT.equals(rowKind) ? true : RowKind.DELETE.equals(rowKind);
            if (bl) {
                row2 = row;
            } else if (RowKind.UPDATE_BEFORE.equals(rowKind)) {
                Row ret = Row.copy((Row)row);
                ret.setKind(RowKind.DELETE);
                row2 = ret;
            } else if (RowKind.UPDATE_AFTER.equals(rowKind)) {
                Row ret = Row.copy((Row)row);
                ret.setKind(RowKind.INSERT);
                row2 = ret;
            } else {
                throw new MatchError((Object)rowKind);
            }
            return row2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public ChangelogSourceITCase(SourceMode sourceMode, StreamingWithMiniBatchTestBase.MiniBatchMode miniBatch, StreamingWithStateTestBase.StateBackendMode state) {
        this.sourceMode = sourceMode;
        super(miniBatch, state);
        this._ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());
    }

    public static class SourceMode
    implements Product,
    scala.Serializable {
        private final String mode;

        public String mode() {
            return this.mode;
        }

        public String toString() {
            return this.mode();
        }

        public SourceMode copy(String mode) {
            return new SourceMode(mode);
        }

        public String copy$default$1() {
            return this.mode();
        }

        public String productPrefix() {
            return "SourceMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.mode();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SourceMode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SourceMode)) return false;
            boolean bl = true;
            if (!bl) return false;
            SourceMode sourceMode = (SourceMode)x$1;
            String string = this.mode();
            String string2 = sourceMode.mode();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!sourceMode.canEqual(this)) return false;
            return true;
        }

        public SourceMode(String mode) {
            this.mode = mode;
            Product.$init$((Product)this);
        }
    }
}

