/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.time.LocalDateTime;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001'\t1b)\u001b7uKJ\f'\r\\3T_V\u00148-Z%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011\u0011c\u0015;sK\u0006l\u0017N\\4UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\u0003}+\u0012A\t\t\u0004G!RS\"\u0001\u0013\u000b\u0005\u00152\u0013!\u0003;fgR,H/\u001b7t\u0015\t9C\"\u0001\u0003d_J,\u0017BA\u0015%\u0005M)\u0015m\u00195DC2d'-Y2l/J\f\u0007\u000f]3s!\tYS&D\u0001-\u0015\t9\"\"\u0003\u0002/Y\t\u0011B*Z4bGf\u0014vn^#yi\u0016t7/[8o\u0011\u0019\u0001\u0004\u0001)A\u0005E\u0005\u0011q\f\t\u0015\u0003_I\u0002\"a\r\u001f\u000e\u0003QR!!\u000e\u001c\u0002\u0013\u0015DH/\u001a8tS>t'BA\u001c9\u0003\r\t\u0007/\u001b\u0006\u0003si\nqA[;qSR,'O\u0003\u0002<!\u0005)!.\u001e8ji&\u0011Q\b\u000e\u0002\u0012%\u0016<\u0017n\u001d;fe\u0016CH/\u001a8tS>t\u0007\"B \u0001\t\u0003\u0001\u0015A\u0005;fgR4\u0015\u000e\u001c;feB+8\u000f\u001b3po:$\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0005+:LG\u000f\u000b\u0002?\u0011B\u0011\u0011JS\u0007\u0002m%\u00111J\u000e\u0002\u0005)\u0016\u001cH\u000fC\u0003N\u0001\u0011\u0005\u0001)\u0001\fuKN$x+\u001b;i%\u0016TWm\u0019;fI\u001aKG\u000e^3sQ\ta\u0005\nC\u0003Q\u0001\u0011\u0005\u0001)\u0001\u0014uKN$\bK]8kK\u000e$x+\u001b;i/\u0006$XM]7be.4\u0015\u000e\u001c;feB+8\u000f\u001b3po:D#a\u0014%")
public class FilterableSourceITCase
extends StreamingTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testFilterPushdown() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23")}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(418).append("\n         | CREATE TABLE MyTable(\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP(3),\n         |   WATERMARK FOR c AS c\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'filterable-fields' = 'a;c;d',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        String query = "SELECT * FROM MyTable WHERE a > 1";
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,3,2020-11-21T21:00:05.230"}));
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWithRejectedFilter() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23")}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(416).append("\n         | CREATE TABLE MyTable(\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP(3),\n         |   WATERMARK FOR c AS c\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'filterable-fields' = 'c;d',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        String query = "SELECT * FROM MyTable WHERE a > 1";
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,3,2020-11-21T21:00:05.230"}));
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProjectWithWatermarkFilterPushdown() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), "Hello", LocalDateTime.parse("2020-11-21T19:00:05.23")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), "World", LocalDateTime.parse("2020-11-21T21:00:05.23")}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(432).append("\n         |CREATE TABLE TableWithWatermark (\n         |  a int,\n         |  b bigint,\n         |  c string,\n         |  d timestamp(3),\n         |  WATERMARK FOR d as d\n         |) WITH (\n         |  'connector' = 'values',\n         |  'filterable-fields' = 'c',\n         |  'enable-watermark-push-down' = 'true',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'false',\n         |  'disable-lookup' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery("select a,b from TableWithWatermark WHERE LOWER(c) = 'world'")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,3", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }
}

