/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.math.BigDecimal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.utils.TestDataTypeTableSource$;
import org.apache.flink.table.planner.utils.TestInputFormatTableSource$;
import org.apache.flink.table.planner.utils.TestLegacyFilterableTableSource$;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestPartitionableSourceFactory$;
import org.apache.flink.table.planner.utils.TestStreamTableSource$;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001'\t9B*Z4bGf$\u0016M\u00197f'>,(oY3J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!E*ue\u0016\fW.\u001b8h)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\u0006A\u0001!\t!I\u0001\"i\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQ>,HOU8xi&lW\r\u0015:pGRLW.\u001a\u000b\u0002EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t!QK\\5uQ\ty\u0012\u0006\u0005\u0002+c5\t1F\u0003\u0002-[\u0005\u0019\u0011\r]5\u000b\u00059z\u0013a\u00026va&$XM\u001d\u0006\u0003aA\tQA[;oSRL!AM\u0016\u0003\tQ+7\u000f\u001e\u0005\u0006i\u0001!\t!I\u0001\u001bi\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQ>,H\u000f\u0015:pGRLW.\u001a\u0015\u0003g%BQa\u000e\u0001\u0005\u0002\u0005\n\u0011\u0004^3tiB\u0013xN[3di^KG\u000f[8viJ{w\u000f^5nK\"\u0012a'\u000b\u0005\u0006u\u0001!\t!I\u0001\u0018i\u0016\u001cH\u000f\u0015:pU\u0016\u001cGo\u00148msB\u0013xn\u0019;j[\u0016DQ\u0001\u0010\u0001\u0005\u0002\u0005\na\u0003^3tiB\u0013xN[3di>sG.\u001f*poRLW.\u001a\u0015\u0003w%BQa\u0010\u0001\u0005\u0002\u0005\na\u0003^3tiB\u0013xN[3di^KG\u000f['baBLgn\u001a\u0015\u0003}%BQA\u0011\u0001\u0005\u0002\u0005\n\u0011\u0003^3ti:+7\u000f^3e!J|'.Z2uQ\t\t\u0015\u0006C\u0003F\u0001\u0011\u0005\u0011%A\u000fuKN$H+\u00192mKN{WO]2f/&$\bNR5mi\u0016\u0014\u0018M\u00197fQ\t!\u0015\u0006C\u0003I\u0001\u0011\u0005\u0011%\u0001\u0011uKN$H+\u00192mKN{WO]2f/&$\b\u000eU1si&$\u0018n\u001c8bE2,\u0007FA$*\u0011\u0015Y\u0005\u0001\"\u0001\"\u0003I!Xm\u001d;DgZ$\u0016M\u00197f'>,(oY3)\u0005)K\u0003\"\u0002(\u0001\t\u0003\t\u0013A\b;fgRdun\\6va*{\u0017N\\\"tmR+W\u000e]8sC2$\u0016M\u00197fQ\ti\u0015\u0006C\u0003R\u0001\u0011\u0005\u0011%A\u000buKN$\u0018J\u001c9vi\u001a{'/\\1u'>,(oY3)\u0005AK\u0003\"\u0002+\u0001\t\u0003\t\u0013!\u0005;fgR$UmY5nC2\u001cv.\u001e:dK\"\u00121+\u000b\u0005\u0006/\u0002!\t!I\u0001.i\u0016\u001cH\u000fT3hC\u000eLH)Z2j[\u0006d7k\\;sG\u0016,6/\u001b8h'R\u0014X-Y7UC\ndWmU8ve\u000e,\u0007F\u0001,*\u0001")
public class LegacyTableSourceITCase
extends StreamingTestBase {
    @Test
    public void testProjectWithoutRowtimeProctime() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), "Mary", new Long(10L), new Long(1L)}), Row.of((Object[])new Object[]{new Integer(2), "Bob", new Long(20L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(3), "Mike", new Long(30L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(4), "Liz", new Long(40L), new Long(2001L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.LONG(), Types.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT name, val, id FROM T")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,10,1", "Bob,20,2", "Mike,30,3", "Liz,40,4"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProjectWithoutProctime() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), "Mary", new Long(10L), new Long(1L)}), Row.of((Object[])new Object[]{new Integer(2), "Bob", new Long(20L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(3), "Mike", new Long(30L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(4), "Liz", new Long(40L), new Long(2001L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.LONG(), Types.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT rtime, name, id FROM T")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01T00:00:00.001,Mary,1", "1970-01-01T00:00:00.002,Bob,2", "1970-01-01T00:00:00.002,Mike,3", "1970-01-01T00:00:02.001,Liz,4"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProjectWithoutRowtime() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), "Mary", new Long(10L), new Long(1L)}), Row.of((Object[])new Object[]{new Integer(2), "Bob", new Long(20L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(3), "Mike", new Long(30L), new Long(2L)}), Row.of((Object[])new Object[]{new Integer(4), "Liz", new Long(40L), new Long(2001L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.LONG(), Types.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        String sqlQuery = "SELECT name, id FROM T";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1", "Bob,2", "Mike,3", "Liz,4"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public void testProjectOnlyProctime() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), new Long(1L), new Long(10L), "Mary"}), Row.of((Object[])new Object[]{new Integer(2), new Long(2L), new Long(20L), "Bob"}), Row.of((Object[])new Object[]{new Integer(3), new Long(2L), new Long(30L), "Mike"}), Row.of((Object[])new Object[]{new Integer(4), new Long(2001L), new Long(30L), "Liz"})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        String sqlQuery = "SELECT COUNT(1) FROM T WHERE ptime > 0";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProjectOnlyRowtime() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Integer(1), new Long(1L), new Long(10L), "Mary"}), Row.of((Object[])new Object[]{new Integer(2), new Long(2L), new Long(20L), "Bob"}), Row.of((Object[])new Object[]{new Integer(3), new Long(2L), new Long(30L), "Mike"}), Row.of((Object[])new Object[]{new Integer(4), new Long(2001L), new Long(30L), "Liz"})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT rtime FROM T")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01T00:00:00.001", "1970-01-01T00:00:00.002", "1970-01-01T00:00:00.002", "1970-01-01T00:00:02.001"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProjectWithMapping() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Long(1L), new Integer(1), "Mary", new Long(10L)}), Row.of((Object[])new Object[]{new Long(2L), new Integer(2), "Bob", new Long(20L)}), Row.of((Object[])new Object[]{new Long(2L), new Integer(3), "Mike", new Long(30L)}), Row.of((Object[])new Object[]{new Long(2001L), new Integer(4), "Liz", new Long(40L)})}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.INT(), Types.STRING(), Types.LONG()}), (String[])((Object[])new String[]{"p-rtime", "p-id", "p-name", "p-val"}));
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rtime"), (Object)"p-rtime"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"p-id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"val"), (Object)"p-val"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"p-name")}));
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, "rtime", "ptime", (Map<String, String>)mapping));
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT name, rtime, val FROM T")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary,1970-01-01T00:00:00.001,10", "Bob,1970-01-01T00:00:00.002,20", "Mike,1970-01-01T00:00:00.002,30", "Liz,1970-01-01T00:00:02.001,40"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNestedProject() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{new Long(1L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Sarah", new Integer(100)}), Row.of((Object[])new Object[]{new Integer(1000), new Boolean(true)})}), Row.of((Object[])new Object[]{"Peter", new Integer(10000)}), "Mary"}), Row.of((Object[])new Object[]{new Long(2L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Rob", new Integer(200)}), Row.of((Object[])new Object[]{new Integer(2000), new Boolean(false)})}), Row.of((Object[])new Object[]{"Lucy", new Integer(20000)}), "Bob"}), Row.of((Object[])new Object[]{new Long(3L), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"Mike", new Integer(300)}), Row.of((Object[])new Object[]{new Integer(3000), new Boolean(true)})}), Row.of((Object[])new Object[]{"Betty", new Integer(30000)}), "Liz"})}));
        RowTypeInfo nested1 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.INT()}), (String[])((Object[])new String[]{"name", "value"}));
        RowTypeInfo nested2 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.BOOLEAN()}), (String[])((Object[])new String[]{"num", "flag"}));
        RowTypeInfo deepNested = new RowTypeInfo((TypeInformation[])new RowTypeInfo[]{nested1, nested2}, (String[])((Object[])new String[]{"nested1", "nested2"}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), deepNested, nested1, Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), deepNested, nested1, Types.STRING()}), (String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}));
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", (TableSource)new TestNestedProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)data, TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$5(), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |FROM T\n      ")).stripMargin();
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,Sarah,10000,true,1000", "2,Rob,20000,false,2000", "3,Mike,30000,true,3000"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testTableSourceWithFilterable() {
        TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), TestLegacyFilterableTableSource$.MODULE$.defaultSchema(), "MyTable", TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$4(), TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$5(), TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$6());
        String sqlQuery = "SELECT id, name FROM MyTable WHERE amount > 4 AND price < 9";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"5,Record_5", "6,Record_6", "7,Record_7", "8,Record_8"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testTableSourceWithPartitionable() {
        TestPartitionableSourceFactory$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), "PartitionableTable", true);
        String sqlQuery = "SELECT * FROM PartitionableTable WHERE part2 > 1 and id > 2 AND part1 = 'A'";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,John,A,2", "4,nosharp,A,2"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCsvTableSource() {
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)this.tEnv(), "persons");
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT id, `first`, `last`, score FROM persons WHERE id < 4 ")).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,Mike,Smith,12.3", "2,Bob,Taylor,45.6", "3,Sam,Miller,7.89"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLookupJoinCsvTemporalTable() {
        TestTableSourceSinks$.MODULE$.createOrdersCsvTemporaryTable((TableEnvironment)this.tEnv(), "orders");
        TestTableSourceSinks$.MODULE$.createRatesCsvTemporaryTable((TableEnvironment)this.tEnv(), "rates");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT o.amount, o.currency, r.rate\n        |FROM (SELECT *, PROCTIME() as proc FROM orders) AS o\n        |JOIN rates FOR SYSTEM_TIME AS OF o.proc AS r\n        |ON o.currency = r.currency\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,Euro,119", "1,US Dollar,102", "50,Yen,1", "3,Euro,119", "5,US Dollar,102"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testInputFormatSource() {
        TableSchema tableSchema = TableSchema.builder().fields((String[])((Object[])new String[]{"a", "b", "c"}), (DataType[])((Object[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()})).build();
        TestInputFormatTableSource$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), tableSchema, TestData$.MODULE$.smallData3(), "MyInputFormatTable");
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT a, c FROM MyInputFormatTable")).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,Hi", "2,Hello", "3,Hello world"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalSource() {
        TableSchema tableSchema = TableSchema.builder().fields((String[])((Object[])new String[]{"a", "b", "c", "d"}), (DataType[])((Object[])new DataType[]{DataTypes.INT(), DataTypes.DECIMAL((int)5, (int)2), DataTypes.VARCHAR((int)5), DataTypes.CHAR((int)5)})).build();
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new BigDecimal(5.1), "1", "1"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), new BigDecimal(6.1), "12", "12"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), new BigDecimal(7.1), "123", "123"}))}));
        TestDataTypeTableSource$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), tableSchema, "MyInputFormatTable", (Seq<Row>)data.seq());
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT a, b, c, d FROM MyInputFormatTable")).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,5.10,1,1", "2,6.10,12,12", "3,7.10,123,123"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLegacyDecimalSourceUsingStreamTableSource() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"a", "b", "c"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.DECIMAL(), Types.STRING()}));
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new BigDecimal(5.1), "1"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), new BigDecimal(6.1), "12"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), new BigDecimal(7.1), "123"}))}));
        TestStreamTableSource$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), tableSchema, "MyInputFormatTable", (Seq<Row>)data);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT a, b, c FROM MyInputFormatTable")).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,5.099999999999999645,1", "2,6.099999999999999645,12", "3,7.099999999999999645,123"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }
}

