/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001'\t\u0011B*[7jiB\u0012V-\\8wK&#6)Y:f\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003U!Xm\u001d;TS6\u0004H.\u001a'j[&$(+Z7pm\u0016$\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000f\u000b\u0002 SA\u0011!&M\u0007\u0002W)\u0011A&L\u0001\u0004CBL'B\u0001\u00180\u0003\u001dQW\u000f]5uKJT!\u0001\r\t\u0002\u000b),h.\u001b;\n\u0005IZ#\u0001\u0002+fgRDQ\u0001\u000e\u0001\u0005\u0002\u0005\n!\u0004^3ti2KW.\u001b;SK6|g/Z,ji\"|%\u000fZ3s\u0005fD#aM\u0015\t\u000b]\u0002A\u0011A\u0011\u00023Q,7\u000f\u001e'j[&$(+Z7pm\u0016<\u0016\u000e\u001e5TK2,7\r\u001e\u0015\u0003m%BQA\u000f\u0001\u0005\u0002\u0005\nQ\u0003^3ti2KW.\u001b;SK6|g/Z,ji\"Le\u000e\u000b\u0002:S!)Q\b\u0001C\u0001C\u0005AB/Z:u\u0019&l\u0017\u000e\u001e*f[>4XmV5uQ:{G/\u00138)\u0005qJ\u0003\"\u0002!\u0001\t\u0003\t\u0013!\u0007;fgRd\u0015.\\5u%\u0016lwN^3XSRDW\t_5tiND#aP\u0015\t\u000b\r\u0003A\u0011A\u0011\u00029Q,7\u000f\u001e'j[&$(+Z7pm\u0016<\u0016\u000e\u001e5O_R,\u00050[:ug\"\u0012!)\u000b\u0005\u0006\r\u0002!\t!I\u0001\u0018i\u0016\u001cH\u000fT5nSR\u0014V-\\8wK^KG\u000f\u001b&pS:D#!R\u0015")
public class Limit0RemoveITCase
extends StreamingTestBase {
    @Test
    public void testSimpleLimitRemove() {
        DataStream ds = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table = package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable", table);
        String sql = "SELECT * FROM MyTable LIMIT 0";
        Table result = this.tEnv().sqlQuery(sql);
        TestingAppendTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingAppendTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        result.executeInsert("MySink").await();
        Assertions.assertThat((int)sink.getAppendResults().size()).isZero();
    }

    @Test
    public void testLimitRemoveWithOrderBy() {
        DataStream ds = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table = package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable", table);
        String sql = "SELECT * FROM MyTable ORDER BY a LIMIT 0";
        Table result = this.tEnv().sqlQuery(sql);
        TestingAppendTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingAppendTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        result.executeInsert("MySink").await();
        Assertions.assertThat((int)sink.getAppendResults().size()).isZero();
    }

    @Test
    public void testLimitRemoveWithSelect() {
        DataStream ds = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table = package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable", table);
        String sql = "select a2 from (select cast(a as int) a2 from MyTable limit 0)";
        Table result = this.tEnv().sqlQuery(sql);
        TestingAppendTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingAppendTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        result.executeInsert("MySink").await();
        Assertions.assertThat((int)sink.getAppendResults().size()).isZero();
    }

    @Test
    public void testLimitRemoveWithIn() {
        DataStream ds1 = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table1 = package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable1", table1);
        DataStream ds2 = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table2 = package$.MODULE$.dataStreamConversions(ds2).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable2", table2);
        String sql = "SELECT * FROM MyTable1 WHERE a IN (SELECT a FROM MyTable2 LIMIT 0)";
        Table result = this.tEnv().sqlQuery(sql);
        TestingAppendTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingAppendTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        result.executeInsert("MySink").await();
        Assertions.assertThat((int)sink.getAppendResults().size()).isZero();
    }

    @Test
    public void testLimitRemoveWithNotIn() {
        DataStream ds1 = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table1 = package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable1", table1);
        DataStream ds2 = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table2 = package$.MODULE$.dataStreamConversions(ds2).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable2", table2);
        String sql = "SELECT * FROM MyTable1 WHERE a NOT IN (SELECT a FROM MyTable2 LIMIT 0)";
        Table result = this.tEnv().sqlQuery(sql);
        TestingAppendTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingAppendTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        result.executeInsert("MySink").await();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3", "4", "5", "6"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @Test
    public void testLimitRemoveWithExists() {
        DataStream ds1 = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table1 = package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable1", table1);
        DataStream ds2 = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table2 = package$.MODULE$.dataStreamConversions(ds2).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable2", table2);
        String sql = "SELECT * FROM MyTable1 WHERE EXISTS (SELECT a FROM MyTable2 LIMIT 0)";
        Table result = this.tEnv().sqlQuery(sql);
        TestingRetractTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingRetractTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        result.executeInsert("MySink").await();
        Assertions.assertThat((int)sink.getRawResults().size()).isZero();
    }

    @Test
    public void testLimitRemoveWithNotExists() {
        DataStream ds1 = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table1 = package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable1", table1);
        DataStream ds2 = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table2 = package$.MODULE$.dataStreamConversions(ds2).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        this.tEnv().createTemporaryView("MyTable2", table2);
        String sql = "SELECT * FROM MyTable1 WHERE NOT EXISTS (SELECT a FROM MyTable2 LIMIT 0)";
        Table result = this.tEnv().sqlQuery(sql);
        TestingRetractTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingRetractTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        result.executeInsert("MySink").await();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3", "4", "5", "6"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @Test
    public void testLimitRemoveWithJoin() {
        DataStream ds1 = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table1 = package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1"))}));
        this.tEnv().createTemporaryView("MyTable1", table1);
        DataStream ds2 = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table table2 = package$.MODULE$.dataStreamConversions(ds2).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2"))}));
        this.tEnv().createTemporaryView("MyTable2", table2);
        String sql = "SELECT a1 FROM MyTable1 INNER JOIN (SELECT a2 FROM MyTable2 LIMIT 0) ON true";
        Table result = this.tEnv().sqlQuery(sql);
        TestingAppendTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingAppendTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        result.executeInsert("MySink").await();
        Assertions.assertThat((int)sink.getAppendResults().size()).isZero();
    }
}

