/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001'\t)B*[7ji\u0006\u0014G.Z*pkJ\u001cW-\u0013+DCN,'BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\t\t2\u000b\u001e:fC6Lgn\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%\t!I\u0001\u0005I\u0006$\u0018-F\u0001#!\r\u0019\u0003FK\u0007\u0002I)\u0011QEJ\u0001\u000bG>dG.Z2uS>t'\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%\"#aA*fcB\u00111FL\u0007\u0002Y)\u0011Q\u0006D\u0001\u0006if\u0004Xm]\u0005\u0003_1\u00121AU8x\u0011\u0019\t\u0004\u0001)A\u0005E\u0005)A-\u0019;bA!)1\u0007\u0001C\u0001i\u0005)1/\u001a;vaR\tQ\u0007\u0005\u00027o5\ta%\u0003\u00029M\t!QK\\5uQ\t\u0011$\b\u0005\u0002<\u00056\tAH\u0003\u0002>}\u0005\u0019\u0011\r]5\u000b\u0005}\u0002\u0015a\u00026va&$XM\u001d\u0006\u0003\u0003B\tQA[;oSRL!a\u0011\u001f\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003F\u0001\u0011\u0005A'A\u0005uKN$H*[7ji\"\u0012Ai\u0012\t\u0003w!K!!\u0013\u001f\u0003\tQ+7\u000f\u001e\u0005\u0006\u0017\u0002!\t\u0001N\u0001\u0013i\u0016\u001cHo\u00144gg\u0016$\u0018I\u001c3GKR\u001c\u0007\u000e\u000b\u0002K\u000f\u0002")
public class LimitableSourceITCase
extends StreamingTestBase {
    private final Seq<Row> data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"book", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"book", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)19)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"book", BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fruit", BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fruit", BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)44)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fruit", BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)22)}))}));

    public Seq<Row> data() {
        return this.data;
    }

    @BeforeEach
    public void setup() {
        String dataId = TestValuesTableFactory.registerData(this.data());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(243).append("\n         |CREATE TABLE Source (\n         |  category STRING,\n         |  shopId INT,\n         |  num INT\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'false'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
    }

    @Test
    public void testLimit() {
        String sql = "SELECT * FROM Source LIMIT 4";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"book,1,12", "book,2,19", "book,4,11", "fruit,4,33"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testOffsetAndFetch() {
        String sql = "SELECT * FROM Source LIMIT 4 OFFSET 2";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"book,4,11", "fruit,4,33", "fruit,3,44", "fruit,5,22"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }
}

