/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.LookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.InMemoryLookupableTableSource$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestAddWithOpen$;
import org.apache.flink.table.runtime.functions.table.fullcache.inputformat.FullCacheTestInputFormat;
import org.apache.flink.table.runtime.functions.table.lookup.LookupCacheManager;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\tEh\u0001B\u0001\u0003\u0001M\u0011\u0001\u0003T8pWV\u0004(j\\5o\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0015)H/\u001b7t\u0013\tIbCA\tTiJ,\u0017-\\5oOR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0012Y\u0016<\u0017mY=UC\ndWmU8ve\u000e,\u0007CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"a\u0002\"p_2,\u0017M\u001c\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005I1-Y2iKRK\b/\u001a\t\u0003K}r!A\n\u001f\u000f\u0005\u001dJdB\u0001\u00157\u001d\tICG\u0004\u0002+g9\u00111F\r\b\u0003YEr!!\f\u0019\u000e\u00039R!a\f\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA\b\u0011\u0013\tia\"\u0003\u0002\f\u0019%\u0011QGC\u0001\nG>tg.Z2u_JL!a\u000e\u001d\u0002\rM|WO]2f\u0015\t)$\"\u0003\u0002;w\u00051An\\8lkBT!a\u000e\u001d\n\u0005ur\u0014!\u0004'p_.,\bo\u00149uS>t7O\u0003\u0002;w%\u0011\u0001)\u0011\u0002\u0010\u0019>|7.\u001e9DC\u000eDW\rV=qK*\u0011QH\u0010\u0005\u0006\u0007\u0002!\t\u0001R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0015;\u0005\n\u0005\u0002G\u00015\t!\u0001C\u0003\u001c\u0005\u0002\u0007A\u0004C\u0003$\u0005\u0002\u0007A\u0005C\u0004K\u0001\t\u0007I\u0011A&\u0002\t\u0011\fG/Y\u000b\u0002\u0019B\u0019QJ\u0015+\u000e\u00039S!a\u0014)\u0002\u0013%lW.\u001e;bE2,'BA)\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003':\u0013A\u0001T5tiB\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bD\u0001\u0006if\u0004Xm]\u0005\u00033Z\u00131AU8x\u0011\u0019Y\u0006\u0001)A\u0005\u0019\u0006)A-\u0019;bA!9Q\f\u0001b\u0001\n\u0003Y\u0015\u0001\u00043bi\u0006<\u0016\u000e\u001e5Ok2d\u0007BB0\u0001A\u0003%A*A\u0007eCR\fw+\u001b;i\u001dVdG\u000e\t\u0005\bC\u0002\u0011\r\u0011\"\u0001L\u0003!)8/\u001a:ECR\f\u0007BB2\u0001A\u0003%A*A\u0005vg\u0016\u0014H)\u0019;bA!9Q\r\u0001b\u0001\n\u0003Y\u0015\u0001E;tKJ$\u0015\r^1XSRDg*\u001e7m\u0011\u00199\u0007\u0001)A\u0005\u0019\u0006\tRo]3s\t\u0006$\u0018mV5uQ:+H\u000e\u001c\u0011\t\u000b%\u0004A\u0011\t6\u0002\r\t,gm\u001c:f)\u0005Y\u0007CA\u000fm\u0013\tigD\u0001\u0003V]&$\bF\u00015p!\t\u0001x/D\u0001r\u0015\t\u00118/A\u0002ba&T!\u0001^;\u0002\u000f),\b/\u001b;fe*\u0011a\u000fE\u0001\u0006UVt\u0017\u000e^\u0005\u0003qF\u0014!BQ3g_J,W)Y2i\u0011\u0015Q\b\u0001\"\u0011k\u0003\u0015\tg\r^3sQ\tIH\u0010\u0005\u0002q{&\u0011a0\u001d\u0002\n\u0003\u001a$XM]#bG\"Dq!!\u0001\u0001\t\u0013\t\u0019!A\tde\u0016\fG/\u001a'p_.,\b\u000fV1cY\u0016$ra[A\u0003\u00033\tY\u0003C\u0004\u0002\b}\u0004\r!!\u0003\u0002\u0013Q\f'\r\\3OC6,\u0007\u0003BA\u0006\u0003'qA!!\u0004\u0002\u0010A\u0011QFH\u0005\u0004\u0003#q\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0016\u0005]!AB*ue&twMC\u0002\u0002\u0012yAaAS@A\u0002\u0005m\u0001#BA\u000f\u0003O!f\u0002BA\u0010\u0003Gq1!LA\u0011\u0013\u0005y\u0012bAA\u0013=\u00059\u0001/Y2lC\u001e,\u0017bA*\u0002*)\u0019\u0011Q\u0005\u0010\t\u0013\u00055r\u0010%AA\u0002\u0005=\u0012a\u00047p_.,\b\u000f\u00165sKNDw\u000e\u001c3\u0011\u0007u\t\t$C\u0002\u00024y\u00111!\u00138u\u0011\u001d\t9\u0004\u0001C\u0005\u0003s\t1e\u0019:fCR,Gj\\8lkB$\u0016M\u00197f/&$\bnQ8naV$X\rZ\"pYVlg\u000eF\u0003l\u0003w\ti\u0004\u0003\u0005\u0002\b\u0005U\u0002\u0019AA\u0005\u0011\u001dQ\u0015Q\u0007a\u0001\u00037Aq!!\u0011\u0001\t\u0013\t\u0019%A\bde\u0016\fG/Z*dC:$\u0016M\u00197f)\u0015Y\u0017QIA$\u0011!\t9!a\u0010A\u0002\u0005%\u0001b\u0002&\u0002@\u0001\u0007\u00111\u0004\u0005\u0007\u0003\u0017\u0002A\u0011\u00016\u0002+Q,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK\"\"\u0011\u0011JA(!\r\u0001\u0018\u0011K\u0005\u0004\u0003'\n(\u0001\u0004+fgR$V-\u001c9mCR,\u0007BBA,\u0001\u0011\u0005!.\u0001\u0012uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDW\u000b\u001a4GS2$XM\u001d\u0015\u0005\u0003+\ny\u0005\u0003\u0004\u0002^\u0001!\tA[\u0001(i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b.\u00163g\u000bF,\u0018\r\u001c$jYR,'\u000f\u000b\u0003\u0002\\\u0005=\u0003BBA2\u0001\u0011\u0005!.\u0001\u0012uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]\u000e{gn\u001d;b]R\\U-\u001f\u0015\u0005\u0003C\ny\u0005\u0003\u0004\u0002j\u0001!\tA[\u0001#i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:tU\u000f\u001c7bE2,7*Z=)\t\u0005\u001d\u0014q\n\u0005\u0007\u0003_\u0002A\u0011\u00016\u0002CQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b)vg\"$un\u001e8)\t\u00055\u0014q\n\u0005\u0007\u0003k\u0002A\u0011\u00016\u0002OQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b(p]\u0016\u000bX/\u00197GS2$XM\u001d\u0015\u0005\u0003g\ny\u0005\u0003\u0004\u0002|\u0001!\tA[\u0001#i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:lU\u000f\u001c;j\r&,G\u000eZ:)\t\u0005e\u0014q\n\u0005\u0007\u0003\u0003\u0003A\u0011\u00016\u0002KQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK>sW*\u001e7uS.+\u0017PR5fY\u0012\u001c\b\u0006BA@\u0003\u001fBa!a\"\u0001\t\u0003Q\u0017A\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/[&fs\u001aKW\r\u001c3te!\"\u0011QQA(\u0011\u0019\ti\t\u0001C\u0001U\u0006!D/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7*Z=GS\u0016dGm],ji\"\u001cuN\\:uC:$8*Z=)\t\u0005-\u0015q\n\u0005\u0007\u0003'\u0003A\u0011\u00016\u0002uQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK>sW*\u001e7uS.+\u0017PR5fY\u0012\u001cx+\u001b;i'R\u0014\u0018N\\4D_:\u001cH/\u00198u\u0017\u0016L\b\u0006BAI\u0003\u001fBa!!'\u0001\t\u0003Q\u0017a\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/[\"p]N$\u0018M\u001c;LKfDC!a&\u0002P!1\u0011q\u0014\u0001\u0005\u0002)\f\u0011\u0004^3ti2+g\r\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK\"\"\u0011QTA(\u0011\u0019\t)\u000b\u0001C\u0001U\u00061C/Z:u\u0019\u00164GOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000e\u0015:f\r&dG/\u001a:)\t\u0005\r\u0016q\n\u0005\u0007\u0003W\u0003A\u0011\u00016\u0002SQ,7\u000f\u001e'fMRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\",FM\u001a)sK\u001aKG\u000e^3sQ\u0011\tI+a\u0014\t\r\u0005E\u0006\u0001\"\u0001k\u0003\u0019\"Xm\u001d;MK\u001a$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]:+H\u000e\\1cY\u0016\\U-\u001f\u0015\u0005\u0003_\u000by\u0005\u0003\u0004\u00028\u0002!\tA[\u0001)i\u0016\u001cH\u000fT3gi*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$8*Z=GS\u0016dGm\u001d\u0015\u0005\u0003k\u000by\u0005\u0003\u0004\u0002>\u0002!\tA[\u00012i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:lU\u000f\u001c;j\u0017\u0016Lh)[3mIN<\u0016\u000e\u001e5Ok2dG)\u0019;bQ\u0011\tY,a\u0014\t\r\u0005\r\u0007\u0001\"\u0001k\u0003U\"Xm\u001d;MK\u001a$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg^KG\u000f\u001b(vY2$\u0015\r^1)\t\u0005\u0005\u0017q\n\u0005\u0007\u0003\u0013\u0004A\u0011\u00016\u0002MQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK>sg*\u001e7m\u0007>t7\u000f^1oi.+\u0017\u0010\u000b\u0003\u0002H\u0006=\u0003BBAh\u0001\u0011\u0005!.\u0001\u001duKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg^KG\u000f\u001b(vY2\u001cuN\\:uC:$8*Z=)\t\u00055\u0017q\n\u0005\u0007\u0003+\u0004A\u0011\u00016\u0002YQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK>sW*\u001e7uS.+\u0017PR5fY\u0012\u001cx+\u001b;i+\u00123\u0005\u0006BAj\u0003\u001fBa!a7\u0001\t\u0003Q\u0017a\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"\u001cu.\u001c9vi\u0016$7i\u001c7v[:DC!!7\u0002P!1\u0011\u0011\u001d\u0001\u0005\u0002)\f!\u0007^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\u0006sG\rU;tQ\u0012{wO\u001c\u0015\u0005\u0003?\fy\u0005\u0003\u0004\u0002h\u0002!\tA[\u0001\u001fi\u0016\u001cHoQ;se\u0016tG\u000fR1uK&s'j\\5o\u0007>tG-\u001b;j_:DC!!:\u0002P!1\u0011Q\u001e\u0001\u0005\u0002)\fA\u0005^3ti2{wn[;q\u0007\u0006\u001c\u0007.Z*iCJLgnZ!de>\u001c8oU;ci\u0006\u001c8n\u001d\u0015\u0005\u0003W\fy\u0005C\u0004\u0002t\u0002!\t!!>\u0002\u0005)LG\u0003BA|\u0005\u000f\u0001B!!?\u0003\u00045\u0011\u00111 \u0006\u0005\u0003{\fy0\u0001\u0003mC:<'B\u0001B\u0001\u0003\u0011Q\u0017M^1\n\t\t\u0015\u00111 \u0002\b\u0013:$XmZ3s\u0011!\u0011I!!=A\u0002\u0005=\u0012!A5\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010\u0005\u0011!\u000e\u001c\u000b\u0005\u0005#\u00119\u0002\u0005\u0003\u0002z\nM\u0011\u0002\u0002B\u000b\u0003w\u0014A\u0001T8oO\"A!\u0011\u0004B\u0006\u0001\u0004\u0011Y\"A\u0001m!\ri\"QD\u0005\u0004\u0005+q\u0002B\u0002B\u0011\u0001\u0011\u0005!.\u0001\u0013uKN$\u0018iZ4B]\u0012dUM\u001a;K_&tw+\u001b;i)JL(+Z:pYZ,Wj\u001c3fQ\u0011\u0011y\"a\u0014\t\r\t\u001d\u0002\u0001\"\u0001k\u0003I\"Xm\u001d;BO\u001e\fe\u000e\u001a'fMRTu.\u001b8BY2\u001cuN\\:uC:$8*Z=XSRDGK]=SKN|GN^3N_\u0012,\u0007\u0006\u0002B\u0013\u0003\u001fBaA!\f\u0001\t\u0003Q\u0017A\f;fgR\fumZ!oI*{\u0017N\\!mY\u000e{gn\u001d;b]R\\U-_,ji\"$&/\u001f*fg>dg/Z'pI\u0016DCAa\u000b\u0002P!9!1\u0007\u0001\u0005\n\tU\u0012AE4fiJ+GO]=M_>\\W\u000f\u001d%j]R$b!!\u0003\u00038\tm\u0002\u0002\u0003B\u001d\u0005c\u0001\r!!\u0003\u0002\u00171|wn[;q)\u0006\u0014G.\u001a\u0005\t\u0005{\u0011\t\u00041\u0001\u00020\u0005YQ.\u0019=BiR,W\u000e\u001d;t\u0011\u0019\u0011\t\u0005\u0001C\u0001U\u0006qB/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i%\u0016$(/\u001f\u0015\u0005\u0005\u007f\ty\u0005\u0003\u0004\u0003H\u0001!\tA[\u0001>i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000eT8pWV\u0004H\u000b\u001b:fg\"|G\u000eZ,ji\"Len];gM&\u001c\u0017.\u001a8u%\u0016$(/\u001f\u0015\u0005\u0005\u000b\ny\u0005\u0003\u0004\u0003N\u0001!\tA[\u0001<i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000eT8pWV\u0004H\u000b\u001b:fg\"|G\u000eZ,ji\"\u001cVO\u001a4jG&,g\u000e\u001e*fiJL\b\u0006\u0002B&\u0003\u001fBaAa\u0015\u0001\t\u0003Q\u0017a\u000e;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"dun\\6vaRC'/Z:i_2$w+\u001b;i\u0019\u0006\u0014x-\u001a:SKR\u0014\u0018\u0010\u000b\u0003\u0003R\u0005=\u0003\"\u0003B-\u0001E\u0005I\u0011\u0002B.\u0003m\u0019'/Z1uK2{wn[;q)\u0006\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\f\u0016\u0005\u0003_\u0011yf\u000b\u0002\u0003bA!!1\rB7\u001b\t\u0011)G\u0003\u0003\u0003h\t%\u0014!C;oG\",7m[3e\u0015\r\u0011YGH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B8\u0005K\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2fQ\u001d\u0001!1\u000fB@\u0005\u0003\u0003BA!\u001e\u0003|5\u0011!q\u000f\u0006\u0004\u0005s\n\u0018!C3yi\u0016t7/[8o\u0013\u0011\u0011iHa\u001e\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\r\f\u0002\u0003\u0004\u000e\u0012!Q\u0011\t\u0005\u0005\u000f\u00139*\u0004\u0002\u0003\n*!!1\u0012BG\u00035\u0001\u0018M]1nKR,'/\u001b>fI*!!q\u0012BI\u0003))\u0007\u0010^3og&|gn\u001d\u0006\u0004m\nM%b\u0001BK\u0019\u0005IA/Z:ukRLGn]\u0005\u0005\u00053\u0013II\u0001\u000eQCJ\fW.\u001a;fe&TX\r\u001a+fgR,\u0005\u0010^3og&|gnB\u0004\u0003\u001e\nA\tAa(\u0002!1{wn[;q\u0015>Lg.\u0013+DCN,\u0007c\u0001$\u0003\"\u001a1\u0011A\u0001E\u0001\u0005G\u001bBA!)\u0003&B\u0019QDa*\n\u0007\t%fD\u0001\u0004B]f\u0014VM\u001a\u0005\b\u0007\n\u0005F\u0011\u0001BW)\t\u0011y\n\u0003\u0006\u00032\n\u0005&\u0019!C\u0001\u0005g\u000b1\u0003T#H\u0003\u000eKv\fV!C\u0019\u0016{6kT+S\u0007\u0016+\"A!.\u0011\t\u0005e(qW\u0005\u0004C\u0005m\b\"\u0003B^\u0005C\u0003\u000b\u0011\u0002B[\u0003QaUiR!D3~#\u0016I\u0011'F?N{UKU\"FA!Q!q\u0018BQ\u0005\u0004%\tAa-\u0002)\u0011Kf*Q'J\u0007~#\u0016I\u0011'F?N{UKU\"F\u0011%\u0011\u0019M!)!\u0002\u0013\u0011),A\u000bE3:\u000bU*S\"`)\u0006\u0013E*R0T\u001fV\u00136)\u0012\u0011\t\u0011\t\u001d'\u0011\u0015C\u0001\u0005\u0013\f!\u0002]1sC6,G/\u001a:t)\t\u0011Y\r\u0005\u0004\u0003N\nM'q[\u0007\u0003\u0005\u001fTAA!5\u0002\u0000\u0006!Q\u000f^5m\u0013\u0011\u0011)Na4\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0003\u001e\u00053\u0014i.C\u0002\u0003\\z\u0011Q!\u0011:sCf\u0004B!!?\u0003`&!!\u0011]A~\u0005\u0019y%M[3di\"B!Q\u0019Bs\u0005W\u0014i\u000f\u0005\u0003\u0003\b\n\u001d\u0018\u0002\u0002Bu\u0005\u0013\u0013!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\t=\u0018\u0001\n'fO\u0006\u001c\u0017\u0010V1cY\u0016\u001cv.\u001e:dKvZ\b' \u0017!G\u0006\u001c\u0007.\u001a+za\u0016l40M?")
public class LookupJoinITCase
extends StreamingTestBase {
    private final boolean legacyTableSource;
    private final LookupOptions.LookupCacheType cacheType;
    private final List<Row> data;
    private final List<Row> dataWithNull;
    private final List<Row> userData;
    private final List<Row> userDataWithNull;

    @Parameters(name="LegacyTableSource={0}, cacheType={1}")
    public static Collection<Object[]> parameters() {
        return LookupJoinITCase$.MODULE$.parameters();
    }

    public static Boolean DYNAMIC_TABLE_SOURCE() {
        return LookupJoinITCase$.MODULE$.DYNAMIC_TABLE_SOURCE();
    }

    public static Boolean LEGACY_TABLE_SOURCE() {
        return LookupJoinITCase$.MODULE$.LEGACY_TABLE_SOURCE();
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> dataWithNull() {
        return this.dataWithNull;
    }

    public List<Row> userData() {
        return this.userData;
    }

    public List<Row> userDataWithNull() {
        return this.userDataWithNull;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        if (this.legacyTableSource) {
            InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().set(0);
        } else {
            TestValuesTableFactory.RESOURCE_COUNTER.set(0);
            FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.set(0);
        }
        this.createScanTable("src", this.data());
        this.createScanTable("nullable_src", this.dataWithNull());
        this.createLookupTable("user_table", this.userData(), this.createLookupTable$default$3());
        this.createLookupTable("nullable_user_table", this.userDataWithNull(), this.createLookupTable$default$3());
        this.createLookupTable("user_table_with_lookup_threshold2", this.userData(), 2);
        this.createLookupTable("user_table_with_lookup_threshold3", this.userData(), 3);
        this.createLookupTableWithComputedColumn("userTableWithComputedColumn", this.userData());
    }

    @Override
    @AfterEach
    public void after() {
        if (this.legacyTableSource) {
            Assertions.assertThat((int)InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().get()).isZero();
        } else {
            Assertions.assertThat((int)TestValuesTableFactory.RESOURCE_COUNTER.get()).isZero();
            Assertions.assertThat((int)FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.get()).isZero();
        }
    }

    private void createLookupTable(String tableName, List<Row> data, int lookupThreshold) {
        if (this.legacyTableSource) {
            TableSchema userSchema = TableSchema.builder().field("age", Types.INT()).field("id", Types.LONG()).field("name", Types.STRING()).build();
            InMemoryLookupableTableSource$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), false, data, userSchema, tableName, InMemoryLookupableTableSource$.MODULE$.createTemporaryTable$default$6());
        } else {
            String string;
            String dataId = TestValuesTableFactory.registerData(data);
            LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
            LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.PARTIAL;
            if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n             |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin();
            } else {
                LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType;
                LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.FULL;
                string = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(90).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.FULL).append("',\n             |  '").append(LookupOptions.FULL_CACHE_RELOAD_STRATEGY.key()).append("' = '").append(LookupOptions.ReloadStrategy.PERIODIC).append("',\n             |  '").append(LookupOptions.FULL_CACHE_PERIODIC_RELOAD_INTERVAL.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin() : "";
            }
            String cacheOptions = string;
            String lookupThresholdOption = lookupThreshold > 0 ? new StringBuilder(28).append("'start-lookup-threshold'='").append(lookupThreshold).append("',").toString() : "";
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(407).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  ").append(lookupThresholdOption).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private int createLookupTable$default$3() {
        return -1;
    }

    private void createLookupTableWithComputedColumn(String tableName, List<Row> data) {
        block2: {
            String string;
            if (this.legacyTableSource) break block2;
            String dataId = TestValuesTableFactory.registerData(data);
            LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
            LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.PARTIAL;
            if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n             |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin();
            } else {
                LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType;
                LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.FULL;
                string = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(90).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.FULL).append("',\n             |  '").append(LookupOptions.FULL_CACHE_RELOAD_STRATEGY.key()).append("' = '").append(LookupOptions.ReloadStrategy.PERIODIC).append("',\n             |  '").append(LookupOptions.FULL_CACHE_PERIODIC_RELOAD_INTERVAL.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin() : "";
            }
            String cacheOptions = string;
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(432).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING,\n                         |  `nominal_age` as age + 1\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(386).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` BIGINT,\n                       |  `len` INT,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithUdfFilter() {
        this.tEnv().createTemporarySystemFunction("add", (UserDefinedFunction)new UserDefinedFunctionTestUtils.TestAddWithOpen());
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE add(T.id, D.id) > 3 AND add(T.id, 2) > 3 AND add (D.id, 2) > 3";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        Assertions.assertThat((int)UserDefinedFunctionTestUtils$TestAddWithOpen$.MODULE$.aliveCounter().get()).isZero();
    }

    @TestTemplate
    public void testJoinTemporalTableWithUdfEqualFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.id, T.len, T.content, D.name\n        |FROM\n        |  src AS T JOIN user_table for system_time as of T.proctime AS D\n        |ON T.id = D.id\n        |WHERE CONCAT('Hello-', D.name) = 'Hello-Jark'\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnConstantKey() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.id = 1";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Julian", "3,15,Fabian,Julian", "8,11,Hello world,Julian", "9,12,Hello world!,Julian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnNullableKey() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithPushDown() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithNonEqualFilter() {
        String sql = "SELECT T.id, T.len, T.content, D.name, D.age FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark,22", "3,15,Fabian,Fabian,33"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiFields() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFields() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFields2() {
        String sql = "SELECT t1.id, t1.len, D.name FROM (select proctime, content, id, len FROM src) t1 JOIN user_table for system_time as of t1.proctime AS D ON t1.content = D.name AND t1.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND 3 = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithStringConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.name = 'Fabian' AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.name = 'Fabian' AND 3 = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Fabian", "2,15,Fabian", "3,15,Fabian", "8,11,Fabian", "9,12,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,11", "2,15,Jark,22", "3,15,Fabian,33", "8,11,null,null", "9,12,null,null"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftJoinTemporalTableWithPreFilter() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.len < 15";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,11", "2,15,null,null", "3,15,null,null", "8,11,null,null", "9,12,null,null"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftJoinTemporalTableWithUdfPreFilter() {
        this.tEnv().createTemporarySystemFunction("add", (UserDefinedFunction)new UserDefinedFunctionTestUtils.TestAddWithOpen());
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND add(T.id, 2) > 4";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,null", "2,15,Hello,null", "3,15,Fabian,Fabian", "8,11,Hello world,null", "9,12,Hello world!,null"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        Assertions.assertThat((AtomicInteger)UserDefinedFunctionTestUtils$TestAddWithOpen$.MODULE$.aliveCounter()).hasValue(0);
    }

    @TestTemplate
    public void testLeftJoinTemporalTableOnNullableKey() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T LEFT OUTER JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null,15,null", "3,15,Fabian", "null,11,null", "9,12,null"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftJoinTemporalTableOnMultKeyFields() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id and T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,11", "2,15,null,null", "3,15,Fabian,33", "8,11,null,null", "9,12,null,null"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T JOIN nullable_user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,15,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = "SELECT D.id, T.len, D.name FROM nullable_src AS T LEFT JOIN nullable_user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null,15,null", "3,15,Fabian", "null,11,null", "null,12,null"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnNullConstantKey() {
        String sql = "SELECT T.id, T.len, T.content FROM nullable_src AS T JOIN nullable_user_table for system_time as of T.proctime AS D ON D.id = null";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((boolean)sink.getAppendResults().isEmpty()).isTrue();
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND null = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((boolean)sink.getAppendResults().isEmpty()).isTrue();
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithUDF() {
        String sql = "SELECT T.id, T.content, D.age, D.id FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id + 4 AND T.content = concat(D.name, '!') AND D.age = 11";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"9,Hello world!,11,5"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumn() {
        if (this.legacyTableSource) {
            return;
        }
        String sql = new StringBuilder(159).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM src AS T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian,11,12", "2,15,Hello,Jark,22,23", "3,15,Fabian,Fabian,33,34"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        if (this.legacyTableSource) {
            return;
        }
        String sql = new StringBuilder(182).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM src AS T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id and D.nominal_age > 12").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark,22,23", "3,15,Fabian,Fabian,33,34"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testCurrentDateInJoinCondition() {
        String id1 = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"abc", LocalDateTime.of(2000, 1, 1, 0, 0)})}))));
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(246).append("\n         |CREATE TABLE Ta (\n         |  id VARCHAR,\n         |  ts TIMESTAMP,\n         |  proc AS PROCTIME()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(id1).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl1);
        String id2 = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"abc", LocalDateTime.of(2000, 1, 2, 0, 0)})}))));
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(214).append("\n         |CREATE TABLE Tb (\n         |  id VARCHAR,\n         |  ts TIMESTAMP\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(id2).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl2);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM Ta AS t1\n        |INNER JOIN Tb FOR SYSTEM_TIME AS OF t1.proc AS t2\n        |ON t1.id = t2.id\n        |WHERE\n        |  CAST(coalesce(t1.ts, t2.ts) AS VARCHAR)\n        |  >=\n        |  CONCAT(CAST(CURRENT_DATE AS VARCHAR), ' 00:00:00')\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat(sink.getAppendResults()).isEqualTo((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    @TestTemplate
    public void testLookupCacheSharingAcrossSubtasks() {
        LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
        LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.NONE;
        if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
            return;
        }
        LookupCacheManager.keepCacheOnRelease((boolean)true);
        try {
            String sourceDdl = new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE T (\n           |  id BIGINT,\n           |  proc AS PROCTIME()\n           |) WITH (\n           |  'connector' = 'datagen',\n           |  'fields.id.kind' = 'sequence',\n           |  'fields.id.start' = '1',\n           |  'fields.id.end' = '6'\n           |)\n           |")).stripMargin();
            this.tEnv().executeSql(sourceDdl);
            String sql = new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT T.id, D.name, D.age FROM T \n          |LEFT JOIN user_table FOR SYSTEM_TIME AS OF T.proc AS D \n          |ON T.id = D.id\n          |")).stripMargin();
            TestingAppendSink sink = new TestingAppendSink();
            package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
            this.env().execute();
            Map managedCaches = LookupCacheManager.getInstance().getManagedCaches();
            Assertions.assertThat((int)managedCaches.size()).isEqualTo(1);
            LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType;
            LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.PARTIAL;
            int numEntries = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? 6 : this.userData().size();
            LookupCache cache = ((LookupCacheManager.RefCountedCache)managedCaches.get(managedCaches.keySet().iterator().next())).getCache();
            Assertions.assertThat((long)cache.size()).isEqualTo((long)numEntries);
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(1L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(1L), BinaryStringData.fromString((String)"Julian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(2L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(22), this.jl(2L), BinaryStringData.fromString((String)"Jark")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(3L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(33), this.jl(3L), BinaryStringData.fromString((String)"Fabian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(4L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(4L), BinaryStringData.fromString((String)"Hello world")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(5L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(5L), BinaryStringData.fromString((String)"Hello world")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(6L)}))).isEmpty();
        }
        finally {
            LookupCacheManager.getInstance().checkAllReleased();
            LookupCacheManager.getInstance().clear();
            LookupCacheManager.keepCacheOnRelease((boolean)false);
        }
    }

    public Integer ji(int i) {
        return new Integer(i);
    }

    public Long jl(long l) {
        return new Long(l);
    }

    @TestTemplate
    public void testAggAndLeftJoinWithTryResolveMode() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().createTemporaryView("t1", table1);
        String sql2 = "SELECT t1.id, D.name, D.age FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON t1.id = D.id";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Fabian,33", "8,null,null", "9,null,null"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggAndLeftJoinAllConstantKeyWithTryResolveMode() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().createTemporaryView("t1", table1);
        String sql2 = "SELECT t1.id, D.name, D.age FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON D.id = 3";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Fabian,33", "8,Fabian,33", "9,Fabian,33"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggAndJoinAllConstantKeyWithTryResolveMode() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().createTemporaryView("t1", table1);
        String sql2 = "SELECT t1.id FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON D.id = 3";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3", "8", "9"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private String getRetryLookupHint(String lookupTable, int maxAttempts) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(178).append("\n       |/*+ LOOKUP('table'='").append(lookupTable).append("', 'retry-predicate'='lookup_miss',\n       | 'retry-strategy'='fixed_delay',\n       |  'fixed-delay'='5 ms',\n       |   'max-attempts'='").append(maxAttempts).append("')\n       |*/").toString())).stripMargin();
    }

    @TestTemplate
    public void testJoinTemporalTableWithRetry() {
        String maxRetryTwiceHint = this.getRetryLookupHint("D", 2);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n                   |SELECT ").append(maxRetryTwiceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    /*
     * Unable to fully structure code
     */
    @TestTemplate
    public void testJoinTemporalTableWithLookupThresholdWithInsufficientRetry() {
        maxRetryOnceHint = this.getRetryLookupHint("D", 1);
        sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(maxRetryOnceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold3 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        if (this.legacyTableSource) ** GOTO lbl-1000
        v0 = this.cacheType;
        var4_3 = LookupOptions.LookupCacheType.FULL;
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) lbl-1000:
        // 2 sources

        {
            v1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        } else {
            v1 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        expected = v1;
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupThresholdWithSufficientRetry() {
        String maxRetryTwiceHint = this.getRetryLookupHint("D", 2);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(maxRetryTwiceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold2 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupThresholdWithLargerRetry() {
        String largerRetryHint = this.getRetryLookupHint("D", 10);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(largerRetryHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold2 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public LookupJoinITCase(boolean legacyTableSource, LookupOptions.LookupCacheType cacheType) {
        this.legacyTableSource = legacyTableSource;
        this.cacheType = cacheType;
        this.data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)12), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)15), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)11), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"})), (List)Nil$.MODULE$)))));
        this.dataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)15), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)11), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"})), (List)Nil$.MODULE$))));
        this.userData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)4L), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)5L), "Hello world"})), (List)Nil$.MODULE$)))));
        this.userDataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), null, "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)44), null, "Hello world"})), (List)Nil$.MODULE$))));
    }
}

