/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.PartitionableSourceITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001M\u0011\u0011\u0004U1si&$\u0018n\u001c8bE2,7k\\;sG\u0016LEkQ1tK*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0019\u0019HO]3b[*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tQ!\u001e;jYNL!!\u0007\f\u0003#M#(/Z1nS:<G+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003U\u0019x.\u001e:dK\u001a+Go\u00195QCJ$\u0018\u000e^5p]N,\u0012!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\b\u0005>|G.Z1o\u0011!!\u0003A!A!\u0002\u0013i\u0012AF:pkJ\u001cWMR3uG\"\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002q\t\u0001#^:f\u0007\u0006$\u0018\r\\8h\r&dG/\u001a:\t\u0011!\u0002!\u0011!Q\u0001\nu\t\u0011#^:f\u0007\u0006$\u0018\r\\8h\r&dG/\u001a:!\u0011\u0015Q\u0003\u0001\"\u0001,\u0003\u0019a\u0014N\\5u}Q\u0019AFL\u0018\u0011\u00055\u0002Q\"\u0001\u0002\t\u000bmI\u0003\u0019A\u000f\t\u000b\u0019J\u0003\u0019A\u000f\t\u000bE\u0002A\u0011\t\u001a\u0002\r\t,gm\u001c:f)\u0005\u0019\u0004C\u0001\u00105\u0013\t)tD\u0001\u0003V]&$\bF\u0001\u00198!\tAt(D\u0001:\u0015\tQ4(A\u0002ba&T!\u0001P\u001f\u0002\u000f),\b/\u001b;fe*\u0011a\bE\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0001f\u0012!BQ3g_J,W)Y2i\u0011\u0015\u0011\u0005\u0001\"\u00013\u0003\t\"Xm\u001d;TS6\u0004H.\u001a)beRLG/[8o\r&,G\u000e\u001a)sK\u0012L7-\u0019;fc!\u0012\u0011\t\u0012\t\u0003q\u0015K!AR\u001d\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\t\u000b!\u0003A\u0011\u0001\u001a\u0002UQ,7\u000f\u001e)beRL\u0017\r\u001c)beRLG/[8o\r&,G\u000e\u001a)sK\u0012L7-\u0019;f!V\u001c\b\u000eR8x]\"\u0012q\t\u0012\u0005\u0006\u0017\u0002!\tAM\u0001\u001ai\u0016\u001cH/\u00168d_:4XM\u001d;fI\u0016C\bO]3tg&|g\u000e\u000b\u0002K\t\")a\n\u0001C\u0001e\u0005\u0019D/Z:u!V\u001c\b\u000eR8x]B\u000b'\u000f^5uS>t\u0017I\u001c3GS2$XM]:D_:$\u0018-\u001b8QCJ$\u0018\u000e^5p].+\u0017p\u001d\u0015\u0003\u001b\u0012CQ!\u0015\u0001\u0005\u0002I\nq\t^3tiB+8\u000f\u001b#po:\u0004\u0016M\u001d;ji&|g.\u00118e\r&dG/\u001a:t\u0007>tG/Y5o!\u0006\u0014H/\u001b;j_:\\U-_:XSRD7+\u001b8hY\u0016\u0004&o\u001c6fGRLwN\u001c\u0015\u0003!\u0012CC\u0001\u0001+[7B\u0011Q\u000bW\u0007\u0002-*\u0011q+O\u0001\nKb$XM\\:j_:L!!\u0017,\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\rL\u0001]G\u0005i\u0006C\u00010g\u001b\u0005y&B\u00011b\u00035\u0001\u0018M]1nKR,'/\u001b>fI*\u0011!mY\u0001\u000bKb$XM\\:j_:\u001c(B\u0001 e\u0015\t)G\"A\u0005uKN$X\u000f^5mg&\u0011qm\u0018\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\\\u0004\u0006S\nA\tA[\u0001\u001a!\u0006\u0014H/\u001b;j_:\f'\r\\3T_V\u00148-Z%U\u0007\u0006\u001cX\r\u0005\u0002.W\u001a)\u0011A\u0001E\u0001YN\u00111.\u001c\t\u0003=9L!a\\\u0010\u0003\r\u0005s\u0017PU3g\u0011\u0015Q3\u000e\"\u0001r)\u0005Q\u0007\"B:l\t\u0003!\u0018A\u00039be\u0006lW\r^3sgR\tQ\u000fE\u0002wwvl\u0011a\u001e\u0006\u0003qf\fA!\u001e;jY*\t!0\u0001\u0003kCZ\f\u0017B\u0001?x\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0005=y\f\t!\u0003\u0002\u0000?\t)\u0011I\u001d:bsB\u0019a$a\u0001\n\u0007\u0005\u0015qDA\u0002B]fDsA]A\u0005\u0003\u001f\t\t\u0002E\u0002_\u0003\u0017I1!!\u0004`\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0005]\u0006lW-\t\u0002\u0002\u0014\u0005y3o\\;sG\u00164U\r^2i!\u0006\u0014H/\u001b;j_:\u001cXh\u001f\u0019~Y\u0001*8/Z\"bi\u0006dwn\u001a$jYR,'/P>2{\u0002")
public class PartitionableSourceITCase
extends StreamingTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;

    @Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceITCase$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().setParallelism(1);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Vivi", "C", BoxesRunTime.boxToInteger((int)1)}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String partitionableTable = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(401).append("\n         |CREATE TABLE PartitionableTable (\n         |  id int,\n         |  name string,\n         |  part1 string,\n         |  part2 int,\n         |  virtualField as part2 + 1)\n         |  partitioned by (part1, part2)\n         |  with (\n         |    'connector' = 'values',\n         |    'data-id' = '").append(dataId).append("',\n         |    'bounded' = 'true',\n         |    'partition-list' = '%s'\n         |)\n         |").toString())).stripMargin();
        String partitionableAndFilterableTable = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(468).append("\n         |CREATE TABLE PartitionableAndFilterableTable (\n         |  id int,\n         |  name string,\n         |  part1 string,\n         |  part2 int,\n         |  virtualField as part2 + 1)\n         |  partitioned by (part1, part2)\n         |  with (\n         |    'connector' = 'values',\n         |    'data-id' = '").append(dataId).append("',\n         |    'bounded' = 'true',\n         |    'partition-list' = '%s',\n         |    'filterable-fields' = 'id;part1;part2'\n         |)\n         |").toString())).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.tEnv().executeSql(String.format(partitionableTable, partitions));
            this.tEnv().executeSql(String.format(partitionableAndFilterableTable, partitions));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.tEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.tEnv().useCatalog("test_catalog");
            this.tEnv().executeSql(String.format(partitionableTable, ""));
            this.tEnv().executeSql(String.format(partitionableAndFilterableTable, ""));
            ObjectPath partitionableTablePath = ObjectPath.fromString((String)"test_database.PartitionableTable");
            ObjectPath partitionableAndFilterableTablePath = ObjectPath.fromString((String)"test_database.PartitionableAndFilterableTable");
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))}));
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionableSourceITCase.$anonfun$before$1(catalog, partitionableTablePath, partitionableAndFilterableTablePath, partition);
                return BoxedUnit.UNIT;
            });
        }
    }

    @TestTemplate
    public void testSimplePartitionFieldPredicate1() {
        String query = "SELECT * FROM PartitionableTable WHERE part1 = 'A'";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,ZhangSan,A,1,2", "2,LiSi,A,1,2", "3,Jack,A,2,3"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testPartialPartitionFieldPredicatePushDown() {
        String query = "SELECT * FROM PartitionableTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Jack,A,2,3", "4,Tom,B,3,4"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testUnconvertedExpression() {
        String query = "select * from PartitionableTable where trim(part1) = 'A' and part2 > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Jack,A,2,3"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeys() {
        String query = "SELECT * FROM PartitionableAndFilterableTable WHERE part1 = 'A' AND id > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,LiSi,A,1,2", "3,Jack,A,2,3"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeysWithSingleProjection() {
        String query = "SELECT name FROM PartitionableAndFilterableTable WHERE part1 = 'A' AND id > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LiSi", "Jack"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$before$1(TestValuesCatalog catalog$1, ObjectPath partitionableTablePath$1, ObjectPath partitionableAndFilterableTablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(partitionableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
        catalog$1.createPartition(partitionableAndFilterableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceITCase(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
    }
}

