/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RTASITCase
extends StreamingTestBase {
    RTASITCase() {
    }

    @Override
    @BeforeEach
    public void before() throws Exception {
        super.before();
        String dataId1 = TestValuesTableFactory.registerData(TestData.smallData3());
        this.tEnv().executeSql(String.format("CREATE TABLE source(a int, b bigint, c string) WITH ('connector' = 'values', 'bounded' = 'true', 'data-id' = '%s')", dataId1));
        this.tEnv().executeSql("CREATE TABLE target(a int, b bigint, c string) WITH ('connector' = 'values')");
    }

    @Test
    void testReplaceTableAS() throws Exception {
        this.tEnv().executeSql("REPLACE TABLE target WITH ('connector' = 'values', 'bounded' = 'true') AS SELECT * FROM source").await();
        Assertions.assertThat((String)TestValuesTableFactory.getResultsAsStrings("target").toString()).isEqualTo("[+I[1, 1, Hi], +I[2, 2, Hello], +I[3, 2, Hello world]]");
        CatalogTable expectCatalogTable = this.getExpectCatalogTable(new String[]{"a", "b", "c"}, new AbstractDataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()});
        this.verifyCatalogTable(expectCatalogTable, this.getCatalogTable("target"));
    }

    @Test
    void testReplaceTableASWithTableNotExist() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv().executeSql("REPLACE TABLE t AS SELECT * FROM source")).isInstanceOf(TableException.class)).hasMessage("The table `default_catalog`.`default_database`.`t` to be replaced doesn't exist. You can try to use CREATE TABLE AS statement or CREATE OR REPLACE TABLE AS statement.");
    }

    @Test
    void testCreateOrReplaceTableAS() throws Exception {
        this.tEnv().executeSql("CREATE OR REPLACE TABLE target WITH ('connector' = 'values', 'bounded' = 'true') AS SELECT a, c FROM source").await();
        Assertions.assertThat((String)TestValuesTableFactory.getResultsAsStrings("target").toString()).isEqualTo("[+I[1, Hi], +I[2, Hello], +I[3, Hello world]]");
        CatalogTable expectCatalogTable = this.getExpectCatalogTable(new String[]{"a", "c"}, new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING()});
        this.verifyCatalogTable(expectCatalogTable, this.getCatalogTable("target"));
    }

    @Test
    void testCreateOrReplaceTableASWithTableNotExist() throws Exception {
        this.tEnv().executeSql("CREATE OR REPLACE TABLE not_exist_target WITH ('connector' = 'values', 'bounded' = 'true') AS SELECT a, c FROM source").await();
        Assertions.assertThat((String)TestValuesTableFactory.getResultsAsStrings("not_exist_target").toString()).isEqualTo("[+I[1, Hi], +I[2, Hello], +I[3, Hello world]]");
        CatalogTable expectCatalogTable = this.getExpectCatalogTable(new String[]{"a", "c"}, new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING()});
        this.verifyCatalogTable(expectCatalogTable, this.getCatalogTable("not_exist_target"));
    }

    private CatalogTable getExpectCatalogTable(String[] cols, AbstractDataType<?>[] fieldDataTypes) {
        return CatalogTable.of((Schema)Schema.newBuilder().fromFields(cols, fieldDataTypes).build(), null, Collections.emptyList(), this.getDefaultTargetTableOptions());
    }

    private Map<String, String> getDefaultTargetTableOptions() {
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("connector", "values");
        expectedOptions.put("bounded", "true");
        return expectedOptions;
    }

    private CatalogTable getCatalogTable(String tableName) throws TableNotExistException {
        return (CatalogTable)((Catalog)this.tEnv().getCatalog("default_catalog").get()).getTable(ObjectPath.fromString((String)("default_database." + tableName)));
    }

    private void verifyCatalogTable(CatalogTable expectedCatalogTable, CatalogTable actualCatalogTable) {
        Assertions.assertThat((Object)actualCatalogTable.getUnresolvedSchema()).isEqualTo((Object)expectedCatalogTable.getUnresolvedSchema());
        Assertions.assertThat((String)actualCatalogTable.getComment()).isEqualTo(expectedCatalogTable.getComment());
        Assertions.assertThat((List)actualCatalogTable.getPartitionKeys()).isEqualTo((Object)expectedCatalogTable.getPartitionKeys());
        Assertions.assertThat((Map)actualCatalogTable.getOptions()).isEqualTo((Object)expectedCatalogTable.getOptions());
    }
}

