/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ScanReuseITCase
extends StreamingTestBase {
    ScanReuseITCase() {
    }

    @Override
    @BeforeEach
    public void before() throws Exception {
        super.before();
        String myTableDataId = TestValuesTableFactory.registerData(Arrays.asList(Row.of((Object[])new Object[]{1, 1L, "1"}), Row.of((Object[])new Object[]{2, 2L, "2"}), Row.of((Object[])new Object[]{3, 3L, "3"})));
        String table = "CREATE TABLE MyTable (\n  a int,\n  b bigint,\n  c string\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true',\n" + String.format(" 'data-id' = '%s',\n", myTableDataId) + " 'nested-projection-supported' = 'true',\n 'readable-metadata' = 'metadata_1:INT, metadata_2:STRING'\n)";
        this.tEnv().executeSql(table);
    }

    @Test
    void testProjectWithExpr() {
        String sqlQuery = "SELECT T1.a, T1.b, T2.c FROM (SELECT a, b + 1 as b FROM MyTable) T1, MyTable T2 WHERE T1.a = T2.a";
        List actual = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql(sqlQuery).collect()).stream().map(Object::toString).collect(Collectors.toList());
        actual.sort(String::compareTo);
        List<String> expected = Arrays.asList("+I[1, 2, 1]", "+I[2, 3, 2]", "+I[3, 4, 3]");
        Assertions.assertThat(actual).isEqualTo(expected);
    }
}

