/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.stream.sql.SortITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.utils.InternalConfigOptions;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001'\tQ1k\u001c:u\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0015)H/\u001b7t\u0013\tIbC\u0001\u000eTiJ,\u0017-\\5oO^KG\u000f[*uCR,G+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0011iw\u000eZ3\u0011\u0005u\tdB\u0001\u00100\u001d\tybF\u0004\u0002![9\u0011\u0011\u0005\f\b\u0003E-r!a\t\u0016\u000f\u0005\u0011JcBA\u0013)\u001b\u00051#BA\u0014\u0013\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002\u0010!%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\f\u0007\u0013\t\u0001d#\u0001\u000eTiJ,\u0017-\\5oO^KG\u000f[*uCR,G+Z:u\u0005\u0006\u001cX-\u0003\u00023g\t\u00012\u000b^1uK\n\u000b7m[3oI6{G-\u001a\u0006\u0003aYAQ!\u000e\u0001\u0005\u0002Y\na\u0001P5oSRtDCA\u001c:!\tA\u0004!D\u0001\u0003\u0011\u0015YB\u00071\u0001\u001d\u0011\u0015Y\u0004\u0001\"\u0001=\u0003}!Xm\u001d;ESN\f'\r\\3T_J$hj\u001c8UK6\u0004xN]1m\r&,G\u000e\u001a\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t!QK\\5uQ\tQD\t\u0005\u0002F\u00196\taI\u0003\u0002H\u0011\u0006\u0019\u0011\r]5\u000b\u0005%S\u0015a\u00026va&$XM\u001d\u0006\u0003\u0017B\tQA[;oSRL!!\u0014$\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\t\u000b=\u0003A\u0011\u0001\u001f\u0002\u0011Q,7\u000f^*peRD#A\u0014#\t\u000bI\u0003A\u0011\u0001\u001f\u0002'Q,7\u000f^*peR|%\u000fZ3s\u0005f$Um]2)\u0005E#\u0005\"B+\u0001\t\u0003a\u0014!\b;fgR\u001cvN\u001d;Pe\u0012,'OQ=Nk2$\u0018\u000e\u001d7f\r&,G\u000eZ:)\u0005Q#\u0005\"\u0002-\u0001\t\u0003a\u0014!\b;fgR\u001cvN\u001d;Pe\u0012,'OQ=SKB,\u0017\r^3e\r&,G\u000eZ:)\u0005]#\u0005\"B.\u0001\t\u0003a\u0014A\u0007;fgR\u001cvN\u001d;Pe\u0012,'OQ=XSRD'+\u001a;sC\u000e$\bF\u0001.E\u0011\u0015q\u0006\u0001\"\u0001=\u0003E!Xm\u001d;T_J$x+\u001b;i/\",'/\u001a\u0015\u0003;\u0012CC\u0001A1hQB\u0011!-Z\u0007\u0002G*\u0011AMR\u0001\nKb$XM\\:j_:L!AZ2\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\rL\u0001jG\u0005Q\u0007CA6t\u001b\u0005a'BA7o\u00035\u0001\u0018M]1nKR,'/\u001b>fI*\u0011q\u000e]\u0001\u000bKb$XM\\:j_:\u001c(BA&r\u0015\t\u0011H\"A\u0005uKN$X\u000f^5mg&\u0011A\u000f\u001c\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\u001c")
public class SortITCase
extends StreamingWithStateTestBase {
    @TestTemplate
    public void testDisableSortNonTemporalField() {
        String sqlQuery = "SELECT * FROM a ORDER BY a2";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"0", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"3"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"2"));
        data.$plus$eq((Object)new Tuple2((Object)"5", (Object)"1"));
        Table da = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple2<String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.SortITCase$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2"))}));
        this.tEnv().createTemporaryView("a", da);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class))).hasMessage("Sort on a non-time-attribute field is not supported.") instanceof TableException;
    }

    @TestTemplate
    public void testSort() {
        String sqlQuery = "SELECT * FROM a ORDER BY a2";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"0", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"3"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"2"));
        data.$plus$eq((Object)new Tuple2((Object)"5", (Object)"1"));
        Table da = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.sql.SortITCase$$anon$9 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2"))}));
        this.tEnv().createTemporaryView("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().set(InternalConfigOptions.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        DataStream results = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"5,1", "1,2", "3,3", "0,4"}));
        Assertions.assertThat(sink.getRetractResults()).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSortOrderByDesc() {
        String sqlQuery = "SELECT * FROM a ORDER BY a1 DESC";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"0", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"3"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"2"));
        data.$plus$eq((Object)new Tuple2((Object)"5", (Object)"1"));
        Table da = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.sql.SortITCase$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2"))}));
        this.tEnv().createTemporaryView("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().set(InternalConfigOptions.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        DataStream results = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"5,1", "3,3", "1,2", "0,4"}));
        Assertions.assertThat(sink.getRetractResults()).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSortOrderByMultipleFields() {
        String sqlQuery = "SELECT * FROM a ORDER BY a1, a2";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"5", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"0", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"7"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"2"));
        Table da = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.stream.sql.SortITCase$$anon$11 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2"))}));
        this.tEnv().createTemporaryView("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().set(InternalConfigOptions.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        DataStream results = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,4", "1,2", "1,7", "5,1"}));
        Assertions.assertThat(sink.getRetractResults()).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSortOrderByRepeatedFields() {
        String sqlQuery = "SELECT * FROM a ORDER BY a1, a1";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"5", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"0", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"7"));
        data.$plus$eq((Object)new Tuple2((Object)"2", (Object)"2"));
        Table da = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.stream.sql.SortITCase$$anon$12 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2"))}));
        this.tEnv().createTemporaryView("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().set(InternalConfigOptions.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        DataStream results = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,4", "1,7", "2,2", "5,1"}));
        Assertions.assertThat(sink.getRetractResults()).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSortOrderByWithRetract() {
        String sqlQuery = "SELECT a1, count(*) as c FROM a GROUP BY a1 ORDER BY c";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"2", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"6", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"2"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"3"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"2"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"3"));
        data.$plus$eq((Object)new Tuple2((Object)"6", (Object)"2"));
        Table da = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.stream.sql.SortITCase$$anon$13 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2"))}));
        this.tEnv().createTemporaryView("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().set(InternalConfigOptions.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        DataStream results = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,1", "6,2", "1,3", "3,4"}));
        Assertions.assertThat(sink.getRetractResults()).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSortWithWhere() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |select * from a where a1 < all (select a1 * 2 from a) order by a1 desc\n       ")).stripMargin();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2.mcII.sp(8, 1));
        data.$plus$eq((Object)new Tuple2.mcII.sp(7, 2));
        data.$plus$eq((Object)new Tuple2.mcII.sp(6, 3));
        data.$plus$eq((Object)new Tuple2.mcII.sp(5, 4));
        data.$plus$eq((Object)new Tuple2.mcII.sp(4, 5));
        Table da = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.stream.sql.SortITCase$$anon$14 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1"))}));
        this.tEnv().createTemporaryView("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().set(InternalConfigOptions.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        DataStream results = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"7", "6", "5", "4"}));
        Assertions.assertThat(sink.getRetractResults()).isEqualTo((Object)expected);
    }

    public SortITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

