/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001'\t)2k\\;sG\u0016<\u0016\r^3s[\u0006\u00148.\u0013+DCN,'BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\t\t2\u000b\u001e:fC6Lgn\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0002?V\t!\u0005E\u0002$Q)j\u0011\u0001\n\u0006\u0003K\u0019\n\u0011\u0002^3tiV$\u0018\u000e\\:\u000b\u0005\u001db\u0011\u0001B2pe\u0016L!!\u000b\u0013\u0003'\u0015\u000b7\r[\"bY2\u0014\u0017mY6Xe\u0006\u0004\b/\u001a:\u0011\u0005-jS\"\u0001\u0017\u000b\u0005]Q\u0011B\u0001\u0018-\u0005IaUmZ1dsJ{w/\u0012=uK:\u001c\u0018n\u001c8\t\rA\u0002\u0001\u0015!\u0003#\u0003\ty\u0006\u0005\u000b\u00020eA\u00111\u0007P\u0007\u0002i)\u0011QGN\u0001\nKb$XM\\:j_:T!a\u000e\u001d\u0002\u0007\u0005\u0004\u0018N\u0003\u0002:u\u00059!.\u001e9ji\u0016\u0014(BA\u001e\u0011\u0003\u0015QWO\\5u\u0013\tiDGA\tSK\u001eL7\u000f^3s\u000bb$XM\\:j_:DQa\u0010\u0001\u0005\u0002\u0001\u000b1\u0004^3tiNKW\u000e\u001d7f/\u0006$XM]7be.\u0004Vo\u001d5E_^tG#A!\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\tUs\u0017\u000e\u001e\u0015\u0003}!\u0003\"!\u0013&\u000e\u0003YJ!a\u0013\u001c\u0003\tQ+7\u000f\u001e\u0005\u0006\u001b\u0002!\t\u0001Q\u0001*i\u0016\u001cHoU5na2,w+\u0019;fe6\f'o[(o)&lWm\u001d;b[BdEO\u001f)vg\"$un\u001e8)\u00051C\u0005\"\u0002)\u0001\t\u0003\u0001\u0015A\u0007;fgR<\u0016\r^3s[\u0006\u00148nV5uQ:+7\u000f^3e%><\bFA(I\u0011\u0015\u0019\u0006\u0001\"\u0001A\u0003y!Xm\u001d;XCR,'/\\1sW^KG\u000f['vYRL\u0017J\u001c9viV#g\r\u000b\u0002S\u0011\")a\u000b\u0001C\u0001\u0001\u0006IB/Z:u/\u0006$XM]7be.<\u0016\u000e\u001e5NKR\fG-\u0019;bQ\t)\u0006\n")
public class SourceWatermarkITCase
extends StreamingTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testSimpleWatermarkPushDown() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23")}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(445).append("\n         | CREATE Table VirtualTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP(3),\n         |   d as c - INTERVAL '5' second,\n         |   WATERMARK FOR d as d + INTERVAL '5' second\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-11-21T19:00:05.230", "2020-11-21T21:00:05.230"}));
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,2,2020-11-21T19:00:05.230", "2,3,2020-11-21T21:00:05.230"}));
        String query = "SELECT a, b, c FROM VirtualTable";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("VirtualTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertThat((Object)actualWatermark).isEqualTo((Object)expectedWatermarkOutput);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleWatermarkOnTimestampLtzPushDown() {
        ZoneId zoneId = ZoneId.of("Asia/Shanghai");
        this.tEnv().getConfig().setLocalTimeZone(zoneId);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23").atZone(zoneId).toInstant()})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23").atZone(zoneId).toInstant()}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(450).append("\n         | CREATE Table VirtualTable1 (\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP_LTZ(3),\n         |   d as c - INTERVAL '5' second,\n         |   WATERMARK FOR d as d + INTERVAL '5' second\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-11-21T19:00:05.230", "2020-11-21T21:00:05.230"}));
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,2,2020-11-21T11:00:05.230Z", "2,3,2020-11-21T13:00:05.230Z"}));
        String query = "SELECT a, b, c FROM VirtualTable1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("VirtualTable1")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> LocalDateTime.ofInstant(Instant.ofEpochMilli(x.getTimestamp()), zoneId).toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertThat((Object)actualWatermark).isEqualTo((Object)expectedWatermarkOutput);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWatermarkWithNestedRow() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)0L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"h1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"h2", null}))}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"i1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"i2", LocalDateTime.parse("2020-11-21T19:00:05.23")}))}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"j1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"j2", LocalDateTime.parse("2020-11-21T21:00:05.23")}))}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)4L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"k1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"k2", null}))}))}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(463).append("\n         | CREATE Table NestedTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c ROW<name STRING, d ROW<e STRING, f TIMESTAMP(3)>>,\n         |   g as c.d.f,\n         |   WATERMARK FOR g as g - INTERVAL '5' second\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TimestampData.fromEpochMillis((long)Long.MIN_VALUE).toString(), "2020-11-21T19:00:00.230", "2020-11-21T21:00:00.230", "2020-11-21T21:00:00.230"}));
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,0,h2,null", "1,2,i2,2020-11-21T19:00:05.230", "2,3,j2,2020-11-21T21:00:05.230", "3,4,k2,null"}));
        String query = "SELECT a, b, c.d FROM NestedTable";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("NestedTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertThat((Object)actualWatermark).isEqualTo((Object)expectedWatermarkOutput);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWatermarkWithMultiInputUdf() {
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23")})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23")}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(424).append("\n         | CREATE Table UdfTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c timestamp(3),\n         |   d as func(c, a),\n         |   WATERMARK FOR c as func(func(d, a), a)\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-11-21T19:00:02.230", "2020-11-21T20:59:59.230"}));
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2000,3,2020-11-21T21:00:03.230"}));
        String query = "SELECT a, b, d FROM UdfTable WHERE b > 2";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("UdfTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertThat((Object)actualWatermark).isEqualTo((Object)expectedWatermarkOutput);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWatermarkWithMetadata() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)Timestamp.valueOf("2020-11-21 19:00:05.23").toInstant().toEpochMilli())})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)Timestamp.valueOf("2020-11-21 21:00:05.23").toInstant().toEpochMilli())}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(553).append("\n         | CREATE TABLE MetadataTable(\n         |   a INT,\n         |   b BIGINT,\n         |   originTime BIGINT METADATA,\n         |   rowtime AS TO_TIMESTAMP(FROM_UNIXTIME(originTime/1000), 'yyyy-MM-dd HH:mm:ss'),\n         |   WATERMARK FOR rowtime AS rowtime\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true',\n         |   'readable-metadata' = 'originTime:BIGINT',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        .colon.colon expectedWatermarkOutput = new .colon.colon((Object)"2020-11-21T19:00:05", (List)new .colon.colon((Object)"2020-11-21T21:00:05", (List)Nil$.MODULE$));
        Seq expectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1"}));
        String query = "SELECT a FROM MetadataTable WHERE b > 2";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("MetadataTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertThat((Object)actualWatermark).isEqualTo((Object)expectedWatermarkOutput);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }
}

