/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.stream.sql.SplitAggregateITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithAggTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithMiniBatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001B\u0001\u0003\u0001M\u0011Ac\u00159mSR\fum\u001a:fO\u0006$X-\u0013+DCN,'BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\tA2\u000b\u001e:fC6LgnZ,ji\"\fum\u001a+fgR\u0014\u0015m]3\t\u0011m\u0001!\u0011!Q\u0001\nq\ta\u0002]1si&\fG.Q4h\u001b>$W\r\u0005\u0002\u001e\u0001:\u0011a$\r\b\u0003?Ar!\u0001I\u0018\u000f\u0005\u0005rcB\u0001\u0012.\u001d\t\u0019CF\u0004\u0002%W9\u0011QE\u000b\b\u0003M%j\u0011a\n\u0006\u0003QI\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\u000bI\u0012\u0001\u0012A\u001a\u0002)M\u0003H.\u001b;BO\u001e\u0014XmZ1uK&#6)Y:f!\t!T'D\u0001\u0003\r\u0015\t!\u0001#\u00017'\t)t\u0007\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0004B]f\u0014VM\u001a\u0005\u0006}U\"\taP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M2A!Q\u001bA\u0005\nq\u0001+\u0019:uS\u0006d\u0017iZ4N_\u0012,7\u0003\u0002!8\u0007\u001a\u0003\"\u0001\u000f#\n\u0005\u0015K$a\u0002)s_\u0012,8\r\u001e\t\u0003q\u001dK!\u0001S\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011)\u0003%Q3A\u0005\u0002-\u000b1#[:QCJ$\u0018.\u00197BO\u001e,e.\u00192mK\u0012,\u0012\u0001\u0014\t\u0003q5K!AT\u001d\u0003\u000f\t{w\u000e\\3b]\"A\u0001\u000b\u0011B\tB\u0003%A*\u0001\u000bjgB\u000b'\u000f^5bY\u0006;w-\u00128bE2,G\r\t\u0005\u0006}\u0001#\tA\u0015\u000b\u0003'V\u0003\"\u0001\u0016!\u000e\u0003UBQAS)A\u00021CQa\u0016!\u0005Ba\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u00023B\u0011!L\u0018\b\u00037r\u0003\"AJ\u001d\n\u0005uK\u0014A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!X\u001d\t\u000f\t\u0004\u0015\u0011!C\u0001G\u0006!1m\u001c9z)\t\u0019F\rC\u0004KCB\u0005\t\u0019\u0001'\t\u000f\u0019\u0004\u0015\u0013!C\u0001O\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00015+\u00051K7&\u00016\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017!C;oG\",7m[3e\u0015\ty\u0017(\u0001\u0006b]:|G/\u0019;j_:L!!\u001d7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004t\u0001\u0006\u0005I\u0011\t;\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005)\bC\u0001<|\u001b\u00059(B\u0001=z\u0003\u0011a\u0017M\\4\u000b\u0003i\fAA[1wC&\u0011ql\u001e\u0005\b{\u0002\u000b\t\u0011\"\u0001\u007f\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005y\bc\u0001\u001d\u0002\u0002%\u0019\u00111A\u001d\u0003\u0007%sG\u000fC\u0005\u0002\b\u0001\u000b\t\u0011\"\u0001\u0002\n\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0006\u0003#\u00012\u0001OA\u0007\u0013\r\ty!\u000f\u0002\u0004\u0003:L\b\"CA\n\u0003\u000b\t\t\u00111\u0001\u0000\u0003\rAH%\r\u0005\n\u0003/\u0001\u0015\u0011!C!\u00033\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00037\u0001b!!\b\u0002$\u0005-QBAA\u0010\u0015\r\t\t#O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0013\u0003?\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003S\u0001\u0015\u0011!C\u0001\u0003W\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u0019\u00065\u0002BCA\n\u0003O\t\t\u00111\u0001\u0002\f!I\u0011\u0011\u0007!\u0002\u0002\u0013\u0005\u00131G\u0001\tQ\u0006\u001c\bnQ8eKR\tq\u0010C\u0005\u00028\u0001\u000b\t\u0011\"\u0011\u0002:\u00051Q-];bYN$2\u0001TA\u001e\u0011)\t\u0019\"!\u000e\u0002\u0002\u0003\u0007\u00111B\u0004\n\u0003\u007f)\u0014\u0011!E\u0001\u0003\u0003\na\u0002U1si&\fG.Q4h\u001b>$W\rE\u0002U\u0003\u00072\u0001\"Q\u001b\u0002\u0002#\u0005\u0011QI\n\u0006\u0003\u0007\n9E\u0012\t\u0007\u0003\u0013\ni\u0005T*\u000e\u0005\u0005-#BA\u0004:\u0013\u0011\ty%a\u0013\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007C\u0004?\u0003\u0007\"\t!a\u0015\u0015\u0005\u0005\u0005\u0003\"C,\u0002D\u0005\u0005IQIA,)\u0005)\bBCA.\u0003\u0007\n\t\u0011\"!\u0002^\u0005)\u0011\r\u001d9msR\u00191+a\u0018\t\r)\u000bI\u00061\u0001M\u0011)\t\u0019'a\u0011\u0002\u0002\u0013\u0005\u0015QM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9'!\u001c\u0011\ta\nI\u0007T\u0005\u0004\u0003WJ$AB(qi&|g\u000eC\u0005\u0002p\u0005\u0005\u0014\u0011!a\u0001'\u0006\u0019\u0001\u0010\n\u0019\t\u0015\u0005M\u00141IA\u0001\n\u0013\t)(A\u0006sK\u0006$'+Z:pYZ,GCAA<!\r1\u0018\u0011P\u0005\u0004\u0003w:(AB(cU\u0016\u001cG\u000fC\u0005\u0002\u0000U\u0012\r\u0011\"\u0001\u0002\u0002\u0006a\u0001+\u0019:uS\u0006d\u0017iZ4P]V\t1\u000bC\u0004\u0002\u0006V\u0002\u000b\u0011B*\u0002\u001bA\u000b'\u000f^5bY\u0006;wm\u00148!\u0011%\tI)\u000eb\u0001\n\u0003\t\t)A\u0007QCJ$\u0018.\u00197BO\u001e|eM\u001a\u0005\b\u0003\u001b+\u0004\u0015!\u0003T\u00039\u0001\u0016M\u001d;jC2\fumZ(gM\u0002Bq!!%6\t\u0003\t\u0019*\u0001\u0006qCJ\fW.\u001a;feN$\"!!&\u0011\r\u0005]\u0015QTAQ\u001b\t\tIJC\u0002\u0002\u001cf\fA!\u001e;jY&!\u0011qTAM\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0006q\u0005\r\u0016qO\u0005\u0004\u0003KK$!B!se\u0006L\b\u0006CAH\u0003S\u000b\t-a1\u0011\t\u0005-\u0016QX\u0007\u0003\u0003[SA!a,\u00022\u0006i\u0001/\u0019:b[\u0016$XM]5{K\u0012TA!a-\u00026\u0006QQ\r\u001f;f]NLwN\\:\u000b\t\u0005]\u0016\u0011X\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0004\u0003wc\u0011!\u0003;fgR,H/\u001b7t\u0013\u0011\ty,!,\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\u0003oC6,\u0017EAAc\u0003E\u0002\u0016M\u001d;jC2\fumZ\u001f|aud\u0003\u0005T8dC2<En\u001c2bYvZ\u0018' \u0017!'R\fG/\u001a\"bG.,g\u000eZ\u001f|euD!\"!3\u0001\u0005\u0003\u0005\u000b\u0011BAf\u0003\u001d\twmZ'pI\u0016\u0004B!!4\u0002X:!\u0011qZAj\u001d\r\u0001\u0013\u0011[\u0005\u0003/\u0019I1!!6\u0017\u0003a\u0019FO]3b[&twmV5uQ\u0006;w\rV3ti\n\u000b7/Z\u0005\u0005\u00033\fYNA\u0004BO\u001elu\u000eZ3\u000b\u0007\u0005Ug\u0003\u0003\u0006\u0002`\u0002\u0011\t\u0011)A\u0005\u0003C\fqAY1dW\u0016tG\r\u0005\u0003\u0002d\u0006%h\u0002BAh\u0003KL1!a:\u0017\u0003i\u0019FO]3b[&twmV5uQN#\u0018\r^3UKN$()Y:f\u0013\u0011\tY/!<\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'bAAt-!1a\b\u0001C\u0001\u0003c$\u0002\"a=\u0002v\u0006]\u0018\u0011 \t\u0003i\u0001AaaGAx\u0001\u0004a\u0002\u0002CAe\u0003_\u0004\r!a3\t\u0011\u0005}\u0017q\u001ea\u0001\u0003CDq!!@\u0001\t\u0003\ny0\u0001\u0004cK\u001a|'/\u001a\u000b\u0003\u0005\u0003\u00012\u0001\u000fB\u0002\u0013\r\u0011)!\u000f\u0002\u0005+:LG\u000f\u000b\u0003\u0002|\n%\u0001\u0003\u0002B\u0006\u0005/i!A!\u0004\u000b\t\t=!\u0011C\u0001\u0004CBL'\u0002\u0002B\n\u0005+\tqA[;qSR,'OC\u0002\u00028BIAA!\u0007\u0003\u000e\tQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000f\tu\u0001\u0001\"\u0001\u0002\u0000\u0006\tB/Z:u\u0007>,h\u000e\u001e#jgRLgn\u0019;)\t\tm!\u0011\u0005\t\u0005\u0005\u0017\u0011\u0019#\u0003\u0003\u0003&\t5!\u0001\u0004+fgR$V-\u001c9mCR,\u0007b\u0002B\u0015\u0001\u0011\u0005\u0011q`\u0001\u0016i\u0016\u001cHoU5oO2,G)[:uS:\u001cG/Q4hQ\u0011\u00119C!\t\t\u000f\t=\u0002\u0001\"\u0001\u0002\u0000\u0006IB/Z:u\u001bVdG/[\"pk:$H)[:uS:\u001cG/Q4hQ\u0011\u0011iC!\t\t\u000f\tU\u0002\u0001\"\u0001\u0002\u0000\u0006\u0001D/Z:u'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<\u0017I\u001c3P]\u0016|%/T;mi&tuN\u001c#jgRLgn\u0019;BO\u001eDCAa\r\u0003\"!9!1\b\u0001\u0005\u0002\u0005}\u0018\u0001\t;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ,ji\"<%o\\;q\u0005fDCA!\u000f\u0003\"!9!\u0011\t\u0001\u0005\u0002\u0005}\u0018A\u000e;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ,ji\"\fe\u000e\u001a(p]\u0012K7\u000f^5oGR\fumZ(o'\u0006lWmQ8mk6t\u0007\u0006\u0002B \u0005CAqAa\u0012\u0001\t\u0003\ty0\u0001\u0016uKN$8k\\7f\u0007>dW/\u001c8t\u0005>$\b.\u00138ESN$\u0018N\\2u\u0003\u001e<\u0017I\u001c3He>,\bOQ=)\t\t\u0015#\u0011\u0005\u0005\b\u0005\u001b\u0002A\u0011AA\u0000\u0003]!Xm\u001d;BO\u001e<\u0016\u000e\u001e5GS2$XM]\"mCV\u001cX\r\u000b\u0003\u0003L\t\u0005\u0002b\u0002B*\u0001\u0011\u0005\u0011q`\u0001\u0019i\u0016\u001cH/T5o\u001b\u0006Dx+\u001b;i%\u0016$(/Y2uS>t\u0007\u0006\u0002B)\u0005CAqA!\u0017\u0001\t\u0003\ty0\u0001\u0015uKN$8i\\;oi^KG\u000f[*j]\u001edW\rR5ti&t7\r^!oIJ+GO]1di&|g\u000e\u000b\u0003\u0003X\t\u0005\u0002b\u0002B0\u0001\u0011\u0005\u0011q`\u0001,i\u0016\u001cHoU;n\u0007>,h\u000e^,ji\"\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fe\u000e\u001a*fiJ\f7\r^5p]\"\"!Q\fB\u0011\u0011\u001d\u0011)\u0007\u0001C\u0001\u0003\u007f\fq\u0002^3ti\u0006;wmV5uQ*{\u0017N\u001c\u0015\u0005\u0005G\u0012\t\u0003C\u0004\u0003l\u0001!\t!a@\u0002)Q,7\u000f^+w/&$\bNU3ue\u0006\u001cG/[8oQ\u0011\u0011IG!\t\t\u000f\tE\u0004\u0001\"\u0001\u0002\u0000\u0006!C/Z:u\u0007>,h\u000e\u001e#jgRLgn\u0019;XSRD')\u001b8bef\u0014vn^*pkJ\u001cW\r\u000b\u0003\u0003p\t\u0005\u0002b\u0002B<\u0001\u0011\u0005\u0011q`\u0001$i\u0016\u001cH/T;mi&\u0004H.\u001a#jgRLgn\u0019;BO\u001e|enU1nK\u000e{G.^7oQ\u0011\u0011)H!\t\t\u000f\tu\u0004\u0001\"\u0001\u0002\u0000\u00061C/Z:u\u0003\u001e<g)\u001b7uKJ\u001cE.Y;tK\n{G\u000f[,ji\"\feoZ!oI\u000e{WO\u001c;)\t\tm$\u0011\u0005\u0005\b\u0005\u0007\u0003A\u0011AA\u0000\u0003\u0001\"Xm\u001d;MSN$\u0018iZ4XSRDG)[:uS:\u001cG/T;mi&\f%oZ:)\t\t\u0005%\u0011\u0005\u0015\b\u0001\t%%Q\u0013BL!\u0011\u0011YI!%\u000e\u0005\t5%\u0002\u0002BH\u0005\u001b\t\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\tM%Q\u0012\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GF\u0001BMG\t\u0011Y\n\u0005\u0003\u0002,\nu\u0015\u0002\u0002BP\u0003[\u0013!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:\u0004")
public class SplitAggregateITCase
extends StreamingWithAggTestBase {
    private final PartialAggMode partialAggMode;

    @Parameters(name="PartialAgg={0}, LocalGlobal={1}, StateBackend={2}")
    public static Collection<Object[]> parameters() {
        return SplitAggregateITCase$.MODULE$.parameters();
    }

    public static PartialAggMode PartialAggOff() {
        return SplitAggregateITCase$.MODULE$.PartialAggOff();
    }

    public static PartialAggMode PartialAggOn() {
        return SplitAggregateITCase$.MODULE$.PartialAggOn();
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        TableConfig tableConfig = this.partialAggMode.isPartialAggEnabled() ? this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true)) : this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)1), (Object)"Hello 0"), new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello 1"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"Hello 1"), new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 1"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"Hello 2"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), null), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 4"), new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 0"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 2"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)5), null), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello 0"), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)6), (Object)"Hello 1")}));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.SplitAggregateITCase$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
    }

    @TestTemplate
    public void testCountDistinct() {
        List ids = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 5}));
        List dateTimes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:01", "1970-01-01 00:00:02", null, "1970-01-01 00:00:04", "1970-01-01 00:00:05", "1970-01-01 00:00:06", "1970-01-01 00:00:07", null, null, "1970-01-01 00:00:10", "1970-01-01 00:00:11", "1970-01-01 00:00:11", "1970-01-01 00:00:13", "1970-01-01 00:00:14", "1970-01-01 00:00:15"}));
        List dates = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01", "1970-01-02", null, "1970-01-04", "1970-01-05", "1970-01-06", "1970-01-07", null, null, "1970-01-10", "1970-01-11", "1970-01-11", "1970-01-13", "1970-01-14", "1970-01-15"}));
        List times = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"00:00:01", "00:00:02", null, "00:00:04", "00:00:05", "00:00:06", "00:00:07", null, null, "00:00:10", "00:00:11", "00:00:11", "00:00:13", "00:00:14", "00:00:15"}));
        List integers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", null, "4", "5", "6", "7", null, null, "10", "11", "11", "13", "14", "15"}));
        List chars = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B", null, "D", "E", "F", "H", null, null, "K", "L", "L", "N", "O", "P"}));
        MutableList data = new MutableList();
        ids.indices().foreach((Function1 & Serializable & scala.Serializable)i -> SplitAggregateITCase.$anonfun$testCountDistinct$1(ids, dateTimes, dates, times, integers, chars, data, BoxesRunTime.unboxToInt((Object)i)));
        MutableList inputs = (MutableList)Random$.MODULE$.shuffle((TraversableOnce)data, MutableList$.MODULE$.canBuildFrom());
        RowTypeInfo rowType = new RowTypeInfo(new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LOCAL_DATE(), Types.LOCAL_TIME(), Types.DECIMAL(), Types.INT(), Types.LONG(), Types.STRING()});
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(inputs, rowType)).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))}));
        this.tEnv().createTemporaryView("MyTable", t);
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              | id,\n                              | count(distinct a),\n                              | count(distinct b),\n                              | count(distinct c),\n                              | count(distinct d),\n                              | count(distinct e),\n                              | count(distinct f),\n                              | count(distinct g)\n                              |FROM MyTable\n                              |GROUP BY id\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,1,1,1,1,1,1", (List)new .colon.colon((Object)"2,1,1,1,1,1,1,1", (List)new .colon.colon((Object)"3,3,3,3,3,3,3,3", (List)new .colon.colon((Object)"4,2,2,2,2,2,2,2", (List)new .colon.colon((Object)"5,4,4,4,4,4,4,4", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSingleDistinctAgg() {
        Table t1 = this.tEnv().sqlQuery("SELECT COUNT(DISTINCT c) FROM T");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"5", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testMultiCountDistinctAgg() {
        Table t1 = this.tEnv().sqlQuery("SELECT COUNT(DISTINCT b), COUNT(DISTINCT c) FROM T");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"6,5", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSingleDistinctAggAndOneOrMultiNonDistinctAgg() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, SUM(b), COUNT(DISTINCT c), avg(b) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,3,2,1", (List)new .colon.colon((Object)"2,29,5,3", (List)new .colon.colon((Object)"3,10,2,5", (List)new .colon.colon((Object)"4,21,3,5", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSingleDistinctAggWithGroupBy() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, COUNT(DISTINCT c) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,2", (List)new .colon.colon((Object)"2,5", (List)new .colon.colon((Object)"3,2", (List)new .colon.colon((Object)"4,3", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSingleDistinctAggWithAndNonDistinctAggOnSameColumn() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, COUNT(DISTINCT b), MAX(b), MIN(b) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,2,2,1", (List)new .colon.colon((Object)"2,4,5,2", (List)new .colon.colon((Object)"3,1,5,5", (List)new .colon.colon((Object)"4,2,6,5", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSomeColumnsBothInDistinctAggAndGroupBy() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, COUNT(DISTINCT a), COUNT(b) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,2", (List)new .colon.colon((Object)"2,1,8", (List)new .colon.colon((Object)"3,1,2", (List)new .colon.colon((Object)"4,1,4", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggWithFilterClause() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  a,\n                              |  COUNT(DISTINCT b) filter (where not b = 2),\n                              |  MAX(b) filter (where not b = 5),\n                              |  MIN(b) filter (where not b = 2)\n                              |FROM T\n                              |GROUP BY a\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,2,1", (List)new .colon.colon((Object)"2,3,4,3", (List)new .colon.colon((Object)"3,1,null,5", (List)new .colon.colon((Object)"4,2,6,5", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testMinMaxWithRetraction() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  c, MIN(b), MAX(b), COUNT(DISTINCT a)\n                              |FROM(\n                              |  SELECT\n                              |    a, COUNT(DISTINCT b) as b, MAX(b) as c\n                              |  FROM T\n                              |  GROUP BY a\n                              |) GROUP BY c\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,2,2,1", (List)new .colon.colon((Object)"5,1,4,2", (List)new .colon.colon((Object)"6,2,2,1", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testCountWithSingleDistinctAndRetraction() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  b, COUNT(DISTINCT b1), COUNT(1)\n                              |FROM(\n                              |   SELECT\n                              |     a, COUNT(b) as b, MAX(b) as b1\n                              |   FROM T\n                              |   GROUP BY a\n                              |) GROUP BY b\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,2,2", (List)new .colon.colon((Object)"4,1,1", (List)new .colon.colon((Object)"8,1,1", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSumCountWithSingleDistinctAndRetraction() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  b, SUM(b1), COUNT(DISTINCT b1), COUNT(1)\n                              |FROM(\n                              |   SELECT\n                              |     a, COUNT(b) as b, MAX(b) as b1\n                              |   FROM T\n                              |   GROUP BY a\n                              |) GROUP BY b\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,7,2,2", (List)new .colon.colon((Object)"4,6,1,1", (List)new .colon.colon((Object)"8,5,1,1", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggWithJoin() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT *\n                              |FROM(\n                              |  SELECT\n                              |    c, MIN(b) as b, MAX(b) as d, COUNT(DISTINCT a) as a\n                              |  FROM(\n                              |    SELECT\n                              |      a, COUNT(DISTINCT b) as b, MAX(b) as c\n                              |    FROM T\n                              |    GROUP BY a\n                              |  ) GROUP BY c\n                              |) as T1 JOIN T ON T1.b + 2 = T.a\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,2,2,1,4,5,Hello 2", "2,2,2,1,4,5,Hello 3", "2,2,2,1,4,5,null", "2,2,2,1,4,6,Hello 1", "5,1,4,2,3,5,Hello 0", "5,1,4,2,3,5,Hello 1", "6,2,2,1,4,5,Hello 2", "6,2,2,1,4,5,Hello 3", "6,2,2,1,4,5,null", "6,2,2,1,4,6,Hello 1"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testUvWithRetraction() {
        List data = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1 & Serializable & scala.Serializable)i -> SplitAggregateITCase.$anonfun$testUvWithRetraction$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple3<String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                    public Tuple3<String, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.sql.SplitAggregateITCase$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("src", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(distinct b) as uv\n         |FROM (\n         |  SELECT a, b, last_value(c)\n         |  FROM src\n         |  GROUP BY a, b\n         |) t\n         |GROUP BY a\n     ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,10", "1,10", "2,10", "3,10", "4,10", "5,10", "6,10", "7,10", "8,10", "9,10"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testCountDistinctWithBinaryRowSource() {
        List data = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)i -> SplitAggregateITCase.$anonfun$testCountDistinctWithBinaryRowSource$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingBinaryRowSource(data, new CaseClassTypeInfo<Tuple4<String, String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, String, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, String, String, String>> unused = new ScalaCaseClassSerializer<Tuple4<String, String, String, String>>(this, fieldSerializers){

                    public Tuple4<String, String, String, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<String, String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.sql.SplitAggregateITCase$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}));
        this.tEnv().createTemporaryView("src", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  b,\n         |  COUNT(distinct c) as uv\n         |FROM (\n         |  SELECT\n         |    a, b, c, d\n         |  FROM\n         |    src where b <> ''\n         |  UNION ALL\n         |  SELECT\n         |    a, 'ALL' as b, c, d\n         |  FROM\n         |    src where b <> ''\n         |) t\n         |GROUP BY\n         |  a, b\n     ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,50", (List)new .colon.colon((Object)"1,ALL,50", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testMultipleDistinctAggOnSameColumn() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  a,\n                              |  COUNT(DISTINCT b),\n                              |  COUNT(DISTINCT b) filter (where not b = 2),\n                              |  MAX(b) filter (where not b = 5),\n                              |  MIN(b) filter (where not b = 2)\n                              |FROM T\n                              |GROUP BY a\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,2,1,2,1", (List)new .colon.colon((Object)"2,4,3,4,3", (List)new .colon.colon((Object)"3,1,1,null,5", (List)new .colon.colon((Object)"4,2,2,6,5", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggFilterClauseBothWithAvgAndCount() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  a,\n                              |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n                              |  SUM(b) FILTER (WHERE NOT b = 5),\n                              |  COUNT(b),\n                              |  SUM(b),\n                              |  AVG(b)\n                              |FROM T\n                              |GROUP BY a\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,3,2,3,1", (List)new .colon.colon((Object)"2,3,24,8,29,3", (List)new .colon.colon((Object)"3,1,null,2,10,5", (List)new .colon.colon((Object)"4,2,6,4,21,5", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testListAggWithDistinctMultiArgs() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  a,\n                              |  LISTAGG(DISTINCT c, '#')\n                              |FROM T\n                              |GROUP BY a\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Map expected = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1"), (Object)new .colon.colon((Object)"Hello 0", (List)new .colon.colon((Object)"Hello 1", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"2"), (Object)new .colon.colon((Object)"Hello 0", (List)new .colon.colon((Object)"Hello 1", (List)new .colon.colon((Object)"Hello 2", (List)new .colon.colon((Object)"Hello 3", (List)new .colon.colon((Object)"Hello 4", (List)Nil$.MODULE$)))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"3"), (Object)new .colon.colon((Object)"Hello 0", (List)new .colon.colon((Object)"Hello 1", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"4"), (Object)new .colon.colon((Object)"Hello 1", (List)new .colon.colon((Object)"Hello 2", (List)new .colon.colon((Object)"Hello 3", (List)Nil$.MODULE$))))}));
        List actualData = (List)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$);
        Map actualMap = ((TraversableOnce)actualData.map((Function1 & Serializable & scala.Serializable)str -> {
            String[] list = str.split(",");
            List values = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list[1].split("#"))).toList().sorted((Ordering)Ordering.String$.MODULE$);
            return new Tuple2((Object)list[0], (Object)values);
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.assertMapStrEquals(expected.toString(), actualMap.toString());
    }

    public static final /* synthetic */ MutableList $anonfun$testCountDistinct$1(List ids$1, List dateTimes$1, List dates$1, List times$1, List integers$1, List chars$1, MutableList data$1, int i) {
        String v = (String)integers$1.apply(i);
        BigDecimal decimal = v == null ? null : new BigDecimal(v);
        Integer n = v == null ? null : Integer.valueOf(v);
        Long l = v == null ? null : Long.valueOf(v);
        return data$1.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)ids$1.apply(i))), DateTimeTestUtil$.MODULE$.localDateTime((String)dateTimes$1.apply(i)), DateTimeTestUtil$.MODULE$.localDate((String)dates$1.apply(i)), DateTimeTestUtil$.MODULE$.localTime((String)times$1.apply(i)), decimal, n, l, chars$1.apply(i)}));
    }

    public static final /* synthetic */ Tuple3 $anonfun$testUvWithRetraction$1(int i) {
        return new Tuple3((Object)String.valueOf(BoxesRunTime.boxToInteger((int)(i % 10))), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)(i % 100))), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)));
    }

    public static final /* synthetic */ Tuple4 $anonfun$testCountDistinctWithBinaryRowSource$1(int i) {
        return new Tuple4((Object)"1", (Object)"1", (Object)String.valueOf(BoxesRunTime.boxToInteger((int)(i % 50))), (Object)"1");
    }

    public SplitAggregateITCase(PartialAggMode partialAggMode, StreamingWithAggTestBase.AggMode aggMode, StreamingWithStateTestBase.StateBackendMode backend) {
        this.partialAggMode = partialAggMode;
        super(aggMode, StreamingWithMiniBatchTestBase$.MODULE$.MiniBatchOn(), backend);
    }

    public static class PartialAggMode
    implements Product,
    scala.Serializable {
        private final boolean isPartialAggEnabled;

        public boolean isPartialAggEnabled() {
            return this.isPartialAggEnabled;
        }

        public String toString() {
            return this.isPartialAggEnabled() ? "ON" : "OFF";
        }

        public PartialAggMode copy(boolean isPartialAggEnabled) {
            return new PartialAggMode(isPartialAggEnabled);
        }

        public boolean copy$default$1() {
            return this.isPartialAggEnabled();
        }

        public String productPrefix() {
            return "PartialAggMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return BoxesRunTime.boxToBoolean((boolean)this.isPartialAggEnabled());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PartialAggMode;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)(this.isPartialAggEnabled() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PartialAggMode)) return false;
            boolean bl = true;
            if (!bl) return false;
            PartialAggMode partialAggMode = (PartialAggMode)x$1;
            if (this.isPartialAggEnabled() != partialAggMode.isPartialAggEnabled()) return false;
            if (!partialAggMode.canEqual(this)) return false;
            return true;
        }

        public PartialAggMode(boolean isPartialAggEnabled) {
            this.isPartialAggEnabled = isPartialAggEnabled;
            Product.$init$((Product)this);
        }
    }
}

