/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001'\t\u0019B+[7f\u0003R$(/\u001b2vi\u0016LEkQ1tK*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0019\u0019HO]3b[*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tQ!\u001e;jYNL!!\u0007\f\u0003#M#(/Z1nS:<G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0013\u0001\u00023bi\u0006,\u0012A\t\t\u0004G)bS\"\u0001\u0013\u000b\u0005\u00152\u0013!C5n[V$\u0018M\u00197f\u0015\t9\u0003&\u0001\u0006d_2dWm\u0019;j_:T\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W\u0011\u0012A\u0001T5tiB\u0011Q\u0006M\u0007\u0002])\u0011q\u0006D\u0001\u0006if\u0004Xm]\u0005\u0003c9\u00121AU8x\u0011\u0019\u0019\u0004\u0001)A\u0005E\u0005)A-\u0019;bA!9Q\u0007\u0001b\u0001\n\u00031\u0014A\u00023bi\u0006LE-F\u00018!\tAtH\u0004\u0002:{A\u0011!\bK\u0007\u0002w)\u0011AHE\u0001\u0007yI|w\u000e\u001e \n\u0005yB\u0013A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!A\u0010\u0015\t\r\r\u0003\u0001\u0015!\u00038\u0003\u001d!\u0017\r^1JI\u0002Bq!\u0012\u0001C\u0002\u0013\u0005\u0011%A\u0004mij$\u0015\r^1\t\r\u001d\u0003\u0001\u0015!\u0003#\u0003!aGO\u001f#bi\u0006\u0004\u0003bB%\u0001\u0005\u0004%\tAN\u0001\nYRTH)\u0019;b\u0013\u0012Daa\u0013\u0001!\u0002\u00139\u0014A\u00037uu\u0012\u000bG/Y%eA!)Q\n\u0001C\u0001\u001d\u0006qB/Z:u/&tGm\\<BO\u001e\u0014XmZ1uK>sw+\u0019;fe6\f'o\u001b\u000b\u0002\u001fB\u0011\u0001+U\u0007\u0002Q%\u0011!\u000b\u000b\u0002\u0005+:LG\u000f\u000b\u0002M)B\u0011Q\u000bX\u0007\u0002-*\u0011q\u000bW\u0001\u0004CBL'BA-[\u0003\u001dQW\u000f]5uKJT!a\u0017\t\u0002\u000b),h.\u001b;\n\u0005u3&\u0001\u0002+fgRDQa\u0018\u0001\u0005\u00029\u000b!\u0006^3ti^Kg\u000eZ8x\u0003\u001e<'/Z4bi\u0016|e\u000eV5nKN$\u0018-\u001c9Mij<\u0016\r^3s[\u0006\u00148\u000e\u000b\u0002_)\")!\r\u0001C\u0001\u001d\u0006AC/Z:u/&tGm\\<BO\u001e\u0014XmZ1uK>s7)^:u_6L'0\u001a3XCR,'/\\1sW\"\u0012\u0011\r\u0016\u0005\u0006K\u0002!\tAT\u0001%i\u0016\u001cHoV5oI><\u0018iZ4sK\u001e\fG/Z(o\u0007>l\u0007/\u001e;fIJ{w\u000f^5nK\"\u0012A\r\u0016\u0005\u0006Q\u0002!I![\u0001\u000eY>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\u0015\u0005)\u0014\bCA6q\u001b\u0005a'BA7o\u0003\u0011!\u0018.\\3\u000b\u0003=\fAA[1wC&\u0011\u0011\u000f\u001c\u0002\u000e\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\t\u000bM<\u0007\u0019\u0001;\u0002\u0005Q\u001c\bC\u0001)v\u0013\t1\bF\u0001\u0003M_:<\u0007")
public class TimeAttributeITCase
extends StreamingTestBase {
    private final List<Row> data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.001", this.localDateTime(1L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.002", this.localDateTime(2L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.003", this.localDateTime(3L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.004", this.localDateTime(4L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)5.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.007", this.localDateTime(7L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.008", this.localDateTime(8L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.016", this.localDateTime(16L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)4.0)})), (List)Nil$.MODULE$)))))));
    private final String dataId = TestValuesTableFactory.registerData(this.data());
    private final List<Row> ltzData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.001", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.002", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.003", BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.004", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)5.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.007", BoxesRunTime.boxToLong((long)7L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.008", BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 08:00:00.016", BoxesRunTime.boxToLong((long)16L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)4.0)})), (List)Nil$.MODULE$)))))));
    private final String ltzDataId = TestValuesTableFactory.registerData(this.ltzData());

    public List<Row> data() {
        return this.data;
    }

    public String dataId() {
        return this.dataId;
    }

    public List<Row> ltzData() {
        return this.ltzData;
    }

    public String ltzDataId() {
        return this.ltzDataId;
    }

    @Test
    public void testWindowAggregateOnWatermark() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(288).append("\n         |CREATE TABLE src (\n         |  log_ts STRING,\n         |  ts TIMESTAMP(3),\n         |  a INT,\n         |  b DOUBLE,\n         |  WATERMARK FOR ts AS ts - INTERVAL '0.001' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(this.dataId()).append("'\n         |)\n      ").toString())).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(ts, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src\n        |GROUP BY TUMBLE(ts, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01T00:00:00.003,2,3.0", "1970-01-01T00:00:00.006,2,7.0", "1970-01-01T00:00:00.009,2,6.0", "1970-01-01T00:00:00.018,1,4.0"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWindowAggregateOnTimestampLtzWatermark() {
        String zoneId = "Asia/Shanghai";
        this.tEnv().getConfig().setLocalTimeZone(ZoneId.of(zoneId));
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("\n         |CREATE TABLE src1 (\n         |  log_ts STRING,\n         |  ts BIGINT,\n         |  a INT,\n         |  b DOUBLE,\n         |  ltz_ts AS TO_TIMESTAMP_LTZ(ts, 3),\n         |  WATERMARK FOR ltz_ts AS ltz_ts - INTERVAL '0.001' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(this.ltzDataId()).append("'\n         |)\n      ").toString())).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(ltz_ts, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src1\n        |GROUP BY TUMBLE(ltz_ts, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink(TimeZone.getTimeZone(zoneId));
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01T08:00:00.003,2,3.0", "1970-01-01T08:00:00.006,2,7.0", "1970-01-01T08:00:00.009,2,6.0", "1970-01-01T08:00:00.018,1,4.0"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWindowAggregateOnCustomizedWatermark() {
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        this.tEnv().createTemporaryFunction("myFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(273).append("\n         |CREATE TABLE src (\n         |  log_ts STRING,\n         |  ts TIMESTAMP(3),\n         |  a INT,\n         |  b DOUBLE,\n         |  WATERMARK FOR ts AS myFunc(ts, a)\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(this.dataId()).append("'\n         |)\n      ").toString())).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(ts, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src\n        |GROUP BY TUMBLE(ts, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01T00:00:00.003,2,3.0", "1970-01-01T00:00:00.006,2,7.0", "1970-01-01T00:00:00.009,2,6.0", "1970-01-01T00:00:00.018,1,4.0"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        Assertions.assertThat((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.openCalled).isTrue();
        Assertions.assertThat((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled).isTrue();
    }

    @Test
    public void testWindowAggregateOnComputedRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(351).append("\n         |CREATE TABLE src (\n         |  log_ts STRING,\n         |  ts TIMESTAMP(3),\n         |  a INT,\n         |  b DOUBLE,\n         |  rowtime AS CAST(log_ts AS TIMESTAMP(3)),\n         |  WATERMARK FOR rowtime AS rowtime - INTERVAL '0.001' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(this.dataId()).append("'\n         |)\n      ").toString())).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(rowtime, INTERVAL '0.003' SECOND), COUNT(ts), SUM(b)\n        |FROM src\n        |GROUP BY TUMBLE(rowtime, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        this.tEnv().executeSql(ddl);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute("SQL JOB");
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01T00:00:00.003,2,3.0", "1970-01-01T00:00:00.006,2,7.0", "1970-01-01T00:00:00.009,2,6.0", "1970-01-01T00:00:00.018,1,4.0"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private LocalDateTime localDateTime(long ts) {
        return new Timestamp(ts - (long)TimeZone.getDefault().getOffset(ts)).toLocalDateTime();
    }
}

