/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.ZoneId;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.stream.sql.WindowAggregateITCase$;
import org.apache.flink.table.planner.runtime.utils.FailingCollectionSource;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.runtime.utils.TimeTestUtil;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u0001\u0003\u0001M\u0011QcV5oI><\u0018iZ4sK\u001e\fG/Z%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\tC\u001e<\u0007\u000b[1tKB\u0011QdH\u0007\u0002=)\u0011q\u0003C\u0005\u0003Ay\u0011a#Q4he\u0016<\u0017\r^3QQ\u0006\u001cXm\u0015;sCR,w-\u001f\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005)1\u000f^1uKB\u0011A\u0005\u000f\b\u0003KYr!AJ\u001b\u000f\u0005\u001d\"dB\u0001\u00154\u001d\tI#G\u0004\u0002+c9\u00111\u0006\r\b\u0003Y=j\u0011!\f\u0006\u0003]I\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003/\u0019I!a\u000e\f\u00025M#(/Z1nS:<w+\u001b;i'R\fG/\u001a+fgR\u0014\u0015m]3\n\u0005eR$\u0001E*uCR,')Y2lK:$Wj\u001c3f\u0015\t9d\u0003\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0003=)8/\u001a+j[\u0016\u001cH/Y7q\u0019RT\bC\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\t\u0002!\t!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0019C\u0015J\u0013\t\u0003\u000f\u0002i\u0011A\u0001\u0005\u00067\r\u0003\r\u0001\b\u0005\u0006E\r\u0003\ra\t\u0005\u0006y\r\u0003\r!\u0010\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0003\u0001\"V/\u001c2mK^Kg\u000eZ8x\u000fJ|W\u000f]*fi\u0016C\b/Z2uK\u0012$\u0015\r^1\u0016\u00039\u00032a\u0014*U\u001b\u0005\u0001&BA)@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003'B\u00131aU3r!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0003mC:<'\"A-\u0002\t)\fg/Y\u0005\u00037Z\u0013aa\u0015;sS:<\u0007BB/\u0001A\u0003%a*A\u0011Uk6\u0014G.Z,j]\u0012|wo\u0012:pkB\u001cV\r^#ya\u0016\u001cG/\u001a3ECR\f\u0007\u0005C\u0004`\u0001\t\u0007I\u0011A'\u00029Q+XN\u00197f/&tGm\\<Dk\n,W\t\u001f9fGR,G\rR1uC\"1\u0011\r\u0001Q\u0001\n9\u000bQ\u0004V;nE2,w+\u001b8e_^\u001cUOY3FqB,7\r^3e\t\u0006$\u0018\r\t\u0005\bG\u0002\u0011\r\u0011\"\u0001N\u0003y!V/\u001c2mK^Kg\u000eZ8x%>dG.\u001e9FqB,7\r^3e\t\u0006$\u0018\r\u0003\u0004f\u0001\u0001\u0006IAT\u0001 )Vl'\r\\3XS:$wn\u001e*pY2,\b/\u0012=qK\u000e$X\r\u001a#bi\u0006\u0004\u0003bB4\u0001\u0005\u0004%\t!T\u0001\u001e\u0011>\u0004x+\u001b8e_^<%o\\;q'\u0016$X\t\u001f9fGR,G\rR1uC\"1\u0011\u000e\u0001Q\u0001\n9\u000ba\u0004S8q/&tGm\\<He>,\boU3u\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0011\t\u000f-\u0004!\u0019!C\u0001\u001b\u0006I\u0002j\u001c9XS:$wn^\"vE\u0016,\u0005\u0010]3di\u0016$G)\u0019;b\u0011\u0019i\u0007\u0001)A\u0005\u001d\u0006Q\u0002j\u001c9XS:$wn^\"vE\u0016,\u0005\u0010]3di\u0016$G)\u0019;bA!9q\u000e\u0001b\u0001\n\u0003i\u0015a\u0007%pa^Kg\u000eZ8x%>dG.\u001e9FqB,7\r^3e\t\u0006$\u0018\r\u0003\u0004r\u0001\u0001\u0006IAT\u0001\u001d\u0011>\u0004x+\u001b8e_^\u0014v\u000e\u001c7va\u0016C\b/Z2uK\u0012$\u0015\r^1!\u0011\u001d\u0019\bA1A\u0005\u00025\u000b!eQ;nk2\fG/Z,j]\u0012|wo\u0012:pkB\u001cV\r^#ya\u0016\u001cG/\u001a3ECR\f\u0007BB;\u0001A\u0003%a*A\u0012Dk6,H.\u0019;f/&tGm\\<He>,\boU3u\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0011\t\u000f]\u0004!\u0019!C\u0001\u001b\u0006q2)^7vY\u0006$XmV5oI><8)\u001e2f\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0005\u0007s\u0002\u0001\u000b\u0011\u0002(\u0002?\r+X.\u001e7bi\u0016<\u0016N\u001c3po\u000e+(-Z#ya\u0016\u001cG/\u001a3ECR\f\u0007\u0005C\u0004|\u0001\t\u0007I\u0011A'\u0002A\r+X.\u001e7bi\u0016<\u0016N\u001c3poJ{G\u000e\\;q\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0005\u0007{\u0002\u0001\u000b\u0011\u0002(\u0002C\r+X.\u001e7bi\u0016<\u0016N\u001c3poJ{G\u000e\\;q\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0011\t\u0011}\u0004!\u0019!C\u0001\u0003\u0003\tQb\u0015%B\u001d\u001eC\u0015)S0[\u001f:+UCAA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u00051\u0006!A/[7f\u0013\u0011\ti!a\u0002\u0003\ri{g.Z%e\u0011!\t\t\u0002\u0001Q\u0001\n\u0005\r\u0011AD*I\u0003:;\u0005*Q%`5>sU\t\t\u0005\b\u0003+\u0001A\u0011IA\f\u0003\u0019\u0011WMZ8sKR\u0011\u0011\u0011\u0004\t\u0004}\u0005m\u0011bAA\u000f\u007f\t!QK\\5uQ\u0011\t\u0019\"!\t\u0011\t\u0005\r\u0012\u0011G\u0007\u0003\u0003KQA!a\n\u0002*\u0005\u0019\u0011\r]5\u000b\t\u0005-\u0012QF\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\ty\u0003E\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003g\t)C\u0001\u0006CK\u001a|'/Z#bG\"Dq!a\u000e\u0001\t\u0003\t9\"A\ruKN$XI^3oiRKW.\u001a+v[\ndWmV5oI><\b\u0006BA\u001b\u0003w\u0001B!a\t\u0002>%!\u0011qHA\u0013\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003/\t1\u0005^3ti\u00163XM\u001c;US6,G+^7cY\u0016<\u0016N\u001c3po^KG\u000f[(gMN,G\u000f\u000b\u0003\u0002B\u0005m\u0002bBA%\u0001\u0011\u0005\u0011qC\u0001+i\u0016\u001cHoQ1tG\u0006$W-\u0012<f]R$\u0016.\\3Uk6\u0014G.Z,j]\u0012|woV5uQ>3gm]3uQ\u0011\t9%a\u000f\t\u000f\u0005=\u0003\u0001\"\u0001\u0002\u0018\u0005YC/Z:u\u000bZ,g\u000e\u001e+j[\u0016$V/\u001c2mK^Kg\u000eZ8x/&$\bNT3hCRLg/Z(gMN,G\u000f\u000b\u0003\u0002N\u0005m\u0002bBA+\u0001\u0011\u0005\u0011qC\u0001'i\u0016\u001cH/\u0012<f]R$\u0016.\\3Uk6\u0014G.Z,j]\u0012|woX$s_V\u0004\u0018N\\4TKR\u001c\b\u0006BA*\u0003wAq!a\u0017\u0001\t\u0003\t9\"\u0001\u0010uKN$XI^3oiRKW.\u001a+v[\ndWmV5oI><xlQ;cK\"\"\u0011\u0011LA\u001e\u0011\u001d\t\t\u0007\u0001C\u0001\u0003/\t\u0001\u0005^3ti\u00163XM\u001c;US6,G+^7cY\u0016<\u0016N\u001c3po~\u0013v\u000e\u001c7va\"\"\u0011qLA\u001e\u0011\u001d\t9\u0007\u0001C\u0001\u0003/\t\u0001\u0005^3tiR+XN\u00197f/&tGm\\<PkR\u0004X\u000f^,j]\u0012|w\u000fV5nK\"\"\u0011QMA\u001e\u0011\u001d\ti\u0007\u0001C\u0001\u0003/\t\u0011\u0005^3tiR+XN\u00197f/&tGm\\<He>,\bo\u00148XS:$wn^(oYfDC!a\u001b\u0002<!9\u00111\u000f\u0001\u0005\u0002\u0005]\u0011A\u000b;fgR$V/\u001c2mK^Kg\u000eZ8x/&$\bn\\;u\u001fV$\b/\u001e;XS:$wn^\"pYVlgn\u001d\u0015\u0005\u0003c\nY\u0004C\u0004\u0002z\u0001!\t!a\u0006\u0002-Q,7\u000f^#wK:$H+[7f\u0011>\u0004x+\u001b8e_^DC!a\u001e\u0002<!9\u0011q\u0010\u0001\u0005\u0002\u0005]\u0011\u0001\t;fgR,e/\u001a8u)&lW\rS8q/&tGm\\<XSRDwJ\u001a4tKRDC!! \u0002<!9\u0011Q\u0011\u0001\u0005\u0002\u0005]\u0011\u0001\u000b;fgR,e/\u001a8u)&lW\rS8q/&tGm\\<XSRDg*Z4bi&4Xm\u00144gg\u0016$\b\u0006BAB\u0003wAq!a#\u0001\t\u0003\t9\"A\u0012uKN$XI^3oiRKW.\u001a%pa^Kg\u000eZ8x?\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:)\t\u0005%\u00151\b\u0005\b\u0003#\u0003A\u0011AA\f\u0003m!Xm\u001d;Fm\u0016tG\u000fV5nK\"{\u0007oV5oI><xlQ;cK\"\"\u0011qRA\u001e\u0011\u001d\t9\n\u0001C\u0001\u0003/\tQ\u0004^3ti\u00163XM\u001c;US6,\u0007j\u001c9XS:$wn^0S_2dW\u000f\u001d\u0015\u0005\u0003+\u000bY\u0004C\u0004\u0002\u001e\u0002!\t!a\u0006\u00027Q,7\u000f^#wK:$H+[7f\u0007VlW\u000f\\1uK^Kg\u000eZ8xQ\u0011\tY*a\u000f\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002\u0018\u0005)C/Z:u\u000bZ,g\u000e\u001e+j[\u0016\u001cU/\\;mCR,w+\u001b8e_^<\u0016\u000e\u001e5PM\u001a\u001cX\r\u001e\u0015\u0005\u0003C\u000bY\u0004C\u0004\u0002*\u0002!\t!a\u0006\u0002[Q,7\u000f^#wK:$H+[7f\u0007VlW\u000f\\1uK^Kg\u000eZ8x/&$\bNT3hCRLg/Z(gMN,G\u000f\u000b\u0003\u0002(\u0006m\u0002bBAX\u0001\u0011\u0005\u0011qC\u0001)i\u0016\u001cH/\u0012<f]R$\u0016.\\3Dk6,H.\u0019;f/&tGm\\<`\u000fJ|W\u000f]5oON+Go\u001d\u0015\u0005\u0003[\u000bY\u0004C\u0004\u00026\u0002!\t!a\u0006\u0002AQ,7\u000f^#wK:$H+[7f\u0007VlW\u000f\\1uK^Kg\u000eZ8x?\u000e+(-\u001a\u0015\u0005\u0003g\u000bY\u0004C\u0004\u0002<\u0002!\t!a\u0006\u0002EQ,7\u000f^#wK:$H+[7f\u0007VlW\u000f\\1uK^Kg\u000eZ8x?J{G\u000e\\;qQ\u0011\tI,a\u000f\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002\u0018\u0005)B/Z:u\r&,G\u000e\u001a(b[\u0016\u001cuN\u001c4mS\u000e$\b\u0006BA`\u0003wAq!a2\u0001\t\u0003\t9\"A\u0013uKN$(+\u001a7bq\u001a{'/\u001c)s_\u000e$\u0018.\\3DCN\u001c\u0017\rZ3XS:$wn^!hO\"\"\u0011QYA\u001e\u0011\u001d\ti\r\u0001C\u0001\u0003/\ta\u0005^3ti\u00163XM\u001c;US6,G+^7cY\u0016<\u0016N\u001c3po^KG\u000f[\"E\u0007N{WO]2fQ\u0011\tY-a\u000f\t\u000f\u0005M\u0007\u0001\"\u0001\u0002\u0018\u0005\u0019C/Z:u\u000bZ,g\u000e\u001e+j[\u0016Du\u000e],j]\u0012|woV5uQ\u000e#5iU8ve\u000e,\u0007\u0006BAi\u0003wAq!!7\u0001\t\u0003\t9\"\u0001\u0015uKN$XI^3oiRKW.Z\"v[Vd\u0017\r^3XS:$wn^,ji\"\u001cEiQ*pkJ\u001cW\r\u000b\u0003\u0002X\u0006m\u0002bBAp\u0001\u0011\u0005\u0011qC\u00011i\u0016\u001cHOU3ue\u0006\u001cG\u000f\u0015:fm&|Wo]*mS\u000eLgnZ*uCR,w+\u001b;i'2L7-\u001b8h/&tGm\\<)\t\u0005u\u00171\b\u0005\b\u0003K\u0004A\u0011AA\f\u0003i!Xm\u001d;Fm\u0016tG\u000fV5nKN+7o]5p]^Kg\u000eZ8xQ\u0011\t\u0019/a\u000f\t\u000f\u0005-\b\u0001\"\u0001\u0002\u0018\u00059D/Z:u\u000bZ,g\u000e\u001e+j[\u0016\u001cVm]:j_:<\u0016N\u001c3po^KG\u000f\u001b+W\r:{G\u000fU;mYV\u0003\u0018J\u001c;p/&tGm\\<BO\u001eDC!!;\u0002<!9\u0011\u0011\u001f\u0001\u0005\u0002\u0005]\u0011a\n;fgR,e/\u001a8u)&lWmU3tg&|gnV5oI><x+\u001b;i\u0007\u0012\u001b5k\\;sG\u0016DC!a<\u0002<!9\u0011q\u001f\u0001\u0005\u0002\u0005]\u0011\u0001\r;fgR$\u0015n\u001d;j]\u000e$\u0018iZ4XSRDW*\u001a:hK>sWI^3oiRKW.Z*fgNLwN\\,j]\u0012|w\u000f\u000b\u0003\u0002v\u0006m\u0002f\u0002\u0001\u0002~\n%!1\u0002\t\u0005\u0003\u007f\u0014)!\u0004\u0002\u0003\u0002)!!1AA\u0013\u0003%)\u0007\u0010^3og&|g.\u0003\u0003\u0003\b\t\u0005!AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\u0012!QB\u0012\u0003\u0005\u001f\u0001BA!\u0005\u0003\"5\u0011!1\u0003\u0006\u0005\u0005+\u00119\"A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0005\u00053\u0011Y\"\u0001\u0006fqR,gn]5p]NTA!a\f\u0003\u001e)\u0019!q\u0004\u0007\u0002\u0013Q,7\u000f^;uS2\u001c\u0018\u0002\u0002B\u0012\u0005'\u0011!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:<qAa\n\u0003\u0011\u0003\u0011I#A\u000bXS:$wn^!hOJ,w-\u0019;f\u0013R\u001b\u0015m]3\u0011\u0007\u001d\u0013YC\u0002\u0004\u0002\u0005!\u0005!QF\n\u0005\u0005W\u0011y\u0003E\u0002?\u0005cI1Aa\r@\u0005\u0019\te.\u001f*fM\"9AIa\u000b\u0005\u0002\t]BC\u0001B\u0015\u0011!\u0011YDa\u000b\u0005\u0002\tu\u0012A\u00039be\u0006lW\r^3sgR\u0011!q\b\t\u0007\u0005\u0003\u00129Ea\u0013\u000e\u0005\t\r#b\u0001B#1\u0006!Q\u000f^5m\u0013\u0011\u0011IEa\u0011\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0003?\u0005\u001b\u0012\t&C\u0002\u0003P}\u0012Q!\u0011:sCf\u00042!\u0016B*\u0013\r\u0011)F\u0016\u0002\u0007\u001f\nTWm\u0019;)\u0011\te\"\u0011\fB0\u0005C\u0002BA!\u0005\u0003\\%!!Q\fB\n\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0005]\u0006lW-\t\u0002\u0003d\u0005)\u0014iZ4QQ\u0006\u001cX-P>1{2\u00023\u000b^1uK\n\u000b7m[3oIvZ\u0018' \u0017!+N,G+[7fgR\fW\u000e\u001d'uu\u0002j\u0004e\u001f\u001a~\u0001")
public class WindowAggregateITCase
extends StreamingWithStateTestBase {
    private final AggregatePhaseStrategy aggPhase;
    private final boolean useTimestampLtz;
    private final Seq<String> TumbleWindowGroupSetExpectedData;
    private final Seq<String> TumbleWindowCubeExpectedData;
    private final Seq<String> TumbleWindowRollupExpectedData;
    private final Seq<String> HopWindowGroupSetExpectedData;
    private final Seq<String> HopWindowCubeExpectedData;
    private final Seq<String> HopWindowRollupExpectedData;
    private final Seq<String> CumulateWindowGroupSetExpectedData;
    private final Seq<String> CumulateWindowCubeExpectedData;
    private final Seq<String> CumulateWindowRollupExpectedData;
    private final ZoneId SHANGHAI_ZONE;

    @Parameters(name="AggPhase={0}, StateBackend={1}, UseTimestampLtz = {2}")
    public static Collection<Object[]> parameters() {
        return WindowAggregateITCase$.MODULE$.parameters();
    }

    public Seq<String> TumbleWindowGroupSetExpectedData() {
        return this.TumbleWindowGroupSetExpectedData;
    }

    public Seq<String> TumbleWindowCubeExpectedData() {
        return this.TumbleWindowCubeExpectedData;
    }

    public Seq<String> TumbleWindowRollupExpectedData() {
        return this.TumbleWindowRollupExpectedData;
    }

    public Seq<String> HopWindowGroupSetExpectedData() {
        return this.HopWindowGroupSetExpectedData;
    }

    public Seq<String> HopWindowCubeExpectedData() {
        return this.HopWindowCubeExpectedData;
    }

    public Seq<String> HopWindowRollupExpectedData() {
        return this.HopWindowRollupExpectedData;
    }

    public Seq<String> CumulateWindowGroupSetExpectedData() {
        return this.CumulateWindowGroupSetExpectedData;
    }

    public Seq<String> CumulateWindowCubeExpectedData() {
        return this.CumulateWindowCubeExpectedData;
    }

    public Seq<String> CumulateWindowRollupExpectedData() {
        return this.CumulateWindowRollupExpectedData;
    }

    public ZoneId SHANGHAI_ZONE() {
        return this.SHANGHAI_ZONE;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().enableCheckpointing(100L, CheckpointingMode.EXACTLY_ONCE);
        this.env().setRestartStrategy(RestartStrategies.fixedDelayRestart((int)1, (long)0L));
        FailingCollectionSource.reset();
        String insertOnlyDataId = this.useTimestampLtz ? TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithLtzInShanghai()) : TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(460).append("\n         |CREATE TABLE T1 (\n         | `ts` ").append((Object)(this.useTimestampLtz ? "BIGINT" : "STRING")).append(",\n         | `int` INT,\n         | `double` DOUBLE,\n         | `float` FLOAT,\n         | `bigdec` DECIMAL(10, 2),\n         | `string` STRING,\n         | `name` STRING,\n         | `rowtime` AS\n         | ").append((Object)(this.useTimestampLtz ? "TO_TIMESTAMP_LTZ(`ts`, 3)" : "TO_TIMESTAMP(`ts`)")).append(",\n         | WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND\n         |) WITH (\n         | 'connector' = 'values',\n         | 'data-id' = '").append(insertOnlyDataId).append("',\n         | 'failing-source' = 'true'\n         |)\n         |").toString())).stripMargin());
        String changelogDataId = this.useTimestampLtz ? TestValuesTableFactory.registerData(TestData$.MODULE$.windowChangelogDataWithLtzInShanghai()) : TestValuesTableFactory.registerData(TestData$.MODULE$.windowChangelogDataWithTimestamp());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(507).append("\n         |CREATE TABLE T1_CDC (\n         | `ts` ").append((Object)(this.useTimestampLtz ? "BIGINT" : "STRING")).append(",\n         | `int` INT,\n         | `double` DOUBLE,\n         | `float` FLOAT,\n         | `bigdec` DECIMAL(10, 2),\n         | `string` STRING,\n         | `name` STRING,\n         | `rowtime` AS\n         | ").append((Object)(this.useTimestampLtz ? "TO_TIMESTAMP_LTZ(`ts`, 3)" : "TO_TIMESTAMP(`ts`)")).append(",\n         | WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND\n         |) WITH (\n         | 'connector' = 'values',\n         | 'data-id' = '").append(changelogDataId).append("',\n         | 'failing-source' = 'true',\n         | 'changelog-mode' = 'I,UA,UB,D'\n         |)\n         |").toString())).stripMargin());
        this.tEnv().createFunction("concat_distinct_agg", JavaUserDefinedAggFunctions.ConcatDistinctAggFunction.class);
        this.tEnv().getConfig().setLocalTimeZone(this.SHANGHAI_ZONE());
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.aggPhase.toString());
    }

    @TestTemplate
    public void testEventTimeTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "a,2020-10-10T00:00:05,2020-10-10T00:00:10,1,3.33,null,3.0,1,Comment#2", "b,2020-10-10T00:00:05,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeTumbleWindowWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '1' DAY, INTERVAL '8' HOUR))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T08:00,2020-10-10T08:00,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "b,2020-10-09T08:00,2020-10-10T08:00,4,14.43,6.0,3.0,3,Hello|Hi|Comment#3", "null,2020-10-09T08:00,2020-10-10T08:00,1,7.77,7.0,7.0,0,null"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCascadeEventTimeTumbleWindowWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  cnt,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*)\n        |  FROM\n        |  (\n        |    SELECT\n        |    `name`,\n        |    window_start,\n        |    window_end,\n        |    COUNT(DISTINCT `string`) AS cnt\n        |    FROM TABLE(\n        |      TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '1' DAY, INTERVAL '8' HOUR))\n        |    GROUP BY `name`, window_start, window_end\n        |) GROUP BY cnt, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,2020-10-09T08:00,2020-10-10T08:00,1", "3,2020-10-09T08:00,2020-10-10T08:00,2"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeTumbleWindowWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '1' DAY, INTERVAL '-8' HOUR))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T16:00,2020-10-10T16:00,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "b,2020-10-09T16:00,2020-10-10T16:00,4,14.43,6.0,3.0,3,Hello|Hi|Comment#3", "null,2020-10-09T16:00,2020-10-10T16:00,1,7.77,7.0,7.0,0,null"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeTumbleWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.TumbleWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeTumbleWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY CUBE(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.TumbleWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeTumbleWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.TumbleWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testTumbleWindowOutputWindowTime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  window_time,\n        |  COUNT(*)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY `name`, window_start, window_end, window_time\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = this.useTimestampLtz ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,2020-10-09T16:00:04.999Z,4", "a,2020-10-10T00:00:05,2020-10-10T00:00:10,2020-10-09T16:00:09.999Z,1", "b,2020-10-10T00:00:05,2020-10-10T00:00:10,2020-10-09T16:00:09.999Z,2", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,2020-10-09T16:00:19.999Z,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:35,2020-10-09T16:00:34.999Z,1", "null,2020-10-10T00:00:30,2020-10-10T00:00:35,2020-10-09T16:00:34.999Z,1"})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,2020-10-10T00:00:04.999,4", "a,2020-10-10T00:00:05,2020-10-10T00:00:10,2020-10-10T00:00:09.999,1", "b,2020-10-10T00:00:05,2020-10-10T00:00:10,2020-10-10T00:00:09.999,2", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,2020-10-10T00:00:19.999,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:35,2020-10-10T00:00:34.999,1", "null,2020-10-10T00:00:30,2020-10-10T00:00:35,2020-10-10T00:00:34.999,1"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testTumbleWindowGroupOnWindowOnly() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "2020-10-10T00:00:05,2020-10-10T00:00:10,3,9.99,6.0,3.0,3,Hello|Hi|Comment#2", "2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1,Comment#3"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testTumbleWindowWithoutOutputWindowColumns() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4,11.10,5.0,1.0,2,Hi|Comment#1", "3,9.99,6.0,3.0,3,Hello|Hi|Comment#2", "1,4.44,4.0,4.0,1,Hi", "2,11.10,7.0,3.0,1,Comment#3"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3,Comment#2|Hi|Comment#1", "a,2020-10-10T00:00:05,2020-10-10T00:00:15,1,3.33,null,3.0,1,Comment#2", "b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00:05,2020-10-10T00:00:15,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:25,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1,Comment#3", "null,2020-10-10T00:00:25,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null", "null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0,null"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeHopWindowWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   HOP(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '12' HOUR,\n        |     INTERVAL '1' DAY,\n        |     INTERVAL '8' HOUR))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T08:00,2020-10-10T08:00,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "a,2020-10-09T20:00,2020-10-10T20:00,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "b,2020-10-09T08:00,2020-10-10T08:00,4,14.43,6.0,3.0,3,Hello|Hi|Comment#3", "b,2020-10-09T20:00,2020-10-10T20:00,4,14.43,6.0,3.0,3,Hello|Hi|Comment#3", "null,2020-10-09T08:00,2020-10-10T08:00,1,7.77,7.0,7.0,0,null", "null,2020-10-09T20:00,2020-10-10T20:00,1,7.77,7.0,7.0,0,null"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeHopWindowWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   HOP(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '12' HOUR,\n        |     INTERVAL '1' DAY,\n        |     INTERVAL '-8' HOUR))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T04:00,2020-10-10T04:00,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "a,2020-10-09T16:00,2020-10-10T16:00,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "b,2020-10-09T04:00,2020-10-10T04:00,4,14.43,6.0,3.0,3,Hello|Hi|Comment#3", "b,2020-10-09T16:00,2020-10-10T16:00,4,14.43,6.0,3.0,3,Hello|Hi|Comment#3", "null,2020-10-09T04:00,2020-10-10T04:00,1,7.77,7.0,7.0,0,null", "null,2020-10-09T16:00,2020-10-10T16:00,1,7.77,7.0,7.0,0,null"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeHopWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.HopWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeHopWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY CUBE(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.HopWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeHopWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.HopWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "a,2020-10-10T00:00,2020-10-10T00:00:15,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00,2020-10-10T00:00:15,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1,Comment#3", "b,2020-10-10T00:00:30,2020-10-10T00:00:45,1,3.33,3.0,3.0,1,Comment#3", "null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null", "null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0,null", "null,2020-10-10T00:00:30,2020-10-10T00:00:45,1,7.77,7.0,7.0,0,null"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeCumulateWindowWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '12' HOUR,\n        |     INTERVAL '1' DAY,\n        |     INTERVAL '8' HOUR))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T08:00,2020-10-10T08:00,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "b,2020-10-09T08:00,2020-10-10T08:00,4,14.43,6.0,3.0,3,Hello|Hi|Comment#3", "null,2020-10-09T08:00,2020-10-10T08:00,1,7.77,7.0,7.0,0,null"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeCumulateWindowWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '12' HOUR,\n        |     INTERVAL '1' DAY,\n        |     INTERVAL '-8' HOUR))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T16:00,2020-10-10T04:00,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "a,2020-10-09T16:00,2020-10-10T16:00,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "b,2020-10-09T16:00,2020-10-10T04:00,4,14.43,6.0,3.0,3,Hello|Hi|Comment#3", "b,2020-10-09T16:00,2020-10-10T16:00,4,14.43,6.0,3.0,3,Hello|Hi|Comment#3", "null,2020-10-09T16:00,2020-10-10T04:00,1,7.77,7.0,7.0,0,null", "null,2020-10-09T16:00,2020-10-10T16:00,1,7.77,7.0,7.0,0,null"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeCumulateWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CumulateWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeCumulateWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY Cube(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CumulateWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeCumulateWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CumulateWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testFieldNameConflict() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_time,\n        |  MIN(rowtime) as start_time,\n        |  MAX(rowtime) as end_time\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY window_start, window_end, window_time\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = this.useTimestampLtz ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-10-09T16:00:04.999Z,2020-10-09T16:00:01Z,2020-10-09T16:00:04Z", "2020-10-09T16:00:09.999Z,2020-10-09T16:00:06Z,2020-10-09T16:00:08Z", "2020-10-09T16:00:19.999Z,2020-10-09T16:00:16Z,2020-10-09T16:00:16Z", "2020-10-09T16:00:34.999Z,2020-10-09T16:00:32Z,2020-10-09T16:00:34Z"})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-10-10T00:00:04.999,2020-10-10T00:00:01,2020-10-10T00:00:04", "2020-10-10T00:00:09.999,2020-10-10T00:00:06,2020-10-10T00:00:08", "2020-10-10T00:00:19.999,2020-10-10T00:00:16,2020-10-10T00:00:16", "2020-10-10T00:00:34.999,2020-10-10T00:00:32,2020-10-10T00:00:34"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testRelaxFormProctimeCascadeWindowAgg() {
        String timestampDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(615).append("\n                       |CREATE TABLE proctime_src (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `double` DOUBLE,\n                       | `float` FLOAT,\n                       | `bigdec` DECIMAL(10, 2),\n                       | `string` STRING,\n                       | `name` STRING,\n                       | `proctime` AS PROCTIME()\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(timestampDataId).append("',\n                       | 'failing-source' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_start,\n        |  window_end,\n        |  COUNT(*)\n        |FROM\n        |(\n        |    SELECT\n        |    `name`,\n        |    window_start,\n        |    window_end,\n        |    COUNT(DISTINCT `string`) AS cnt\n        |    FROM TABLE(\n        |      TUMBLE(TABLE proctime_src, DESCRIPTOR(proctime), INTERVAL '1' SECOND))\n        |    GROUP BY `name`, window_start, window_end\n        |) GROUP BY window_start, window_end\n        ")).stripMargin();
        TestingRetractSink sink = new TestingRetractSink();
        Table res = this.tEnv().sqlQuery(sql);
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(res).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
    }

    @TestTemplate
    public void testEventTimeTumbleWindowWithCDCSource() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1_CDC, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,3,29.99,22.0,2.0,2", "a,2020-10-10T00:00:05,2020-10-10T00:00:10,1,3.33,null,3.0,1", "b,2020-10-10T00:00:05,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeHopWindowWithCDCSource() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1_CDC, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T23:59:55,2020-10-10T00:00:05,3,29.99,22.0,2.0,2", "a,2020-10-10T00:00,2020-10-10T00:00:10,5,38.87,22.0,2.0,4", "a,2020-10-10T00:00:05,2020-10-10T00:00:15,1,3.33,null,3.0,1", "b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:05,2020-10-10T00:00:15,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeCumulateWindowWithCDCSource() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(TABLE T1_CDC, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '15' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,3,29.99,22.0,2.0,2", "a,2020-10-10T00:00,2020-10-10T00:00:10,5,38.87,22.0,2.0,4", "a,2020-10-10T00:00,2020-10-10T00:00:15,5,38.87,22.0,2.0,4", "b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00,2020-10-10T00:00:15,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testRetractPreviousSlicingStateWithSlicingWindow() {
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{TestValuesTableFactory.changelogRow("+I", "2020-10-10 00:00:01", BoxesRunTime.boxToInteger((int)1), "s1", "a"), TestValuesTableFactory.changelogRow("+I", "2020-10-10 00:00:04", BoxesRunTime.boxToInteger((int)1), "s2", "a"), TestValuesTableFactory.changelogRow("-D", "2020-10-10 00:00:06", BoxesRunTime.boxToInteger((int)3), "s3", "a")}))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(627).append("\n                       |CREATE TABLE MyTable (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `string` STRING,\n                       | `name` STRING,\n                       | `rowtime` AS TO_TIMESTAMP(`ts`),\n                       | WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(dataId).append("',\n                       | 'failing-source' = 'true',\n                       | 'changelog-mode' = 'I,UA,UB,D'\n                       |)\n                       |").toString())).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`int`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T23:59:55,2020-10-10T00:00:05,2,2,2", "a,2020-10-10T00:00,2020-10-10T00:00:10,1,-1,2", "a,2020-10-10T00:00:05,2020-10-10T00:00:15,-1,-3,0"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeSessionWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM TABLE(\n        |   SESSION(TABLE T1 PARTITION BY `name`, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00:01,2020-10-10T00:00:13,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "b,2020-10-10T00:00:06,2020-10-10T00:00:12,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00:16,2020-10-10T00:00:21,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:34,2020-10-10T00:00:39,1,3.33,3.0,3.0,1,Comment#3", "null,2020-10-10T00:00:32,2020-10-10T00:00:37,1,7.77,7.0,7.0,0,null"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeSessionWindowWithTVFNotPullUpIntoWindowAgg() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`),\n        |  concat_distinct_agg(`string`)\n        |FROM (\n        | SELECT * FROM TABLE(\n        |   SESSION(TABLE T1 PARTITION BY `name`, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |   WHERE window_start > TIMESTAMP '2000-01-01 10:10:00.000'\n        |)\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00:01,2020-10-10T00:00:13,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "b,2020-10-10T00:00:06,2020-10-10T00:00:12,2,6.66,6.0,3.0,2,Hello|Hi", "b,2020-10-10T00:00:16,2020-10-10T00:00:21,1,4.44,4.0,4.0,1,Hi", "b,2020-10-10T00:00:34,2020-10-10T00:00:39,1,3.33,3.0,3.0,1,Comment#3", "null,2020-10-10T00:00:32,2020-10-10T00:00:37,1,7.77,7.0,7.0,0,null"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testEventTimeSessionWindowWithCDCSource() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   SESSION(TABLE T1_CDC PARTITION BY `name`, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00:01,2020-10-10T00:00:13,5,38.87,22.0,2.0,4", "b,2020-10-10T00:00:06,2020-10-10T00:00:12,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:16,2020-10-10T00:00:21,1,4.44,4.0,4.0,1"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testDistinctAggWithMergeOnEventTimeSessionWindow() {
        .colon.colon sessionWindowTestData = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"Hello"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToInteger((int)9), (Object)"Hello World"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)1), (Object)"Hello"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)16L), (Object)BoxesRunTime.boxToInteger((int)16), (Object)"Hello"), (List)Nil$.MODULE$)))))));
        DataStream stream = this.failingDataSource(sessionWindowTestData, new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.WindowAggregateITCase$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(new TimeTestUtil.TimestampAndWatermarkWithOffset(10L));
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(stream).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        this.tEnv().registerTable("MyTable", table);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |   COUNT(DISTINCT b),\n        |   window_end\n        |FROM TABLE(\n        |  SESSION(TABLE MyTable PARTITION BY c, DESCRIPTOR(rowtime), INTERVAL '0.005' SECOND))\n        |GROUP BY c, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello World,1,1970-01-01T00:00:00.014", "Hello,1,1970-01-01T00:00:00.021", "Hello,3,1970-01-01T00:00:00.015"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    public WindowAggregateITCase(AggregatePhaseStrategy aggPhase, StreamingWithStateTestBase.StateBackendMode state, boolean useTimestampLtz) {
        this.aggPhase = aggPhase;
        this.useTimestampLtz = useTimestampLtz;
        super(state);
        this.TumbleWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "0,a,2020-10-10T00:00:05,2020-10-10T00:00:10,1,3.33,null,3.0,1,Comment#2", "0,b,2020-10-10T00:00:05,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null", "1,null,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "1,null,2020-10-10T00:00:05,2020-10-10T00:00:10,3,9.99,6.0,3.0,3,Hello|Hi|Comment#2", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1,Comment#3"}));
        this.TumbleWindowCubeExpectedData = this.TumbleWindowGroupSetExpectedData();
        this.TumbleWindowRollupExpectedData = this.TumbleWindowGroupSetExpectedData();
        this.HopWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "0,a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3,Comment#2|Hi|Comment#1", "0,a,2020-10-10T00:00:05,2020-10-10T00:00:15,1,3.33,null,3.0,1,Comment#2", "0,b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "0,b,2020-10-10T00:00:05,2020-10-10T00:00:15,2,6.66,6.0,3.0,2,Hello|Hi", "0,b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:25,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1,Comment#3", "0,null,2020-10-10T00:00:25,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0,null", "1,null,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "1,null,2020-10-10T00:00,2020-10-10T00:00:10,8,26.64,6.0,1.0,4,Hello|Hi|Comment#2|Comment#1", "1,null,2020-10-10T00:00:05,2020-10-10T00:00:15,3,9.99,6.0,3.0,3,Hello|Hi|Comment#2", "1,null,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:25,2020-10-10T00:00:35,2,11.10,7.0,3.0,1,Comment#3", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:40,2,11.10,7.0,3.0,1,Comment#3"}));
        this.HopWindowCubeExpectedData = this.HopWindowGroupSetExpectedData();
        this.HopWindowRollupExpectedData = this.HopWindowGroupSetExpectedData();
        this.CumulateWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "0,a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "0,a,2020-10-10T00:00,2020-10-10T00:00:15,6,19.98,5.0,1.0,3,Hi|Comment#1|Comment#2", "0,b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2,Hello|Hi", "0,b,2020-10-10T00:00,2020-10-10T00:00:15,2,6.66,6.0,3.0,2,Hello|Hi", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1,Hi", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1,Comment#3", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1,Comment#3", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:45,1,3.33,3.0,3.0,1,Comment#3", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0,null", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0,null", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:45,1,7.77,7.0,7.0,0,null", "1,null,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2,Hi|Comment#1", "1,null,2020-10-10T00:00,2020-10-10T00:00:10,8,26.64,6.0,1.0,4,Hi|Comment#1|Hello|Comment#2", "1,null,2020-10-10T00:00,2020-10-10T00:00:15,8,26.64,6.0,1.0,4,Hi|Comment#1|Hello|Comment#2", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1,Hi", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1,Comment#3", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:40,2,11.10,7.0,3.0,1,Comment#3", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:45,2,11.10,7.0,3.0,1,Comment#3"}));
        this.CumulateWindowCubeExpectedData = this.CumulateWindowGroupSetExpectedData();
        this.CumulateWindowRollupExpectedData = this.CumulateWindowGroupSetExpectedData();
        this.SHANGHAI_ZONE = ZoneId.of("Asia/Shanghai");
    }
}

