/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.util.Collection;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.WindowDistinctAggregateITCase$;
import org.apache.flink.table.planner.runtime.utils.FailingCollectionSource;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u0001\u0003\u0001M\u0011QdV5oI><H)[:uS:\u001cG/Q4he\u0016<\u0017\r^3J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"AG*ue\u0016\fW.\u001b8h/&$\bn\u0015;bi\u0016$Vm\u001d;CCN,\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u001bM\u0004H.\u001b;ESN$\u0018N\\2u!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u001d\u0011un\u001c7fC:D\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\bE\u0006\u001c7.\u001a8e!\t)\u0013H\u0004\u0002'o9\u0011qE\u000e\b\u0003QUr!!\u000b\u001b\u000f\u0005)\u001adBA\u00163\u001d\ta\u0013G\u0004\u0002.a5\taF\u0003\u00020%\u00051AH]8pizJ\u0011!E\u0005\u0003\u001fAI!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0018\r%\u0011\u0001HF\u0001\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/Z\u0005\u0003um\u0012\u0001c\u0015;bi\u0016\u0014\u0015mY6f]\u0012lu\u000eZ3\u000b\u0005a2\u0002\"B\u001f\u0001\t\u0003q\u0014A\u0002\u001fj]&$h\bF\u0002@\u0003\n\u0003\"\u0001\u0011\u0001\u000e\u0003\tAQa\u0007\u001fA\u0002qAQa\t\u001fA\u0002\u0011Bq\u0001\u0012\u0001C\u0002\u0013\u0005Q)\u0001\u0011Uk6\u0014G.Z,j]\u0012|wo\u0012:pkB\u001cV\r^#ya\u0016\u001cG/\u001a3ECR\fW#\u0001$\u0011\u0007\u001dSE*D\u0001I\u0015\tIe$\u0001\u0006d_2dWm\u0019;j_:L!a\u0013%\u0003\u0007M+\u0017\u000f\u0005\u0002N%6\taJ\u0003\u0002P!\u0006!A.\u00198h\u0015\u0005\t\u0016\u0001\u00026bm\u0006L!a\u0015(\u0003\rM#(/\u001b8h\u0011\u0019)\u0006\u0001)A\u0005\r\u0006\tC+^7cY\u0016<\u0016N\u001c3po\u001e\u0013x.\u001e9TKR,\u0005\u0010]3di\u0016$G)\u0019;bA!9q\u000b\u0001b\u0001\n\u0003)\u0015\u0001\b+v[\ndWmV5oI><8)\u001e2f\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0005\u00073\u0002\u0001\u000b\u0011\u0002$\u0002;Q+XN\u00197f/&tGm\\<Dk\n,W\t\u001f9fGR,G\rR1uC\u0002Bqa\u0017\u0001C\u0002\u0013\u0005Q)\u0001\u0010Uk6\u0014G.Z,j]\u0012|wOU8mYV\u0004X\t\u001f9fGR,G\rR1uC\"1Q\f\u0001Q\u0001\n\u0019\u000bq\u0004V;nE2,w+\u001b8e_^\u0014v\u000e\u001c7va\u0016C\b/Z2uK\u0012$\u0015\r^1!\u0011\u001dy\u0006A1A\u0005\u0002\u0015\u000b\u0011fQ1tG\u0006$\u0017N\\4Uk6\u0014G.Z,j]\u0012|wo\u0012:pkB\u001cV\r^#ya\u0016\u001cG/\u001a3ECR\f\u0007BB1\u0001A\u0003%a)\u0001\u0016DCN\u001c\u0017\rZ5oOR+XN\u00197f/&tGm\\<He>,\boU3u\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0011\t\u000f\r\u0004!\u0019!C\u0001\u000b\u0006)3)Y:dC\u0012Lgn\u001a+v[\ndWmV5oI><8)\u001e2f\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0005\u0007K\u0002\u0001\u000b\u0011\u0002$\u0002M\r\u000b7oY1eS:<G+^7cY\u0016<\u0016N\u001c3po\u000e+(-Z#ya\u0016\u001cG/\u001a3ECR\f\u0007\u0005C\u0004h\u0001\t\u0007I\u0011A#\u0002O\r\u000b7oY1eS:<G+^7cY\u0016<\u0016N\u001c3poJ{G\u000e\\;q\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0005\u0007S\u0002\u0001\u000b\u0011\u0002$\u0002Q\r\u000b7oY1eS:<G+^7cY\u0016<\u0016N\u001c3poJ{G\u000e\\;q\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0011\t\u000f-\u0004!\u0019!C\u0001\u000b\u0006i\u0002j\u001c9XS:$wn^$s_V\u00048+\u001a;FqB,7\r^3e\t\u0006$\u0018\r\u0003\u0004n\u0001\u0001\u0006IAR\u0001\u001f\u0011>\u0004x+\u001b8e_^<%o\\;q'\u0016$X\t\u001f9fGR,G\rR1uC\u0002Bqa\u001c\u0001C\u0002\u0013\u0005Q)A\rI_B<\u0016N\u001c3po\u000e+(-Z#ya\u0016\u001cG/\u001a3ECR\f\u0007BB9\u0001A\u0003%a)\u0001\u000eI_B<\u0016N\u001c3po\u000e+(-Z#ya\u0016\u001cG/\u001a3ECR\f\u0007\u0005C\u0004t\u0001\t\u0007I\u0011A#\u00027!{\u0007oV5oI><(k\u001c7mkB,\u0005\u0010]3di\u0016$G)\u0019;b\u0011\u0019)\b\u0001)A\u0005\r\u0006a\u0002j\u001c9XS:$wn\u001e*pY2,\b/\u0012=qK\u000e$X\r\u001a#bi\u0006\u0004\u0003bB<\u0001\u0005\u0004%\t!R\u0001#\u0007VlW\u000f\\1uK^Kg\u000eZ8x\u000fJ|W\u000f]*fi\u0016C\b/Z2uK\u0012$\u0015\r^1\t\re\u0004\u0001\u0015!\u0003G\u0003\r\u001aU/\\;mCR,w+\u001b8e_^<%o\\;q'\u0016$X\t\u001f9fGR,G\rR1uC\u0002Bqa\u001f\u0001C\u0002\u0013\u0005Q)\u0001\u0010Dk6,H.\u0019;f/&tGm\\<Dk\n,W\t\u001f9fGR,G\rR1uC\"1Q\u0010\u0001Q\u0001\n\u0019\u000bqdQ;nk2\fG/Z,j]\u0012|woQ;cK\u0016C\b/Z2uK\u0012$\u0015\r^1!\u0011\u001dy\bA1A\u0005\u0002\u0015\u000b\u0001eQ;nk2\fG/Z,j]\u0012|wOU8mYV\u0004X\t\u001f9fGR,G\rR1uC\"9\u00111\u0001\u0001!\u0002\u00131\u0015!I\"v[Vd\u0017\r^3XS:$wn\u001e*pY2,\b/\u0012=qK\u000e$X\r\u001a#bi\u0006\u0004\u0003bBA\u0004\u0001\u0011\u0005\u0013\u0011B\u0001\u0007E\u00164wN]3\u0015\u0005\u0005-\u0001cA\u000f\u0002\u000e%\u0019\u0011q\u0002\u0010\u0003\tUs\u0017\u000e\u001e\u0015\u0005\u0003\u000b\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005\rRBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u001e\u0005}\u0011a\u00026va&$XM\u001d\u0006\u0004\u0003C\u0001\u0012!\u00026v]&$\u0018\u0002BA\u0013\u0003/\u0011!BQ3g_J,W)Y2i\u0011\u001d\tI\u0003\u0001C\u0001\u0003\u0013\t\u0001\u0003^3tiR+XN\u00197f/&tGm\\<)\t\u0005\u001d\u0012Q\u0006\t\u0005\u0003+\ty#\u0003\u0003\u00022\u0005]!\u0001\u0004+fgR$V-\u001c9mCR,\u0007bBA\u001b\u0001\u0011\u0005\u0011\u0011B\u0001\u001ei\u0016\u001cH\u000fV;nE2,w+\u001b8e_^|vI]8va&twmU3ug\"\"\u00111GA\u0017\u0011\u001d\tY\u0004\u0001C\u0001\u0003\u0013\tQ\u0003^3tiR+XN\u00197f/&tGm\\<`\u0007V\u0014W\r\u000b\u0003\u0002:\u00055\u0002bBA!\u0001\u0011\u0005\u0011\u0011B\u0001\u0018i\u0016\u001cH\u000fV;nE2,w+\u001b8e_^|&k\u001c7mkBDC!a\u0010\u0002.!9\u0011q\t\u0001\u0005\u0002\u0005%\u0011!\u0007;fgR\u001c\u0015m]2bI&tw\rV;nE2,w+\u001b8e_^DC!!\u0012\u0002.!9\u0011Q\n\u0001\u0005\u0002\u0005%\u0011A\n;fgR\u001c\u0015m]2bI&tw\rV;nE2,w+\u001b8e_^|vI]8va&twmU3ug\"\"\u00111JA\u0017\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003\u0013\ta\u0004^3ti\u000e\u000b7oY1eS:<G+^7cY\u0016<\u0016N\u001c3po~\u001bUOY3)\t\u0005E\u0013Q\u0006\u0005\b\u00033\u0002A\u0011AA\u0005\u0003\u0001\"Xm\u001d;DCN\u001c\u0017\rZ5oOR+XN\u00197f/&tGm\\<`%>dG.\u001e9)\t\u0005]\u0013Q\u0006\u0005\b\u0003?\u0002A\u0011AA\u0005\u00035!Xm\u001d;I_B<\u0016N\u001c3po\"\"\u0011QLA\u0017\u0011\u001d\t)\u0007\u0001C\u0001\u0003\u0013\t!\u0004^3ti\"{\u0007oV5oI><xl\u0012:pkBLgnZ*fiNDC!a\u0019\u0002.!9\u00111\u000e\u0001\u0005\u0002\u0005%\u0011A\u0005;fgRDu\u000e],j]\u0012|woX\"vE\u0016DC!!\u001b\u0002.!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005%\u0011\u0001\u0006;fgRDu\u000e],j]\u0012|wo\u0018*pY2,\b\u000f\u000b\u0003\u0002p\u00055\u0002bBA<\u0001\u0011\u0005\u0011\u0011B\u0001\u0013i\u0016\u001cHoQ;nk2\fG/Z,j]\u0012|w\u000f\u000b\u0003\u0002v\u00055\u0002bBA?\u0001\u0011\u0005\u0011\u0011B\u0001 i\u0016\u001cHoQ;nk2\fG/Z,j]\u0012|woX$s_V\u0004\u0018N\\4TKR\u001c\b\u0006BA>\u0003[Aq!a!\u0001\t\u0003\tI!A\fuKN$8)^7vY\u0006$XmV5oI><xlQ;cK\"\"\u0011\u0011QA\u0017\u0011\u001d\tI\t\u0001C\u0001\u0003\u0013\t\u0011\u0004^3ti\u000e+X.\u001e7bi\u0016<\u0016N\u001c3po~\u0013v\u000e\u001c7va\"\"\u0011qQA\u0017Q\u001d\u0001\u0011qRAN\u0003;\u0003B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9\"A\u0005fqR,gn]5p]&!\u0011\u0011TAJ\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003?\u001b#!!)\u0011\t\u0005\r\u00161W\u0007\u0003\u0003KSA!a*\u0002*\u0006i\u0001/\u0019:b[\u0016$XM]5{K\u0012TA!a+\u0002.\u0006QQ\r\u001f;f]NLwN\\:\u000b\t\u0005\u0005\u0012q\u0016\u0006\u0004\u0003cc\u0011!\u0003;fgR,H/\u001b7t\u0013\u0011\t),!*\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\b\u000f\u0005e&\u0001#\u0001\u0002<\u0006ir+\u001b8e_^$\u0015n\u001d;j]\u000e$\u0018iZ4sK\u001e\fG/Z%U\u0007\u0006\u001cX\rE\u0002A\u0003{3a!\u0001\u0002\t\u0002\u0005}6\u0003BA_\u0003\u0003\u00042!HAb\u0013\r\t)M\b\u0002\u0007\u0003:L(+\u001a4\t\u000fu\ni\f\"\u0001\u0002JR\u0011\u00111\u0018\u0005\t\u0003\u001b\fi\f\"\u0001\u0002P\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005E\u0007CBAj\u00033\fi.\u0004\u0002\u0002V*\u0019\u0011q\u001b)\u0002\tU$\u0018\u000e\\\u0005\u0005\u00037\f)N\u0001\u0006D_2dWm\u0019;j_:\u0004R!HAp\u0003GL1!!9\u001f\u0005\u0015\t%O]1z!\ri\u0015Q]\u0005\u0004\u0003Ot%AB(cU\u0016\u001cG\u000f\u000b\u0005\u0002L\u0006-\u0018\u0011_Az!\u0011\t\u0019+!<\n\t\u0005=\u0018Q\u0015\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00028b[\u0016\f#!!>\u0002GM\u0003H.\u001b;ESN$\u0018N\\2u{m\u0004T\u0010\f\u0011Ti\u0006$XMQ1dW\u0016tG-P>2{\u0002")
public class WindowDistinctAggregateITCase
extends StreamingWithStateTestBase {
    private final boolean splitDistinct;
    private final Seq<String> TumbleWindowGroupSetExpectedData;
    private final Seq<String> TumbleWindowCubeExpectedData;
    private final Seq<String> TumbleWindowRollupExpectedData;
    private final Seq<String> CascadingTumbleWindowGroupSetExpectedData;
    private final Seq<String> CascadingTumbleWindowCubeExpectedData;
    private final Seq<String> CascadingTumbleWindowRollupExpectedData;
    private final Seq<String> HopWindowGroupSetExpectedData;
    private final Seq<String> HopWindowCubeExpectedData;
    private final Seq<String> HopWindowRollupExpectedData;
    private final Seq<String> CumulateWindowGroupSetExpectedData;
    private final Seq<String> CumulateWindowCubeExpectedData;
    private final Seq<String> CumulateWindowRollupExpectedData;

    @Parameters(name="SplitDistinct={0}, StateBackend={1}")
    public static Collection<Object[]> parameters() {
        return WindowDistinctAggregateITCase$.MODULE$.parameters();
    }

    public Seq<String> TumbleWindowGroupSetExpectedData() {
        return this.TumbleWindowGroupSetExpectedData;
    }

    public Seq<String> TumbleWindowCubeExpectedData() {
        return this.TumbleWindowCubeExpectedData;
    }

    public Seq<String> TumbleWindowRollupExpectedData() {
        return this.TumbleWindowRollupExpectedData;
    }

    public Seq<String> CascadingTumbleWindowGroupSetExpectedData() {
        return this.CascadingTumbleWindowGroupSetExpectedData;
    }

    public Seq<String> CascadingTumbleWindowCubeExpectedData() {
        return this.CascadingTumbleWindowCubeExpectedData;
    }

    public Seq<String> CascadingTumbleWindowRollupExpectedData() {
        return this.CascadingTumbleWindowRollupExpectedData;
    }

    public Seq<String> HopWindowGroupSetExpectedData() {
        return this.HopWindowGroupSetExpectedData;
    }

    public Seq<String> HopWindowCubeExpectedData() {
        return this.HopWindowCubeExpectedData;
    }

    public Seq<String> HopWindowRollupExpectedData() {
        return this.HopWindowRollupExpectedData;
    }

    public Seq<String> CumulateWindowGroupSetExpectedData() {
        return this.CumulateWindowGroupSetExpectedData;
    }

    public Seq<String> CumulateWindowCubeExpectedData() {
        return this.CumulateWindowCubeExpectedData;
    }

    public Seq<String> CumulateWindowRollupExpectedData() {
        return this.CumulateWindowRollupExpectedData;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().enableCheckpointing(100L, CheckpointingMode.EXACTLY_ONCE);
        this.env().setRestartStrategy(RestartStrategies.fixedDelayRestart((int)1, (long)0L));
        FailingCollectionSource.reset();
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(697).append("\n                       |CREATE TABLE T1 (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `double` DOUBLE,\n                       | `float` FLOAT,\n                       | `bigdec` DECIMAL(10, 2),\n                       | `string` STRING,\n                       | `name` STRING,\n                       | `rowtime` AS TO_TIMESTAMP(`ts`),\n                       | WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(dataId).append("',\n                       | 'failing-source' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)this.splitDistinct));
    }

    @TestTemplate
    public void testTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "2020-10-10T00:00:05,2020-10-10T00:00:10,3,9.99,6.0,3.0,3", "2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testTumbleWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.TumbleWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testTumbleWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY CUBE(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.TumbleWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testTumbleWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.TumbleWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCascadingTumbleWindow() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE VIEW V1 AS\n                      |SELECT\n                      |  `name`,\n                      |  window_time as rowtime,\n                      |  COUNT(*) as cnt,\n                      |  SUM(`bigdec`) as sum_bigdec,\n                      |  MAX(`double`) as max_double,\n                      |  MIN(`float`) as min_float,\n                      |  COUNT(DISTINCT `string`) as uv\n                      |FROM TABLE(\n                      |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n                      |GROUP BY `name`, window_start, window_end, window_time\n                      |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`, window_start, window_end,\n        |  SUM(cnt),\n        |  SUM(sum_bigdec),\n        |  MAX(max_double),\n        |  MIN(min_float),\n        |  SUM(uv)\n        |FROM TABLE(\n        |   TUMBLE(TABLE V1, DESCRIPTOR(rowtime), INTERVAL '10' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:10,5,14.43,5.0,1.0,3", "b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", "null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCascadingTumbleWindow_GroupingSets() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE VIEW V1 AS\n                      |SELECT\n                      |  GROUPING_ID(`name`) as group_id,\n                      |  `name`,\n                      |  window_time as rowtime,\n                      |  COUNT(*) as cnt,\n                      |  SUM(`bigdec`) as sum_bigdec,\n                      |  MAX(`double`) as max_double,\n                      |  MIN(`float`) as min_float,\n                      |  COUNT(DISTINCT `string`) as uv\n                      |FROM TABLE(\n                      |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n                      |GROUP BY GROUPING SETS((`name`),()), window_start, window_end, window_time\n                      |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  group_id,\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  SUM(cnt),\n        |  SUM(sum_bigdec),\n        |  MAX(max_double),\n        |  MIN(min_float),\n        |  SUM(uv)\n        |FROM TABLE(\n        |   TUMBLE(TABLE V1, DESCRIPTOR(rowtime), INTERVAL '10' SECOND))\n        |GROUP BY group_id, `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CascadingTumbleWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCascadingTumbleWindow_Cube() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE VIEW V1 AS\n                      |SELECT\n                      |  GROUPING_ID(`name`) as group_id,\n                      |  `name`,\n                      |  window_time as rowtime,\n                      |  COUNT(*) as cnt,\n                      |  SUM(`bigdec`) as sum_bigdec,\n                      |  MAX(`double`) as max_double,\n                      |  MIN(`float`) as min_float,\n                      |  COUNT(DISTINCT `string`) as uv\n                      |FROM TABLE(\n                      |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n                      |GROUP BY CUBE(`name`), window_start, window_end, window_time\n                      |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  group_id,\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  SUM(cnt),\n        |  SUM(sum_bigdec),\n        |  MAX(max_double),\n        |  MIN(min_float),\n        |  SUM(uv)\n        |FROM TABLE(\n        |   TUMBLE(TABLE V1, DESCRIPTOR(rowtime), INTERVAL '10' SECOND))\n        |GROUP BY group_id, `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CascadingTumbleWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCascadingTumbleWindow_Rollup() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE VIEW V1 AS\n                      |SELECT\n                      |  GROUPING_ID(`name`) as group_id,\n                      |  `name`,\n                      |  window_time as rowtime,\n                      |  COUNT(*) as cnt,\n                      |  SUM(`bigdec`) as sum_bigdec,\n                      |  MAX(`double`) as max_double,\n                      |  MIN(`float`) as min_float,\n                      |  COUNT(DISTINCT `string`) as uv\n                      |FROM TABLE(\n                      |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n                      |GROUP BY ROLLUP(`name`), window_start, window_end, window_time\n                      |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  group_id,\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  SUM(cnt),\n        |  SUM(sum_bigdec),\n        |  MAX(max_double),\n        |  MIN(min_float),\n        |  SUM(uv)\n        |FROM TABLE(\n        |   TUMBLE(TABLE V1, DESCRIPTOR(rowtime), INTERVAL '10' SECOND))\n        |GROUP BY group_id, `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CascadingTumbleWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3", "a,2020-10-10T00:00:05,2020-10-10T00:00:15,1,3.33,null,3.0,1", "b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:05,2020-10-10T00:00:15,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:25,2020-10-10T00:00:35,1,3.33,3.0,3.0,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", "null,2020-10-10T00:00:25,2020-10-10T00:00:35,1,7.77,7.0,7.0,0", "null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testHopWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.HopWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testHopWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY CUBE(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.HopWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testHopWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.HopWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3", "a,2020-10-10T00:00,2020-10-10T00:00:15,6,19.98,5.0,1.0,3", "b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00,2020-10-10T00:00:15,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:45,1,3.33,3.0,3.0,1", "null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0", "null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0", "null,2020-10-10T00:00:30,2020-10-10T00:00:45,1,7.77,7.0,7.0,0"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCumulateWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CumulateWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCumulateWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY Cube(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CumulateWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCumulateWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CumulateWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    public WindowDistinctAggregateITCase(boolean splitDistinct, StreamingWithStateTestBase.StateBackendMode backend) {
        this.splitDistinct = splitDistinct;
        super(backend);
        this.TumbleWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "0,a,2020-10-10T00:00:05,2020-10-10T00:00:10,1,3.33,null,3.0,1", "0,b,2020-10-10T00:00:05,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0", "1,null,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "1,null,2020-10-10T00:00:05,2020-10-10T00:00:10,3,9.99,6.0,3.0,3", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1"}));
        this.TumbleWindowCubeExpectedData = this.TumbleWindowGroupSetExpectedData();
        this.TumbleWindowRollupExpectedData = this.TumbleWindowGroupSetExpectedData();
        this.CascadingTumbleWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-10T00:00,2020-10-10T00:00:10,5,14.43,5.0,1.0,3", "0,b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0", "1,null,2020-10-10T00:00,2020-10-10T00:00:10,7,21.09,6.0,1.0,5", "1,null,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:40,2,11.10,7.0,3.0,1"}));
        this.CascadingTumbleWindowCubeExpectedData = this.CascadingTumbleWindowGroupSetExpectedData();
        this.CascadingTumbleWindowRollupExpectedData = this.CascadingTumbleWindowGroupSetExpectedData();
        this.HopWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "0,a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3", "0,a,2020-10-10T00:00:05,2020-10-10T00:00:15,1,3.33,null,3.0,1", "0,b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00:05,2020-10-10T00:00:15,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:25,2020-10-10T00:00:35,1,3.33,3.0,3.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", "0,null,2020-10-10T00:00:25,2020-10-10T00:00:35,1,7.77,7.0,7.0,0", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0", "1,null,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "1,null,2020-10-10T00:00,2020-10-10T00:00:10,8,26.64,6.0,1.0,4", "1,null,2020-10-10T00:00:05,2020-10-10T00:00:15,3,9.99,6.0,3.0,3", "1,null,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:25,2020-10-10T00:00:35,2,11.10,7.0,3.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:40,2,11.10,7.0,3.0,1"}));
        this.HopWindowCubeExpectedData = this.HopWindowGroupSetExpectedData();
        this.HopWindowRollupExpectedData = this.HopWindowGroupSetExpectedData();
        this.CumulateWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "0,a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3", "0,a,2020-10-10T00:00,2020-10-10T00:00:15,6,19.98,5.0,1.0,3", "0,b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00,2020-10-10T00:00:15,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:45,1,3.33,3.0,3.0,1", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:45,1,7.77,7.0,7.0,0", "1,null,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "1,null,2020-10-10T00:00,2020-10-10T00:00:10,8,26.64,6.0,1.0,4", "1,null,2020-10-10T00:00,2020-10-10T00:00:15,8,26.64,6.0,1.0,4", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:40,2,11.10,7.0,3.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:45,2,11.10,7.0,3.0,1"}));
        this.CumulateWindowCubeExpectedData = this.CumulateWindowGroupSetExpectedData();
        this.CumulateWindowRollupExpectedData = this.CumulateWindowGroupSetExpectedData();
    }
}

