/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class DataGeneratorConnectorITCase
extends BatchTestBase {
    private static final String TABLE = "CREATE TABLE datagen_t (\n\tf0 CHAR(1),\n\tf1 VARCHAR(10),\n\tf2 STRING,\n\tf3 BOOLEAN,\n\tf4 DECIMAL(32,2),\n\tf5 TINYINT,\n\tf6 SMALLINT,\n\tf7 INT,\n\tf8 BIGINT,\n\tf9 FLOAT,\n\tf10 DOUBLE,\n\tf11 DATE,\n\tf12 TIME,\n\tf13 TIMESTAMP(3),\n\tf14 TIMESTAMP WITH LOCAL TIME ZONE,\n\tf15 INT ARRAY,\n\tf16 MAP<STRING, DATE>,\n\tf17 DECIMAL(32,2) MULTISET,\n\tf18 ROW<a BIGINT, b TIME, c ROW<d TIMESTAMP>>\n) WITH (\t'connector' = 'datagen',\n\t'number-of-rows' = '10'\n)";

    DataGeneratorConnectorITCase() {
    }

    @Test
    void testTypes() throws Exception {
        this.tEnv().executeSql(TABLE);
        ArrayList<Object> results = new ArrayList<Object>();
        try (CloseableIterator iter = this.tEnv().executeSql("select * from datagen_t").collect();){
            while (iter.hasNext()) {
                results.add(iter.next());
            }
        }
        ((ListAssert)Assertions.assertThat(results).as("Unexpected number of results", new Object[0])).hasSize(10);
    }

    @Test
    void testLimitPushDown() {
        TestingTableEnvironment env = TestingTableEnvironment.create(EnvironmentSettings.newInstance().inStreamingMode().build(), null, TableConfig.getDefault());
        env.executeSql("CREATE TABLE datagen_t (\n\tf0 CHAR(1)\n) WITH (\t'connector' = 'datagen')");
        Table table = env.sqlQuery("select * from datagen_t limit 5");
        Assertions.assertThat((String)table.explain(new ExplainDetail[0])).contains(new CharSequence[]{"table=[[default_catalog, default_database, datagen_t, limit=[5]]], fields=[f0]"});
        ((ListAssert)Assertions.assertThat((List)CollectionUtil.iteratorToList((Iterator)table.execute().collect())).as("Unexpected number of results", new Object[0])).hasSize(5);
    }

    @Test
    void testWithParallelism() {
        TestingTableEnvironment env = TestingTableEnvironment.create(EnvironmentSettings.newInstance().inStreamingMode().build(), null, TableConfig.getDefault());
        env.executeSql("CREATE TABLE datagen_t (\n\tf0 CHAR(1)\n) WITH (\t'connector' = 'datagen',\t'scan.parallelism' = '2')");
        Table table = env.sqlQuery("select * from datagen_t");
        String explain = table.explain(new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN});
        String expectedPhysicalExecutionPlanFragment = "table=[[default_catalog, default_database, datagen_t]], fields=[f0])\",\n    \"parallelism\" : 2";
        Assertions.assertThat((String)explain).contains(new CharSequence[]{"table=[[default_catalog, default_database, datagen_t]], fields=[f0])\",\n    \"parallelism\" : 2"});
    }
}

