/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.TimeZone;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Tumble;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingUpsertTableSink;
import org.apache.flink.table.planner.utils.MemoryTableSourceSinkUtil$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.sinks.CsvTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001I\u0011Q\u0003T3hC\u000eLH+\u00192mKNKgn[%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005)A/\u00192mK*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\u0004\u0017)\u0011A\"D\u0001\u0006M2Lgn\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\rC\u0003\u001b\u0001\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u0005!9q\u0004\u0001b\u0001\n\u0013\u0001\u0013!A0\u0016\u0003\u0005\u00022AI\u0014*\u001b\u0005\u0019#B\u0001\u0013&\u0003%!Xm\u001d;vi&d7O\u0003\u0002'\u0017\u0005!1m\u001c:f\u0013\tA3EA\nFC\u000eD7)\u00197mE\u0006\u001c7n\u0016:baB,'\u000f\u0005\u0002+[5\t1F\u0003\u0002-\u0015\u0005)Q\u000f^5mg&\u0011af\u000b\u0002\u0013\u0019\u0016<\u0017mY=S_^,\u0005\u0010^3og&|g\u000e\u0003\u00041\u0001\u0001\u0006I!I\u0001\u0003?\u0002B#a\f\u001a\u0011\u0005MbT\"\u0001\u001b\u000b\u0005U2\u0014!C3yi\u0016t7/[8o\u0015\t9\u0004(A\u0002ba&T!!\u000f\u001e\u0002\u000f),\b/\u001b;fe*\u00111hD\u0001\u0006UVt\u0017\u000e^\u0005\u0003{Q\u0012\u0011CU3hSN$XM]#yi\u0016t7/[8o\u0011\u0015y\u0004\u0001\"\u0001A\u0003M!Xm\u001d;TiJ,\u0017-\u001c+bE2,7+\u001b8l)\u0005\t\u0005C\u0001\u000bC\u0013\t\u0019UC\u0001\u0003V]&$\bF\u0001 F!\t1u)D\u00017\u0013\tAeG\u0001\u0003UKN$\b\"\u0002&\u0001\t\u0003\u0001\u0015a\u0007;fgR\f\u0005\u000f]3oINKgn[(o\u0003B\u0004XM\u001c3UC\ndW\r\u000b\u0002J\u000b\")Q\n\u0001C\u0001\u0001\u0006YB/Z:u\u0003B\u0004XM\u001c3TS:\\w+\u001b;i\u001d\u0016\u001cH/\u001a3S_^D#\u0001T#\t\u000bA\u0003A\u0011\u0001!\u0002OQ,7\u000f^!qa\u0016tGmU5oW>s\u0017\t\u001d9f]\u0012$\u0016M\u00197f\r>\u0014\u0018J\u001c8fe*{\u0017N\u001c\u0015\u0003\u001f\u0016CQa\u0015\u0001\u0005\u0002\u0001\u000ba\u0004^3tiJ+GO]1diNKgn[(o+B$\u0017\r^5oOR\u000b'\r\\3)\u0005I+\u0005\"\u0002,\u0001\t\u0003\u0001\u0015\u0001\b;fgR\u0014V\r\u001e:bGR\u001c\u0016N\\6P]\u0006\u0003\b/\u001a8e)\u0006\u0014G.\u001a\u0015\u0003+\u0016CQ!\u0017\u0001\u0005\u0002\u0001\u000b\u0001\u0006^3tiV\u00038/\u001a:u'&t7n\u00148Va\u0012\fG/\u001b8h)\u0006\u0014G.Z,ji\"4U\u000f\u001c7LKfD#\u0001W#\t\u000bq\u0003A\u0011\u0001!\u0002UQ,7\u000f^+qg\u0016\u0014HoU5oW>s\u0017\t\u001d9f]\u0012Lgn\u001a+bE2,w+\u001b;i\rVdGnS3zc!\u00121,\u0012\u0005\u0006?\u0002!\t\u0001Q\u0001+i\u0016\u001cH/\u00169tKJ$8+\u001b8l\u001f:\f\u0005\u000f]3oI&tw\rV1cY\u0016<\u0016\u000e\u001e5Gk2d7*Z=3Q\tqV\tC\u0003c\u0001\u0011\u0005\u0001)A\u0017uKN$X\u000b]:feR\u001c\u0016N\\6P]\u0006\u0003\b/\u001a8eS:<G+\u00192mK^KG\u000f[8vi\u001a+H\u000e\\&fsFB#!Y#\t\u000b\u0015\u0004A\u0011\u0001!\u0002[Q,7\u000f^+qg\u0016\u0014HoU5oW>s\u0017\t\u001d9f]\u0012Lgn\u001a+bE2,w+\u001b;i_V$h)\u001e7m\u0017\u0016L(\u0007\u000b\u0002e\u000b\")\u0001\u000e\u0001C\u0001\u0001\u0006AB/Z:u+B\u001cXM\u001d;TS:\\w+\u001b;i\r&dG/\u001a:)\u0005\u001d,\u0005\"B6\u0001\t\u0003\u0001\u0015\u0001\b;fgR$v\u000eR1uCN#(/Z1n\u001bVdG/\u001b*poRLW.\u001a\u0015\u0003U\u0016CQA\u001c\u0001\u0005\u0002\u0001\u000bq\u0004^3tiR{'+\u001a;sC\u000e$8\u000b\u001e:fC6lU\u000f\u001c;j%><H/[7fQ\tiW\tC\u0003r\u0001\u0011\u0005\u0001)\u0001\u0011uKN$H)Z2j[\u0006d\u0017\t\u001d9f]\u0012\u001cFO]3b[R\u000b'\r\\3TS:\\\u0007F\u00019F\u000f\u0015!(\u0001#\u0001v\u0003UaUmZ1dsR\u000b'\r\\3TS:\\\u0017\nV\"bg\u0016\u0004\"!\b<\u0007\u000b\u0005\u0011\u0001\u0012A<\u0014\u0005Y\u001c\u0002\"\u0002\u000ew\t\u0003IH#A;\t\u000f}1(\u0019!C\u0005wV\tA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011A\u00026v]&$XGC\u0002\u0002\u0004-\tA\u0001^3ti&\u0019\u0011q\u0001@\u0003)5Kg.[\"mkN$XM]#yi\u0016t7/[8o\u0011\u0019\u0001d\u000f)A\u0005y\"\u001a\u0011\u0011\u0002\u001a")
public class LegacyTableSinkITCase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testStreamTableSink() {
        File tmpFile = File.createTempFile("flink-table-sink-test", ".tmp");
        tmpFile.delete();
        tmpFile.deleteOnExit();
        String path = tmpFile.toURI().toString();
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(4);
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("csvSink", new CsvTableSink(path).configure((String[])((Object[])new String[]{"nullableCol", "c", "b"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.SQL_TIMESTAMP()})));
        DataStream input = env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$18 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testStreamTableSink$1(x$1))).map((Function1 & Serializable & scala.Serializable)x -> x, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$19 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).setParallelism(4);
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(input).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(5))).$bar$bar(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(17)))).select(new Expression[]{package$.MODULE$.ifThenElse(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(4)), package$.MODULE$.nullOf(Types.INT()), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        table.executeInsert("csvSink").await();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",Hello world,1970-01-01 00:00:00.002", ",Hello,1970-01-01 00:00:00.002", ",Hi,1970-01-01 00:00:00.001", "18,Comment#12,1970-01-01 00:00:00.006", "19,Comment#13,1970-01-01 00:00:00.006", "20,Comment#14,1970-01-01 00:00:00.006", "21,Comment#15,1970-01-01 00:00:00.006", "4,Hello world, how are you?,1970-01-01 00:00:00.003"}))).mkString("\n");
        TestBaseUtils.compareResultsByLinesInMemory((String)expected, (String)path);
    }

    @Test
    public void testAppendSinkOnAppendTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$20 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testAppendSinkOnAppendTable$1(x$2)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingAppendTableSink sink = new TestingAppendTableSink(TimeZone.getDefault());
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("appendSink", (TableSink)sink.configure((String[])((Object[])new String[]{"t", "icnt", "nsum"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "t"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "nsum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("appendSink").await();
        List result = (List)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1970-01-01 00:00:00.005,4,8", (List)new .colon.colon((Object)"1970-01-01 00:00:00.010,5,18", (List)new .colon.colon((Object)"1970-01-01 00:00:00.015,5,24", (List)new .colon.colon((Object)"1970-01-01 00:00:00.020,5,29", (List)new .colon.colon((Object)"1970-01-01 00:00:00.025,2,12", (List)Nil$.MODULE$))))).sorted((Ordering)Ordering.String$.MODULE$);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testAppendSinkWithNestedRow() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$21 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text"))}));
        tEnv.createTemporaryView("src", t);
        TestingAppendTableSink sink = new TestingAppendTableSink();
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("appendSink", (TableSink)sink.configure((String[])((Object[])new String[]{"t", "item"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.ROW((TypeInformation[])new TypeInformation[]{Types.LONG(), Types.STRING()})}))));
        tEnv.executeSql("INSERT INTO appendSink SELECT id, ROW(num, text) FROM src").await();
        List result = (List)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1,1,Hi", (List)new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,2,Hello world", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testAppendSinkOnAppendTableForInnerJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table ds1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$22 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table ds2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData5(), (TypeInformation)new CaseClassTypeInfo<Tuple5<Object, Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$23 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple5<Object, Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$23 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}));
        TestingAppendTableSink sink = new TestingAppendTableSink();
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("appendSink", (TableSink)sink.configure((String[])((Object[])new String[]{"c", "g"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.STRING()}))));
        Table table = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        table.executeInsert("appendSink").await();
        List result = (List)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"Hi,Hallo", (List)new .colon.colon((Object)"Hello,Hallo Welt", (List)new .colon.colon((Object)"Hello world,Hallo Welt", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testRetractSinkOnUpdatingTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$24 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$24 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testRetractSinkOnUpdatingTable$1(x$3)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text"))}));
        TestingRetractTableSink sink = new TestingRetractTableSink();
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("retractSink", (TableSink)sink.configure((String[])((Object[])new String[]{"len", "icnt", "nsum"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.DECIMAL()}))));
        Table table = t.select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")).charLength()).as((Symbol)SymbolLiteral.bootstrap("apply", "len"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "nsum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("retractSink").await();
        List retracted = (List)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"2,1,1.000000000000000000", (List)new .colon.colon((Object)"5,1,2.000000000000000000", (List)new .colon.colon((Object)"11,1,2.000000000000000000", (List)new .colon.colon((Object)"25,1,3.000000000000000000", (List)new .colon.colon((Object)"10,7,39.000000000000000000", (List)new .colon.colon((Object)"14,1,3.000000000000000000", (List)new .colon.colon((Object)"9,9,41.000000000000000000", (List)Nil$.MODULE$))))))).sorted((Ordering)Ordering.String$.MODULE$);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testRetractSinkOnAppendTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$25 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$25 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testRetractSinkOnAppendTable$1(x$4)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingRetractTableSink sink = new TestingRetractTableSink(TimeZone.getDefault());
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("retractSink", (TableSink)sink.configure((String[])((Object[])new String[]{"t", "icnt", "nsum"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "t"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "nsum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("retractSink").await();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith("(false,"))), (String)"Received retraction messages for append only table");
        List retracted = (List)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1970-01-01 00:00:00.005,4,8", (List)new .colon.colon((Object)"1970-01-01 00:00:00.010,5,18", (List)new .colon.colon((Object)"1970-01-01 00:00:00.015,5,24", (List)new .colon.colon((Object)"1970-01-01 00:00:00.020,5,29", (List)new .colon.colon((Object)"1970-01-01 00:00:00.025,2,12", (List)Nil$.MODULE$))))).sorted((Ordering)Ordering.String$.MODULE$);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnUpdatingTableWithFullKey() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$26 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$26 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkOnUpdatingTableWithFullKey$1(x$6)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text"))}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0, 2}, TimeZone.getDefault()).configure((String[])((Object[])new String[]{"cnt", "lencnt", "cTrue"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.DECIMAL(), Types.BOOLEAN()})));
        sink.expectedKeys_$eq((Option<String[]>)new Some((Object)new String[]{"cnt", "cTrue"}));
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink);
        Table table = t.select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")).charLength()).as((Symbol)SymbolLiteral.bootstrap("apply", "len"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).$greater(package$.MODULE$.int2Literal(0))).as((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "count"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "count")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "count")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "lencnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cTrue"))});
        table.executeInsert("upsertSink").await();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith("(false,"))), (String)"Results must include delete messages");
        List retracted = (List)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1,5.000000000000000000,true", (List)new .colon.colon((Object)"7,1.000000000000000000,true", (List)new .colon.colon((Object)"9,1.000000000000000000,true", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithFullKey1() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$27 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$27 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithFullKey1$1(x$8)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0, 1, 2}, TimeZone.getDefault()).configure((String[])((Object[])new String[]{"num", "wend", "icnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.SQL_TIMESTAMP(), Types.LONG()})));
        sink.expectedKeys_$eq((Option<String[]>)new Some((Object)new String[]{"wend", "num"}));
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink);
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "window_end"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.startsWith("(false,"))), (String)"Received retraction messages for append only table");
        List retracted = (List)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1970-01-01 00:00:00.005,1", "2,1970-01-01 00:00:00.005,2", "3,1970-01-01 00:00:00.005,1", "3,1970-01-01 00:00:00.010,2", "4,1970-01-01 00:00:00.010,3", "4,1970-01-01 00:00:00.015,1", "5,1970-01-01 00:00:00.015,4", "5,1970-01-01 00:00:00.020,1", "6,1970-01-01 00:00:00.020,4", "6,1970-01-01 00:00:00.025,2"})).sorted((Ordering)Ordering.String$.MODULE$);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithFullKey2() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$28 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$11[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$11(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$28 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithFullKey2$1(x$10)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0, 1, 2}, TimeZone.getDefault());
        sink.expectedKeys_$eq((Option<String[]>)new Some((Object)new String[]{"wend", "num"}));
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"wstart", "wend", "num", "icnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).start()).as((Symbol)SymbolLiteral.bootstrap("apply", "wstart"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "wend"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "icnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.startsWith("(false,"))), (String)"Received retraction messages for append only table");
        List retracted = (List)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.000,1970-01-01 00:00:00.005,1,1", "1970-01-01 00:00:00.000,1970-01-01 00:00:00.005,2,2", "1970-01-01 00:00:00.000,1970-01-01 00:00:00.005,3,1", "1970-01-01 00:00:00.005,1970-01-01 00:00:00.010,3,2", "1970-01-01 00:00:00.005,1970-01-01 00:00:00.010,4,3", "1970-01-01 00:00:00.010,1970-01-01 00:00:00.015,4,1", "1970-01-01 00:00:00.010,1970-01-01 00:00:00.015,5,4", "1970-01-01 00:00:00.015,1970-01-01 00:00:00.020,5,1", "1970-01-01 00:00:00.015,1970-01-01 00:00:00.020,6,4", "1970-01-01 00:00:00.020,1970-01-01 00:00:00.025,6,2"})).sorted((Ordering)Ordering.String$.MODULE$);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithoutFullKey1() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$29 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$12[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$12(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$29 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithoutFullKey1$1(x$12)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0}, TimeZone.getDefault());
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"wend", "cnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end()).as((Symbol)SymbolLiteral.bootstrap("apply", "wend"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "cnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.startsWith("(false,"))), (String)"Received retraction messages for append only table");
        List retracted = (List)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(true,1970-01-01 00:00:00.005,1)", "(true,1970-01-01 00:00:00.005,2)", "(true,1970-01-01 00:00:00.005,1)", "(true,1970-01-01 00:00:00.010,2)", "(true,1970-01-01 00:00:00.010,3)", "(true,1970-01-01 00:00:00.015,1)", "(true,1970-01-01 00:00:00.015,4)", "(true,1970-01-01 00:00:00.020,1)", "(true,1970-01-01 00:00:00.020,4)", "(true,1970-01-01 00:00:00.025,2)"})).sorted((Ordering)Ordering.String$.MODULE$);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithoutFullKey2() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$30 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$13[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$13(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$30 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkOnAppendingTableWithoutFullKey2$1(x$14)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0}, TimeZone.getDefault());
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"num", "cnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "cnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sink.getRawResults().exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.startsWith("(false,"))), (String)"Received retraction messages for append only table");
        List retracted = (List)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(true,1,1)", "(true,2,2)", "(true,3,1)", "(true,3,2)", "(true,4,3)", "(true,4,1)", "(true,5,4)", "(true,5,1)", "(true,6,4)", "(true,6,2)"})).sorted((Ordering)Ordering.String$.MODULE$);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkWithFilter() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(4);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$31 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$14[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$14(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$31 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testUpsertSinkWithFilter$1(x$16)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text"))}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0});
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"num", "cnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.LONG()}))));
        Table table = t.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).count()).as((Symbol)SymbolLiteral.bootstrap("apply", "cnt"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "cnt")).$less$eq(package$.MODULE$.int2Literal(3)));
        table.executeInsert("upsertSink").await();
        .colon.colon expectedWithFilter = new .colon.colon((Object)"1,1", (List)new .colon.colon((Object)"2,2", (List)new .colon.colon((Object)"3,3", (List)Nil$.MODULE$)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedWithFilter.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testToDataStreamMultiRowtime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$32 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$15[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$15(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$32 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testToDataStreamMultiRowtime$1(x$17)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        Table r = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).milli())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime(), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime()).as((Symbol)SymbolLiteral.bootstrap("apply", "rowtime2"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(r).toDataStream());
    }

    @Test
    public void testToRetractStreamMultiRowtime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$33 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$16[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$16(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$33 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)LegacyTableSinkITCase.$anonfun$testToRetractStreamMultiRowtime$1(x$18)))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "text")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        Table r = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).milli())).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "num")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime(), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).rowtime()).as((Symbol)SymbolLiteral.bootstrap("apply", "rowtime2"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(r).toRetractStream(TypeExtractor.createTypeInfo(Row.class)));
    }

    @Test
    public void testDecimalAppendStreamTableSink() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        TableSchema schema = TableSchema.builder().field("c", DataTypes.VARCHAR((int)5)).field("b", DataTypes.DECIMAL((int)10, (int)0)).field("d", DataTypes.CHAR((int)5)).build();
        MemoryTableSourceSinkUtil$.MODULE$.createDataTypeAppendStreamTable((TableEnvironment)tEnv, schema, "testSink");
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$34 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$17[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$17(org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$$anon$34 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("testSink").await();
        java.util.List results = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(MemoryTableSourceSinkUtil$.MODULE$.tableDataStrings()).asJava();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"12345,55,12345"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)results, (String)expected);
    }

    public static final /* synthetic */ long $anonfun$testStreamTableSink$1(Tuple3 x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1._2());
    }

    public static final /* synthetic */ long $anonfun$testAppendSinkOnAppendTable$1(Tuple3 x$2) {
        return BoxesRunTime.unboxToInt((Object)x$2._1());
    }

    public static final /* synthetic */ long $anonfun$testRetractSinkOnUpdatingTable$1(Tuple3 x$3) {
        return BoxesRunTime.unboxToInt((Object)x$3._1());
    }

    public static final /* synthetic */ long $anonfun$testRetractSinkOnAppendTable$1(Tuple3 x$4) {
        return BoxesRunTime.unboxToInt((Object)x$4._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnUpdatingTableWithFullKey$1(Tuple3 x$6) {
        return BoxesRunTime.unboxToInt((Object)x$6._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithFullKey1$1(Tuple3 x$8) {
        return BoxesRunTime.unboxToInt((Object)x$8._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithFullKey2$1(Tuple3 x$10) {
        return BoxesRunTime.unboxToInt((Object)x$10._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithoutFullKey1$1(Tuple3 x$12) {
        return BoxesRunTime.unboxToInt((Object)x$12._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkOnAppendingTableWithoutFullKey2$1(Tuple3 x$14) {
        return BoxesRunTime.unboxToInt((Object)x$14._1());
    }

    public static final /* synthetic */ long $anonfun$testUpsertSinkWithFilter$1(Tuple3 x$16) {
        return BoxesRunTime.unboxToInt((Object)x$16._1());
    }

    public static final /* synthetic */ long $anonfun$testToDataStreamMultiRowtime$1(Tuple3 x$17) {
        return BoxesRunTime.unboxToInt((Object)x$17._1());
    }

    public static final /* synthetic */ long $anonfun$testToRetractStreamMultiRowtime$1(Tuple3 x$18) {
        return BoxesRunTime.unboxToInt((Object)x$18._1());
    }
}

