/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInfoFactory;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.GroupedTable;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableAggFunctions;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.utils.TableAggSum;
import org.apache.flink.table.planner.utils.Top3;
import org.apache.flink.table.planner.utils.Top3Accum;
import org.apache.flink.table.planner.utils.Top3WithMapView;
import org.apache.flink.table.planner.utils.Top3WithMapViewAccum;
import org.apache.flink.table.planner.utils.Top3WithRetractInput;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001I\u0011A\u0003V1cY\u0016\fum\u001a:fO\u0006$X-\u0013+DCN,'BA\u0002\u0005\u0003\u0015!\u0018M\u00197f\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0002\f\u0015\taQ\"A\u0003gY&t7N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005a)\"AG*ue\u0016\fW.\u001b8h/&$\bn\u0015;bi\u0016$Vm\u001d;CCN,\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\t5|G-\u001a\t\u00039Ar!!\b\u0018\u000f\u0005yicBA\u0010-\u001d\t\u00013F\u0004\u0002\"U9\u0011!%\u000b\b\u0003G!r!\u0001J\u0014\u000e\u0003\u0015R!AJ\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012B\u0001\b\u0010\u0013\taQ\"\u0003\u0002\u0004\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!A\u0006\u0004\n\u0005=*\u0012AG*ue\u0016\fW.\u001b8h/&$\bn\u0015;bi\u0016$Vm\u001d;CCN,\u0017BA\u00193\u0005A\u0019F/\u0019;f\u0005\u0006\u001c7.\u001a8e\u001b>$WM\u0003\u00020+!)A\u0007\u0001C\u0001k\u00051A(\u001b8jiz\"\"A\u000e\u001d\u0011\u0005]\u0002Q\"\u0001\u0002\t\u000bi\u0019\u0004\u0019A\u000e\t\u000bi\u0002A\u0011I\u001e\u0002\r\t,gm\u001c:f)\u0005a\u0004CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$\u0001B+oSRD#!O\"\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015aA1qS*\u0011\u0001*S\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQu\"A\u0003kk:LG/\u0003\u0002M\u000b\nQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000b9\u0003A\u0011A\u001e\u0002SQ,7\u000f\u001e$mCR\fum\u001a:fO\u0006$XmV5uQ>,H/\u00138de\u0016lWM\u001c;bYV\u0003H-\u0019;fQ\ti\u0005\u000b\u0005\u0002E#&\u0011!+\u0012\u0002\r)\u0016\u001cH\u000fV3na2\fG/\u001a\u0005\u0006)\u0002!\taO\u0001'i\u0016\u001cHO\u00127bi\u0006;wM]3hCR,w+\u001b;i\u0013:\u001c'/Z7f]R\fG.\u00169eCR,\u0007FA*Q\u0011\u00159\u0006\u0001\"\u0001Y\u0003%\u0019\u0007.Z2l%\u0006t7\u000eF\u0002=3\u000eDQA\u0017,A\u0002m\u000bAAZ;oGB\u0011A\f\u0019\b\u0003;z\u0003\"\u0001\n \n\u0005}s\u0014A\u0002)sK\u0012,g-\u0003\u0002bE\n11\u000b\u001e:j]\u001eT!a\u0018 \t\u000b\u00114\u0006\u0019A3\u0002\u001d\u0015D\b/Z2uK\u0012\u0014Vm];miB\u0019am[.\u000f\u0005\u001dLgB\u0001\u0013i\u0013\u0005y\u0014B\u00016?\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\t1K7\u000f\u001e\u0006\u0003UzBQa\u001c\u0001\u0005\u0002m\n\u0001\u0004^3ti\u001e\u0013x.\u001e9Cs\u001ac\u0017\r^!hOJ,w-\u0019;fQ\tq\u0007\u000bC\u0003s\u0001\u0011\u00051(A\ruKN$hj\u001c8lKf,GM\u00127bi\u0006;wM]3hCR,\u0007FA9Q\u0011\u0015)\b\u0001\"\u0001<\u0003\u0001\"Xm\u001d;BO\u001e\u0014XmZ1uK\u00063G/\u001a:UC\ndW-Q4he\u0016<\u0017\r^3)\u0005Q\u0004\u0006\"\u0002=\u0001\t\u0003Y\u0014a\t;fgR<%o\\;q\u0005f4E.\u0019;BO\u001e\u0014XmZ1uK^KG\u000f['baZKWm\u001e\u0015\u0003oBCQa\u001f\u0001\u0005\u0002m\nq\u0003^3ti&s\u0007/\u001e;XSRD'+\u001a;sC\u000e$\u0018n\u001c8)\u0005i\u0004\u0006\"\u0002@\u0001\t\u0003Y\u0014a\u0007;fgRLe\u000e^3s]\u0006d\u0017iY2v[Vd\u0017\r^8s)f\u0004X\r\u000b\u0002~!\"1\u00111\u0001\u0001\u0005\u0002m\n1\u0006^3tiR\u000b'\r\\3BO\u001e4UO\\2uS>tw+\u001b;i_V$(+\u001a;sC\u000e$\u0018n\u001c8NKRDw\u000e\u001a\u0015\u0004\u0003\u0003\u0001\u0006BBA\u0005\u0001\u0011\u00051(A\ruKN$xJ^3sY>\fG-\u001a3BG\u000e,X.\u001e7bi>\u0014\bfAA\u0004!\":\u0001!a\u0004\u0002\u001c\u0005u\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005UQ)A\u0005fqR,gn]5p]&!\u0011\u0011DA\n\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003?\u0019#!!\t\u0011\t\u0005\r\u00121G\u0007\u0003\u0003KQA!a\n\u0002*\u0005i\u0001/\u0019:b[\u0016$XM]5{K\u0012TA!a\u000b\u0002.\u0005QQ\r\u001f;f]NLwN\\:\u000b\u0007)\u000byCC\u0002\u00022-\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\t\u0005U\u0012Q\u0005\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\u001c")
public class TableAggregateITCase
extends StreamingWithStateTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofHours(1L));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(337).append("\n                       |CREATE TABLE myTable (\n                       |  `id` INT,\n                       |  `name` STRING,\n                       |  `price` INT\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(TestValuesTableFactory.registerData(TestData$.MODULE$.tupleData4())).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testFlatAggregateWithoutIncrementalUpdate() {
        this.tEnv().createTemporarySystemFunction("top2", (UserDefinedFunction)new JavaUserDefinedTableAggFunctions.Top2());
        this.checkRank("top2", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(true,6,1)", "(false,6,1)", "(true,6,1)", "(true,3,2)", "(false,6,1)", "(false,3,2)", "(true,6,1)", "(true,5,2)", "(false,6,1)", "(false,5,2)", "(true,8,1)", "(true,6,2)", "(false,8,1)", "(false,6,2)", "(true,8,1)", "(true,6,2)"})));
    }

    @TestTemplate
    public void testFlatAggregateWithIncrementalUpdate() {
        this.tEnv().createTemporarySystemFunction("incrementalTop2", (UserDefinedFunction)new JavaUserDefinedTableAggFunctions.IncrementalTop2());
        this.checkRank("incrementalTop2", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(true,6,1)", "(true,3,2)", "(false,3,2)", "(true,5,2)", "(false,6,1)", "(true,8,1)", "(false,5,2)", "(true,6,2)"})));
    }

    public void checkRank(String func, List<String> expectedResult) {
        Table resultTable = this.tEnv().from("myTable").flatAggregate((Expression)package$.MODULE$.WithOperations(package$.MODULE$.call(func, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.$("price")}))).as("top_price", new String[]{"rank"})).select(new Expression[]{package$.MODULE$.$("top_price"), package$.MODULE$.$("rank")});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Assertions.assertThat(sink.getRawResults()).isEqualTo(expectedResult);
    }

    @TestTemplate
    public void testGroupByFlatAggregate() {
        GenericTypeInfo genericTypeInfo;
        Class<Top3Accum> clazz;
        Top3 top3 = new Top3();
        GroupedTable groupedTable = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$9 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz2 = Tuple2.class;
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(clazz2, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        .colon.colon fields2 = new .colon.colon((Object)new scala.Tuple2((Object)"smallest", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"size", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"data", (Object)TypeExtractor.createTypeInfo(java.util.Map.class)), (List)Nil$.MODULE$)));
        scala.collection.mutable.Map clazzFields = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = Top3Accum.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$1.elem = true;
                }
                return (scala.collection.mutable.Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields2.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                scala.Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                TypeInformation fTpe = (TypeInformation)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        Table resultTable = groupedTable.flatAggregate(package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)top3, (TypeInformation)tupleTypeInfo, (TypeInformation)genericTypeInfo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))}).as("category", new String[]{"v1", "v2"});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,1", "2,2,2", "2,3,3", "3,4,4", "3,5,5", "3,6,6", "4,10,10", "4,9,9", "4,8,8", "5,15,15", "5,14,14", "5,13,13", "6,21,21", "6,20,20", "6,19,19"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testNonkeyedFlatAggregate() {
        GenericTypeInfo genericTypeInfo;
        Class<Top3Accum> clazz;
        Top3 top3 = new Top3();
        Table source = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz2 = Tuple2.class;
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(clazz2, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        .colon.colon fields2 = new .colon.colon((Object)new scala.Tuple2((Object)"smallest", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"size", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"data", (Object)TypeExtractor.createTypeInfo(java.util.Map.class)), (List)Nil$.MODULE$)));
        scala.collection.mutable.Map clazzFields = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = Top3Accum.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$2.elem = true;
                }
                return (scala.collection.mutable.Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields2.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                scala.Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                TypeInformation fTpe = (TypeInformation)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        Table resultTable = source.flatAggregate(package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)top3, (TypeInformation)tupleTypeInfo, (TypeInformation)genericTypeInfo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))}).as("v1", new String[]{"v2"});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)new .colon.colon((Object)"19,19", (List)new .colon.colon((Object)"20,20", (List)new .colon.colon((Object)"21,21", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAggregateAfterTableAggregate() {
        GenericTypeInfo genericTypeInfo;
        Class<Top3Accum> clazz;
        Top3 top3 = new Top3();
        GroupedTable groupedTable = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$11 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz2 = Tuple2.class;
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(clazz2, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        .colon.colon fields2 = new .colon.colon((Object)new scala.Tuple2((Object)"smallest", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"size", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"data", (Object)TypeExtractor.createTypeInfo(java.util.Map.class)), (List)Nil$.MODULE$)));
        scala.collection.mutable.Map clazzFields = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = Top3Accum.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$3.elem = true;
                }
                return (scala.collection.mutable.Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields2.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                scala.Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                TypeInformation fTpe = (TypeInformation)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        Table resultTable = groupedTable.flatAggregate(package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)top3, (TypeInformation)tupleTypeInfo, (TypeInformation)genericTypeInfo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))}).as("category", new String[]{"v1", "v2"}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "category"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "category")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v1")).max()});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)new .colon.colon((Object)"1,1", (List)new .colon.colon((Object)"2,3", (List)new .colon.colon((Object)"3,6", (List)new .colon.colon((Object)"4,10", (List)new .colon.colon((Object)"5,15", (List)new .colon.colon((Object)"6,21", (List)Nil$.MODULE$)))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testGroupByFlatAggregateWithMapView() {
        GenericTypeInfo genericTypeInfo;
        Class<Top3WithMapViewAccum> clazz;
        Top3WithMapView top3 = new Top3WithMapView();
        GroupedTable groupedTable = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$12 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz2 = Tuple2.class;
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(clazz2, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        TypeInfoFactory factory = TypeExtractor.getTypeInfoFactory(MapView.class);
        scala.collection.immutable.Map genericParameters = ((TraversableOnce)((List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])MapView.class.getTypeParameters()), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            scala.Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BasicTypeInfo typeInfo = (BasicTypeInfo)tuple2._1();
            TypeVariable typeParam = (TypeVariable)tuple2._2();
            scala.Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)typeParam.getName()), (Object)typeInfo);
            return tuple22;
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        .colon.colon fields2 = new .colon.colon((Object)new scala.Tuple2((Object)"smallest", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"size", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"data", (Object)factory.createTypeInfo(MapView.class, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)genericParameters).asJava())), (List)Nil$.MODULE$)));
        scala.collection.mutable.Map clazzFields = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = Top3WithMapViewAccum.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$4.elem = true;
                }
                return (scala.collection.mutable.Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields2.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                scala.Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                TypeInformation fTpe = (TypeInformation)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        Table resultTable = groupedTable.flatAggregate(package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)top3, (TypeInformation)tupleTypeInfo, (TypeInformation)genericTypeInfo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))}).as("category", new String[]{"v1", "v2"});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,1", "2,2,2", "2,3,3", "3,4,4", "3,5,5", "3,6,6", "4,10,10", "4,9,9", "4,8,8", "5,15,15", "5,14,14", "5,13,13", "6,21,21", "6,20,20", "6,19,19"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testInputWithRetraction() {
        Top3WithRetractInput top3 = new Top3WithRetractInput();
        Table source = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$13 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table resultTable = source.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).flatAggregate(package$.MODULE$.WithOperations(package$.MODULE$.call((UserDefinedFunction)top3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "v1"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "v2")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v2"))});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)new .colon.colon((Object)"111,111", (List)new .colon.colon((Object)"65,65", (List)new .colon.colon((Object)"34,34", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testInternalAccumulatorType() {
        Table source = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$14 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table resultTable = source.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).flatAggregate(package$.MODULE$.WithOperations(package$.MODULE$.call(TableAggSum.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "sum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "sum"))});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"6,111", "6,111", "5,65", "5,65", "4,34", "4,34", "3,15", "3,15", "2,5", "2,5", "1,1", "1,1"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testTableAggFunctionWithoutRetractionMethod() {
        Top3 top3 = new Top3();
        Table source = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$15 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> {
            GenericTypeInfo genericTypeInfo;
            Class<Top3Accum> clazz;
            Table table = source.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
            .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$));
            Class<Tuple2> clazz2 = Tuple2.class;
            TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(clazz2, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
            .colon.colon fields2 = new .colon.colon((Object)new scala.Tuple2((Object)"smallest", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"size", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"data", (Object)TypeExtractor.createTypeInfo(java.util.Map.class)), (List)Nil$.MODULE$)));
            scala.collection.mutable.Map clazzFields = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            BooleanRef error = BooleanRef.create((boolean)false);
            for (Class traversalClazz = clazz = Top3Accum.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                    block0: {
                        if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                        Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                        error$5.elem = true;
                    }
                    return (scala.collection.mutable.Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
                });
            }
            if (error.elem) {
                genericTypeInfo = new GenericTypeInfo(clazz);
            } else {
                List pojoFields = (List)fields2.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    scala.Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String fName = (String)tuple2._1();
                    TypeInformation fTpe = (TypeInformation)tuple2._2();
                    Field field = (Field)clazzFields.apply((Object)fName);
                    Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), fTpe)));
                    return iterable;
                }, List$.MODULE$.canBuildFrom());
                genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
            }
            org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(table.flatAggregate(package$.MODULE$.WithOperations(package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)top3, (TypeInformation)tupleTypeInfo, (TypeInformation)genericTypeInfo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "v1"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "v2")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v2"))})).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
            this.env().execute();
        }).hasMessage(new StringBuilder(120).append("Could not find an implementation method 'retract' in class '").append(Top3.class.getName()).append("' ").append("for function 'Top3' that matches the following signature:\n").append(new StringBuilder(33).append("void retract(").append(Top3Accum.class.getName()).append(", java.lang.Integer)").toString()).toString()) instanceof ValidationException;
    }

    @TestTemplate
    public void testOverloadedAccumulator() {
        Table source = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$16 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        TestingRetractSink sink1 = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(source.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).flatAggregate(package$.MODULE$.WithOperations(package$.MODULE$.call(JavaUserDefinedAggFunctions.OverloadedDoubleMaxFunction.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "max"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "max"))})).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink1).setParallelism(1);
        TestingRetractSink sink2 = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(source.select(new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast(DataTypes.STRING())).$plus(package$.MODULE$.string2Literal("str"))).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).flatAggregate(package$.MODULE$.WithOperations(package$.MODULE$.call(JavaUserDefinedAggFunctions.OverloadedDoubleMaxFunction.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "max"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "max"))})).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink2).setParallelism(1);
        this.env().execute();
        List expected1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1", "1,1", "2,3", "2,3", "3,6", "3,6", "4,10", "4,10", "5,15", "5,15", "6,21", "6,21"}));
        Assertions.assertThat((Object)sink1.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected1.sorted((Ordering)Ordering.String$.MODULE$));
        List expected2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1str", "1,1str", "2,3str", "2,3str", "3,6str", "3,6str", "4,9str", "4,9str", "5,15str", "5,15str", "6,21str", "6,21str"}));
        Assertions.assertThat((Object)sink2.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected2.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public TableAggregateITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

