/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.table.StringWithTimestampRetractSink;
import org.apache.flink.table.planner.runtime.stream.table.StringWithTimestampSink;
import org.apache.flink.table.planner.runtime.stream.table.TableToDataStreamITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0003%\t9B+\u00192mKR{G)\u0019;b'R\u0014X-Y7J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\tQ\u0001^1cY\u0016T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0007-Q!\u0001D\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\r\u0005)Q\u000f^5mg&\u0011\u0001$\u0006\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0007\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\ti\u0002!D\u0001\u0003\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0015\"Xm\u001d;ICN\u0014vn\u001e;j[\u00164%o\\7UC\ndW\rV8BaB,g\u000eZ*ue\u0016\fW\u000eF\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0011)f.\u001b;)\u0005yA\u0003CA\u00151\u001b\u0005Q#BA\u0016-\u0003\r\t\u0007/\u001b\u0006\u0003[9\nqA[;qSR,'O\u0003\u00020\u001f\u0005)!.\u001e8ji&\u0011\u0011G\u000b\u0002\u0005)\u0016\u001cH\u000fC\u00034\u0001\u0011\u0005\u0001%\u0001\u0014uKN$\b*Y:S_^$\u0018.\\3Ge>lG+\u00192mKR{'+\u001a;sC\u000e$8\u000b\u001e:fC6D#A\r\u0015\t\u000bY\u0002A\u0011\u0001\u0011\u0002cQ,7\u000f\u001e%bgJ{w\u000f^5nK\u001a\u0013x.\u001c#bi\u0006\u001cFO]3b[R{G+\u00192mK\n\u000b7m\u001b#bi\u0006\u001cFO]3b[\"\u0012Q\u0007\u000b\u0005\u0006s\u0001!\t\u0001I\u0001(i\u0016\u001cH\u000fS1t%><H/[7f\rJ|W\u000eV1cY\u0016$v.\u0012=uKJt\u0017\r\\*zgR,W\u000e\u000b\u00029Q!)A\b\u0001C\u0001A\u0005)C/Z:u\rJ|W\u000eV1cY\u0016$v\u000eR1uCN#(/Z1n/&$\b\u000e\u0015:pGRLW.\u001a\u0015\u0003w!BQa\u0010\u0001\u0005\u0002\u0001\na\u0007^3ti\"\u000b7O\u0012:p[\u0012\u000bG/Y*ue\u0016\fW\u000eV8UC\ndWMQ1dW\u0012\u000bG/Y*ue\u0016\fWnV5uQB\u0013xn\u0019;j[\u0016D#A\u0010\u0015\t\u000b\t\u0003A\u0011B\"\u0002\u001b1|7-\u00197ECR,G+[7f)\t!E\n\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!A/[7f\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\u001b1{7-\u00197ECR,G+[7f\u0011\u0015i\u0015\t1\u0001O\u0003-)\u0007o\\2i'\u0016\u001cwN\u001c3\u0011\u0005\tz\u0015B\u0001)$\u0005\u0011auN\\4")
public final class TableToDataStreamITCase
extends StreamingTestBase {
    @Test
    public void testHasRowtimeFromTableToAppendStream() {
        .colon.colon data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(1L), "A"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(2L), "B"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(3L), "C"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(4L), "D"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(7L), "E"})), (List)Nil$.MODULE$)))));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(242).append("\n         |CREATE TABLE src (\n         |  ts TIMESTAMP(3),\n         |  a STRING,\n         |  WATERMARK FOR ts AS ts - INTERVAL '0.005' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("'\n         |)\n      ").toString())).stripMargin();
        this.tEnv().executeSql(sourceDDL);
        DataStream dataStream = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT a, ts FROM src")).toDataStream();
        .colon.colon expected = new .colon.colon((Object)"+I[A, 1970-01-01T00:00:01], 1000", (List)new .colon.colon((Object)"+I[B, 1970-01-01T00:00:02], 2000", (List)new .colon.colon((Object)"+I[C, 1970-01-01T00:00:03], 3000", (List)new .colon.colon((Object)"+I[D, 1970-01-01T00:00:04], 4000", (List)new .colon.colon((Object)"+I[E, 1970-01-01T00:00:07], 7000", (List)Nil$.MODULE$)))));
        StringWithTimestampSink sink = new StringWithTimestampSink();
        dataStream.addSink(sink);
        this.env().execute("TableToAppendStream");
        Assertions.assertThat((Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @Test
    public void testHasRowtimeFromTableToRetractStream() {
        .colon.colon data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(1L), "A"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(2L), "A"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(3L), "C"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(4L), "D"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(7L), "E"})), (List)Nil$.MODULE$)))));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(242).append("\n         |CREATE TABLE src (\n         |  ts TIMESTAMP(3),\n         |  a STRING,\n         |  WATERMARK FOR ts AS ts - INTERVAL '0.005' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("'\n         |)\n      ").toString())).stripMargin();
        this.tEnv().executeSql(sourceDDL);
        DataStream dataStream = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT a, ts\n          |FROM (\n          |  SELECT *,\n          |    ROW_NUMBER() OVER (PARTITION BY a ORDER BY ts DESC) as rowNum\n          |  FROM src\n          |)\n          |WHERE rowNum = 1\n      ")).stripMargin())).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        StringWithTimestampRetractSink sink = new StringWithTimestampRetractSink();
        dataStream.addSink(sink);
        this.env().execute("TableToRetractStream");
        .colon.colon expected = new .colon.colon((Object)"A,1970-01-01T00:00:02,2000", (List)new .colon.colon((Object)"C,1970-01-01T00:00:03,3000", (List)new .colon.colon((Object)"D,1970-01-01T00:00:04,4000", (List)new .colon.colon((Object)"E,1970-01-01T00:00:07,7000", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
        .colon.colon expectedRetract = new .colon.colon((Object)"(true,A,1970-01-01T00:00:01,1000)", (List)new .colon.colon((Object)"(false,A,1970-01-01T00:00:01,1000)", (List)new .colon.colon((Object)"(true,A,1970-01-01T00:00:02,2000)", (List)new .colon.colon((Object)"(true,C,1970-01-01T00:00:03,3000)", (List)new .colon.colon((Object)"(true,D,1970-01-01T00:00:04,4000)", (List)new .colon.colon((Object)"(true,E,1970-01-01T00:00:07,7000)", (List)Nil$.MODULE$))))));
        Assertions.assertThat((Object)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedRetract.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testHasRowtimeFromDataStreamToTableBackDataStream() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"A"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"B"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"C"), new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)"D"), new Tuple2((Object)BoxesRunTime.boxToLong((long)7L), (Object)"E")}));
        DataStream ds1 = this.env().fromCollection(data, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.table.TableToDataStreamITCase$$anon$3 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)TableToDataStreamITCase.$anonfun$testHasRowtimeFromDataStreamToTableBackDataStream$1(x$1)));
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        this.tEnv().createTemporaryView("t1", table);
        DataStream ds2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n          | SELECT CONCAT(a, '_'), ts, rowtime\n          | FROM t1\n      ")).stripMargin())).toDataStream();
        .colon.colon expected = new .colon.colon((Object)"+I[A_, 1, 1970-01-01T00:00:01], 1000", (List)new .colon.colon((Object)"+I[B_, 2, 1970-01-01T00:00:02], 2000", (List)new .colon.colon((Object)"+I[C_, 3, 1970-01-01T00:00:03], 3000", (List)new .colon.colon((Object)"+I[D_, 4, 1970-01-01T00:00:04], 4000", (List)new .colon.colon((Object)"+I[E_, 7, 1970-01-01T00:00:07], 7000", (List)Nil$.MODULE$)))));
        StringWithTimestampSink sink = new StringWithTimestampSink();
        ds2.addSink(sink);
        this.env().execute("DataStreamToTableBackDataStream");
        Assertions.assertThat((Object)sink.getResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @Test
    public void testHasRowtimeFromTableToExternalSystem() {
        .colon.colon data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.001", this.localDateTime(1L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.002", this.localDateTime(2L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.003", this.localDateTime(3L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.004", this.localDateTime(4L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)5.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.007", this.localDateTime(7L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.008", this.localDateTime(8L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1970-01-01 00:00:00.016", this.localDateTime(16L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)4.0)})), (List)Nil$.MODULE$)))))));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(288).append("\n         |CREATE TABLE src (\n         |  log_ts STRING,\n         |  ts TIMESTAMP(3),\n         |  a INT,\n         |  b DOUBLE,\n         |  WATERMARK FOR ts AS ts - INTERVAL '0.001' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("'\n         |)\n      ").toString())).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(236).append("\n         |CREATE TABLE sink (\n         |  log_ts STRING,\n         |  ts TIMESTAMP(3),\n         |  a INT,\n         |  b DOUBLE\n         |) WITH (\n         |  'connector' = 'values',\n         |  'table-sink-class' = '").append(TestValuesTableFactory.TestSinkContextTableSink.class.getName()).append("'\n         |)\n      ").toString())).stripMargin();
        this.tEnv().executeSql(sourceDDL);
        this.tEnv().executeSql(sinkDDL);
        this.tEnv().executeSql("INSERT INTO sink SELECT * FROM src").await();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1000, 2000, 3000, 4000, 7000, 8000, 16000}));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.TestSinkContextTableSink.ROWTIMES).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).isEqualTo(expected.sorted((Ordering)Ordering.Int$.MODULE$));
        String sinkDDL2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n         |CREATE TABLE sink2 (\n         |  window_rowtime TIMESTAMP(3),\n         |  b DOUBLE\n         |) WITH (\n         |  'connector' = 'values',\n         |  'table-sink-class' = '").append(TestValuesTableFactory.TestSinkContextTableSink.class.getName()).append("'\n         |)\n      ").toString())).stripMargin();
        this.tEnv().executeSql(sinkDDL2);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n          |INSERT INTO sink2\n          |SELECT\n          |  TUMBLE_ROWTIME(ts, INTERVAL '5' SECOND),\n          |  SUM(b)\n          |FROM src\n          |GROUP BY TUMBLE(ts, INTERVAL '5' SECOND)\n          |")).stripMargin()).await();
        List expected2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4999, 9999, 19999}));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.TestSinkContextTableSink.ROWTIMES).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).isEqualTo(expected2.sorted((Ordering)Ordering.Int$.MODULE$));
    }

    @Test
    public void testFromTableToDataStreamWithProctime() {
        .colon.colon data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localDateTime(1L), "A"})), (List)Nil$.MODULE$);
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n         |CREATE TABLE src (\n         |  ts TIMESTAMP(3),\n         |  a STRING,\n         |  proctime as PROCTIME()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("'\n         |)\n      ").toString())).stripMargin();
        this.tEnv().executeSql(sourceDDL);
        DataStream dataStream = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT a, ts, proctime FROM src")).toDataStream();
        String expected = "ROW<`a` STRING, `ts` TIMESTAMP(3), `proctime` TIMESTAMP_LTZ(3) NOT NULL> NOT NULL(org.apache.flink.types.Row, org.apache.flink.table.runtime.typeutils.ExternalSerializer)";
        Assertions.assertThat((String)dataStream.dataType().toString()).isEqualTo(expected);
    }

    @Test
    public void testHasFromDataStreamToTableBackDataStreamWithProctime() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"A")}));
        DataStream ds1 = this.env().fromCollection(data, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.table.TableToDataStreamITCase$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)TableToDataStreamITCase.$anonfun$testHasFromDataStreamToTableBackDataStreamWithProctime$1(x$2)));
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds1).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        this.tEnv().createTemporaryView("t1", table);
        DataStream ds2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n          | SELECT CONCAT(a, '_'), ts, proctime\n          | FROM t1\n      ")).stripMargin())).toDataStream();
        String expected = "ROW<`EXPR$0` STRING, `ts` BIGINT, `proctime` TIMESTAMP_LTZ(3)> NOT NULL(org.apache.flink.types.Row, org.apache.flink.table.runtime.typeutils.ExternalSerializer)";
        Assertions.assertThat((String)ds2.dataType().toString()).isEqualTo(expected);
    }

    private LocalDateTime localDateTime(long epochSecond) {
        return LocalDateTime.ofEpochSecond(epochSecond, 0, ZoneOffset.UTC);
    }

    public static final /* synthetic */ long $anonfun$testHasRowtimeFromDataStreamToTableBackDataStream$1(Tuple2 x$1) {
        return x$1._1$mcJ$sp() * 1000L;
    }

    public static final /* synthetic */ long $anonfun$testHasFromDataStreamToTableBackDataStreamWithProctime$1(Tuple2 x$2) {
        return x$2._1$mcJ$sp() * 1000L;
    }
}

