/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.planner.runtime.stream.table.TimeAttributesITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001%\t!B+[7f\u0003R$(/\u001b2vi\u0016\u001c\u0018\nV\"bg\u0016T!a\u0001\u0003\u0002\u000bQ\f'\r\\3\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!aA\u0006\u000b\u00051i\u0011!\u00024mS:\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\u0011aCB\u0001\u0006kRLGn]\u0005\u00031U\u0011!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016D\u0001B\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0005[>$W\r\u0005\u0002\u001da9\u0011QD\f\b\u0003=5r!a\b\u0017\u000f\u0005\u0001ZcBA\u0011+\u001d\t\u0011\u0013F\u0004\u0002$Q9\u0011AeJ\u0007\u0002K)\u0011a%E\u0001\u0007yI|w\u000e\u001e \n\u0003AI!AD\b\n\u00051i\u0011BA\u0002\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011aCB\u0005\u0003_U\t!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016L!!\r\u001a\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'BA\u0018\u0016\u0011\u0015!\u0004\u0001\"\u00016\u0003\u0019a\u0014N\\5u}Q\u0011a\u0007\u000f\t\u0003o\u0001i\u0011A\u0001\u0005\u00065M\u0002\ra\u0007\u0005\u0006u\u0001!\taO\u0001=i\u0016\u001cH/T5tg&tw\rV5nK\u0006#HO]5ckR,\u0017J\u001c'fO\u0006\u001c\u0017pU8ve\u000e,G\u000b\u001b:poN\u001cuN\u001d:fGR,\u0005pY3qi&|g\u000eF\u0001=!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0011)f.\u001b;)\u0005e\u001a\u0005C\u0001#L\u001b\u0005)%B\u0001$H\u0003\r\t\u0007/\u001b\u0006\u0003\u0011&\u000bqA[;qSR,'O\u0003\u0002K\u001f\u0005)!.\u001e8ji&\u0011A*\u0012\u0002\r)\u0016\u001cH\u000fV3na2\fG/\u001a\u0005\u0006\u001d\u0002!\taO\u0001-i\u0016\u001cH\u000fV5nKN$\u0018-\u001c9BiR\u0014\u0018NY;uKN<\u0016\u000e\u001e5XCR,'/\\1sWN#(/\u0019;fOfD#!T\")\t\u0001\tv\u000b\u0017\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u0016\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005Y\u001b&AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\n\u0011lI\u0001[!\tY6-D\u0001]\u0015\tif,A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0003?\u0002\f!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\tQ\u0015M\u0003\u0002c\u0017\u0005IA/Z:ukRLGn]\u0005\u0003Ir\u0013!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:\u0004")
public class TimeAttributesITCase
extends StreamingWithStateTestBase {
    @TestTemplate
    public void testMissingTimeAttributeInLegacySourceThrowsCorrectException() {
        DataStream stream = this.env().addSource((SourceFunction)new SourceFunction<Tuple2<Object, String>>(null){

            public void run(SourceFunction.SourceContext<Tuple2<Object, String>> ctx) {
                ctx.collect((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)"hello"));
                ctx.collect((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)"world"));
            }

            public void cancel() {
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.table.TimeAttributesITCase$$anon$3 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.tEnv().createTemporaryView("test", stream, Schema.newBuilder().columnByMetadata("event_time", (AbstractDataType)DataTypes.TIMESTAMP((int)3), "rowtime", true).build());
        Table result = this.tEnv().sqlQuery("SELECT * FROM test");
        TestingAppendSink sink = new TestingAppendSink();
        this.tEnv().toDataStream(result).addSink((SinkFunction)sink);
        Assertions.assertThatThrownBy(() -> this.env().execute()).hasMessageNotContaining("Rowtime timestamp is not defined. Please make sure that a proper TimestampAssigner is defined and the stream environment uses the EventTime time characteristic.");
    }

    @TestTemplate
    public void testTimestampAttributesWithWatermarkStrategy() {
        .colon.colon data = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)Instant.now().toEpochMilli())), (Object)"hello"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)Instant.now().toEpochMilli())), (Object)"world"), (List)Nil$.MODULE$));
        DataStream stream = this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.table.TimeAttributesITCase$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(WatermarkStrategy.forBoundedOutOfOrderness((Duration)Duration.ofMinutes(5L)).withTimestampAssigner((SerializableTimestampAssigner)new SerializableTimestampAssigner<Tuple2<Object, String>>(null){

            public long extractTimestamp(Tuple2<Object, String> element, long recordTimestamp) {
                return element._1$mcJ$sp();
            }
        }));
        this.tEnv().createTemporaryView("test", stream, Schema.newBuilder().columnByMetadata("event_time", (AbstractDataType)DataTypes.TIMESTAMP((int)3), "rowtime", true).build());
        Table result = this.tEnv().sqlQuery("SELECT * FROM test");
        TestingAppendSink sink = new TestingAppendSink();
        this.tEnv().toDataStream(result).addSink((SinkFunction)sink);
        this.env().execute();
        List formattedData = (List)data.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long timestamp = tuple2._1$mcJ$sp();
            String data = (String)tuple2._2();
            String formattedTimestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).toString();
            String string = new StringBuilder(2).append(timestamp).append(",").append(data).append(",").append(formattedTimestamp).toString();
            return string;
        }, List$.MODULE$.canBuildFrom());
        Assertions.assertThat((Object)formattedData.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public TimeAttributesITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

