/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.io.Serializable;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.BatchExecutionOptions;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.RangeInputFormat;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.table.planner.utils.TestingTableEnvironment$;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011eb\u0001B\u0001\u0003\u0001E\u0011QBQ1uG\"$Vm\u001d;CCN,'BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t)\")\u0019;dQ\u0006\u00137\u000f\u001e:bGR$Vm\u001d;CCN,\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\t\u0019\u0002\u0001C\u0004\u001c\u0001\u0001\u0007I\u0011\u0003\u000f\u0002\u0011M,G\u000f^5oON,\u0012!\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A!\t1!\u00199j\u0013\t\u0011sDA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7\u000fC\u0004%\u0001\u0001\u0007I\u0011C\u0013\u0002\u0019M,G\u000f^5oON|F%Z9\u0015\u0005\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRDq!L\u0012\u0002\u0002\u0003\u0007Q$A\u0002yIEBaa\f\u0001!B\u0013i\u0012!C:fiRLgnZ:!\u0011%\t\u0004\u00011AA\u0002\u0013E!'A\buKN$\u0018N\\4UC\ndW-\u00128w+\u0005\u0019\u0004C\u0001\u001b7\u001b\u0005)$BA\u0002\u0007\u0013\t9TGA\fUKN$\u0018N\\4UC\ndW-\u00128wSJ|g.\\3oi\"I\u0011\b\u0001a\u0001\u0002\u0004%\tBO\u0001\u0014i\u0016\u001cH/\u001b8h)\u0006\u0014G.Z#om~#S-\u001d\u000b\u0003MmBq!\f\u001d\u0002\u0002\u0003\u00071\u0007C\u0005>\u0001\u0001\u0007\t\u0011)Q\u0005g\u0005\u0001B/Z:uS:<G+\u00192mK\u0016sg\u000f\t\u0005\n\u007f\u0001\u0001\r\u00111A\u0005\u0012\u0001\u000bA\u0001^#omV\t\u0011\t\u0005\u0002\u001f\u0005&\u00111i\b\u0002\u0011)\u0006\u0014G.Z#om&\u0014xN\\7f]RD\u0011\"\u0012\u0001A\u0002\u0003\u0007I\u0011\u0003$\u0002\u0011Q,eN^0%KF$\"AJ$\t\u000f5\"\u0015\u0011!a\u0001\u0003\"I\u0011\n\u0001a\u0001\u0002\u0003\u0006K!Q\u0001\u0006i\u0016sg\u000f\t\u0005\n\u000f\u0001\u0001\r\u00111A\u0005\u0012-+\u0012\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\u001a\t!\u0002Z3mK\u001e\fG/[8o\u0013\t\tfJA\u0006QY\u0006tg.\u001a:CCN,\u0007\"C*\u0001\u0001\u0004\u0005\r\u0011\"\u0005U\u0003-\u0001H.\u00198oKJ|F%Z9\u0015\u0005\u0019*\u0006bB\u0017S\u0003\u0003\u0005\r\u0001\u0014\u0005\n/\u0002\u0001\r\u0011!Q!\n1\u000b\u0001\u0002\u001d7b]:,'\u000f\t\u0005\n3\u0002\u0001\r\u00111A\u0005\u0012i\u000b1!\u001a8w+\u0005Y\u0006C\u0001/c\u001b\u0005i&B\u00010`\u0003-)gN^5s_:lWM\u001c;\u000b\u0005\u0001\u0002'BA1\u000b\u0003%\u0019HO]3b[&tw-\u0003\u0002d;\nQ2\u000b\u001e:fC6,\u00050Z2vi&|g.\u00128wSJ|g.\\3oi\"IQ\r\u0001a\u0001\u0002\u0004%\tBZ\u0001\bK:4x\fJ3r)\t1s\rC\u0004.I\u0006\u0005\t\u0019A.\t\u0013%\u0004\u0001\u0019!A!B\u0013Y\u0016\u0001B3om\u0002B\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011\u00037\u0002\u0017Q\f'\r\\3D_:4\u0017nZ\u000b\u0002[B\u0011aD\\\u0005\u0003_~\u00111\u0002V1cY\u0016\u001cuN\u001c4jO\"I\u0011\u000f\u0001a\u0001\u0002\u0004%\tB]\u0001\u0010i\u0006\u0014G.Z\"p]\u001aLwm\u0018\u0013fcR\u0011ae\u001d\u0005\b[A\f\t\u00111\u0001n\u0011%)\b\u00011A\u0001B\u0003&Q.\u0001\u0007uC\ndWmQ8oM&<\u0007\u0005C\u0004x\u0001\t\u0007I\u0011\u0001=\u0002!1Ke*R0D\u001f2{\u0006+\u0011+U\u000bJsU#A=\u0011\u0007i\f\u0019!D\u0001|\u0015\taX0A\u0003sK\u001e,\u0007P\u0003\u0002\u007f\u007f\u0006!Q\u000f^5m\u0015\t\t\t!\u0001\u0003kCZ\f\u0017bAA\u0003w\n9\u0001+\u0019;uKJt\u0007bBA\u0005\u0001\u0001\u0006I!_\u0001\u0012\u0019&sUiX\"P\u0019~\u0003\u0016\t\u0016+F%:\u0003\u0003\u0002CA\u0007\u0001\t\u0007I\u0011\u0001=\u0002-1Ke*R0D\u001f2{FkV%D\u000b~\u0003\u0016\t\u0016+F%:Cq!!\u0005\u0001A\u0003%\u00110A\fM\u0013:+ulQ(M?R;\u0016jQ#`!\u0006#F+\u0012*OA!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0011\u0001C:fiV\u0004XI\u001c<\u0015\u0003\u0019BC!a\u0005\u0002\u001cA!\u0011QDA\u0015\u001b\t\tyBC\u0002!\u0003CQA!a\t\u0002&\u00059!.\u001e9ji\u0016\u0014(bAA\u0014\u001d\u0005)!.\u001e8ji&!\u00111FA\u0010\u0005)\u0011UMZ8sK\u0016\u000b7\r\u001b\u0015\u0007\u0003'\ty#!\u0014\u0011\u000b\u001d\n\t$!\u000e\n\u0007\u0005M\u0002F\u0001\u0004uQJ|wo\u001d\t\u0005\u0003o\t9E\u0004\u0003\u0002:\u0005\rc\u0002BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}\u0002#\u0001\u0004=e>|GOP\u0005\u0002S%\u0019\u0011Q\t\u0015\u0002\u000fA\f7m[1hK&!\u0011\u0011JA&\u0005%)\u0005pY3qi&|gNC\u0002\u0002F!\u001a#!!\u000e\t\u000f\u0005E\u0003\u0001\"\u0001\u0002\u0018\u00051!-\u001a4pe\u0016DC!a\u0014\u0002\u001c!2\u0011qJA\u0018\u0003\u001bBq!!\u0017\u0001\t\u0003\t9\"A\u0003bMR,'\u000f\u000b\u0003\u0002X\u0005u\u0003\u0003BA\u000f\u0003?JA!!\u0019\u0002 \tI\u0011I\u001a;fe\u0016\u000b7\r\u001b\u0005\b\u0003K\u0002A\u0011AA4\u00039)\u0007\u0010\u001d7bS:dunZ5dC2$B!!\u001b\u0002zA!\u00111NA:\u001d\u0011\ti'a\u001c\u0011\u0007\u0005m\u0002&C\u0002\u0002r!\na\u0001\u0015:fI\u00164\u0017\u0002BA;\u0003o\u0012aa\u0015;sS:<'bAA9Q!9\u0011\"a\u0019A\u0002\u0005m\u0004c\u0001\u0010\u0002~%\u0019\u0011qP\u0010\u0003\u000bQ\u000b'\r\\3\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\u0006Y1\r[3dWJ+7/\u001e7u)\u001d1\u0013qQAF\u0003CC\u0001\"!#\u0002\u0002\u0002\u0007\u0011\u0011N\u0001\tgFd\u0017+^3ss\"A\u0011QRAA\u0001\u0004\ty)\u0001\bfqB,7\r^3e%\u0016\u001cX\u000f\u001c;\u0011\r\u0005]\u0012\u0011SAK\u0013\u0011\t\u0019*a\u0013\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\r\tYJC\u0001\u0006if\u0004Xm]\u0005\u0005\u0003?\u000bIJA\u0002S_^D!\"a)\u0002\u0002B\u0005\t\u0019AAS\u0003!I7oU8si\u0016$\u0007cA\u0014\u0002(&\u0019\u0011\u0011\u0016\u0015\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0016\u0001E2iK\u000e\\G+\u00192mKJ+7/\u001e7u)\u001d1\u0013\u0011WAZ\u0003kCq!CAV\u0001\u0004\tY\b\u0003\u0005\u0002\u000e\u0006-\u0006\u0019AAH\u0011)\t\u0019+a+\u0011\u0002\u0003\u0007\u0011Q\u0015\u0005\b\u0003s\u0003A\u0011AA^\u0003%\u0019\u0007.Z2l'&TX\rF\u0003'\u0003{\u000by\f\u0003\u0005\u0002\n\u0006]\u0006\u0019AA5\u0011!\t\t-a.A\u0002\u0005\r\u0017\u0001D3ya\u0016\u001cG/\u001a3TSj,\u0007cA\u0014\u0002F&\u0019\u0011q\u0019\u0015\u0003\u0007%sG\u000fC\u0004\u0002L\u0002!I!!4\u0002\u000f\u001d,G\u000f\u00157b]R!\u0011\u0011NAh\u0011!\t\t.!3A\u0002\u0005M\u0017a\u0002:fY:{G-\u001a\t\u0005\u0003+\fy.\u0004\u0002\u0002X*!\u0011\u0011\\An\u0003\r\u0011X\r\u001c\u0006\u0004\u0003;d\u0011aB2bY\u000eLG/Z\u0005\u0005\u0003C\f9NA\u0004SK2tu\u000eZ3\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\u0006)1\r[3dWR)a%!;\u0002l\"A\u0011\u0011RAr\u0001\u0004\tI\u0007\u0003\u0005\u0002n\u0006\r\b\u0019AAx\u0003%\u0019\u0007.Z2l\rVt7\rE\u0004(\u0003c\fy)!>\n\u0007\u0005M\bFA\u0005Gk:\u001cG/[8ocA)q%a>\u0002j%\u0019\u0011\u0011 \u0015\u0003\r=\u0003H/[8o\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u007f\f!b\u00195fG.$\u0016M\u00197f)\u00151#\u0011\u0001B\u0002\u0011\u001dI\u00111 a\u0001\u0003wB\u0001\"!<\u0002|\u0002\u0007\u0011q\u001e\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0003-\u0019\u0007.Z2l\r\u0006LG.\u001a3\u0015\u000b\u0019\u0012YA!\u0004\t\u0011\u0005%%Q\u0001a\u0001\u0003SB\u0001Ba\u0004\u0003\u0006\u0001\u0007\u0011\u0011N\u0001\u0013Kb\u0004Xm\u0019;fI6\u001bx\rU1ui\u0016\u0014h\u000eC\u0004\u0003\u0014\u0001!\tA!\u0006\u0002!\rDWmY6F[B$\u0018PU3tk2$Hc\u0001\u0014\u0003\u0018!A\u0011\u0011\u0012B\t\u0001\u0004\tI\u0007C\u0004\u0003\u001c\u0001!\tA!\b\u0002\u0015A\f'o]3Rk\u0016\u0014\u0018\u0010\u0006\u0003\u0002|\t}\u0001\u0002CAE\u00053\u0001\r!!\u001b\t\u000f\t\r\u0002\u0001\"\u0001\u0003&\u0005aQ\r_3dkR,\u0017+^3ssR!\u0011q\u0012B\u0014\u0011\u001dI!\u0011\u0005a\u0001\u0003wBqAa\t\u0001\t\u0003\u0011Y\u0003\u0006\u0003\u0002\u0010\n5\u0002\u0002CAE\u0005S\u0001\r!!\u001b\t\u000f\tE\u0002\u0001\"\u0003\u00034\u0005i\u0001O]3qCJ,'+Z:vYR$bA!\u000e\u00038\tm\u0002CBA\u001c\u0003#\u000bI\u0007\u0003\u0005\u0003:\t=\u0002\u0019AAH\u0003\r\u0019X-\u001d\u0005\t\u0003G\u0013y\u00031\u0001\u0002&\"9!q\b\u0001\u0005\u0002\t\u0005\u0013!C2iK\u000e\\7+Y7f)!\t)Pa\u0011\u0003F\t%\u0003\u0002CAG\u0005{\u0001\r!a$\t\u0011\t\u001d#Q\ba\u0001\u0003\u001f\u000baA]3tk2$\bBCAR\u0005{\u0001\n\u00111\u0001\u0002&\"9!Q\n\u0001\u0005\n\t=\u0013AC2iK\u000e\\W)\u001c9usR!\u0011Q\u001fB)\u0011!\u00119Ea\u0013A\u0002\u0005=\u0005b\u0002B+\u0001\u0011%!qK\u0001\u000bg&$WMQ=TS\u0012,GC\u0002B-\u0005[\u0012\t\b\u0005\u0004\u0003\\\t\u0005$1M\u0007\u0003\u0005;R1Aa\u0018)\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\u0013i\u0006\u0005\u0003\u0003f\t-TB\u0001B4\u0015\r\u0011Ig`\u0001\u0005Y\u0006tw-\u0003\u0003\u0002v\t\u001d\u0004\u0002\u0003B8\u0005'\u0002\rA!\u000e\u0002\t1,g\r\u001e\u0005\t\u0005g\u0012\u0019\u00061\u0001\u00036\u0005)!/[4ii\"9!q\u000f\u0001\u0005\u0004\te\u0014A\u0005:fO&\u001cH/\u001a:D_2dWm\u0019;j_:$\u0012B\nB>\u0005\u007f\u0012IIa(\t\u0011\tu$Q\u000fa\u0001\u0003S\n\u0011\u0002^1cY\u0016t\u0015-\\3\t\u0011\t\u0005%Q\u000fa\u0001\u0005\u0007\u000bA\u0001Z1uCB1\u0011q\u0007BC\u0003+KAAa\"\u0002L\tA\u0011\n^3sC\ndW\r\u0003\u0005\u0003\f\nU\u0004\u0019\u0001BG\u0003!!\u0018\u0010]3J]\u001a|\u0007C\u0002BH\u00057\u000b)*\u0004\u0002\u0003\u0012*!!1\u0013BK\u0003!!\u0018\u0010]3j]\u001a|'\u0002\u0002BL\u00053\u000baaY8n[>t'B\u0001\u0011\u000b\u0013\u0011\u0011iJ!%\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:D\u0001B!)\u0003v\u0001\u0007\u0011\u0011N\u0001\u0007M&,G\u000eZ:\t\u000f\t\u0015\u0006\u0001\"\u0001\u0003(\u00061\"/Z4jgR,'OS1wC\u000e{G\u000e\\3di&|g.\u0006\u0003\u0003*\n]F#\u0003\u0014\u0003,\n5&\u0011\u001aBg\u0011!\u0011iHa)A\u0002\u0005%\u0004\u0002\u0003BA\u0005G\u0003\rAa,\u0011\r\t\u0015$\u0011\u0017BZ\u0013\u0011\u00119Ia\u001a\u0011\t\tU&q\u0017\u0007\u0001\t!\u0011ILa)C\u0002\tm&!\u0001+\u0012\t\tu&1\u0019\t\u0004O\t}\u0016b\u0001BaQ\t9aj\u001c;iS:<\u0007cA\u0014\u0003F&\u0019!q\u0019\u0015\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003\f\n\r\u0006\u0019\u0001Bf!\u0019\u0011yIa'\u00034\"A!\u0011\u0015BR\u0001\u0004\tI\u0007C\u0004\u0003x\u0001!\tA!5\u0016\t\tM'Q\u001c\u000b\fM\tU'q\u001bBp\u0005G\u0014)\u000f\u0003\u0005\u0003~\t=\u0007\u0019AA5\u0011!\u0011\tIa4A\u0002\te\u0007CBA\u001c\u0005\u000b\u0013Y\u000e\u0005\u0003\u00036\nuG\u0001\u0003B]\u0005\u001f\u0014\rAa/\t\u0011\t-%q\u001aa\u0001\u0005C\u0004bAa$\u0003\u001c\nm\u0007\u0002\u0003BQ\u0005\u001f\u0004\r!!\u001b\t\u0011\t\u001d(q\u001aa\u0001\u0005S\faBZ5fY\u0012tU\u000f\u001c7bE2,7\u000fE\u0003(\u0005W\f)+C\u0002\u0003n\"\u0012Q!\u0011:sCfDqAa\u001e\u0001\t\u0003\u0011\t0\u0006\u0003\u0003t\nuH#\u0004\u0014\u0003v\n](q`B\u0002\u0007\u000b\u00199\u0001\u0003\u0005\u0003~\t=\b\u0019AA5\u0011!\u0011\tIa<A\u0002\te\bCBA\u001c\u0005\u000b\u0013Y\u0010\u0005\u0003\u00036\nuH\u0001\u0003B]\u0005_\u0014\rAa/\t\u0011\t-%q\u001ea\u0001\u0007\u0003\u0001bAa$\u0003\u001c\nm\b\u0002\u0003BQ\u0005_\u0004\r!!\u001b\t\u0011\t\u001d(q\u001ea\u0001\u0005SD\u0001b!\u0003\u0003p\u0002\u000711B\u0001\ngR\fG/[:uS\u000e\u0004Ba!\u0004\u0004\u00185\u00111q\u0002\u0006\u0005\u0007#\u0019\u0019\"A\u0003ti\u0006$8OC\u0002\u0004\u0016\u0019\tA\u0001\u001d7b]&!1\u0011DB\b\u000591E.\u001b8l'R\fG/[:uS\u000eDqa!\b\u0001\t\u0003\u0019y\"A\u0010sK\u001eL7\u000f^3s)\u0016l\u0007o\u001c:bef\u001c\u0016p\u001d;f[\u001a+hn\u0019;j_:$RAJB\u0011\u0007KA\u0001ba\t\u0004\u001c\u0001\u0007\u0011\u0011N\u0001\u0005]\u0006lW\r\u0003\u0005\u0004(\rm\u0001\u0019AB\u0015\u000351WO\\2uS>t7\t\\1tgB\"11FB\u001a!\u0019\tYg!\f\u00042%!1qFA<\u0005\u0015\u0019E.Y:t!\u0011\u0011)la\r\u0005\u0019\rU2QEA\u0001\u0002\u0003\u0015\taa\u000e\u0003\u0007}#\u0013'\u0005\u0003\u0003>\u000ee\u0002\u0003BB\u001e\u0007\u0003j!a!\u0010\u000b\u0007\r}\u0002\"A\u0005gk:\u001cG/[8og&!11IB\u001f\u0005M)6/\u001a:EK\u001aLg.\u001a3Gk:\u001cG/[8o\u0011\u001d\u00199\u0005\u0001C\u0001\u0007\u0013\nQB]3hSN$XM\u001d*b]\u001e,G#\u0002\u0014\u0004L\r5\u0003\u0002CB\u0012\u0007\u000b\u0002\r!!\u001b\t\u0011\r=3Q\ta\u0001\u0007#\n1!\u001a8e!\r931K\u0005\u0004\u0007+B#\u0001\u0002'p]\u001eDqaa\u0012\u0001\t\u0003\u0019I\u0006F\u0004'\u00077\u001aif!\u0019\t\u0011\r\r2q\u000ba\u0001\u0003SB\u0001ba\u0018\u0004X\u0001\u00071\u0011K\u0001\u0006gR\f'\u000f\u001e\u0005\t\u0007\u001f\u001a9\u00061\u0001\u0004R!91Q\r\u0001\u0005\u0002\r\u001d\u0014A\u00048foJ\u000bgnZ3T_V\u00148-\u001a\u000b\u0007\u0007S\u001ayh!!\u0011\r\r-4\u0011OB;\u001b\t\u0019iGC\u0002\u0004p}\u000b!\u0002Z1uCN$(/Z1n\u0013\u0011\u0019\u0019h!\u001c\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000e\u0005\u0003\u0004x\rmTBAB=\u0015\r\u0011\t\tC\u0005\u0005\u0007{\u001aIHA\u0004S_^$\u0015\r^1\t\u0011\r}31\ra\u0001\u0007#B\u0001ba\u0014\u0004d\u0001\u00071\u0011\u000b\u0005\b\u0007\u000b\u0003A\u0011CBD\u0003\u0015\u0011xn^(g)\u0011\t)j!#\t\u0011\r-51\u0011a\u0001\u0007\u001b\u000bA!\u0019:hgB)qea$\u0003D&\u00191\u0011\u0013\u0015\u0003\u0015q\u0012X\r]3bi\u0016$g\bC\u0005\u0004\u0016\u0002\t\n\u0011\"\u0001\u0004\u0018\u0006)2\r[3dWJ+7/\u001e7uI\u0011,g-Y;mi\u0012\u001aTCABMU\u0011\t)ka',\u0005\ru\u0005\u0003BBP\u0007Sk!a!)\u000b\t\r\r6QU\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa*)\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007W\u001b\tKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011ba,\u0001#\u0003%\taa&\u00025\rDWmY6UC\ndWMU3tk2$H\u0005Z3gCVdG\u000fJ\u001a\t\u0013\rM\u0006!%A\u0005\u0002\r]\u0015aE2iK\u000e\\7+Y7fI\u0011,g-Y;mi\u0012\u001ataBB\\\u0005!\u00051\u0011X\u0001\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\u0011\u0007M\u0019YL\u0002\u0004\u0002\u0005!\u00051QX\n\u0005\u0007w\u001by\fE\u0002(\u0007\u0003L1aa1)\u0005\u0019\te.\u001f*fM\"9qca/\u0005\u0002\r\u001dGCAB]\u0011!\u0019Yma/\u0005\u0002\r5\u0017a\u0001:poR!\u0011QSBh\u0011!\u0019Yi!3A\u0002\r5\u0005\u0002CBj\u0007w#\ta!6\u0002\u0013\tLg.\u0019:z%><HCBBl\u0007G\u001c)\u0010\u0005\u0003\u0004Z\u000e}WBABn\u0015\u0011\u0019in!\u001f\u0002\r\tLg.\u0019:z\u0013\u0011\u0019\toa7\u0003\u001b\tKg.\u0019:z%><H)\u0019;b\u0011!\tYj!5A\u0002\r\u0015\b#B\u0014\u0003l\u000e\u001d\b\u0003BBu\u0007cl!aa;\u000b\t\r58q^\u0001\bY><\u0017nY1m\u0015\r\tY\nC\u0005\u0005\u0007g\u001cYOA\u0006M_\u001eL7-\u00197UsB,\u0007\u0002\u0003BQ\u0007#\u0004\ra!$\t\u0011\re81\u0018C\u0001\u0007w\fQbY8na\u0006\u0014XMU3tk2$X\u0003BB\u007f\t\u0017!\u0012BJB\u0000\t\u000b!i\u0001\"\u0005\t\u0011\u0011\u00051q\u001fa\u0001\t\u0007\tq\"\u001a=qK\u000e$X\rZ*ue&twm\u001d\t\u0006O\t-\u0018\u0011\u000e\u0005\t\u0005\u000f\u001a9\u00101\u0001\u0005\bA)qEa;\u0005\nA!!Q\u0017C\u0006\t!\u0011Ila>C\u0002\tm\u0006\u0002\u0003C\b\u0007o\u0004\r!!*\u0002\tM|'\u000f\u001e\u0005\u000b\t'\u00199\u0010%AA\u0002\u0005\u0015\u0016\u0001C1t)V\u0004H.Z:\t\u0011\u0011]11\u0018C\u0001\t3\tAcY8oM&<gi\u001c:NS:L7\t\\;ti\u0016\u0014Hc\u0001\u0014\u0005\u001c!11\u000e\"\u0006A\u00025D\u0001\u0002b\b\u0004<\u0012\u0005A\u0011E\u0001\u0017G>tg-[4CCR\u001c\u0007n\u00155vM\u001adW-T8eKR)a\u0005b\t\u0005&!11\u000e\"\bA\u00025D\u0001\u0002b\n\u0005\u001e\u0001\u0007A\u0011F\u0001\fg\",hM\u001a7f\u001b>$W\r\u0005\u0003\u0005,\u00115RB\u0001BK\u0013\u0011!yC!&\u0003!\t\u000bGo\u00195TQV4g\r\\3N_\u0012,\u0007B\u0003C\u001a\u0007w\u000b\n\u0011\"\u0001\u00056\u000592m\\7qCJ,'+Z:vYR$C-\u001a4bk2$H\u0005N\u000b\u0005\u0007/#9\u0004\u0002\u0005\u0003:\u0012E\"\u0019\u0001B^\u0001")
public class BatchTestBase
extends BatchAbstractTestBase {
    private EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
    private TestingTableEnvironment testingTableEnv;
    private TableEnvironment tEnv;
    private PlannerBase planner;
    private StreamExecutionEnvironment env;
    private TableConfig tableConfig;
    private final Pattern LINE_COL_PATTERN = Pattern.compile("At line ([0-9]+), column ([0-9]+)");
    private final Pattern LINE_COL_TWICE_PATTERN = Pattern.compile("(?s)From line ([0-9]+), column ([0-9]+) to line ([0-9]+), column ([0-9]+): (.*)");

    public static <T> boolean compareResult$default$4() {
        return BatchTestBase$.MODULE$.compareResult$default$4();
    }

    public static void configBatchShuffleMode(TableConfig tableConfig, BatchShuffleMode batchShuffleMode) {
        BatchTestBase$.MODULE$.configBatchShuffleMode(tableConfig, batchShuffleMode);
    }

    public static void configForMiniCluster(TableConfig tableConfig) {
        BatchTestBase$.MODULE$.configForMiniCluster(tableConfig);
    }

    public static <T> void compareResult(String[] stringArray, Object object, boolean bl, boolean bl2) {
        BatchTestBase$.MODULE$.compareResult(stringArray, object, bl, bl2);
    }

    public static BinaryRowData binaryRow(LogicalType[] logicalTypeArray, Seq<Object> seq) {
        return BatchTestBase$.MODULE$.binaryRow(logicalTypeArray, seq);
    }

    public static Row row(Seq<Object> seq) {
        return BatchTestBase$.MODULE$.row(seq);
    }

    public EnvironmentSettings settings() {
        return this.settings;
    }

    public void settings_$eq(EnvironmentSettings x$1) {
        this.settings = x$1;
    }

    public TestingTableEnvironment testingTableEnv() {
        return this.testingTableEnv;
    }

    public void testingTableEnv_$eq(TestingTableEnvironment x$1) {
        this.testingTableEnv = x$1;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    public PlannerBase planner() {
        return this.planner;
    }

    public void planner_$eq(PlannerBase x$1) {
        this.planner = x$1;
    }

    public StreamExecutionEnvironment env() {
        return this.env;
    }

    public void env_$eq(StreamExecutionEnvironment x$1) {
        this.env = x$1;
    }

    public TableConfig tableConfig() {
        return this.tableConfig;
    }

    public void tableConfig_$eq(TableConfig x$1) {
        this.tableConfig = x$1;
    }

    public Pattern LINE_COL_PATTERN() {
        return this.LINE_COL_PATTERN;
    }

    public Pattern LINE_COL_TWICE_PATTERN() {
        return this.LINE_COL_TWICE_PATTERN;
    }

    @BeforeEach
    public void setupEnv() throws Exception {
        this.testingTableEnv_$eq(TestingTableEnvironment$.MODULE$.create(this.settings(), (Option<CatalogManager>)None$.MODULE$, TableConfig.getDefault()));
        this.tEnv_$eq((TableEnvironment)this.testingTableEnv());
        this.tEnv().getConfig().set(BatchExecutionOptions.ADAPTIVE_AUTO_PARALLELISM_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.planner_$eq((PlannerBase)((TableEnvironmentImpl)this.tEnv()).getPlanner());
        this.env_$eq(this.planner().getExecEnv());
        this.env().getConfig().enableObjectReuse();
        this.tableConfig_$eq(this.tEnv().getConfig());
        BatchTestBase$.MODULE$.configForMiniCluster(this.tableConfig());
    }

    @BeforeEach
    public void before() throws Exception {
    }

    @AfterEach
    public void after() {
        TestValuesTableFactory.clearAllData();
    }

    public String explainLogical(Table table) {
        RelNode ast = TableTestUtil$.MODULE$.toRelNode(table);
        String logicalPlan = this.getPlan(ast);
        return new StringBuilder(54).append("== Abstract Syntax Tree ==").append(System.lineSeparator()).append(String.valueOf(FlinkRelOptUtil$.MODULE$.toString(ast, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()))).append(System.lineSeparator()).append("== Optimized Logical Plan ==").append(System.lineSeparator()).append(String.valueOf(logicalPlan)).toString();
    }

    public void checkResult(String sqlQuery, Seq<Row> expectedResult, boolean isSorted) {
        this.check(sqlQuery, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> this.checkSame(expectedResult, (Seq<Row>)result, isSorted));
    }

    public void checkTableResult(Table table, Seq<Row> expectedResult, boolean isSorted) {
        this.checkTable(table, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> this.checkSame(expectedResult, (Seq<Row>)result, isSorted));
    }

    public void checkSize(String sqlQuery, int expectedSize) {
        this.check(sqlQuery, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> {
            None$ none$;
            if (result.size() != expectedSize) {
                String string = new StringBuilder(23).append("== Correct Result - ").append(expectedSize).append(" ==").toString();
                String string2 = new StringBuilder(22).append("== Actual Result - ").append(result.size()).append(" ==").toString();
                String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("\n               |Results\n               |").append(this.sideBySide((Seq<String>)((Seq)this.prepareResult((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), false).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)this.prepareResult((Seq<Row>)result, false).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom()))).mkString("\n")).append("\n        ").toString())).stripMargin();
                none$ = new Some((Object)errorMessage);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    private String getPlan(RelNode relNode) {
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)this.tEnv()).getPlanner();
        RelNode optimized = planner.optimize(relNode);
        return FlinkRelOptUtil$.MODULE$.toString(optimized, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7());
    }

    public void check(String sqlQuery, Function1<Seq<Row>, Option<String>> checkFunc) {
        Table table = this.parseQuery(sqlQuery);
        Seq<Row> result = this.executeQuery(table);
        ((Option)checkFunc.apply(result)).foreach((Function1 & Serializable & scala.Serializable)results -> {
            String plan = this.explainLogical(table);
            return (Nothing$)Assertions.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(138).append("\n                |Results do not match for query:\n                |  ").append(sqlQuery).append("\n                |").append((String)results).append("\n                |Plan:\n                |  ").append(plan).append("\n       ").toString())).stripMargin());
        });
    }

    public boolean checkResult$default$3() {
        return false;
    }

    public void checkTable(Table table, Function1<Seq<Row>, Option<String>> checkFunc) {
        Seq<Row> result = this.executeQuery(table);
        ((Option)checkFunc.apply(result)).foreach((Function1 & Serializable & scala.Serializable)results -> {
            String plan = this.explainLogical(table);
            return (Nothing$)Assertions.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(108).append("\n                |Results do not match:\n                |").append((String)results).append("\n                |Plan:\n                |  ").append(plan).append("\n       ").toString())).stripMargin());
        });
    }

    public boolean checkTableResult$default$3() {
        return false;
    }

    public void checkFailed(String sqlQuery, String expectedMsgPattern) {
        block26: {
            try {
                Table table = this.parseQuery(sqlQuery);
                Seq<Row> _ = this.executeQuery(table);
                if (expectedMsgPattern != null) {
                    throw new AssertionError((Object)new StringBuilder(50).append("Expected query to throw exception, but it did not;").append(new StringBuilder(11).append(" query [").append(sqlQuery).append(" ];").toString()).append(new StringBuilder(12).append(" expected [").append(expectedMsgPattern).append("]").toString()).toString());
                }
            }
            catch (SqlParserException spe) {
                String errMsg = spe.getMessage();
                if (expectedMsgPattern == null) {
                    throw new RuntimeException(new StringBuilder(27).append("Error while parsing query: ").append(sqlQuery).toString(), spe);
                }
                if (errMsg == null || !errMsg.matches(expectedMsgPattern)) {
                    throw new RuntimeException(new StringBuilder(38).append("Error did not match expected [").append(expectedMsgPattern).append("] while ").append(new StringBuilder(16).append("parsing query [").append(sqlQuery).append("]").toString()).toString(), spe);
                }
            }
            catch (Throwable thrown) {
                Object object;
                Throwable actualExp = thrown;
                String actualMsg = actualExp.getMessage();
                int actualLine = -1;
                int actualColumn = -1;
                int actualEndLine = 100;
                int actualEndColumn = 99;
                CalciteContextException ece = null;
                SqlParseException spe = null;
                Throwable ex = actualExp;
                boolean found = false;
                while (ex != null && !found) {
                    BoxedUnit boxedUnit;
                    Throwable throwable = ex;
                    if (throwable instanceof CalciteContextException) {
                        CalciteContextException calciteContextException;
                        ece = calciteContextException = (CalciteContextException)throwable;
                        found = true;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (throwable != null) {
                        Throwable throwable2 = throwable;
                        Throwable throwable3 = throwable2.getCause();
                        Throwable throwable4 = ex;
                        if (!(throwable3 != null ? !throwable3.equals(throwable4) : throwable4 != null)) {
                            found = true;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    ex = ex.getCause();
                    boxedUnit = BoxedUnit.UNIT;
                }
                ex = actualExp;
                found = false;
                while (ex != null && !found) {
                    BoxedUnit boxedUnit;
                    SqlParseException sqlParseException;
                    Throwable throwable = ex;
                    if (throwable instanceof SqlParseException && (sqlParseException = (SqlParseException)throwable).getPos() != null) {
                        spe = sqlParseException;
                        found = true;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (throwable != null) {
                        Throwable throwable5 = throwable;
                        Throwable throwable6 = throwable5.getCause();
                        Throwable throwable7 = ex;
                        if (!(throwable6 != null ? !throwable6.equals(throwable7) : throwable7 != null)) {
                            found = true;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    ex = ex.getCause();
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (ece != null) {
                    actualLine = ece.getPosLine();
                    actualColumn = ece.getPosColumn();
                    actualEndLine = ece.getEndPosLine();
                    actualEndColumn = ece.getEndPosColumn();
                    if (ece.getCause() != null) {
                        actualExp = ece.getCause();
                        actualMsg = actualExp.getMessage();
                    }
                } else if (spe != null) {
                    actualLine = spe.getPos().getLineNum();
                    actualColumn = spe.getPos().getColumnNum();
                    actualEndLine = spe.getPos().getEndLineNum();
                    actualEndColumn = spe.getPos().getEndColumnNum();
                    if (spe.getCause() != null) {
                        actualExp = spe.getCause();
                        actualMsg = actualExp.getMessage();
                    }
                } else {
                    String message = actualMsg;
                    if (message != null) {
                        Matcher matcher = this.LINE_COL_TWICE_PATTERN().matcher(message);
                        if (matcher.matches()) {
                            actualLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toInt();
                            actualColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(2))).toInt();
                            actualEndLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(3))).toInt();
                            actualEndColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(4))).toInt();
                            actualMsg = matcher.group(5);
                        } else {
                            matcher = this.LINE_COL_PATTERN().matcher(message);
                            if (matcher.matches()) {
                                actualLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toInt();
                                actualColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(2))).toInt();
                            }
                        }
                    }
                }
                if (expectedMsgPattern == null) {
                    actualExp.printStackTrace();
                    object = Assertions.fail((String)new StringBuilder(47).append("Validator threw unexpected exception; query [").append(sqlQuery).append("];").append(new StringBuilder(33).append(" exception [").append(actualMsg).append("]; class [").append(actualExp).append(".getClass];").toString()).append(new StringBuilder(33).append(" pos [line ").append(actualLine).append(" col ").append(actualColumn).append(" thru line ").append(actualLine).append(" col ").append(actualColumn).append("]").toString()).toString());
                } else {
                    object = BoxedUnit.UNIT;
                }
                if (actualMsg != null && actualMsg.matches(expectedMsgPattern)) break block26;
                actualExp.printStackTrace();
                Assertions.fail((String)new StringBuilder(26).append("Validator threw different ").append(new StringBuilder(35).append("exception than expected; query [").append(sqlQuery).append("];\n").toString()).append(new StringBuilder(22).append(" expected pattern [").append(expectedMsgPattern).append("];\n").toString()).append(new StringBuilder(12).append(" actual [").append(actualMsg).append("];\n").toString()).append(new StringBuilder(6).append(" pos [").append(actualLine).toString()).append(new StringBuilder(5).append(" col ").append(actualColumn).toString()).append(new StringBuilder(11).append(" thru line ").append(actualEndLine).toString()).append(new StringBuilder(7).append(" col ").append(actualEndColumn).append("].").toString()).toString());
            }
        }
    }

    public void checkEmptyResult(String sqlQuery) {
        Table table = this.parseQuery(sqlQuery);
        Seq<Row> result = this.executeQuery(table);
        this.checkEmpty(result).foreach((Function1 & Serializable & scala.Serializable)results -> (Nothing$)Assertions.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(75).append("\n                |Results do not match for query:\n                |").append((String)results).append("\n       ").toString())).stripMargin()));
    }

    public Table parseQuery(String sqlQuery) {
        return this.tEnv().sqlQuery(sqlQuery);
    }

    public Seq<Row> executeQuery(Table table) {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(CollectionUtil.iteratorToList((Iterator)table.execute().collect())).asScala();
    }

    public Seq<Row> executeQuery(String sqlQuery) {
        Table table = this.parseQuery(sqlQuery);
        return this.executeQuery(table);
    }

    private Seq<String> prepareResult(Seq<Row> seq, boolean isSorted) {
        return !isSorted ? (Seq)((SeqLike)seq.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)s -> s, (Ordering)Ordering.String$.MODULE$) : (Seq)seq.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> checkSame(Seq<Row> expectedResult, Seq<Row> result, boolean isSorted) {
        None$ none$;
        if (expectedResult.size() != result.size() || !this.prepareResult(expectedResult, isSorted).equals(this.prepareResult(result, isSorted))) {
            String string = new StringBuilder(23).append("== Correct Result - ").append(expectedResult.size()).append(" ==").toString();
            String string2 = new StringBuilder(22).append("== Actual Result - ").append(result.size()).append(" ==").toString();
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(42).append("\n           |Results\n           |").append(this.sideBySide((Seq<String>)((Seq)this.prepareResult(expectedResult, isSorted).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)this.prepareResult(result, isSorted).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom()))).mkString("\n")).append("\n        ").toString())).stripMargin();
            none$ = new Some((Object)errorMessage);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean checkSame$default$3() {
        return false;
    }

    private Option<String> checkEmpty(Seq<Row> result) {
        Nil$ expectedResult = Nil$.MODULE$;
        return this.checkSame((Seq<Row>)expectedResult, result, true);
    }

    private Seq<String> sideBySide(Seq<String> left, Seq<String> right) {
        int maxLeftSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)left.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.length()), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        Seq leftPadded = (Seq)left.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(scala.math.package$.MODULE$.max(right.size() - left.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        Seq rightPadded = (Seq)right.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(scala.math.package$.MODULE$.max(left.size() - right.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)leftPadded.zip((GenIterable)rightPadded, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String l = (String)tuple2._1();
            String r = (String)tuple2._2();
            String string = l;
            String string2 = r;
            String string3 = new StringBuilder(0).append(!(string == null ? string2 != null : !string.equals(string2)) || l.startsWith("== Correct") ? " " : "!").append(l).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(maxLeftSize - l.length() + 3)).append(r).toString();
            return string3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void registerCollection(String tableName, Iterable<Row> data, TypeInformation<Row> typeInfo, String fields) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields);
    }

    public <T> void registerJavaCollection(String tableName, java.lang.Iterable<T> data, TypeInformation<T> typeInfo, String fields) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(data).asScala(), typeInfo, fields);
    }

    public <T> void registerCollection(String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fields, boolean[] fieldNullables) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields, fieldNullables, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public <T> void registerCollection(String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fields, boolean[] fieldNullables, FlinkStatistic statistic) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields, fieldNullables, (Option<FlinkStatistic>)new Some((Object)statistic));
    }

    public void registerTemporarySystemFunction(String name, Class<? extends UserDefinedFunction> functionClass) {
        this.testingTableEnv().createTemporarySystemFunction(name, functionClass);
    }

    public void registerRange(String name, long end) {
        this.registerRange(name, 0L, end);
    }

    public void registerRange(String name, long start, long end) {
        BatchTableEnvUtil$.MODULE$.registerBoundedStreamInternal(this.tEnv(), name, this.newRangeSource(start, end), (Option<Expression[]>)new Some((Object)new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)}), (Option<boolean[]>)None$.MODULE$, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public DataStream<RowData> newRangeSource(long start, long end) {
        InternalTypeInfo typeInfo = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new BigIntType()});
        DataStreamSource boundedStream = this.env().createInput((InputFormat)new RangeInputFormat(start, end), (TypeInformation)typeInfo);
        boundedStream.setParallelism(1);
        return boundedStream;
    }

    /*
     * WARNING - void declaration
     */
    public Row rowOf(Seq<Object> args) {
        void var2_2;
        Row row = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setField(i, args.apply(i)));
        return var2_2;
    }
}

