/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.FunctionRequirement;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.python.PythonEnv;
import org.apache.flink.table.functions.python.PythonFunction;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;

public class JavaUserDefinedAggFunctions {
    public static boolean isCloseCalled = false;

    public static class OverloadedDoubleMaxFunction
    extends TableAggregateFunction<Object, Row> {
        public Row createAccumulator() {
            return new Row(1);
        }

        @FunctionHint(accumulator=@DataTypeHint(value="ROW<max BIGINT>"), output=@DataTypeHint(value="BIGINT"))
        public void accumulate(Row accumulator, Long l) {
            Long max = (Long)accumulator.getField(0);
            if (max == null || l > max) {
                accumulator.setField(0, (Object)l);
            }
        }

        @FunctionHint(accumulator=@DataTypeHint(value="ROW<max STRING>"), output=@DataTypeHint(value="STRING"))
        public void accumulate(Row accumulator, String s) {
            String max = (String)accumulator.getField(0);
            if (max == null || s.compareTo(max) > 0) {
                accumulator.setField(0, (Object)s);
            }
        }

        public void emitValue(Row accumulator, Collector<Object> out) {
            out.collect(accumulator.getField(0));
            out.collect(accumulator.getField(0));
        }
    }

    public static class OverloadedMaxFunction
    extends AggregateFunction<Object, Row> {
        public Row createAccumulator() {
            return new Row(1);
        }

        @FunctionHint(accumulator=@DataTypeHint(value="ROW<max BIGINT>"), output=@DataTypeHint(value="BIGINT"))
        public void accumulate(Row accumulator, Long l) {
            Long max = (Long)accumulator.getField(0);
            if (max == null || l > max) {
                accumulator.setField(0, (Object)l);
            }
        }

        @FunctionHint(accumulator=@DataTypeHint(value="ROW<max STRING>"), output=@DataTypeHint(value="STRING"))
        public void accumulate(Row accumulator, String s) {
            String max = (String)accumulator.getField(0);
            if (max == null || s.compareTo(max) > 0) {
                accumulator.setField(0, (Object)s);
            }
        }

        public Object getValue(Row accumulator) {
            return accumulator.getField(0);
        }
    }

    public static class MultiArgSum
    extends AggregateFunction<Long, MultiArgSumAcc> {
        public MultiArgSumAcc createAccumulator() {
            MultiArgSumAcc acc = new MultiArgSumAcc();
            acc.count = 0L;
            return acc;
        }

        public void accumulate(MultiArgSumAcc acc, long in1, long in2) {
            acc.count += in1 + in2;
        }

        public void retract(MultiArgSumAcc acc, long in1, long in2) {
            acc.count -= in1 + in2;
        }

        public Long getValue(MultiArgSumAcc acc) {
            return acc.count;
        }
    }

    public static class MultiArgSumAcc {
        public long count;
    }

    public static class MultiArgCount
    extends AggregateFunction<Long, MultiArgCountAcc> {
        public MultiArgCountAcc createAccumulator() {
            MultiArgCountAcc acc = new MultiArgCountAcc();
            acc.count = 0L;
            return acc;
        }

        public void accumulate(MultiArgCountAcc acc, Object in1, Object in2) {
            if (in1 != null && in2 != null) {
                ++acc.count;
            }
        }

        public void retract(MultiArgCountAcc acc, Object in1, Object in2) {
            if (in1 != null && in2 != null) {
                --acc.count;
            }
        }

        public void merge(MultiArgCountAcc accumulator, Iterable<MultiArgCountAcc> iterable) {
            for (MultiArgCountAcc otherAcc : iterable) {
                accumulator.count += otherAcc.count;
            }
        }

        public Long getValue(MultiArgCountAcc acc) {
            return acc.count;
        }
    }

    public static class MultiArgCountAcc {
        public long count;
    }

    public static class DataViewTestAgg
    extends AggregateFunction<Long, DataViewTestAccum> {
        public DataViewTestAccum createAccumulator() {
            return new DataViewTestAccum();
        }

        public void accumulate(DataViewTestAccum accumulator, String a, Long b) {
            try {
                if (!accumulator.map.contains((Object)a)) {
                    accumulator.map.put((Object)a, (Object)1);
                    ++accumulator.count;
                }
                accumulator.list.add((Object)b);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Long getValue(DataViewTestAccum accumulator) {
            long sum = accumulator.count;
            try {
                for (Long value : accumulator.list.get()) {
                    sum += value.longValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return sum;
        }

        public void close() {
            isCloseCalled = true;
        }
    }

    public static class DataViewTestAccum {
        public MapView<String, Integer> map = new MapView();
        public MapView<String, Integer> map2 = new MapView();
        public long count = 0L;
        private ListView<Long> list = new ListView();

        public ListView<Long> getList() {
            return this.list;
        }

        public void setList(ListView<Long> list) {
            this.list = list;
        }
    }

    public static class CountDistinctWithRetractAndReset
    extends CountDistinct {
        public void retract(CountDistinctAccum accumulator, long id) {
            try {
                Integer cnt = (Integer)accumulator.map.get((Object)String.valueOf(id));
                if (cnt != null) {
                    if ((cnt = Integer.valueOf(cnt - 1)) <= 0) {
                        accumulator.map.remove((Object)String.valueOf(id));
                        --accumulator.count;
                    } else {
                        accumulator.map.put((Object)String.valueOf(id), (Object)cnt);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void resetAccumulator(CountDistinctAccum acc) {
            acc.map.clear();
            acc.count = 0L;
        }
    }

    public static class CountDistinctWithMergeAndReset
    extends CountDistinctWithMerge {
        public void resetAccumulator(CountDistinctAccum acc) {
            acc.map.clear();
            acc.count = 0L;
        }
    }

    public static class CountDistinctWithMerge
    extends CountDistinct {
        public void merge(CountDistinctAccum acc, Iterable<CountDistinctAccum> it) {
            for (CountDistinctAccum mergeAcc : it) {
                acc.count += mergeAcc.count;
                try {
                    for (Map.Entry entry : mergeAcc.map) {
                        String key = (String)entry.getKey();
                        Integer cnt = (Integer)entry.getValue();
                        if (acc.map.contains((Object)key)) {
                            acc.map.put((Object)key, (Object)((Integer)acc.map.get((Object)key) + cnt));
                            continue;
                        }
                        acc.map.put((Object)key, (Object)cnt);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class CountDistinct
    extends AggregateFunction<Long, CountDistinctAccum> {
        public CountDistinctAccum createAccumulator() {
            CountDistinctAccum accum = new CountDistinctAccum();
            accum.map = new MapView(Types.STRING, Types.INT);
            accum.count = 0L;
            return accum;
        }

        public void accumulate(CountDistinctAccum accumulator, String id) {
            try {
                Integer cnt = (Integer)accumulator.map.get((Object)id);
                if (cnt != null) {
                    cnt = cnt + 1;
                    accumulator.map.put((Object)id, (Object)cnt);
                } else {
                    accumulator.map.put((Object)id, (Object)1);
                    ++accumulator.count;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void accumulate(CountDistinctAccum accumulator, long id) {
            try {
                Integer cnt = (Integer)accumulator.map.get((Object)String.valueOf(id));
                if (cnt != null) {
                    cnt = cnt + 1;
                    accumulator.map.put((Object)String.valueOf(id), (Object)cnt);
                } else {
                    accumulator.map.put((Object)String.valueOf(id), (Object)1);
                    ++accumulator.count;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Long getValue(CountDistinctAccum accumulator) {
            return accumulator.count;
        }
    }

    public static class CountDistinctAccum {
        public MapView<String, Integer> map;
        public long count;
    }

    public static class WeightedAvgWithRetract
    extends WeightedAvg {
        public void retract(WeightedAvgAccum accumulator, long iValue, int iWeight) {
            accumulator.sum -= iValue * (long)iWeight;
            accumulator.count -= iWeight;
        }

        public void retract(WeightedAvgAccum accumulator, int iValue, int iWeight) {
            accumulator.sum -= (long)(iValue * iWeight);
            accumulator.count -= iWeight;
        }
    }

    public static class WeightedAvgWithMergeAndReset
    extends WeightedAvgWithMerge {
        public void resetAccumulator(WeightedAvgAccum acc) {
            acc.count = 0;
            acc.sum = 0L;
        }
    }

    public static class WeightedAvgWithMerge
    extends WeightedAvg {
        public void merge(WeightedAvgAccum acc, Iterable<WeightedAvgAccum> it) {
            for (WeightedAvgAccum a : it) {
                acc.count += a.count;
                acc.sum += a.sum;
            }
        }

        public String toString() {
            return "myWeightedAvg";
        }
    }

    public static class PandasAggregateFunction
    extends WeightedAvg
    implements PythonFunction {
        public byte[] getSerializedPythonFunction() {
            return new byte[0];
        }

        public PythonEnv getPythonEnv() {
            return null;
        }

        public PythonFunctionKind getPythonFunctionKind() {
            return PythonFunctionKind.PANDAS;
        }
    }

    public static class TestPythonAggregateFunction
    extends WeightedAvg
    implements PythonFunction {
        public byte[] getSerializedPythonFunction() {
            return new byte[0];
        }

        public PythonEnv getPythonEnv() {
            return null;
        }

        public PythonFunctionKind getPythonFunctionKind() {
            return PythonFunctionKind.GENERAL;
        }
    }

    public static class WeightedAvg
    extends AggregateFunction<Long, WeightedAvgAccum> {
        public WeightedAvgAccum createAccumulator() {
            return new WeightedAvgAccum();
        }

        public Long getValue(WeightedAvgAccum accumulator) {
            if (accumulator.count == 0) {
                return null;
            }
            return accumulator.sum / (long)accumulator.count;
        }

        public void accumulate(WeightedAvgAccum accumulator, long iValue, int iWeight, int x, String string) {
            accumulator.sum += (iValue + (long)Integer.parseInt(string)) * (long)iWeight;
            accumulator.count += iWeight;
        }

        public void accumulate(WeightedAvgAccum accumulator, @DataTypeHint(value="BIGINT") long iValue, @DataTypeHint(value="INT") int iWeight) {
            accumulator.sum += iValue * (long)iWeight;
            accumulator.count += iWeight;
        }

        public void accumulate(WeightedAvgAccum accumulator, int iValue, int iWeight) {
            accumulator.sum += (long)(iValue * iWeight);
            accumulator.count += iWeight;
        }
    }

    public static class WeightedAvgAccum {
        public long sum = 0L;
        public int count = 0;
    }

    public static class OverAgg0
    extends AggregateFunction<Long, Accumulator0> {
        public Accumulator0 createAccumulator() {
            return new Accumulator0();
        }

        public Long getValue(Accumulator0 accumulator) {
            return 1L;
        }

        public void accumulate(Accumulator0 accumulator, long iValue, int iWeight) {
        }

        public Set<FunctionRequirement> getRequirements() {
            return Collections.singleton(FunctionRequirement.OVER_WINDOW_ONLY);
        }
    }

    public static class Accumulator0
    extends Tuple2<Long, Integer> {
    }
}

