/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.io.IOException;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.table.data.BoxedWrapperRowData;
import org.apache.flink.table.data.RowData;

public class RangeInputFormat
extends GenericInputFormat<RowData>
implements NonParallelInput {
    private static final long serialVersionUID = 1L;
    private long start;
    private long end;
    private transient long current;
    private transient BoxedWrapperRowData reuse;

    public RangeInputFormat(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public boolean reachedEnd() throws IOException {
        return this.current >= this.end;
    }

    public void open(GenericInputSplit split) throws IOException {
        super.open(split);
        this.current = this.start;
    }

    public RowData nextRecord(RowData ignore) throws IOException {
        if (this.reuse == null) {
            this.reuse = new BoxedWrapperRowData(1);
        }
        this.reuse.setLong(0, this.current);
        ++this.current;
        return this.reuse;
    }
}

