/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.runtime.utils.JavaPojos;
import org.apache.flink.table.planner.runtime.utils.TestingAppendTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingUpsertTableSink;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.StringUtils;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TestSinkUtil$ {
    public static TestSinkUtil$ MODULE$;

    static {
        new TestSinkUtil$();
    }

    public <T extends TableSink<?>> T configureSink(Table table, T sink) {
        Object object;
        RelDataType rowType = TableTestUtil$.MODULE$.toRelNode(table).getRowType();
        String[] fieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        TypeInformation[] fieldTypes = (TypeInformation[])((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> FlinkTypeFactory$.MODULE$.toLogicalType(field.getType()), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)x$1), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class));
        T t = sink;
        if (t instanceof TestingAppendTableSink) {
            object = new TestingAppendTableSink().configure(fieldNames, (TypeInformation<?>[])fieldTypes);
        } else if (t instanceof TestingUpsertTableSink) {
            TestingUpsertTableSink testingUpsertTableSink = (TestingUpsertTableSink)t;
            object = new TestingUpsertTableSink(testingUpsertTableSink.keys(), testingUpsertTableSink.tz()).configure(fieldNames, (TypeInformation<?>[])fieldTypes);
        } else if (t instanceof TestingRetractTableSink) {
            object = new TestingRetractTableSink().configure(fieldNames, (TypeInformation<?>[])fieldTypes);
        } else {
            throw new TableException(new StringBuilder(18).append("Unsupported sink: ").append(sink).toString());
        }
        return (T)object;
    }

    public String fieldToString(Object field, TimeZone tz) {
        Object object = field;
        boolean bl = object instanceof Date ? true : (object instanceof Time ? true : object instanceof Timestamp);
        String string = bl ? this.unixDateTimeToString(field, tz) : StringUtils.arrayAwareToString((Object)field);
        return string;
    }

    public String rowToString(Row row, TimeZone tz) {
        scala.collection.mutable.StringBuilder sb = package$.MODULE$.StringBuilder().newBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.getArity()).foreach((Function1 & Serializable & scala.Serializable)i -> TestSinkUtil$.$anonfun$rowToString$1(row, tz, sb, BoxesRunTime.unboxToInt((Object)i)));
        return sb.toString();
    }

    public TimeZone rowToString$default$2() {
        return TimeZone.getTimeZone("UTC");
    }

    public String genericRowToString(GenericRowData row, TimeZone tz) {
        scala.collection.mutable.StringBuilder sb = package$.MODULE$.StringBuilder().newBuilder();
        sb.append(row.getRowKind().shortString()).append("(");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.getArity()).foreach((Function1 & Serializable & scala.Serializable)i -> TestSinkUtil$.$anonfun$genericRowToString$1(row, tz, sb, BoxesRunTime.unboxToInt((Object)i)));
        sb.append(")");
        return sb.toString();
    }

    public String pojoToString(JavaPojos.Pojo1 pojo, TimeZone tz) {
        return new StringBuilder(18).append("Pojo1{ts=").append(this.fieldToString(pojo.ts, tz)).append(", msg='").append(pojo.msg).append("'}").toString();
    }

    public String unixDateTimeToString(Object value, TimeZone tz) {
        int offset = tz.useDaylightTime() ? tz.getOffset(((java.util.Date)value).getTime()) : tz.getOffset(15L);
        Object object = value;
        if (!(object instanceof java.util.Date)) {
            throw new MatchError(object);
        }
        long origin = ((java.util.Date)value).getTime();
        long l = origin + (long)DateTimeUtils.UTC_ZONE.getOffset(origin);
        long time = l;
        Object object2 = value;
        String string = object2 instanceof Date ? DateTimeUtils.unixDateToString((int)((int)(time / 86400000L) + offset)) : (object2 instanceof Time ? DateTimeUtils.unixTimeToString((int)(((int)(time % 86400000L) + offset) % (int)86400000L)) : (object2 instanceof Timestamp ? DateTimeUtils.unixTimestampToString((long)(time + (long)offset), (int)3) : value.toString()));
        return string;
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$rowToString$1(Row row$1, TimeZone tz$1, scala.collection.mutable.StringBuilder sb$1, int i) {
        Object object = i > 0 ? sb$1.append(",") : BoxedUnit.UNIT;
        return sb$1.append(MODULE$.fieldToString(row$1.getField(i), tz$1));
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$genericRowToString$1(GenericRowData row$2, TimeZone tz$2, scala.collection.mutable.StringBuilder sb$2, int i) {
        Object object = i > 0 ? sb$2.append(",") : BoxedUnit.UNIT;
        return sb$2.append(MODULE$.fieldToString(row$2.getField(i), tz$2));
    }

    private TestSinkUtil$() {
        MODULE$ = this;
    }
}

