/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.graph.GlobalStreamExchangeMode;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.utils.StreamExchangeModeUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamExchangeModeUtilsTest {
    StreamExchangeModeUtilsTest() {
    }

    @Test
    void testBatchStreamExchangeMode() {
        Configuration configuration = new Configuration();
        Assertions.assertThat((Comparable)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, null)).isEqualTo((Object)StreamExchangeMode.BATCH);
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_BLOCKING);
        Assertions.assertThat((Comparable)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, null)).isEqualTo((Object)StreamExchangeMode.BATCH);
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_HYBRID_FULL);
        Assertions.assertThat((Comparable)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, null)).isEqualTo((Object)StreamExchangeMode.HYBRID_FULL);
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_HYBRID_SELECTIVE);
        Assertions.assertThat((Comparable)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, null)).isEqualTo((Object)StreamExchangeMode.HYBRID_SELECTIVE);
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_PIPELINED);
        Assertions.assertThat((Comparable)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, null)).isEqualTo((Object)StreamExchangeMode.UNDEFINED);
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_PIPELINED);
        Assertions.assertThat((Comparable)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, (StreamExchangeMode)StreamExchangeMode.BATCH)).isEqualTo((Object)StreamExchangeMode.BATCH);
    }

    @Test
    void testBatchStreamExchangeModeLegacyPrecedence() {
        Configuration configuration = new Configuration();
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_PIPELINED);
        configuration.set(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, (Object)GlobalStreamExchangeMode.ALL_EDGES_BLOCKING.toString());
        Assertions.assertThat((Comparable)StreamExchangeModeUtils.getBatchStreamExchangeMode((ReadableConfig)configuration, null)).isEqualTo((Object)StreamExchangeMode.BATCH);
    }

    @Test
    void testLegacyShuffleMode() {
        Configuration configuration = new Configuration();
        configuration.set(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, (Object)GlobalStreamExchangeMode.ALL_EDGES_BLOCKING.toString());
        Assertions.assertThat((Comparable)((Comparable)StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new))).isEqualTo((Object)GlobalStreamExchangeMode.ALL_EDGES_BLOCKING);
        configuration.set(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, (Object)GlobalStreamExchangeMode.FORWARD_EDGES_PIPELINED.toString());
        Assertions.assertThat((Comparable)((Comparable)StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new))).isEqualTo((Object)GlobalStreamExchangeMode.FORWARD_EDGES_PIPELINED);
        configuration.set(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, (Object)GlobalStreamExchangeMode.POINTWISE_EDGES_PIPELINED.toString());
        Assertions.assertThat((Comparable)((Comparable)StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new))).isEqualTo((Object)GlobalStreamExchangeMode.POINTWISE_EDGES_PIPELINED);
        configuration.set(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, (Object)GlobalStreamExchangeMode.ALL_EDGES_PIPELINED.toString());
        Assertions.assertThat((Comparable)((Comparable)StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new))).isEqualTo((Object)GlobalStreamExchangeMode.ALL_EDGES_PIPELINED);
        configuration.set(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, (Object)"batch");
        Assertions.assertThat((Comparable)((Comparable)StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new))).isEqualTo((Object)GlobalStreamExchangeMode.ALL_EDGES_BLOCKING);
        configuration.set(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, (Object)"pipelined");
        Assertions.assertThat((Comparable)((Comparable)StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new))).isEqualTo((Object)GlobalStreamExchangeMode.ALL_EDGES_PIPELINED);
        configuration.set(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, (Object)"Forward_edges_PIPELINED");
        Assertions.assertThat((Comparable)((Comparable)StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration).orElseThrow(AssertionError::new))).isEqualTo((Object)GlobalStreamExchangeMode.FORWARD_EDGES_PIPELINED);
    }

    @Test
    void testInvalidLegacyShuffleMode() {
        Configuration configuration = new Configuration();
        configuration.set(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, (Object)"invalid-value");
        Assertions.assertThatThrownBy(() -> StreamExchangeModeUtils.getGlobalStreamExchangeMode((ReadableConfig)configuration)).isInstanceOf(IllegalArgumentException.class);
    }
}

