/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.SqlTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.table.test.program.TableTestProgramRunner;
import org.apache.flink.table.test.program.TestStep;
import org.apache.flink.table.utils.UserDefinedFunctions;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TableTestProgramRunnerTest {
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";

    @Test
    void testConfigStep() {
        TableTestProgram program = TableTestProgram.of((String)ID, (String)DESCRIPTION).setupConfig(TableConfigOptions.LOCAL_TIME_ZONE, (Object)"GMT+3").build();
        Assertions.assertThat((List)program.setupSteps).hasSize(1);
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        program.getSetupConfigOptionTestSteps().forEach(s -> s.apply(env));
        Assertions.assertThat((Object)env.getConfig().getLocalTimeZone()).isEqualTo((Object)ZoneId.of("GMT+3"));
    }

    @Test
    void testFunctionStep() {
        TableTestProgram program = TableTestProgram.of((String)ID, (String)DESCRIPTION).setupTemporarySystemFunction("tmp_sys", UserDefinedFunctions.ScalarUDF.class).setupTemporaryCatalogFunction("tmp_cat", UserDefinedFunctions.ScalarUDF.class).setupCatalogFunction("cat", UserDefinedFunctions.ScalarUDF.class).build();
        Assertions.assertThat((List)program.setupSteps).hasSize(3);
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        program.getSetupFunctionTestSteps().forEach(s -> s.apply(env));
        Assertions.assertThat((Object[])env.listUserDefinedFunctions()).contains((Object[])new String[]{"tmp_sys", "tmp_cat", "cat"});
    }

    @Test
    void testSqlStep() {
        TableTestProgram program = TableTestProgram.of((String)ID, (String)DESCRIPTION).setupSql("CREATE TABLE MyTable1 (i INT) WITH ('connector' = 'datagen')").runSql("CREATE TABLE MyTable2 (i INT) WITH ('connector' = 'datagen')").build();
        Assertions.assertThat((List)program.setupSteps).hasSize(1);
        Assertions.assertThat((List)program.runSteps).hasSize(1);
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        program.setupSteps.stream().map(SqlTestStep.class::cast).forEach(s -> s.apply(env));
        program.runSteps.stream().map(SqlTestStep.class::cast).forEach(s -> s.apply(env));
        Assertions.assertThat((Object[])env.listTables()).contains((Object[])new String[]{"MyTable1", "MyTable2"});
    }

    @Test
    void testTableStep() {
        TableTestProgram program = TableTestProgram.of((String)ID, (String)DESCRIPTION).setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"MyTableSource").addSchema(new String[]{"i INT"})).addOption("connector", "datagen")).build()).setupTableSink(((SinkTestStep.Builder)((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MyTableSink").addSchema(new String[]{"i INT"})).addOption("connector", "blackhole")).build()).build();
        Assertions.assertThat((List)program.setupSteps).hasSize(2);
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        program.getSetupSourceTestSteps().forEach(s -> s.apply(env, Collections.singletonMap("number-of-rows", "3")));
        program.getSetupSinkTestSteps().forEach(s -> s.apply(env));
        Assertions.assertThat((Object)((Row)env.executeSql("SHOW CREATE TABLE MyTableSource").collect().next()).getField(0)).isEqualTo((Object)"CREATE TABLE `default_catalog`.`default_database`.`MyTableSource` (\n  `i` INT\n) WITH (\n  'connector' = 'datagen',\n  'number-of-rows' = '3'\n)\n");
        Assertions.assertThat((Object)((Row)env.executeSql("SHOW CREATE TABLE MyTableSink").collect().next()).getField(0)).isEqualTo((Object)"CREATE TABLE `default_catalog`.`default_database`.`MyTableSink` (\n  `i` INT\n) WITH (\n  'connector' = 'blackhole'\n)\n");
    }

    @Test
    void testRunnerValidationDuplicate() {
        TableTestProgram program1 = TableTestProgram.of((String)ID, (String)DESCRIPTION).runSql("SELECT 1").build();
        TableTestProgram program2 = TableTestProgram.of((String)ID, (String)DESCRIPTION).runSql("SELECT 1").build();
        LimitedTableTestProgramRunner runner = new LimitedTableTestProgramRunner();
        runner.programs = Arrays.asList(program1, program2);
        Assertions.assertThatThrownBy(() -> ((LimitedTableTestProgramRunner)runner).supportedPrograms()).hasMessageContaining("Duplicate test program id found: [id]");
    }

    @Test
    void testRunnerValidationUnsupported() {
        LimitedTableTestProgramRunner runner = new LimitedTableTestProgramRunner();
        TableTestProgram program = TableTestProgram.of((String)ID, (String)DESCRIPTION).setupSql("SELECT 1").build();
        runner.programs = Collections.singletonList(program);
        Assertions.assertThatThrownBy(() -> ((LimitedTableTestProgramRunner)runner).supportedPrograms()).hasMessageContaining("Test runner does not support setup step: SQL");
    }

    private static class LimitedTableTestProgramRunner
    implements TableTestProgramRunner {
        List<TableTestProgram> programs;

        private LimitedTableTestProgramRunner() {
        }

        public List<TableTestProgram> programs() {
            return this.programs;
        }

        public EnumSet<TestStep.TestKind> supportedSetupSteps() {
            return EnumSet.of(TestStep.TestKind.SOURCE_WITH_DATA);
        }

        public EnumSet<TestStep.TestKind> supportedRunSteps() {
            return EnumSet.of(TestStep.TestKind.SQL);
        }
    }
}

