/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.filesystem.PartitionComputer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class RowDataPartitionComputer
implements PartitionComputer<RowData> {
    private static final long serialVersionUID = 1L;
    protected final String defaultPartValue;
    protected final String[] partitionColumns;
    protected final int[] partitionIndexes;
    protected final LogicalType[] partitionTypes;
    private final int[] nonPartitionIndexes;
    private final LogicalType[] nonPartitionTypes;
    private transient GenericRowData reuseRow;

    public RowDataPartitionComputer(String defaultPartValue, String[] columnNames, DataType[] columnTypes, String[] partitionColumns) {
        this.defaultPartValue = defaultPartValue;
        this.partitionColumns = partitionColumns;
        List<String> columnList = Arrays.asList(columnNames);
        List columnTypeList = Arrays.stream(columnTypes).map(DataType::getLogicalType).collect(Collectors.toList());
        this.partitionIndexes = Arrays.stream(partitionColumns).mapToInt(columnList::indexOf).toArray();
        this.partitionTypes = (LogicalType[])Arrays.stream(this.partitionIndexes).mapToObj(columnTypeList::get).toArray(LogicalType[]::new);
        List partitionIndexList = Arrays.stream(this.partitionIndexes).boxed().collect(Collectors.toList());
        this.nonPartitionIndexes = IntStream.range(0, columnNames.length).filter(c -> !partitionIndexList.contains(c)).toArray();
        this.nonPartitionTypes = (LogicalType[])Arrays.stream(this.nonPartitionIndexes).mapToObj(columnTypeList::get).toArray(LogicalType[]::new);
    }

    @Override
    public LinkedHashMap<String, String> generatePartValues(RowData in) {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionIndexes.length; ++i) {
            String partitionValue;
            Object field = RowData.get((RowData)in, (int)this.partitionIndexes[i], (LogicalType)this.partitionTypes[i]);
            String string = partitionValue = field != null ? field.toString() : null;
            if (partitionValue == null || "".equals(partitionValue)) {
                partitionValue = this.defaultPartValue;
            }
            partSpec.put(this.partitionColumns[i], partitionValue);
        }
        return partSpec;
    }

    @Override
    public RowData projectColumnsToWrite(RowData in) {
        if (this.partitionIndexes.length == 0) {
            return in;
        }
        if (this.reuseRow == null) {
            this.reuseRow = new GenericRowData(this.nonPartitionIndexes.length);
        }
        for (int i = 0; i < this.nonPartitionIndexes.length; ++i) {
            this.reuseRow.setField(i, RowData.get((RowData)in, (int)this.nonPartitionIndexes[i], (LogicalType)this.nonPartitionTypes[i]));
        }
        return this.reuseRow;
    }
}

