/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

class DeduplicateFunctionHelper {
    static void processLastRow(RowData currentRow, boolean generateUpdateBefore, boolean generateInsert, ValueState<RowData> state, Collector<RowData> out) throws Exception {
        Preconditions.checkArgument((currentRow.getRowKind() == RowKind.INSERT ? 1 : 0) != 0);
        if (generateUpdateBefore || generateInsert) {
            RowData preRow = (RowData)state.value();
            state.update((Object)currentRow);
            if (preRow == null) {
                currentRow.setRowKind(RowKind.INSERT);
                out.collect((Object)currentRow);
            } else {
                if (generateUpdateBefore) {
                    preRow.setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect((Object)preRow);
                }
                currentRow.setRowKind(RowKind.UPDATE_AFTER);
                out.collect((Object)currentRow);
            }
        } else {
            currentRow.setRowKind(RowKind.UPDATE_AFTER);
            out.collect((Object)currentRow);
        }
    }

    static void processFirstRow(RowData currentRow, ValueState<Boolean> state, Collector<RowData> out) throws Exception {
        Preconditions.checkArgument((currentRow.getRowKind() == RowKind.INSERT ? 1 : 0) != 0);
        if (state.value() != null) {
            return;
        }
        state.update((Object)true);
        out.collect((Object)currentRow);
    }

    private DeduplicateFunctionHelper() {
    }
}

