/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.types.logical.RowType;

public abstract class UnboundedFollowingOverFrame
implements OverWindowFrame {
    private GeneratedAggsHandleFunction aggsHandleFunction;
    private final RowType valueType;
    private AggsHandleFunction processor;
    private RowData accValue;
    ResettableExternalBuffer input;
    private RowDataSerializer valueSer;
    int inputIndex = 0;

    public UnboundedFollowingOverFrame(RowType valueType, GeneratedAggsHandleFunction aggsHandleFunction) {
        this.valueType = valueType;
        this.aggsHandleFunction = aggsHandleFunction;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        ClassLoader cl = ctx.getRuntimeContext().getUserCodeClassLoader();
        this.processor = (AggsHandleFunction)this.aggsHandleFunction.newInstance(cl);
        this.processor.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.aggsHandleFunction = null;
        this.valueSer = new RowDataSerializer(ctx.getRuntimeContext().getExecutionConfig(), this.valueType);
    }

    @Override
    public void prepare(ResettableExternalBuffer rows) throws Exception {
        this.input = rows;
        this.processor.setAccumulators(this.processor.createAccumulators());
        this.inputIndex = 0;
    }

    RowData accumulateIterator(boolean bufferUpdated, BinaryRowData firstRow, ResettableExternalBuffer.BufferIterator iterator) throws Exception {
        if (bufferUpdated) {
            this.processor.setAccumulators(this.processor.createAccumulators());
            if (firstRow != null) {
                this.processor.accumulate((RowData)firstRow);
            }
            while (iterator.advanceNext()) {
                this.processor.accumulate((RowData)iterator.getRow());
            }
            this.accValue = this.valueSer.copy(this.processor.getValue());
        }
        iterator.close();
        return this.accValue;
    }
}

