/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink;

import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;

public class SinkOperator
extends AbstractUdfStreamOperator<Object, SinkFunction<RowData>>
implements OneInputStreamOperator<RowData, Object> {
    private static final long serialVersionUID = 1L;
    private final int rowtimeFieldIndex;
    private final int[] notNullFieldIndices;
    private final String[] allFieldNames;
    private final ExecutionConfigOptions.NotNullEnforcer notNullEnforcer;
    private final boolean notNullCheck;
    private transient SimpleContext sinkContext;
    private long currentWatermark = Long.MIN_VALUE;

    public SinkOperator(SinkFunction<RowData> sinkFunction, int rowtimeFieldIndex, ExecutionConfigOptions.NotNullEnforcer notNullEnforcer, int[] notNullFieldIndices, String[] allFieldNames) {
        super(sinkFunction);
        this.rowtimeFieldIndex = rowtimeFieldIndex;
        this.notNullFieldIndices = notNullFieldIndices;
        this.notNullEnforcer = notNullEnforcer;
        this.notNullCheck = notNullFieldIndices.length > 0;
        this.allFieldNames = allFieldNames;
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void open() throws Exception {
        super.open();
        this.sinkContext = new SimpleContext(this.getProcessingTimeService());
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        this.sinkContext.element = element;
        RowData row = (RowData)element.getValue();
        if (this.notNullCheck && this.failOrFilterNullValues(row)) {
            return;
        }
        ((SinkFunction)this.userFunction).invoke((Object)row, (SinkFunction.Context)this.sinkContext);
    }

    private boolean failOrFilterNullValues(RowData row) {
        for (int index : this.notNullFieldIndices) {
            if (!row.isNullAt(index)) continue;
            if (this.notNullEnforcer == ExecutionConfigOptions.NotNullEnforcer.ERROR) {
                String optionKey = ExecutionConfigOptions.TABLE_EXEC_SINK_NOT_NULL_ENFORCER.key();
                throw new TableException(String.format("Column '%s' is NOT NULL, however, a null value is being written into it. You can set job configuration '" + optionKey + "'='drop' to suppress this exception and drop such records silently.", this.allFieldNames[index]));
            }
            return true;
        }
        return false;
    }

    protected void reportOrForwardLatencyMarker(LatencyMarker marker) {
        this.latencyStats.reportLatency(marker);
    }

    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    private class SimpleContext
    implements SinkFunction.Context<RowData> {
        private StreamRecord<RowData> element;
        private final ProcessingTimeService processingTimeService;

        public SimpleContext(ProcessingTimeService processingTimeService) {
            this.processingTimeService = processingTimeService;
        }

        public long currentProcessingTime() {
            return this.processingTimeService.getCurrentProcessingTime();
        }

        public long currentWatermark() {
            return SinkOperator.this.currentWatermark;
        }

        public Long timestamp() {
            if (SinkOperator.this.rowtimeFieldIndex > 0) {
                return ((RowData)this.element.getValue()).getLong(SinkOperator.this.rowtimeFieldIndex);
            }
            return null;
        }
    }
}

