/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.types;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BooleanSerializer;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.ShortSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.table.runtime.typeutils.DecimalDataSerializer;
import org.apache.flink.table.runtime.typeutils.MapDataSerializer;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.typeutils.StringDataSerializer;
import org.apache.flink.table.runtime.typeutils.TimestampDataSerializer;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

public class InternalSerializers {
    public static TypeSerializer<?> create(LogicalType type) {
        return InternalSerializers.create(type, new ExecutionConfig());
    }

    public static TypeSerializer create(LogicalType type, ExecutionConfig config) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return StringDataSerializer.INSTANCE;
            }
            case BOOLEAN: {
                return BooleanSerializer.INSTANCE;
            }
            case BINARY: 
            case VARBINARY: {
                return BytePrimitiveArraySerializer.INSTANCE;
            }
            case DECIMAL: {
                return new DecimalDataSerializer(LogicalTypeChecks.getPrecision((LogicalType)type), LogicalTypeChecks.getScale((LogicalType)type));
            }
            case TINYINT: {
                return ByteSerializer.INSTANCE;
            }
            case SMALLINT: {
                return ShortSerializer.INSTANCE;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return IntSerializer.INSTANCE;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return LongSerializer.INSTANCE;
            }
            case FLOAT: {
                return FloatSerializer.INSTANCE;
            }
            case DOUBLE: {
                return DoubleSerializer.INSTANCE;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new TimestampDataSerializer(LogicalTypeChecks.getPrecision((LogicalType)type));
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                throw new UnsupportedOperationException();
            }
            case ARRAY: {
                return new ArrayDataSerializer(((ArrayType)type).getElementType(), config);
            }
            case MULTISET: {
                return new MapDataSerializer(((MultisetType)type).getElementType(), (LogicalType)new IntType(false), config);
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return new MapDataSerializer(mapType.getKeyType(), mapType.getValueType(), config);
            }
            case ROW: 
            case STRUCTURED_TYPE: {
                return new RowDataSerializer(config, type.getChildren().toArray(new LogicalType[0]));
            }
            case DISTINCT_TYPE: {
                return InternalSerializers.create(((DistinctType)type).getSourceType(), config);
            }
            case RAW: {
                if (type instanceof RawType) {
                    RawType rawType = (RawType)type;
                    return new RawValueDataSerializer(rawType.getTypeSerializer());
                }
                return new RawValueDataSerializer(((TypeInformationRawType)type).getTypeInformation().createSerializer(config));
            }
        }
        throw new UnsupportedOperationException("Unsupported type '" + type + "' to get internal serializer");
    }
}

