/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.NestedSerializersSnapshotDelegate;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.data.writer.BinaryWriter;
import org.apache.flink.table.runtime.types.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class RowDataSerializer
extends AbstractRowDataSerializer<RowData> {
    private static final long serialVersionUID = 1L;
    private BinaryRowDataSerializer binarySerializer;
    private final LogicalType[] types;
    private final TypeSerializer[] fieldSerializers;
    private transient BinaryRowData reuseRow;
    private transient BinaryRowWriter reuseWriter;

    public RowDataSerializer(ExecutionConfig config, RowType rowType) {
        this(rowType.getChildren().toArray(new LogicalType[0]), (TypeSerializer[])rowType.getChildren().stream().map(type -> InternalSerializers.create(type, config)).toArray(TypeSerializer[]::new));
    }

    public RowDataSerializer(ExecutionConfig config, LogicalType ... types) {
        this(types, (TypeSerializer[])Arrays.stream(types).map(type -> InternalSerializers.create(type, config)).toArray(TypeSerializer[]::new));
    }

    public RowDataSerializer(LogicalType[] types, TypeSerializer<?>[] fieldSerializers) {
        this.types = types;
        this.fieldSerializers = fieldSerializers;
        this.binarySerializer = new BinaryRowDataSerializer(types.length);
    }

    public TypeSerializer<RowData> duplicate() {
        TypeSerializer[] duplicateFieldSerializers = new TypeSerializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
        }
        return new RowDataSerializer(this.types, duplicateFieldSerializers);
    }

    public RowData createInstance() {
        return new BinaryRowData(this.types.length);
    }

    public void serialize(RowData row, DataOutputView target) throws IOException {
        this.binarySerializer.serialize(this.toBinaryRow(row), target);
    }

    public RowData deserialize(DataInputView source) throws IOException {
        return this.binarySerializer.deserialize(source);
    }

    public RowData deserialize(RowData reuse, DataInputView source) throws IOException {
        if (reuse instanceof BinaryRowData) {
            return this.binarySerializer.deserialize((BinaryRowData)reuse, source);
        }
        return this.binarySerializer.deserialize(source);
    }

    public RowData copy(RowData from) {
        if (from.getArity() != this.types.length) {
            throw new IllegalArgumentException("Row arity: " + from.getArity() + ", but serializer arity: " + this.types.length);
        }
        if (from instanceof BinaryRowData) {
            return ((BinaryRowData)from).copy();
        }
        return this.copyRowData(from, (RowData)new GenericRowData(from.getArity()));
    }

    public RowData copy(RowData from, RowData reuse) {
        if (from.getArity() != this.types.length || reuse.getArity() != this.types.length) {
            throw new IllegalArgumentException("Row arity: " + from.getArity() + ", reuse Row arity: " + reuse.getArity() + ", but serializer arity: " + this.types.length);
        }
        if (from instanceof BinaryRowData) {
            return reuse instanceof BinaryRowData ? ((BinaryRowData)from).copy((BinaryRowData)reuse) : ((BinaryRowData)from).copy();
        }
        return this.copyRowData(from, reuse);
    }

    private RowData copyRowData(RowData from, RowData reuse) {
        GenericRowData ret = reuse instanceof GenericRowData ? (GenericRowData)reuse : new GenericRowData(from.getArity());
        ret.setRowKind(from.getRowKind());
        for (int i = 0; i < from.getArity(); ++i) {
            if (!from.isNullAt(i)) {
                ret.setField(i, this.fieldSerializers[i].copy(RowData.get((RowData)from, (int)i, (LogicalType)this.types[i])));
                continue;
            }
            ret.setField(i, null);
        }
        return ret;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.binarySerializer.copy(source, target);
    }

    @Override
    public int getArity() {
        return this.types.length;
    }

    @Override
    public BinaryRowData toBinaryRow(RowData row) {
        if (row instanceof BinaryRowData) {
            return (BinaryRowData)row;
        }
        if (this.reuseRow == null) {
            this.reuseRow = new BinaryRowData(this.types.length);
            this.reuseWriter = new BinaryRowWriter(this.reuseRow);
        }
        this.reuseWriter.reset();
        this.reuseWriter.writeRowKind(row.getRowKind());
        for (int i = 0; i < this.types.length; ++i) {
            if (row.isNullAt(i)) {
                this.reuseWriter.setNullAt(i);
                continue;
            }
            BinaryWriter.write(this.reuseWriter, i, RowData.get((RowData)row, (int)i, (LogicalType)this.types[i]), this.types[i], this.fieldSerializers[i]);
        }
        this.reuseWriter.complete();
        return this.reuseRow;
    }

    @Override
    public int serializeToPages(RowData row, AbstractPagedOutputView target) throws IOException {
        return this.binarySerializer.serializeToPages(this.toBinaryRow(row), target);
    }

    @Override
    public RowData deserializeFromPages(AbstractPagedInputView source) throws IOException {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public RowData deserializeFromPages(RowData reuse, AbstractPagedInputView source) throws IOException {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public RowData mapFromPages(AbstractPagedInputView source) throws IOException {
        return this.binarySerializer.mapFromPages(source);
    }

    @Override
    public RowData mapFromPages(RowData reuse, AbstractPagedInputView source) throws IOException {
        if (reuse instanceof BinaryRowData) {
            return this.binarySerializer.mapFromPages((BinaryRowData)reuse, source);
        }
        throw new UnsupportedOperationException("Not support!");
    }

    public boolean equals(Object obj) {
        if (obj instanceof RowDataSerializer) {
            RowDataSerializer other = (RowDataSerializer)((Object)obj);
            return Arrays.equals(this.types, other.types);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.types);
    }

    public boolean isImmutableType() {
        return false;
    }

    public int getLength() {
        return -1;
    }

    public TypeSerializerSnapshot<RowData> snapshotConfiguration() {
        return new RowDataSerializerSnapshot(this.types, this.fieldSerializers);
    }

    public static final class RowDataSerializerSnapshot
    implements TypeSerializerSnapshot<RowData> {
        private static final int CURRENT_VERSION = 3;
        private LogicalType[] previousTypes;
        private NestedSerializersSnapshotDelegate nestedSerializersSnapshotDelegate;

        public RowDataSerializerSnapshot() {
        }

        RowDataSerializerSnapshot(LogicalType[] types, TypeSerializer[] serializers) {
            this.previousTypes = types;
            this.nestedSerializersSnapshotDelegate = new NestedSerializersSnapshotDelegate(serializers);
        }

        public int getCurrentVersion() {
            return 3;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.previousTypes.length);
            DataOutputViewStream stream = new DataOutputViewStream(out);
            for (LogicalType previousType : this.previousTypes) {
                InstantiationUtil.serializeObject((OutputStream)stream, (Object)previousType);
            }
            this.nestedSerializersSnapshotDelegate.writeNestedSerializerSnapshots(out);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            int length = in.readInt();
            DataInputViewStream stream = new DataInputViewStream(in);
            this.previousTypes = new LogicalType[length];
            for (int i = 0; i < length; ++i) {
                try {
                    this.previousTypes[i] = (LogicalType)InstantiationUtil.deserializeObject((InputStream)stream, (ClassLoader)userCodeClassLoader);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
            this.nestedSerializersSnapshotDelegate = NestedSerializersSnapshotDelegate.readNestedSerializerSnapshots((DataInputView)in, (ClassLoader)userCodeClassLoader);
        }

        public RowDataSerializer restoreSerializer() {
            return new RowDataSerializer(this.previousTypes, this.nestedSerializersSnapshotDelegate.getRestoredNestedSerializers());
        }

        public TypeSerializerSchemaCompatibility<RowData> resolveSchemaCompatibility(TypeSerializer<RowData> newSerializer) {
            if (!(newSerializer instanceof RowDataSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            RowDataSerializer newRowSerializer = (RowDataSerializer)newSerializer;
            if (!Arrays.equals(this.previousTypes, newRowSerializer.types)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializer[])newRowSerializer.fieldSerializers, (TypeSerializerSnapshot[])this.nestedSerializersSnapshotDelegate.getNestedSerializerSnapshots());
            if (intermediateResult.isCompatibleWithReconfiguredSerializer()) {
                RowDataSerializer reconfiguredCompositeSerializer = this.restoreSerializer();
                return TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer((TypeSerializer)reconfiguredCompositeSerializer);
            }
            return intermediateResult.getFinalResult();
        }
    }
}

