/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.calcite.materialize.Lattices;
import org.apache.calcite.materialize.TileSuggester;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.schema.impl.StarTable;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.graph.DirectedGraph;
import org.apache.calcite.util.graph.TopologicalOrderIterator;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableListMultimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;
import org.apache.flink.calcite.shaded.com.google.common.collect.Ordering;

public class Lattice {
    public final CalciteSchema rootSchema;
    public final ImmutableList<Node> nodes;
    public final ImmutableList<Column> columns;
    public final boolean auto;
    public final boolean algorithm;
    public final long algorithmMaxMillis;
    public final double rowCountEstimate;
    public final ImmutableList<Measure> defaultMeasures;
    public final ImmutableList<Tile> tiles;
    public final ImmutableList<String> uniqueColumnNames;
    public final LatticeStatisticProvider statisticProvider;

    private Lattice(CalciteSchema rootSchema, ImmutableList<Node> nodes, boolean auto, boolean algorithm, long algorithmMaxMillis, LatticeStatisticProvider.Factory statisticProviderFactory, Double rowCountEstimate, ImmutableList<Column> columns, ImmutableList<Measure> defaultMeasures, ImmutableList<Tile> tiles) {
        this.rootSchema = rootSchema;
        this.nodes = Objects.requireNonNull(nodes);
        this.columns = Objects.requireNonNull(columns);
        this.auto = auto;
        this.algorithm = algorithm;
        this.algorithmMaxMillis = algorithmMaxMillis;
        this.defaultMeasures = Objects.requireNonNull(defaultMeasures);
        this.tiles = Objects.requireNonNull(tiles);
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            if (i == 0 ? !$assertionsDisabled && node.parent != null : !$assertionsDisabled && !((ImmutableList)nodes.subList(0, i)).contains(node.parent)) {
                throw new AssertionError();
            }
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (Column column : columns) {
            nameList.add(column.alias);
        }
        this.uniqueColumnNames = ImmutableList.copyOf(SqlValidatorUtil.uniquify(Lists.transform(columns, input -> input.alias), true));
        if (rowCountEstimate == null) {
            rowCountEstimate = 1000.0;
        }
        Preconditions.checkArgument(rowCountEstimate > 0.0);
        this.rowCountEstimate = rowCountEstimate;
        this.statisticProvider = (LatticeStatisticProvider)Objects.requireNonNull(statisticProviderFactory.apply(this));
    }

    public static Lattice create(CalciteSchema schema2, String sql, boolean auto) {
        return Lattice.builder(schema2, sql).auto(auto).build();
    }

    private static void populateAliases(SqlNode from, List<String> aliases, String current) {
        if (from instanceof SqlJoin) {
            SqlJoin join = (SqlJoin)from;
            Lattice.populateAliases(join.getLeft(), aliases, null);
            Lattice.populateAliases(join.getRight(), aliases, null);
        } else if (from.getKind() == SqlKind.AS) {
            Lattice.populateAliases(SqlUtil.stripAs(from), aliases, SqlValidatorUtil.getAlias(from, -1));
        } else {
            if (current == null) {
                current = SqlValidatorUtil.getAlias(from, -1);
            }
            aliases.add(current);
        }
    }

    private static boolean populate(List<RelNode> nodes, List<int[][]> tempLinks, RelNode rel) {
        if (nodes.isEmpty() && rel instanceof LogicalProject) {
            return Lattice.populate(nodes, tempLinks, ((LogicalProject)rel).getInput());
        }
        if (rel instanceof TableScan) {
            nodes.add(rel);
            return true;
        }
        if (rel instanceof LogicalJoin) {
            LogicalJoin join = (LogicalJoin)rel;
            if (join.getJoinType() != JoinRelType.INNER) {
                throw new RuntimeException("only inner join allowed, but got " + (Object)((Object)join.getJoinType()));
            }
            Lattice.populate(nodes, tempLinks, join.getLeft());
            Lattice.populate(nodes, tempLinks, join.getRight());
            for (RexNode rex : RelOptUtil.conjunctions(join.getCondition())) {
                tempLinks.add(Lattice.grab(nodes, rex));
            }
            return true;
        }
        throw new RuntimeException("Invalid node type " + rel.getClass().getSimpleName() + " in lattice query");
    }

    private static int[][] grab(List<RelNode> leaves, RexNode rex) {
        switch (rex.getKind()) {
            case EQUALS: {
                break;
            }
            default: {
                throw new AssertionError((Object)"only equi-join allowed");
            }
        }
        List<RexNode> operands = ((RexCall)rex).getOperands();
        return new int[][]{Lattice.inputField(leaves, operands.get(0)), Lattice.inputField(leaves, operands.get(1))};
    }

    private static int[] inputField(List<RelNode> leaves, RexNode rex) {
        if (!(rex instanceof RexInputRef)) {
            throw new RuntimeException("only equi-join of columns allowed: " + rex);
        }
        RexInputRef ref = (RexInputRef)rex;
        int start = 0;
        for (int i = 0; i < leaves.size(); ++i) {
            RelNode leaf = leaves.get(i);
            int end = start + leaf.getRowType().getFieldCount();
            if (ref.getIndex() < end) {
                return new int[]{i, ref.getIndex() - start};
            }
            start = end;
        }
        throw new AssertionError((Object)"input not found");
    }

    public String sql(ImmutableBitSet groupSet, List<Measure> aggCallList) {
        return this.sql(groupSet, true, aggCallList);
    }

    public String sql(ImmutableBitSet groupSet, boolean group, List<Measure> aggCallList) {
        ArrayList<Node> usedNodes = new ArrayList<Node>();
        if (group) {
            ImmutableBitSet.Builder columnSetBuilder = groupSet.rebuild();
            for (Measure measure : aggCallList) {
                for (Column arg : measure.args) {
                    columnSetBuilder.set(arg.ordinal);
                }
            }
            ImmutableBitSet columnSet = columnSetBuilder.build();
            for (Node node : this.nodes) {
                if (!ImmutableBitSet.range(node.startCol, node.endCol).intersects(columnSet)) continue;
                Lattice.use(usedNodes, node);
            }
            if (usedNodes.isEmpty()) {
                usedNodes.add((Node)this.nodes.get(0));
            }
        } else {
            usedNodes.addAll(this.nodes);
        }
        SqlDialect dialect = SqlDialect.DatabaseProduct.CALCITE.getDialect();
        StringBuilder buf = new StringBuilder("SELECT ");
        StringBuilder stringBuilder = new StringBuilder("\nGROUP BY ");
        int k = 0;
        HashSet<String> columnNames = new HashSet<String>();
        if (groupSet != null) {
            for (int i : groupSet) {
                if (k++ > 0) {
                    buf.append(", ");
                    stringBuilder.append(", ");
                }
                Column column = (Column)this.columns.get(i);
                dialect.quoteIdentifier(buf, column.identifiers());
                dialect.quoteIdentifier(stringBuilder, column.identifiers());
                String fieldName = (String)this.uniqueColumnNames.get(i);
                columnNames.add(fieldName);
                if (column.alias.equals(fieldName)) continue;
                buf.append(" AS ");
                dialect.quoteIdentifier(buf, fieldName);
            }
            if (groupSet.isEmpty()) {
                stringBuilder.append("()");
            }
            int m = 0;
            for (Measure measure : aggCallList) {
                String measureName;
                if (k++ > 0) {
                    buf.append(", ");
                }
                buf.append(measure.agg.getName()).append("(");
                if (measure.args.isEmpty()) {
                    buf.append("*");
                } else {
                    int z = 0;
                    for (Column arg : measure.args) {
                        if (z++ > 0) {
                            buf.append(", ");
                        }
                        dialect.quoteIdentifier(buf, arg.identifiers());
                    }
                }
                buf.append(") AS ");
                while (!columnNames.add(measureName = "m" + m)) {
                    ++m;
                }
                dialect.quoteIdentifier(buf, measureName);
            }
        } else {
            buf.append("*");
        }
        buf.append("\nFROM ");
        for (Node node : usedNodes) {
            if (node.parent != null) {
                buf.append("\nJOIN ");
            }
            dialect.quoteIdentifier(buf, node.scan.getTable().getQualifiedName());
            buf.append(" AS ");
            dialect.quoteIdentifier(buf, node.alias);
            if (node.parent == null) continue;
            buf.append(" ON ");
            k = 0;
            for (IntPair pair : node.link) {
                if (k++ > 0) {
                    buf.append(" AND ");
                }
                Column left = (Column)this.columns.get(node.parent.startCol + pair.source);
                dialect.quoteIdentifier(buf, left.identifiers());
                buf.append(" = ");
                Column right = (Column)this.columns.get(node.startCol + pair.target);
                dialect.quoteIdentifier(buf, right.identifiers());
            }
        }
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println("Lattice SQL:\n" + buf);
        }
        if (group) {
            buf.append((CharSequence)stringBuilder);
        }
        return buf.toString();
    }

    public String countSql(ImmutableBitSet groupSet) {
        return "select count(*) as c from (" + this.sql(groupSet, ImmutableList.of()) + ")";
    }

    private static void use(List<Node> usedNodes, Node node) {
        if (!usedNodes.contains(node)) {
            if (node.parent != null) {
                Lattice.use(usedNodes, node.parent);
            }
            usedNodes.add(node);
        }
    }

    public StarTable createStarTable() {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Node node : this.nodes) {
            tables.add(node.scan.getTable().unwrap(Table.class));
        }
        return StarTable.of(this, tables);
    }

    public static Builder builder(CalciteSchema calciteSchema, String sql) {
        return new Builder(calciteSchema, sql);
    }

    public List<Measure> toMeasures(List<AggregateCall> aggCallList) {
        return Lists.transform(aggCallList, call -> new Measure(call.getAggregation(), Lists.transform(call.getArgList(), this.columns::get)));
    }

    public Iterable<? extends Tile> computeTiles() {
        if (!this.algorithm) {
            return this.tiles;
        }
        return new TileSuggester(this).tiles();
    }

    public double getFactRowCount() {
        return this.rowCountEstimate;
    }

    public double getRowCount(List<Column> columns) {
        return this.statisticProvider.cardinality(columns);
    }

    public static double getRowCount(double factCount, double ... columnCounts) {
        return Lattice.getRowCount(factCount, Primitive.asList(columnCounts));
    }

    public static double getRowCount(double factCount, List<Double> columnCounts) {
        double n = 1.0;
        for (Double columnCount : columnCounts) {
            if (!(columnCount > 1.0)) continue;
            n *= columnCount.doubleValue();
        }
        double a = (n - 1.0) / n;
        if (a == 1.0) {
            return factCount;
        }
        double v = n * (1.0 - Math.pow(a, factCount));
        return Math.min(v, factCount);
    }

    public static class TileBuilder {
        private final List<Measure> measureBuilder = new ArrayList<Measure>();
        private final List<Column> dimensionListBuilder = new ArrayList<Column>();

        public Tile build() {
            return new Tile(Ordering.natural().immutableSortedCopy(this.measureBuilder), Ordering.natural().immutableSortedCopy(this.dimensionListBuilder));
        }

        public void addMeasure(Measure measure) {
            this.measureBuilder.add(measure);
        }

        public void addDimension(Column column) {
            this.dimensionListBuilder.add(column);
        }
    }

    public static class Tile {
        public final ImmutableList<Measure> measures;
        public final ImmutableList<Column> dimensions;
        public final ImmutableBitSet bitSet;

        public Tile(ImmutableList<Measure> measures, ImmutableList<Column> dimensions) {
            this.measures = Objects.requireNonNull(measures);
            this.dimensions = Objects.requireNonNull(dimensions);
            assert (Ordering.natural().isStrictlyOrdered(dimensions));
            assert (Ordering.natural().isStrictlyOrdered(measures));
            this.bitSet = Column.toBitSet(dimensions);
        }

        public static TileBuilder builder() {
            return new TileBuilder();
        }

        public ImmutableBitSet bitSet() {
            return this.bitSet;
        }
    }

    public static class Builder {
        private final List<Node> nodes = new ArrayList<Node>();
        private final ImmutableList<Column> columns;
        private final ImmutableListMultimap<String, Column> columnsByAlias;
        private final ImmutableList.Builder<Measure> defaultMeasureListBuilder = ImmutableList.builder();
        private final ImmutableList.Builder<Tile> tileListBuilder = ImmutableList.builder();
        private final CalciteSchema rootSchema;
        private boolean algorithm = false;
        private long algorithmMaxMillis = -1L;
        private boolean auto = true;
        private Double rowCountEstimate;
        private String statisticProvider;

        public Builder(CalciteSchema schema2, String sql) {
            this.rootSchema = Objects.requireNonNull(schema2.root());
            Preconditions.checkArgument(this.rootSchema.isRoot(), "must be root schema");
            CalcitePrepare.ConvertResult parsed = Schemas.convert(MaterializedViewTable.MATERIALIZATION_CONNECTION, schema2, schema2.path(null), sql);
            ArrayList relNodes = new ArrayList();
            ArrayList tempLinks = new ArrayList();
            Lattice.populate(relNodes, tempLinks, parsed.root.rel);
            ArrayList aliases = new ArrayList();
            Lattice.populateAliases(((SqlSelect)parsed.sqlNode).getFrom(), aliases, null);
            DefaultDirectedGraph<RelNode, Edge> graph = DefaultDirectedGraph.create(Edge.FACTORY);
            for (RelNode node : relNodes) {
                graph.addVertex(node);
            }
            for (int[][] tempLink : tempLinks) {
                Object target;
                RelNode source = (RelNode)relNodes.get(tempLink[0][0]);
                Edge edge = (Edge)graph.getEdge(source, (RelNode)(target = (RelNode)relNodes.get(tempLink[1][0])));
                if (edge == null) {
                    edge = (Edge)graph.addEdge(source, (RelNode)target);
                }
                edge.pairs.add(IntPair.of(tempLink[0][1], tempLink[1][1]));
            }
            Node previous = null;
            IdentityHashMap<RelNode, Node> map2 = new IdentityHashMap<RelNode, Node>();
            int previousColumn = 0;
            for (RelNode relNode : TopologicalOrderIterator.of(graph)) {
                Node node;
                List edges = graph.getInwardEdges(relNode);
                int column = previousColumn + relNode.getRowType().getFieldCount();
                if (previous == null) {
                    if (!edges.isEmpty()) {
                        throw new RuntimeException("root node must not have relationships: " + relNode);
                    }
                    node = new Node((TableScan)relNode, null, null, previousColumn, column, (String)aliases.get(this.nodes.size()));
                } else {
                    if (edges.size() != 1) {
                        throw new RuntimeException("child node must have precisely one parent: " + relNode);
                    }
                    Edge edge = (Edge)edges.get(0);
                    node = new Node((TableScan)relNode, (Node)map2.get(edge.getSource()), edge.pairs, previousColumn, column, (String)aliases.get(this.nodes.size()));
                }
                this.nodes.add(node);
                map2.put(relNode, node);
                previous = node;
                previousColumn = column;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            ImmutableListMultimap.Builder aliasBuilder = ImmutableListMultimap.builder();
            int c = 0;
            for (Node node : this.nodes) {
                if (node.scan == null) continue;
                for (String name : node.scan.getRowType().getFieldNames()) {
                    Column column = new Column(c++, node.alias, name, name);
                    builder.add(column);
                    aliasBuilder.put(column.alias, column);
                }
            }
            this.columns = builder.build();
            this.columnsByAlias = aliasBuilder.build();
        }

        public Builder auto(boolean auto) {
            this.auto = auto;
            return this;
        }

        public Builder algorithm(boolean algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder algorithmMaxMillis(long algorithmMaxMillis) {
            this.algorithmMaxMillis = algorithmMaxMillis;
            return this;
        }

        public Builder rowCountEstimate(double rowCountEstimate) {
            this.rowCountEstimate = rowCountEstimate;
            return this;
        }

        public Builder statisticProvider(String statisticProvider) {
            this.statisticProvider = statisticProvider;
            return this;
        }

        public Lattice build() {
            LatticeStatisticProvider.Factory statisticProvider = this.statisticProvider != null ? AvaticaUtils.instantiatePlugin(LatticeStatisticProvider.Factory.class, this.statisticProvider) : Lattices.CACHED_SQL;
            Preconditions.checkArgument(this.rootSchema.isRoot(), "must be root schema");
            return new Lattice(this.rootSchema, ImmutableList.copyOf(this.nodes), this.auto, this.algorithm, this.algorithmMaxMillis, statisticProvider, this.rowCountEstimate, this.columns, (ImmutableList)this.defaultMeasureListBuilder.build(), (ImmutableList)this.tileListBuilder.build());
        }

        public ImmutableList<Column> resolveArgs(Object args) {
            if (args == null) {
                return ImmutableList.of();
            }
            if (args instanceof String) {
                return ImmutableList.of(this.resolveColumnByAlias((String)args));
            }
            if (args instanceof List) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object o : (List)args) {
                    if (o instanceof String) {
                        builder.add(this.resolveColumnByAlias((String)o));
                        continue;
                    }
                    throw new RuntimeException("Measure arguments must be a string or a list of strings; argument: " + o);
                }
                return builder.build();
            }
            throw new RuntimeException("Measure arguments must be a string or a list of strings");
        }

        private Column resolveColumnByAlias(String name) {
            ImmutableCollection list = this.columnsByAlias.get((Object)name);
            if (list == null || list.size() == 0) {
                throw new RuntimeException("Unknown lattice column '" + name + "'");
            }
            if (list.size() == 1) {
                return (Column)list.get(0);
            }
            throw new RuntimeException("Lattice column alias '" + name + "' is not unique");
        }

        public Column resolveColumn(Object name) {
            if (name instanceof String) {
                return this.resolveColumnByAlias((String)name);
            }
            if (name instanceof List) {
                List list = (List)name;
                switch (list.size()) {
                    case 1: {
                        Object alias2 = list.get(0);
                        if (!(alias2 instanceof String)) break;
                        return this.resolveColumnByAlias((String)alias2);
                    }
                    case 2: {
                        Object table = list.get(0);
                        Object column = list.get(1);
                        if (!(table instanceof String) || !(column instanceof String)) break;
                        return this.resolveQualifiedColumn((String)table, (String)column);
                    }
                }
            }
            throw new RuntimeException("Lattice column reference must be a string or a list of 1 or 2 strings; column: " + name);
        }

        private Column resolveQualifiedColumn(String table, String column) {
            for (Column column1 : this.columns) {
                if (!column1.table.equals(table) || !column1.column.equals(column)) continue;
                return column1;
            }
            throw new RuntimeException("Unknown lattice column [" + table + ", " + column + "]");
        }

        public Measure resolveMeasure(String aggName, Object args) {
            SqlAggFunction agg = this.resolveAgg(aggName);
            ImmutableList<Column> list = this.resolveArgs(args);
            return new Measure(agg, list);
        }

        private SqlAggFunction resolveAgg(String aggName) {
            if (aggName.equalsIgnoreCase("count")) {
                return SqlStdOperatorTable.COUNT;
            }
            if (aggName.equalsIgnoreCase("sum")) {
                return SqlStdOperatorTable.SUM;
            }
            throw new RuntimeException("Unknown lattice aggregate function " + aggName);
        }

        public void addMeasure(Measure measure) {
            this.defaultMeasureListBuilder.add((Object)measure);
        }

        public void addTile(Tile tile) {
            this.tileListBuilder.add((Object)tile);
        }
    }

    public static class Column
    implements Comparable<Column> {
        public final int ordinal;
        public final String table;
        public final String column;
        public final String alias;

        private Column(int ordinal, String table, String column, String alias2) {
            this.ordinal = ordinal;
            this.table = Objects.requireNonNull(table);
            this.column = Objects.requireNonNull(column);
            this.alias = Objects.requireNonNull(alias2);
        }

        static ImmutableBitSet toBitSet(List<Column> columns) {
            ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
            for (Column column : columns) {
                builder.set(column.ordinal);
            }
            return builder.build();
        }

        @Override
        public int compareTo(Column column) {
            return Utilities.compare(this.ordinal, column.ordinal);
        }

        public int hashCode() {
            return this.ordinal;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Column && this.ordinal == ((Column)obj).ordinal;
        }

        public String toString() {
            return this.identifiers().toString();
        }

        public List<String> identifiers() {
            return ImmutableList.of(this.table, this.column);
        }
    }

    public static class Measure
    implements Comparable<Measure> {
        public final SqlAggFunction agg;
        public final ImmutableList<Column> args;

        public Measure(SqlAggFunction agg, Iterable<Column> args) {
            this.agg = Objects.requireNonNull(agg);
            this.args = ImmutableList.copyOf(args);
        }

        @Override
        public int compareTo(Measure measure) {
            int c = this.agg.getName().compareTo(measure.agg.getName());
            if (c != 0) {
                return c;
            }
            return Measure.compare(this.args, measure.args);
        }

        public String toString() {
            return "Measure: [agg: " + this.agg + ", args: " + this.args + "]";
        }

        public int hashCode() {
            return Objects.hash(this.agg, this.args);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Measure && this.agg.equals(((Measure)obj).agg) && this.args.equals(((Measure)obj).args);
        }

        public ImmutableBitSet argBitSet() {
            ImmutableBitSet.Builder bitSet = ImmutableBitSet.builder();
            for (Column arg : this.args) {
                bitSet.set(arg.ordinal);
            }
            return bitSet.build();
        }

        public List<Integer> argOrdinals() {
            return Lists.transform(this.args, input -> input.ordinal);
        }

        private static int compare(List<Column> list0, List<Column> list1) {
            int size = Math.min(list0.size(), list1.size());
            for (int i = 0; i < size; ++i) {
                int o0 = list0.get((int)i).ordinal;
                int o1 = list1.get((int)i).ordinal;
                int c = Utilities.compare(o0, o1);
                if (c == 0) continue;
                return c;
            }
            return Utilities.compare(list0.size(), list1.size());
        }
    }

    private static class Edge
    extends DefaultEdge {
        public static final DirectedGraph.EdgeFactory<RelNode, Edge> FACTORY = Edge::new;
        final List<IntPair> pairs = new ArrayList<IntPair>();

        Edge(RelNode source, RelNode target) {
            super(source, target);
        }

        public RelNode getTarget() {
            return (RelNode)this.target;
        }

        public RelNode getSource() {
            return (RelNode)this.source;
        }
    }

    public static class Node {
        public final TableScan scan;
        public final Node parent;
        public final ImmutableList<IntPair> link;
        public final int startCol;
        public final int endCol;
        public final String alias;

        public Node(TableScan scan, Node parent, List<IntPair> link, int startCol, int endCol, String alias2) {
            this.scan = Objects.requireNonNull(scan);
            this.parent = parent;
            ImmutableList<IntPair> immutableList = this.link = link == null ? null : ImmutableList.copyOf(link);
            assert (parent == null == (link == null));
            assert (startCol >= 0);
            assert (endCol > startCol);
            this.startCol = startCol;
            this.endCol = endCol;
            this.alias = alias2;
        }
    }
}

