/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.profile;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.profile.SimpleProfiler;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSortedSet;

public interface Profiler {
    public Profile profile(Iterable<List<Comparable>> var1, List<Column> var2, Collection<ImmutableBitSet> var3);

    public static class Profile {
        public final RowCount rowCount;
        public final List<FunctionalDependency> functionalDependencyList;
        public final List<Distribution> distributionList;
        public final List<Unique> uniqueList;
        private final Map<ImmutableBitSet, Distribution> distributionMap;
        private final List<Distribution> singletonDistributionList;

        Profile(List<Column> columns, RowCount rowCount, Iterable<FunctionalDependency> functionalDependencyList, Iterable<Distribution> distributionList, Iterable<Unique> uniqueList) {
            this.rowCount = rowCount;
            this.functionalDependencyList = ImmutableList.copyOf(functionalDependencyList);
            this.distributionList = ImmutableList.copyOf(distributionList);
            this.uniqueList = ImmutableList.copyOf(uniqueList);
            ImmutableMap.Builder<ImmutableBitSet, Distribution> m = ImmutableMap.builder();
            for (Distribution distribution : distributionList) {
                m.put(distribution.columnOrdinals(), distribution);
            }
            this.distributionMap = m.build();
            ImmutableList.Builder b = ImmutableList.builder();
            int i = 0;
            while (i < columns.size()) {
                b.add(this.distributionMap.get(ImmutableBitSet.of(i++)));
            }
            this.singletonDistributionList = b.build();
        }

        public List<Statistic> statistics() {
            return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(this.rowCount)).addAll(this.functionalDependencyList)).addAll(this.distributionList)).addAll(this.uniqueList)).build();
        }

        public double cardinality(ImmutableBitSet columnOrdinals) {
            ImmutableBitSet originalOrdinals = columnOrdinals;
            while (true) {
                Distribution distribution;
                if ((distribution = this.distributionMap.get(columnOrdinals)) != null) {
                    if (columnOrdinals == originalOrdinals) {
                        return distribution.cardinality;
                    }
                    ArrayList<Double> cardinalityList = new ArrayList<Double>();
                    cardinalityList.add(distribution.cardinality);
                    for (int ordinal : originalOrdinals.except(columnOrdinals)) {
                        Distribution d = this.singletonDistributionList.get(ordinal);
                        cardinalityList.add(d.cardinality);
                    }
                    return Lattice.getRowCount((double)this.rowCount.rowCount, cardinalityList);
                }
                List<Integer> list = columnOrdinals.asList();
                columnOrdinals = columnOrdinals.clear(Util.last(list));
            }
        }
    }

    public static class Distribution
    implements Statistic {
        final NavigableSet<Column> columns;
        final NavigableSet<Comparable> values;
        final double cardinality;
        final int nullCount;
        final double expectedCardinality;
        final boolean minimal;

        public Distribution(SortedSet<Column> columns, SortedSet<Comparable> values, double cardinality, int nullCount, double expectedCardinality, boolean minimal) {
            this.columns = ImmutableSortedSet.copyOf(columns);
            this.values = values == null ? null : ImmutableSortedSet.copyOf(values);
            this.cardinality = cardinality;
            this.nullCount = nullCount;
            this.expectedCardinality = expectedCardinality;
            this.minimal = minimal;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object toMap(JsonBuilder jsonBuilder) {
            Map<String, Object> map2 = jsonBuilder.map();
            map2.put("type", "distribution");
            map2.put("columns", FunctionalDependency.getObjects(jsonBuilder, this.columns));
            if (this.values != null) {
                List<Object> list = jsonBuilder.list();
                for (Comparable comparable : this.values) {
                    void var5_5;
                    if (comparable instanceof Date) {
                        String string = comparable.toString();
                    }
                    list.add(var5_5);
                }
                map2.put("values", list);
            }
            map2.put("cardinality", this.cardinality);
            if (this.nullCount > 0) {
                map2.put("nullCount", this.nullCount);
            }
            map2.put("expectedCardinality", this.expectedCardinality);
            map2.put("surprise", this.surprise());
            return map2;
        }

        ImmutableBitSet columnOrdinals() {
            return Column.toOrdinals(this.columns);
        }

        double surprise() {
            return SimpleProfiler.surprise(this.expectedCardinality, this.cardinality);
        }
    }

    public static class FunctionalDependency
    implements Statistic {
        final NavigableSet<Column> columns;
        final Column dependentColumn;

        FunctionalDependency(SortedSet<Column> columns, Column dependentColumn) {
            this.columns = ImmutableSortedSet.copyOf(columns);
            this.dependentColumn = dependentColumn;
        }

        @Override
        public Object toMap(JsonBuilder jsonBuilder) {
            Map<String, Object> map2 = jsonBuilder.map();
            map2.put("type", "fd");
            map2.put("columns", FunctionalDependency.getObjects(jsonBuilder, this.columns));
            map2.put("dependentColumn", this.dependentColumn.name);
            return map2;
        }

        private static List<Object> getObjects(JsonBuilder jsonBuilder, NavigableSet<Column> columns) {
            List<Object> list = jsonBuilder.list();
            for (Column column : columns) {
                list.add(column.name);
            }
            return list;
        }
    }

    public static class Unique
    implements Statistic {
        final NavigableSet<Column> columns;

        public Unique(SortedSet<Column> columns) {
            this.columns = ImmutableSortedSet.copyOf(columns);
        }

        @Override
        public Object toMap(JsonBuilder jsonBuilder) {
            Map<String, Object> map2 = jsonBuilder.map();
            map2.put("type", "unique");
            map2.put("columns", FunctionalDependency.getObjects(jsonBuilder, this.columns));
            return map2;
        }
    }

    public static class RowCount
    implements Statistic {
        final int rowCount;

        public RowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        @Override
        public Object toMap(JsonBuilder jsonBuilder) {
            Map<String, Object> map2 = jsonBuilder.map();
            map2.put("type", "rowCount");
            map2.put("rowCount", this.rowCount);
            return map2;
        }
    }

    public static interface Statistic {
        public Object toMap(JsonBuilder var1);
    }

    public static class Column
    implements Comparable<Column> {
        public final int ordinal;
        public final String name;

        public Column(int ordinal, String name) {
            this.ordinal = ordinal;
            this.name = name;
        }

        static ImmutableBitSet toOrdinals(Iterable<Column> columns) {
            ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
            for (Column column : columns) {
                builder.set(column.ordinal);
            }
            return builder.build();
        }

        public int hashCode() {
            return this.ordinal;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Column && this.ordinal == ((Column)o).ordinal;
        }

        @Override
        public int compareTo(@Nonnull Column column) {
            return Integer.compare(this.ordinal, column.ordinal);
        }

        public String toString() {
            return this.name;
        }
    }
}

