/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.ExplicitOperatorBinding;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public abstract class SqlOperator {
    public static final String NL = System.getProperty("line.separator");
    public static final int MDX_PRECEDENCE = 200;
    private final String name;
    public final SqlKind kind;
    private final int leftPrec;
    private final int rightPrec;
    private final SqlReturnTypeInference returnTypeInference;
    private final SqlOperandTypeInference operandTypeInference;
    private final SqlOperandTypeChecker operandTypeChecker;

    protected SqlOperator(String name, SqlKind kind, int leftPrecedence, int rightPrecedence, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        assert (kind != null);
        this.name = name;
        this.kind = kind;
        this.leftPrec = leftPrecedence;
        this.rightPrec = rightPrecedence;
        this.returnTypeInference = returnTypeInference;
        this.operandTypeInference = operandTypeInference;
        this.operandTypeChecker = operandTypeChecker;
    }

    protected SqlOperator(String name, SqlKind kind, int prec, boolean leftAssoc, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        this(name, kind, SqlOperator.leftPrec(prec, leftAssoc), SqlOperator.rightPrec(prec, leftAssoc), returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    protected static int leftPrec(int prec, boolean leftAssoc) {
        assert (prec % 2 == 0);
        if (!leftAssoc) {
            ++prec;
        }
        return prec;
    }

    protected static int rightPrec(int prec, boolean leftAssoc) {
        assert (prec % 2 == 0);
        if (leftAssoc) {
            ++prec;
        }
        return prec;
    }

    public SqlOperandTypeChecker getOperandTypeChecker() {
        return this.operandTypeChecker;
    }

    public SqlOperandCountRange getOperandCountRange() {
        if (this.operandTypeChecker != null) {
            return this.operandTypeChecker.getOperandCountRange();
        }
        throw Util.needToImplement(this);
    }

    public String getName() {
        return this.name;
    }

    public SqlIdentifier getNameAsId() {
        return new SqlIdentifier(this.getName(), SqlParserPos.ZERO);
    }

    public SqlKind getKind() {
        return this.kind;
    }

    public String toString() {
        return this.name;
    }

    public int getLeftPrec() {
        return this.leftPrec;
    }

    public int getRightPrec() {
        return this.rightPrec;
    }

    public abstract SqlSyntax getSyntax();

    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        pos = pos.plusAll(Arrays.asList(operands));
        return new SqlBasicCall(this, operands, pos, false, functionQualifier);
    }

    public final SqlCall createCall(SqlParserPos pos, SqlNode ... operands) {
        return this.createCall(null, pos, operands);
    }

    public final SqlCall createCall(SqlNodeList nodeList) {
        return this.createCall(null, nodeList.getParserPosition(), nodeList.toArray());
    }

    public final SqlCall createCall(SqlParserPos pos, List<? extends SqlNode> operandList) {
        return this.createCall(null, pos, operandList.toArray(new SqlNode[0]));
    }

    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        return call;
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        this.getSyntax().unparse(writer, this, call, leftPrec, rightPrec);
    }

    protected void unparseListClause(SqlWriter writer, SqlNode clause) {
        this.unparseListClause(writer, clause, null);
    }

    protected void unparseListClause(SqlWriter writer, SqlNode clause, SqlKind sepKind) {
        if (clause instanceof SqlNodeList) {
            if (sepKind != null) {
                ((SqlNodeList)clause).andOrList(writer, sepKind);
            } else {
                ((SqlNodeList)clause).commaList(writer);
            }
        } else {
            clause.unparse(writer, 0, 0);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SqlOperator)) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        SqlOperator other = (SqlOperator)obj;
        return this.name.equals(other.name) && this.kind == other.kind;
    }

    public boolean isName(String testName) {
        return this.name.equals(testName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.name});
    }

    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        for (SqlNode operand : call.getOperandList()) {
            operand.validateExpr(validator, operandScope);
        }
    }

    public final RelDataType validateOperands(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        this.preValidateCall(validator, scope, call);
        this.checkOperandCount(validator, this.operandTypeChecker, call);
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope, call);
        this.checkOperandTypes(opBinding, true);
        RelDataType ret = this.inferReturnType(opBinding);
        ((SqlValidatorImpl)validator).setValidatedNodeType(call, ret);
        return ret;
    }

    protected void preValidateCall(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        if (this.returnTypeInference != null) {
            return this.returnTypeInference.inferReturnType(opBinding);
        }
        throw Util.needToImplement(this);
    }

    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType nodeType = validator.deriveType(scope, operand);
            assert (nodeType != null);
        }
        List<SqlNode> args = this.constructOperandList(validator, call, null);
        List<RelDataType> argTypes = this.constructArgTypeList(validator, scope, call, args, false);
        SqlOperator sqlOperator = SqlUtil.lookupRoutine(validator.getOperatorTable(), this.getNameAsId(), argTypes, null, null, this.getSyntax(), this.getKind());
        ((SqlBasicCall)call).setOperator(sqlOperator);
        RelDataType type = call.getOperator().validateOperands(validator, scope, call);
        type = this.adjustType(validator, call, type);
        SqlValidatorUtil.checkCharsetAndCollateConsistentIfCharType(type);
        return type;
    }

    protected List<String> constructArgNameList(SqlCall call) {
        ImmutableList.Builder nameBuilder = ImmutableList.builder();
        for (SqlNode operand : call.getOperandList()) {
            if (operand.getKind() != SqlKind.ARGUMENT_ASSIGNMENT) continue;
            List<SqlNode> operandList = ((SqlCall)operand).getOperandList();
            nameBuilder.add(((SqlIdentifier)operandList.get(1)).getSimple());
        }
        ImmutableCollection argNames = nameBuilder.build();
        if (argNames.isEmpty()) {
            return null;
        }
        return argNames;
    }

    protected List<SqlNode> constructOperandList(SqlValidator validator, SqlCall call, List<String> argNames) {
        if (argNames == null) {
            return call.getOperandList();
        }
        if (argNames.size() < call.getOperandList().size()) {
            throw validator.newValidationError(call, Static.RESOURCE.someButNotAllArgumentsAreNamed());
        }
        int duplicate = Util.firstDuplicate(argNames);
        if (duplicate >= 0) {
            throw validator.newValidationError(call, Static.RESOURCE.duplicateArgumentName(argNames.get(duplicate)));
        }
        ImmutableList.Builder argBuilder = ImmutableList.builder();
        for (SqlNode operand : call.getOperandList()) {
            if (operand.getKind() != SqlKind.ARGUMENT_ASSIGNMENT) continue;
            List<SqlNode> operandList = ((SqlCall)operand).getOperandList();
            argBuilder.add(operandList.get(0));
        }
        return argBuilder.build();
    }

    protected List<RelDataType> constructArgTypeList(SqlValidator validator, SqlValidatorScope scope, SqlCall call, List<SqlNode> args, boolean convertRowArgToColumnList) {
        SqlValidatorScope operandScope = scope.getOperandScope(call);
        ImmutableList.Builder argTypeBuilder = ImmutableList.builder();
        for (SqlNode operand : args) {
            RelDataType nodeType;
            if (operand.getKind() == SqlKind.ROW && convertRowArgToColumnList) {
                RelDataTypeFactory typeFactory = validator.getTypeFactory();
                nodeType = typeFactory.createSqlType(SqlTypeName.COLUMN_LIST);
                ((SqlValidatorImpl)validator).setValidatedNodeType(operand, nodeType);
            } else {
                nodeType = validator.deriveType(operandScope, operand);
            }
            argTypeBuilder.add(nodeType);
        }
        return argTypeBuilder.build();
    }

    boolean needsSpace() {
        return true;
    }

    protected RelDataType adjustType(SqlValidator validator, SqlCall call, RelDataType type) {
        return type;
    }

    public final RelDataType inferReturnType(RelDataTypeFactory typeFactory, List<RelDataType> operandTypes) {
        return this.inferReturnType(new ExplicitOperatorBinding(typeFactory, this, operandTypes));
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (null == this.operandTypeChecker) {
            throw Util.needToImplement(this);
        }
        if (this.kind != SqlKind.ARGUMENT_ASSIGNMENT) {
            for (Ord<SqlNode> operand : Ord.zip(callBinding.operands())) {
                if (operand.e == null || ((SqlNode)operand.e).getKind() != SqlKind.DEFAULT || this.operandTypeChecker.isOptional(operand.i)) continue;
                throw callBinding.getValidator().newValidationError(callBinding.getCall(), Static.RESOURCE.defaultForOptionalParameter());
            }
        }
        return this.operandTypeChecker.checkOperandTypes(callBinding, throwOnFailure);
    }

    protected void checkOperandCount(SqlValidator validator, SqlOperandTypeChecker argType, SqlCall call) {
        SqlOperandCountRange od = call.getOperator().getOperandCountRange();
        if (od.isValidCount(call.operandCount())) {
            return;
        }
        if (od.getMin() == od.getMax()) {
            throw validator.newValidationError(call, Static.RESOURCE.invalidArgCount(call.getOperator().getName(), od.getMin()));
        }
        throw validator.newValidationError(call, Static.RESOURCE.wrongNumOfArguments());
    }

    public boolean validRexOperands(int count, Litmus litmus) {
        return true;
    }

    public String getSignatureTemplate(int operandsCount) {
        return null;
    }

    public final String getAllowedSignatures() {
        return this.getAllowedSignatures(this.name);
    }

    public String getAllowedSignatures(String opNameToUse) {
        assert (this.operandTypeChecker != null) : "If you see this, assign operandTypeChecker a value or override this function";
        return this.operandTypeChecker.getAllowedSignatures(this, opNameToUse).trim();
    }

    public SqlOperandTypeInference getOperandTypeInference() {
        return this.operandTypeInference;
    }

    public boolean isAggregator() {
        return false;
    }

    public boolean requiresOver() {
        return false;
    }

    public boolean requiresOrder() {
        return false;
    }

    public boolean allowsFraming() {
        return true;
    }

    public boolean isGroup() {
        return false;
    }

    public boolean isGroupAuxiliary() {
        return false;
    }

    public <R> R acceptCall(SqlVisitor<R> visitor, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            if (operand == null) continue;
            operand.accept(visitor);
        }
        return null;
    }

    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        List<SqlNode> operands = call.getOperandList();
        for (int i = 0; i < operands.size(); ++i) {
            argHandler.visitChild(visitor, call, i, operands.get(i));
        }
    }

    public SqlReturnTypeInference getReturnTypeInference() {
        return this.returnTypeInference;
    }

    @Deprecated
    public SqlMonotonicity getMonotonicity(SqlCall call, SqlValidatorScope scope) {
        return this.getMonotonicity(new SqlCallBinding(scope.getValidator(), scope, call));
    }

    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean isDynamicFunction() {
        return false;
    }

    public boolean requiresDecimalExpansion() {
        return true;
    }

    public boolean argumentMustBeScalar(int ordinal) {
        return true;
    }
}

