/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.plan.rules.logical.PushFilterIntoTableSourceScanRule$;
import org.apache.flink.table.plan.util.RexProgramExtractor$;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.validate.FunctionCatalog;
import org.apache.flink.table.validate.FunctionCatalog$;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001#\t\t\u0003+^:i\r&dG/\u001a:J]R|G+\u00192mKN{WO]2f'\u000e\fgNU;mK*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M9R\"\u0001\u000b\u000b\u0005\u001d)\"B\u0001\f\r\u0003\u001d\u0019\u0017\r\\2ji\u0016L!\u0001\u0007\u000b\u0003\u0015I+Gn\u00149u%VdW\rC\u0003\u001b\u0001\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u0005!)q\u0004\u0001C!A\u00059Q.\u0019;dQ\u0016\u001cHCA\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u000b\u0010A\u0002%\nAaY1mYB\u00111CK\u0005\u0003WQ\u0011aBU3m\u001fB$(+\u001e7f\u0007\u0006dG\u000eC\u0003.\u0001\u0011\u0005c&A\u0004p]6\u000bGo\u00195\u0015\u0005=\u0012\u0004C\u0001\u00121\u0013\t\t4E\u0001\u0003V]&$\b\"\u0002\u0015-\u0001\u0004I\u0003\"\u0002\u001b\u0001\t\u0013)\u0014A\u00059vg\"4\u0015\u000e\u001c;fe&sGo\\*dC:$ba\f\u001c8\u0001\u0016K\u0006\"\u0002\u00154\u0001\u0004I\u0003\"\u0002\u001d4\u0001\u0004I\u0014\u0001B2bY\u000e\u0004\"A\u000f \u000e\u0003mR!a\u0001\u001f\u000b\u0005u2\u0011!\u00028pI\u0016\u001c\u0018BA <\u0005A1E.\u001b8l\u0019><\u0017nY1m\u0007\u0006d7\rC\u0003Bg\u0001\u0007!)\u0001\u0003tG\u0006t\u0007C\u0001\u001eD\u0013\t!5HA\u000eGY&t7\u000eT8hS\u000e\fG\u000eV1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c\u0005\u0006\rN\u0002\raR\u0001\u0011M&dG/\u001a:bE2,7k\\;sG\u0016\u0004$\u0001\u0013)\u0011\u0007%ce*D\u0001K\u0015\tY\u0005\"A\u0004t_V\u00148-Z:\n\u00055S%!\u0006$jYR,'/\u00192mKR\u000b'\r\\3T_V\u00148-\u001a\t\u0003\u001fBc\u0001\u0001B\u0005R\u000b\u0006\u0005\t\u0011!B\u0001%\n\u0019q\f\n\u001a\u0012\u0005M3\u0006C\u0001\u0012U\u0013\t)6EA\u0004O_RD\u0017N\\4\u0011\u0005\t:\u0016B\u0001-$\u0005\r\te.\u001f\u0005\u00065N\u0002\raW\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0005\u0002]?:\u0011!%X\u0005\u0003=\u000e\na\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011alI\u0004\u0006G\nA\t\u0001Z\u0001\"!V\u001c\bNR5mi\u0016\u0014\u0018J\u001c;p)\u0006\u0014G.Z*pkJ\u001cWmU2b]J+H.\u001a\t\u0003;\u00154Q!\u0001\u0002\t\u0002\u0019\u001c\"!Z4\u0011\u0005\tB\u0017BA5$\u0005\u0019\te.\u001f*fM\")!$\u001aC\u0001WR\tA\rC\u0004nK\n\u0007I\u0011\u00018\u0002\u0011%s5\u000bV!O\u0007\u0016+\u0012A\u0005\u0005\u0007a\u0016\u0004\u000b\u0011\u0002\n\u0002\u0013%s5\u000bV!O\u0007\u0016\u0003\u0003")
public class PushFilterIntoTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushFilterIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean bl;
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        TableSource<?> tableSource = scan.tableSource();
        if (tableSource instanceof FilterableTableSource) {
            TableSource<?> tableSource2 = tableSource;
            bl = calc.getProgram().getCondition() != null && !((FilterableTableSource)((Object)tableSource2)).isFilterPushedDown();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        FilterableTableSource filterableSource = (FilterableTableSource)((Object)scan.tableSource());
        this.pushFilterIntoScan(call, calc, scan, filterableSource, this.description);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, FlinkLogicalCalc calc, FlinkLogicalTableSourceScan scan, FilterableTableSource<?> filterableSource, String description) {
        Preconditions.checkArgument((!filterableSource.isFilterPushedDown() ? 1 : 0) != 0);
        RexProgram program = calc.getProgram();
        FunctionCatalog functionCatalog = FunctionCatalog$.MODULE$.withBuiltIns();
        Tuple2<Expression[], RexNode[]> tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, call.builder().getRexBuilder(), functionCatalog);
        if (tuple2 != null) {
            RexProgram newRexProgram;
            RexProgram rexProgram;
            RexNode rexNode;
            Tuple2 tuple22;
            Expression[] predicates = (Expression[])tuple2._1();
            RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)predicates, (Object)unconvertedRexNodes);
            Expression[] predicates2 = (Expression[])tuple23._1();
            RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
            if (Predef$.MODULE$.refArrayOps((Object[])predicates2).isEmpty()) {
                return;
            }
            LinkedList<Expression> remainingPredicates = new LinkedList<Expression>();
            Predef$.MODULE$.refArrayOps((Object[])predicates2).foreach((Function1)new Serializable(this, remainingPredicates){
                public static final long serialVersionUID = 0L;
                private final LinkedList remainingPredicates$1;

                public final boolean apply(Expression e2) {
                    return this.remainingPredicates$1.add(e2);
                }
                {
                    this.remainingPredicates$1 = remainingPredicates$1;
                }
            });
            TableSource<?> newTableSource = filterableSource.applyPredicate(remainingPredicates);
            RelBuilder relBuilder = call.builder();
            if (remainingPredicates.isEmpty() && !Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2).nonEmpty()) {
                rexNode = null;
            } else {
                relBuilder.push(scan);
                Buffer remainingConditions = ((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(remainingPredicates).asScala()).map((Function1)new Serializable(this, relBuilder){
                    public static final long serialVersionUID = 0L;
                    private final RelBuilder relBuilder$1;

                    public final RexNode apply(Expression expr) {
                        return expr.toRexNode(this.relBuilder$1);
                    }
                    {
                        this.relBuilder$1 = relBuilder$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2));
                rexNode = (RexNode)remainingConditions.reduce((Function2)new Serializable(this, relBuilder){
                    public static final long serialVersionUID = 0L;
                    private final RelBuilder relBuilder$1;

                    public final RexNode apply(RexNode l, RexNode r) {
                        return this.relBuilder$1.and(l, r);
                    }
                    {
                        this.relBuilder$1 = relBuilder$1;
                    }
                });
            }
            RexNode remainingCondition = rexNode;
            FlinkLogicalTableSourceScan newScan = scan.copy(scan.getTraitSet(), newTableSource, scan.selectedFields());
            if (remainingCondition == null && program.projectsOnlyIdentity()) {
                rexProgram = null;
            } else {
                List expandedProjectList = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(program.getProjectList()).asScala()).map((Function1)new Serializable(this, program){
                    public static final long serialVersionUID = 0L;
                    private final RexProgram program$1;

                    public final RexNode apply(RexLocalRef ref) {
                        return this.program$1.expandLocalRef(ref);
                    }
                    {
                        this.program$1 = program$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).asJava();
                rexProgram = newRexProgram = RexProgram.create(program.getInputRowType(), (List<? extends RexNode>)expandedProjectList, remainingCondition, program.getOutputRowType(), relBuilder.getRexBuilder());
            }
            if (newRexProgram == null) {
                call.transformTo(newScan);
            } else {
                Calc newCalc = calc.copy(calc.getTraitSet(), newScan, newRexProgram);
                call.transformTo(newCalc);
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public PushFilterIntoTableSourceScanRule() {
        super(RelOptRule.operand(FlinkLogicalCalc.class, RelOptRule.operand(FlinkLogicalTableSourceScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushFilterIntoTableSourceScanRule");
    }
}

