/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.runtime.join.CRowWrappingMultiOutputCollector;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.typeutils.TypeCheckUtils$;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tec!B\u0001\u0003\u0003\u0003y!!\u0004(p]^Kg\u000eZ8x\u0015>LgN\u0003\u0002\u0004\t\u0005!!n\\5o\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u00126!\u0015\t\"\u0004\b\u000f\u001d\u001b\u0005\u0011\"BA\n\u0015\u0003\t\u0019wN\u0003\u0002\u0016-\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003/a\t1!\u00199j\u0015\tI\u0002\"A\u0005tiJ,\u0017-\\5oO&\u00111D\u0005\u0002\u0012\u0007>\u0004&o\\2fgN4UO\\2uS>t\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003\u0015!\u0018\u0010]3t\u0013\t\tcD\u0001\u0003D%><\bcA\u0012'Q5\tAE\u0003\u0002&\r\u000591m\u001c3fO\u0016t\u0017BA\u0014%\u0005!\u0019u.\u001c9jY\u0016\u0014\b#B\u0015/aA\u0002T\"\u0001\u0016\u000b\u0005UY#B\u0001\u0017.\u0003\u0019\u0019w.\\7p]*\u0011q\u0003C\u0005\u0003_)\u0012\u0001C\u00127bi*{\u0017N\u001c$v]\u000e$\u0018n\u001c8\u0011\u0005E\u001aT\"\u0001\u001a\u000b\u0005}A\u0011B\u0001\u001b3\u0005\r\u0011vn\u001e\t\u0003mej\u0011a\u000e\u0006\u0003q\u0019\tA!\u001e;jY&\u0011!h\u000e\u0002\b\u0019><w-\u001b8h\u0011!a\u0004A!A!\u0002\u0013i\u0014\u0001\u00037fMR$\u0016\u0010]3\u0011\u0007y\n\u0005'D\u0001@\u0015\t\u00015&\u0001\u0005usB,\u0017N\u001c4p\u0013\t\u0011uHA\bUsB,\u0017J\u001c4pe6\fG/[8o\u0011!!\u0005A!A!\u0002\u0013i\u0014!\u0003:jO\"$H+\u001f9f\u0011!1\u0005A!A!\u0002\u00139\u0015aD4f]*{\u0017N\u001c$v]\u000et\u0015-\\3\u0011\u0005!seBA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S\u0015A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014&\t\u0011I\u0003!\u0011!Q\u0001\n\u001d\u000bqbZ3o\u0015>LgNR;oG\u000e{G-\u001a\u0005\t)\u0002\u0011\t\u0011)A\u0005+\u0006Y\u0011/^3ss\u000e{gNZ5h!\t1\u0006,D\u0001X\u0015\t9b!\u0003\u0002Z/\n\t2\u000b\u001e:fC6\fV/\u001a:z\u0007>tg-[4\t\u000bm\u0003A\u0011\u0001/\u0002\rqJg.\u001b;?)\u0019iv\fY1cGB\u0011a\fA\u0007\u0002\u0005!)AH\u0017a\u0001{!)AI\u0017a\u0001{!)aI\u0017a\u0001\u000f\")!K\u0017a\u0001\u000f\")AK\u0017a\u0001+\"IQ\r\u0001a\u0001\u0002\u0004%\tBZ\u0001\nY\u00164Go\u0015;bi\u0016,\u0012a\u001a\t\u0005Q.\u0004T.D\u0001j\u0015\tQ7&A\u0003ti\u0006$X-\u0003\u0002mS\nAQ*\u00199Ti\u0006$X\r\u0005\u0003ogV,X\"A8\u000b\u0005A\f\u0018!\u0002;va2,'B\u0001:.\u0003\u0011Q\u0017M^1\n\u0005Q|'A\u0002+va2,'\u0007\u0005\u0002Jm&\u0011qO\u0013\u0002\u0005\u0019>tw\rC\u0005z\u0001\u0001\u0007\t\u0019!C\tu\u0006iA.\u001a4u'R\fG/Z0%KF$\"a\u001f@\u0011\u0005%c\u0018BA?K\u0005\u0011)f.\u001b;\t\u000f}D\u0018\u0011!a\u0001O\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005\r\u0001\u0001)Q\u0005O\u0006QA.\u001a4u'R\fG/\u001a\u0011\t\u0015\u0005\u001d\u0001\u00011AA\u0002\u0013Ea-\u0001\u0006sS\u001eDGo\u0015;bi\u0016D1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002\u000e\u0005q!/[4iiN#\u0018\r^3`I\u0015\fHcA>\u0002\u0010!Aq0!\u0003\u0002\u0002\u0003\u0007q\rC\u0004\u0002\u0014\u0001\u0001\u000b\u0015B4\u0002\u0017ILw\r\u001b;Ti\u0006$X\r\t\u0005\f\u0003/\u0001\u0001\u0019!a\u0001\n#\tI\"A\u0006d%><xK]1qa\u0016\u0014XCAA\u000e!\rq\u0016QD\u0005\u0004\u0003?\u0011!\u0001I\"S_^<&/\u00199qS:<W*\u001e7uS>+H\u000f];u\u0007>dG.Z2u_JD1\"a\t\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002&\u0005y1MU8x/J\f\u0007\u000f]3s?\u0012*\u0017\u000fF\u0002|\u0003OA\u0011b`A\u0011\u0003\u0003\u0005\r!a\u0007\t\u0011\u0005-\u0002\u0001)Q\u0005\u00037\tAb\u0019*po^\u0013\u0018\r\u001d9fe\u0002B\u0011\"a\f\u0001\u0005\u0004%\t\"!\r\u0002!5LgNU3uK:$\u0018n\u001c8US6,W#A;\t\u000f\u0005U\u0002\u0001)A\u0005k\u0006\tR.\u001b8SKR,g\u000e^5p]RKW.\u001a\u0011\t\u0013\u0005e\u0002A1A\u0005\u0012\u0005E\u0012\u0001E7bqJ+G/\u001a8uS>tG+[7f\u0011\u001d\ti\u0004\u0001Q\u0001\nU\f\u0011#\\1y%\u0016$XM\u001c;j_:$\u0016.\\3!\u0011%\t\t\u0005\u0001b\u0001\n#\t\u0019%\u0001\u000bti\u0006$Xm\u00117fC:LgnZ#oC\ndW\rZ\u000b\u0003\u0003\u000b\u00022!SA$\u0013\r\tIE\u0013\u0002\b\u0005>|G.Z1o\u0011!\ti\u0005\u0001Q\u0001\n\u0005\u0015\u0013!F:uCR,7\t\\3b]&tw-\u00128bE2,G\r\t\u0005\f\u0003#\u0002\u0001\u0019!a\u0001\n#\t\u0019&A\u0005mK\u001a$H+[7feV\u0011\u0011Q\u000b\t\u0005Q\u0006]S/C\u0002\u0002Z%\u0014!BV1mk\u0016\u001cF/\u0019;f\u0011-\ti\u0006\u0001a\u0001\u0002\u0004%\t\"a\u0018\u0002\u001b1,g\r\u001e+j[\u0016\u0014x\fJ3r)\rY\u0018\u0011\r\u0005\n\u007f\u0006m\u0013\u0011!a\u0001\u0003+B\u0001\"!\u001a\u0001A\u0003&\u0011QK\u0001\u000bY\u00164G\u000fV5nKJ\u0004\u0003bCA5\u0001\u0001\u0007\t\u0019!C\t\u0003'\n!B]5hQR$\u0016.\\3s\u0011-\ti\u0007\u0001a\u0001\u0002\u0004%\t\"a\u001c\u0002\u001dILw\r\u001b;US6,'o\u0018\u0013fcR\u001910!\u001d\t\u0013}\fY'!AA\u0002\u0005U\u0003\u0002CA;\u0001\u0001\u0006K!!\u0016\u0002\u0017ILw\r\u001b;US6,'\u000f\t\u0005\f\u0003s\u0002\u0001\u0019!a\u0001\n#\tY(\u0001\u0007k_&tg)\u001e8di&|g.F\u0001)\u0011-\ty\b\u0001a\u0001\u0002\u0004%\t\"!!\u0002!)|\u0017N\u001c$v]\u000e$\u0018n\u001c8`I\u0015\fHcA>\u0002\u0004\"Aq0! \u0002\u0002\u0003\u0007\u0001\u0006C\u0004\u0002\b\u0002\u0001\u000b\u0015\u0002\u0015\u0002\u001b)|\u0017N\u001c$v]\u000e$\u0018n\u001c8!\u0011-\tY\t\u0001a\u0001\u0002\u0004%\t\"!\r\u0002\u001d\r,(\u000f\u0015:pG\u0016\u001c8\u000fV5nK\"Y\u0011q\u0012\u0001A\u0002\u0003\u0007I\u0011CAI\u0003I\u0019WO\u001d)s_\u000e,7o\u001d+j[\u0016|F%Z9\u0015\u0007m\f\u0019\n\u0003\u0005\u0000\u0003\u001b\u000b\t\u00111\u0001v\u0011\u001d\t9\n\u0001Q!\nU\fqbY;s!J|7-Z:t)&lW\r\t\u0005\b\u00037\u0003A\u0011IAO\u0003\u0011y\u0007/\u001a8\u0015\u0007m\fy\n\u0003\u0005\u0002\"\u0006e\u0005\u0019AAR\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005\u0003K\u000bY+\u0004\u0002\u0002(*\u0019\u0011\u0011\u0016\u0005\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\ti+a*\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\t\t\f\u0001C!\u0003g\u000bq\u0002\u001d:pG\u0016\u001c8/\u00127f[\u0016tG/\r\u000b\bw\u0006U\u0016\u0011XAb\u0011\u001d\t9,a,A\u0002q\taA^1mk\u0016\u001c\u0005\u0002CA^\u0003_\u0003\r!!0\u0002\u0007\r$\b\u0010E\u0002\u0011\u0003\u007fK1!!1\u001b\u0005\u001d\u0019uN\u001c;fqRD\u0001\"!2\u00020\u0002\u0007\u0011qY\u0001\u0004_V$\b#BAe\u0003\u001bdRBAAf\u0015\tA\u0004\"\u0003\u0003\u0002P\u0006-'!C\"pY2,7\r^8s\u0011\u001d\t\u0019\u000e\u0001C!\u0003+\fq\u0002\u001d:pG\u0016\u001c8/\u00127f[\u0016tGO\r\u000b\bw\u0006]\u0017\u0011\\An\u0011\u001d\t9,!5A\u0002qA\u0001\"a/\u0002R\u0002\u0007\u0011Q\u0018\u0005\t\u0003\u000b\f\t\u000e1\u0001\u0002H\"9\u0011q\u001c\u0001\u0005B\u0005\u0005\u0018aB8o)&lWM\u001d\u000b\bw\u0006\r\u0018q]Ax\u0011\u001d\t)/!8A\u0002U\f\u0011\u0002^5nKN$\u0018-\u001c9\t\u0011\u0005m\u0016Q\u001ca\u0001\u0003S\u00042\u0001EAv\u0013\r\tiO\u0007\u0002\u000f\u001f:$\u0016.\\3s\u0007>tG/\u001a=u\u0011!\t)-!8A\u0002\u0005\u001d\u0007bBAz\u0001\u0011\u0005\u0011Q_\u0001\u0012O\u0016$h*Z<FqBL'/\u001a3US6,G#B;\u0002x\u0006e\bbBAF\u0003c\u0004\r!\u001e\u0005\b\u0003w\f\t\u00101\u0001v\u00039yG\u000eZ#ya&\u0014X\r\u001a+j[\u0016Dq!a@\u0001\t\u0003\u0011\t!\u0001\tfqBL'/Z(viRKW.\u001a*poRY1Pa\u0001\u0003\b\t-!q\u0002B\n\u0011\u001d\u0011)!!@A\u0002U\fqaY;s)&lW\rC\u0004\u0003\n\u0005u\b\u0019A4\u0002\u0017I|w/T1q'R\fG/\u001a\u0005\t\u0005\u001b\ti\u00101\u0001\u0002V\u0005QA/[7feN#\u0018\r^3\t\u0011\tE\u0011Q a\u0001\u0003\u000b\na![:MK\u001a$\b\u0002CA^\u0003{\u0004\r!!;\t\u000f\t]\u0001A\"\u0001\u0003\u001a\u0005q\u0001O]8dKN\u001cX\t\\3nK:$HcD>\u0003\u001c\t}!\u0011\u0005B\u0012\u0005K\u0011IC!\f\t\u000f\tu!Q\u0003a\u00019\u0005)a/\u00197vK\"A\u00111\u0018B\u000b\u0001\u0004\ti\f\u0003\u0005\u0002F\nU\u0001\u0019AAd\u0011!\u0011iA!\u0006A\u0002\u0005U\u0003b\u0002B\u0014\u0005+\u0001\raZ\u0001\u0011GV\u0014(/\u001a8u'&$Wm\u0015;bi\u0016DqAa\u000b\u0003\u0016\u0001\u0007q-\u0001\bpi\",'oU5eKN#\u0018\r^3\t\u0011\tE!Q\u0003a\u0001\u0003\u000bBqA!\r\u0001\t\u0003\u0011\u0019$A\tva\u0012\fG/Z\"veJ,g\u000e^*jI\u0016$\u0012\"\u001cB\u001b\u0005o\u0011IDa\u000f\t\u000f\tu!q\u0006a\u00019!A\u00111\u0018B\u0018\u0001\u0004\ti\f\u0003\u0005\u0003\u000e\t=\u0002\u0019AA+\u0011\u001d\u00119Ca\fA\u0002\u001dDqAa\u0010\u0001\t\u0003\u0011\t%\u0001\tdC2d'j\\5o\rVt7\r^5p]RI1Pa\u0011\u0003H\t-#q\n\u0005\b\u0005\u000b\u0012i\u00041\u00011\u0003!Ig\u000e];u%><\b\u0002\u0003B%\u0005{\u0001\r!!\u0012\u0002!%t\u0007/\u001e;S_^4%o\\7MK\u001a$\bb\u0002B'\u0005{\u0001\r\u0001M\u0001\r_RDWM]*jI\u0016\u0014vn\u001e\u0005\t\u0003/\u0011i\u00041\u0001\u0003RA)\u0011\u0011ZAga!9!Q\u000b\u0001\u0005B\t]\u0013!B2m_N,G#A>")
public abstract class NonWindowJoin
extends CoProcessFunction<CRow, CRow, CRow>
implements Compiler<FlatJoinFunction<Row, Row, Row>>,
Logging {
    private final TypeInformation<Row> leftType;
    private final TypeInformation<Row> rightType;
    private final String genJoinFuncName;
    private final String genJoinFuncCode;
    private MapState<Row, Tuple2<Object, Object>> leftState;
    private MapState<Row, Tuple2<Object, Object>> rightState;
    private CRowWrappingMultiOutputCollector cRowWrapper;
    private final long minRetentionTime;
    private final long maxRetentionTime;
    private final boolean stateCleaningEnabled;
    private ValueState<Object> leftTimer;
    private ValueState<Object> rightTimer;
    private FlatJoinFunction<Row, Row, Row> joinFunction;
    private long curProcessTime;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        NonWindowJoin nonWindowJoin = this;
        synchronized (nonWindowJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<FlatJoinFunction<Row, Row, Row>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    public MapState<Row, Tuple2<Object, Object>> leftState() {
        return this.leftState;
    }

    public void leftState_$eq(MapState<Row, Tuple2<Object, Object>> x$1) {
        this.leftState = x$1;
    }

    public MapState<Row, Tuple2<Object, Object>> rightState() {
        return this.rightState;
    }

    public void rightState_$eq(MapState<Row, Tuple2<Object, Object>> x$1) {
        this.rightState = x$1;
    }

    public CRowWrappingMultiOutputCollector cRowWrapper() {
        return this.cRowWrapper;
    }

    public void cRowWrapper_$eq(CRowWrappingMultiOutputCollector x$1) {
        this.cRowWrapper = x$1;
    }

    public long minRetentionTime() {
        return this.minRetentionTime;
    }

    public long maxRetentionTime() {
        return this.maxRetentionTime;
    }

    public boolean stateCleaningEnabled() {
        return this.stateCleaningEnabled;
    }

    public ValueState<Object> leftTimer() {
        return this.leftTimer;
    }

    public void leftTimer_$eq(ValueState<Object> x$1) {
        this.leftTimer = x$1;
    }

    public ValueState<Object> rightTimer() {
        return this.rightTimer;
    }

    public void rightTimer_$eq(ValueState<Object> x$1) {
        this.rightTimer = x$1;
    }

    public FlatJoinFunction<Row, Row, Row> joinFunction() {
        return this.joinFunction;
    }

    public void joinFunction_$eq(FlatJoinFunction<Row, Row, Row> x$1) {
        this.joinFunction = x$1;
    }

    public long curProcessTime() {
        return this.curProcessTime;
    }

    public void curProcessTime_$eq(long x$1) {
        this.curProcessTime = x$1;
    }

    public void open(Configuration parameters) {
        this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling JoinFunction: ", " \\n\\n Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genJoinFuncName, this.genJoinFuncCode})));
        Class<FlatJoinFunction<Row, Row, Row>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName, this.genJoinFuncCode);
        this.LOG().debug("Instantiating JoinFunction.");
        this.joinFunction_$eq(clazz.newInstance());
        FunctionUtils.setFunctionRuntimeContext(this.joinFunction(), (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.joinFunction(), (Configuration)parameters);
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.LONG()});
        MapStateDescriptor leftStateDescriptor = new MapStateDescriptor("left", this.leftType, (TypeInformation)tupleTypeInfo);
        MapStateDescriptor rightStateDescriptor = new MapStateDescriptor("right", this.rightType, (TypeInformation)tupleTypeInfo);
        this.leftState_$eq((MapState<Row, Tuple2<Object, Object>>)this.getRuntimeContext().getMapState(leftStateDescriptor));
        this.rightState_$eq((MapState<Row, Tuple2<Object, Object>>)this.getRuntimeContext().getMapState(rightStateDescriptor));
        ValueStateDescriptor valueStateDescriptor1 = new ValueStateDescriptor("timervaluestate1", Long.TYPE);
        this.leftTimer_$eq((ValueState<Object>)this.getRuntimeContext().getState(valueStateDescriptor1));
        ValueStateDescriptor valueStateDescriptor2 = new ValueStateDescriptor("timervaluestate2", Long.TYPE);
        this.rightTimer_$eq((ValueState<Object>)this.getRuntimeContext().getState(valueStateDescriptor2));
        this.cRowWrapper_$eq(new CRowWrappingMultiOutputCollector());
        this.LOG().debug("Instantiating NonWindowJoin.");
    }

    public void processElement1(CRow valueC, CoProcessFunction.Context ctx, Collector<CRow> out) {
        this.processElement(valueC, ctx, out, this.leftTimer(), this.leftState(), this.rightState(), true);
    }

    public void processElement2(CRow valueC, CoProcessFunction.Context ctx, Collector<CRow> out) {
        this.processElement(valueC, ctx, out, this.rightTimer(), this.rightState(), this.leftState(), false);
    }

    public void onTimer(long timestamp, CoProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.stateCleaningEnabled() && BoxesRunTime.unboxToLong((Object)this.leftTimer().value()) == timestamp) {
            this.expireOutTimeRow(timestamp, this.leftState(), this.leftTimer(), true, ctx);
        }
        if (this.stateCleaningEnabled() && BoxesRunTime.unboxToLong((Object)this.rightTimer().value()) == timestamp) {
            this.expireOutTimeRow(timestamp, this.rightState(), this.rightTimer(), false, ctx);
        }
    }

    public long getNewExpiredTime(long curProcessTime, long oldExpiredTime) {
        return this.stateCleaningEnabled() && curProcessTime + this.minRetentionTime() > oldExpiredTime ? curProcessTime + this.maxRetentionTime() : oldExpiredTime;
    }

    public void expireOutTimeRow(long curTime, MapState<Row, Tuple2<Object, Object>> rowMapState, ValueState<Object> timerState, boolean isLeft, CoProcessFunction.OnTimerContext ctx) {
        Iterator rowMapIter = rowMapState.iterator();
        boolean validTimestamp = false;
        while (rowMapIter.hasNext()) {
            Map.Entry mapEntry = (Map.Entry)rowMapIter.next();
            long recordExpiredTime = BoxesRunTime.unboxToLong((Object)((Tuple2)mapEntry.getValue()).f1);
            if (recordExpiredTime <= curTime) {
                rowMapIter.remove();
                continue;
            }
            validTimestamp = true;
        }
        if (validTimestamp) {
            long cleanupTime = curTime + this.maxRetentionTime();
            ctx.timerService().registerProcessingTimeTimer(cleanupTime);
            timerState.update((Object)BoxesRunTime.boxToLong((long)cleanupTime));
        } else {
            timerState.clear();
            rowMapState.clear();
        }
    }

    public abstract void processElement(CRow var1, CoProcessFunction.Context var2, Collector<CRow> var3, ValueState<Object> var4, MapState<Row, Tuple2<Object, Object>> var5, MapState<Row, Tuple2<Object, Object>> var6, boolean var7);

    public Tuple2<Object, Object> updateCurrentSide(CRow value, CoProcessFunction.Context ctx, ValueState<Object> timerState, MapState<Row, Tuple2<Object, Object>> currentSideState) {
        Row inputRow = value.row();
        this.curProcessTime_$eq(ctx.timerService().currentProcessingTime());
        Tuple2 oldCntAndExpiredTime = (Tuple2)currentSideState.get((Object)inputRow);
        Tuple2 cntAndExpiredTime = oldCntAndExpiredTime == null ? Tuple2.of((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)-1L)) : oldCntAndExpiredTime;
        cntAndExpiredTime.f1 = BoxesRunTime.boxToLong((long)this.getNewExpiredTime(this.curProcessTime(), BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f1)));
        if (this.stateCleaningEnabled() && BoxesRunTime.unboxToLong((Object)timerState.value()) == 0L) {
            timerState.update(cntAndExpiredTime.f1);
            ctx.timerService().registerProcessingTimeTimer(BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f1));
        }
        if (value.change()) {
            cntAndExpiredTime.f0 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f0) + 1L));
            currentSideState.put((Object)inputRow, (Object)cntAndExpiredTime);
        } else {
            cntAndExpiredTime.f0 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f0) - 1L));
            if (BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f0) <= 0L) {
                currentSideState.remove((Object)inputRow);
            } else {
                currentSideState.put((Object)inputRow, (Object)cntAndExpiredTime);
            }
        }
        return cntAndExpiredTime;
    }

    public void callJoinFunction(Row inputRow, boolean inputRowFromLeft, Row otherSideRow, Collector<Row> cRowWrapper) {
        if (inputRowFromLeft) {
            this.joinFunction().join((Object)inputRow, (Object)otherSideRow, cRowWrapper);
        } else {
            this.joinFunction().join((Object)otherSideRow, (Object)inputRow, cRowWrapper);
        }
    }

    public void close() {
        FunctionUtils.closeFunction(this.joinFunction());
    }

    public NonWindowJoin(TypeInformation<Row> leftType, TypeInformation<Row> rightType, String genJoinFuncName, String genJoinFuncCode, StreamQueryConfig queryConfig) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", leftType);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", rightType);
        this.minRetentionTime = queryConfig.getMinIdleStateRetentionTime();
        this.maxRetentionTime = queryConfig.getMaxIdleStateRetentionTime();
        this.stateCleaningEnabled = this.minRetentionTime() > 1L;
    }
}

