/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf;

import java.util.LinkedList;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.flume.conf.FlumeConfigurationError;
import org.apache.flume.conf.FlumeConfigurationErrorType;

public abstract class ComponentConfiguration {
    protected String componentName;
    private String type;
    protected boolean configured;
    protected List<FlumeConfigurationError> errors;
    private boolean notFoundConfigClass;

    public boolean isNotFoundConfigClass() {
        return this.notFoundConfigClass;
    }

    public void setNotFoundConfigClass() {
        this.notFoundConfigClass = true;
    }

    protected ComponentConfiguration(String componentName) {
        this.componentName = componentName;
        this.errors = new LinkedList<FlumeConfigurationError>();
        this.type = null;
        this.configured = false;
    }

    public List<FlumeConfigurationError> getErrors() {
        return this.errors;
    }

    public void configure(Context context) throws ConfigurationException {
        this.failIfConfigured();
        String confType = context.getString("type");
        if (confType != null && !confType.isEmpty()) {
            this.type = confType;
        }
        if (this.type == null || this.type.isEmpty()) {
            this.errors.add(new FlumeConfigurationError(this.componentName, "type", FlumeConfigurationErrorType.ATTRS_MISSING, FlumeConfigurationError.ErrorOrWarning.ERROR));
            throw new ConfigurationException("Component has no type. Cannot configure. " + this.componentName);
        }
    }

    protected void failIfConfigured() throws ConfigurationException {
        if (this.configured) {
            throw new ConfigurationException("Already configured component." + this.componentName);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentCount) {
        StringBuilder indentSb = new StringBuilder("");
        for (int i = 0; i < indentCount; ++i) {
            indentSb.append("  ");
        }
        String indent = indentSb.toString();
        StringBuilder sb = new StringBuilder(indent);
        sb.append("ComponentConfiguration[").append(this.componentName).append("]");
        sb.append(FlumeConfiguration.NEWLINE).append(indent).append("  ").append("CONFIG: ");
        sb.append(FlumeConfiguration.NEWLINE).append(indent).append("  ");
        return sb.toString();
    }

    public String getComponentName() {
        return this.componentName;
    }

    protected void setConfigured() {
        this.configured = true;
    }

    public static enum ComponentType {
        OTHER(null),
        SOURCE("Source"),
        SINK("Sink"),
        SINK_PROCESSOR("SinkProcessor"),
        SINKGROUP("Sinkgroup"),
        CHANNEL("Channel"),
        CHANNELSELECTOR("ChannelSelector");

        private final String componentType;

        private ComponentType(String type) {
            this.componentType = type;
        }

        public String getComponentType() {
            return this.componentType;
        }
    }
}

