/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf.channel;

import org.apache.flume.Context;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.ConfigurationException;

public class ChannelConfiguration
extends ComponentConfiguration {
    public ChannelConfiguration(String componentName) {
        super(componentName);
    }

    @Override
    public void configure(Context context) throws ConfigurationException {
        super.configure(context);
    }

    public static enum ChannelConfigurationType {
        OTHER(null),
        MEMORY("org.apache.flume.conf.channel.MemoryChannelConfiguration"),
        FILE("org.apache.flume.conf.channel.FileChannelConfiguration"),
        JDBC("org.apache.flume.conf.channel.JdbcChannelConfiguration"),
        SPILLABLEMEMORY("org.apache.flume.conf.channel.SpillableMemoryChannelConfiguration");

        private String channelConfigurationType;

        private ChannelConfigurationType(String type) {
            this.channelConfigurationType = type;
        }

        public String getChannelConfigurationType() {
            return this.channelConfigurationType;
        }

        public ChannelConfiguration getConfiguration(String name) throws ConfigurationException {
            if (this.equals((Object)OTHER)) {
                return new ChannelConfiguration(name);
            }
            ChannelConfiguration instance = null;
            try {
                if (this.channelConfigurationType == null) {
                    return new ChannelConfiguration(name);
                }
                Class<?> clazz = Class.forName(this.channelConfigurationType);
                instance = (ChannelConfiguration)clazz.getConstructor(String.class).newInstance(name);
            }
            catch (ClassNotFoundException e) {
                instance = new ChannelConfiguration(name);
                instance.setNotFoundConfigClass();
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            return instance;
        }
    }
}

