/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerResourceDecrease;
import org.apache.hadoop.yarn.api.records.ContainerResourceIncrease;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class AllocateResponse {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static AllocateResponse newInstance(int responseId, List<ContainerStatus> completedContainers, List<Container> allocatedContainers, List<NodeReport> updatedNodes, Resource availResources, AMCommand command, int numClusterNodes, PreemptionMessage preempt, List<NMToken> nmTokens) {
        AllocateResponse response = Records.newRecord(AllocateResponse.class);
        response.setNumClusterNodes(numClusterNodes);
        response.setResponseId(responseId);
        response.setCompletedContainersStatuses(completedContainers);
        response.setAllocatedContainers(allocatedContainers);
        response.setUpdatedNodes(updatedNodes);
        response.setAvailableResources(availResources);
        response.setAMCommand(command);
        response.setPreemptionMessage(preempt);
        response.setNMTokens(nmTokens);
        return response;
    }

    @Deprecated
    public static AllocateResponse newInstance(int responseId, List<ContainerStatus> completedContainers, List<Container> allocatedContainers, List<NodeReport> updatedNodes, Resource availResources, AMCommand command, int numClusterNodes, PreemptionMessage preempt, List<NMToken> nmTokens, List<ContainerResourceIncrease> increasedContainers, List<ContainerResourceDecrease> decreasedContainers) {
        return AllocateResponse.newInstance(responseId, completedContainers, allocatedContainers, updatedNodes, availResources, command, numClusterNodes, preempt, nmTokens);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static AllocateResponse newInstance(int responseId, List<ContainerStatus> completedContainers, List<Container> allocatedContainers, List<NodeReport> updatedNodes, Resource availResources, AMCommand command, int numClusterNodes, PreemptionMessage preempt, List<NMToken> nmTokens, List<UpdatedContainer> updatedContainers) {
        AllocateResponse response = AllocateResponse.newInstance(responseId, completedContainers, allocatedContainers, updatedNodes, availResources, command, numClusterNodes, preempt, nmTokens);
        response.setUpdatedContainers(updatedContainers);
        return response;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static AllocateResponse newInstance(int responseId, List<ContainerStatus> completedContainers, List<Container> allocatedContainers, List<NodeReport> updatedNodes, Resource availResources, AMCommand command, int numClusterNodes, PreemptionMessage preempt, List<NMToken> nmTokens, Token amRMToken, List<UpdatedContainer> updatedContainers) {
        AllocateResponse response = AllocateResponse.newInstance(responseId, completedContainers, allocatedContainers, updatedNodes, availResources, command, numClusterNodes, preempt, nmTokens, updatedContainers);
        response.setAMRMToken(amRMToken);
        return response;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract AMCommand getAMCommand();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAMCommand(AMCommand var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getResponseId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setResponseId(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<Container> getAllocatedContainers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAllocatedContainers(List<Container> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getAvailableResources();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAvailableResources(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<ContainerStatus> getCompletedContainersStatuses();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCompletedContainersStatuses(List<ContainerStatus> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<NodeReport> getUpdatedNodes();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setUpdatedNodes(List<NodeReport> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getNumClusterNodes();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNumClusterNodes(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract PreemptionMessage getPreemptionMessage();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setPreemptionMessage(PreemptionMessage var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<NMToken> getNMTokens();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNMTokens(List<NMToken> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract List<UpdatedContainer> getUpdatedContainers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setUpdatedContainers(List<UpdatedContainer> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Token getAMRMToken();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAMRMToken(Token var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Priority getApplicationPriority();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationPriority(Priority var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public List<UpdateContainerError> getUpdateErrors() {
        return new ArrayList<UpdateContainerError>();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void setUpdateErrors(List<UpdateContainerError> updateErrors) {
    }

    @Deprecated
    public abstract List<ContainerResourceIncrease> getIncreasedContainers();

    @Deprecated
    public abstract List<ContainerResourceDecrease> getDecreasedContainers();
}

