/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterListBase;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FilterListWithAND
extends FilterListBase {
    private List<Filter> seekHintFilters = new ArrayList<Filter>();

    public FilterListWithAND(List<Filter> filters) {
        super(filters);
        this.subFiltersIncludedCell = new ArrayList<Boolean>(Collections.nCopies(filters.size(), true));
    }

    @Override
    public void addFilterLists(List<Filter> filters) {
        if (FilterListWithAND.checkAndGetReversed(filters, this.isReversed()) != this.isReversed()) {
            throw new IllegalArgumentException("Filters in the list must have the same reversed flag");
        }
        this.filters.addAll(filters);
        this.subFiltersIncludedCell.addAll(Collections.nCopies(filters.size(), true));
    }

    @Override
    protected String formatLogFilters(List<Filter> logFilters) {
        return String.format("FilterList AND (%d/%d): %s", logFilters.size(), this.size(), logFilters.toString());
    }

    private Filter.ReturnCode mergeReturnCode(Filter.ReturnCode rc, Filter.ReturnCode localRC) {
        if (rc == Filter.ReturnCode.SEEK_NEXT_USING_HINT) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        switch (localRC) {
            case SEEK_NEXT_USING_HINT: {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
            case INCLUDE: {
                return rc;
            }
            case INCLUDE_AND_NEXT_COL: {
                if (FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE, Filter.ReturnCode.INCLUDE_AND_NEXT_COL)) {
                    return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                }
                if (FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW)) {
                    return Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW;
                }
                if (FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.SKIP, Filter.ReturnCode.NEXT_COL)) {
                    return Filter.ReturnCode.NEXT_COL;
                }
                if (!FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.NEXT_ROW)) break;
                return Filter.ReturnCode.NEXT_ROW;
            }
            case INCLUDE_AND_SEEK_NEXT_ROW: {
                if (FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE, Filter.ReturnCode.INCLUDE_AND_NEXT_COL, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW)) {
                    return Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW;
                }
                if (!FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.SKIP, Filter.ReturnCode.NEXT_COL, Filter.ReturnCode.NEXT_ROW)) break;
                return Filter.ReturnCode.NEXT_ROW;
            }
            case SKIP: {
                if (FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE, Filter.ReturnCode.SKIP)) {
                    return Filter.ReturnCode.SKIP;
                }
                if (FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE_AND_NEXT_COL, Filter.ReturnCode.NEXT_COL)) {
                    return Filter.ReturnCode.NEXT_COL;
                }
                if (!FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW, Filter.ReturnCode.NEXT_ROW)) break;
                return Filter.ReturnCode.NEXT_ROW;
            }
            case NEXT_COL: {
                if (FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE, Filter.ReturnCode.INCLUDE_AND_NEXT_COL, Filter.ReturnCode.SKIP, Filter.ReturnCode.NEXT_COL)) {
                    return Filter.ReturnCode.NEXT_COL;
                }
                if (!FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW, Filter.ReturnCode.NEXT_ROW)) break;
                return Filter.ReturnCode.NEXT_ROW;
            }
            case NEXT_ROW: {
                return Filter.ReturnCode.NEXT_ROW;
            }
        }
        throw new IllegalStateException("Received code is not valid. rc: " + (Object)((Object)rc) + ", localRC: " + (Object)((Object)localRC));
    }

    private boolean isIncludeRelatedReturnCode(Filter.ReturnCode rc) {
        return FilterListWithAND.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE, Filter.ReturnCode.INCLUDE_AND_NEXT_COL, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) throws IOException {
        if (this.isEmpty()) {
            return Filter.ReturnCode.INCLUDE;
        }
        Filter.ReturnCode rc = Filter.ReturnCode.INCLUDE;
        this.seekHintFilters.clear();
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            Filter filter = (Filter)this.filters.get(i);
            if (filter.filterAllRemaining()) {
                return Filter.ReturnCode.NEXT_ROW;
            }
            Filter.ReturnCode localRC = filter.filterCell(c);
            if (localRC == Filter.ReturnCode.SEEK_NEXT_USING_HINT) {
                this.seekHintFilters.add(filter);
            }
            if (this.isIncludeRelatedReturnCode(rc = this.mergeReturnCode(rc, localRC))) continue;
            return rc;
        }
        if (!this.seekHintFilters.isEmpty()) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        return rc;
    }

    @Override
    public void reset() throws IOException {
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            ((Filter)this.filters.get(i)).reset();
        }
        this.seekHintFilters.clear();
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) throws IOException {
        if (this.isEmpty()) {
            return super.filterRowKey(rowKey, offset, length);
        }
        boolean retVal = false;
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            Filter filter = (Filter)this.filters.get(i);
            if (!filter.filterAllRemaining() && !filter.filterRowKey(rowKey, offset, length)) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean filterRowKey(Cell firstRowCell) throws IOException {
        if (this.isEmpty()) {
            return super.filterRowKey(firstRowCell);
        }
        boolean retVal = false;
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            Filter filter = (Filter)this.filters.get(i);
            if (!filter.filterAllRemaining() && !filter.filterRowKey(firstRowCell)) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean filterAllRemaining() throws IOException {
        if (this.isEmpty()) {
            return super.filterAllRemaining();
        }
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            if (!((Filter)this.filters.get(i)).filterAllRemaining()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterRow() throws IOException {
        if (this.isEmpty()) {
            return super.filterRow();
        }
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            Filter filter = (Filter)this.filters.get(i);
            if (!filter.filterRow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Cell getNextCellHint(Cell currentCell) throws IOException {
        if (this.isEmpty()) {
            return super.getNextCellHint(currentCell);
        }
        Cell maxHint = null;
        for (Filter filter : this.seekHintFilters) {
            if (filter.filterAllRemaining()) continue;
            Cell curKeyHint = filter.getNextCellHint(currentCell);
            if (maxHint == null) {
                maxHint = curKeyHint;
                continue;
            }
            if (this.compareCell(maxHint, curKeyHint) >= 0) continue;
            maxHint = curKeyHint;
        }
        return maxHint;
    }
}

