/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestChoreService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testInitialChorePrecedence() throws InterruptedException {
        ChoreService service = ChoreService.getInstance((String)"testInitialChorePrecedence");
        int period = 100;
        int failureThreshold = 5;
        try {
            ScheduledChoreSamples.FailInitialChore chore = new ScheduledChoreSamples.FailInitialChore("chore", 100, 5);
            service.scheduleChore((ScheduledChore)chore);
            int loopCount = 0;
            boolean brokeOutOfLoop = false;
            while (!chore.isInitialChoreComplete() && chore.isScheduled()) {
                Thread.sleep(500L);
                if (++loopCount <= 3) continue;
                brokeOutOfLoop = true;
                break;
            }
            Assert.assertFalse((boolean)brokeOutOfLoop);
        }
        finally {
            this.shutdownService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testCancelChore() throws InterruptedException {
        int period = 100;
        ScheduledChoreSamples.DoNothingChore chore1 = new ScheduledChoreSamples.DoNothingChore("chore1", 100);
        ChoreService service = ChoreService.getInstance((String)"testCancelChore");
        try {
            service.scheduleChore((ScheduledChore)chore1);
            Assert.assertTrue((boolean)chore1.isScheduled());
            chore1.cancel(true);
            Assert.assertFalse((boolean)chore1.isScheduled());
            Assert.assertTrue((service.getNumberOfScheduledChores() == 0 ? 1 : 0) != 0);
        }
        finally {
            this.shutdownService(service);
        }
    }

    @Test(timeout=20000L)
    public void testScheduledChoreConstruction() {
        String NAME = "chore";
        int PERIOD = 100;
        long VALID_DELAY = 0L;
        long INVALID_DELAY = -100L;
        TimeUnit UNIT = TimeUnit.NANOSECONDS;
        ScheduledChore chore1 = new ScheduledChore("chore", new ScheduledChoreSamples.SampleStopper(), 100, 0L, UNIT){

            protected void chore() {
            }
        };
        Assert.assertEquals((String)"Name construction failed", (Object)chore1.getName(), (Object)"chore");
        Assert.assertEquals((String)"Period construction failed", (long)chore1.getPeriod(), (long)100L);
        Assert.assertEquals((String)"Initial Delay construction failed", (long)chore1.getInitialDelay(), (long)0L);
        Assert.assertEquals((String)"TimeUnit construction failed", (Object)((Object)chore1.getTimeUnit()), (Object)((Object)UNIT));
        ScheduledChore invalidDelayChore = new ScheduledChore("chore", new ScheduledChoreSamples.SampleStopper(), 100, -100L, UNIT){

            protected void chore() {
            }
        };
        Assert.assertEquals((String)"Initial Delay should be set to 0 when invalid", (long)0L, (long)invalidDelayChore.getInitialDelay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testChoreServiceConstruction() throws InterruptedException {
        int corePoolSize = 10;
        boolean defaultCorePoolSize = true;
        ChoreService customInit = new ChoreService("testChoreServiceConstruction_custom", 10, false);
        try {
            Assert.assertEquals((long)10L, (long)customInit.getCorePoolSize());
        }
        finally {
            this.shutdownService(customInit);
        }
        ChoreService defaultInit = new ChoreService("testChoreServiceConstruction_default");
        try {
            Assert.assertEquals((long)1L, (long)defaultInit.getCorePoolSize());
        }
        finally {
            this.shutdownService(defaultInit);
        }
        ChoreService invalidInit = new ChoreService("testChoreServiceConstruction_invalid", -10, false);
        try {
            Assert.assertEquals((long)1L, (long)invalidInit.getCorePoolSize());
        }
        finally {
            this.shutdownService(invalidInit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testFrequencyOfChores() throws InterruptedException {
        int period = 100;
        int delta = 5;
        ChoreService service = ChoreService.getInstance((String)"testFrequencyOfChores");
        ScheduledChoreSamples.CountingChore chore = new ScheduledChoreSamples.CountingChore("countingChore", 100);
        try {
            service.scheduleChore((ScheduledChore)chore);
            Thread.sleep(1005L);
            Assert.assertTrue((chore.getCountOfChoreCalls() == 11 ? 1 : 0) != 0);
            Thread.sleep(1000L);
            Assert.assertTrue((chore.getCountOfChoreCalls() == 21 ? 1 : 0) != 0);
        }
        finally {
            this.shutdownService(service);
        }
    }

    public void shutdownService(ChoreService service) throws InterruptedException {
        service.shutdown();
        while (!service.isTerminated()) {
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testForceTrigger() throws InterruptedException {
        int period = 100;
        int delta = 5;
        ChoreService service = ChoreService.getInstance((String)"testForceTrigger");
        ScheduledChoreSamples.CountingChore chore = new ScheduledChoreSamples.CountingChore("countingChore", 100);
        try {
            service.scheduleChore((ScheduledChore)chore);
            Thread.sleep(1005L);
            Assert.assertTrue((chore.getCountOfChoreCalls() == 11 ? 1 : 0) != 0);
            chore.triggerNow();
            Thread.sleep(5L);
            chore.triggerNow();
            Thread.sleep(5L);
            chore.triggerNow();
            Thread.sleep(5L);
            chore.triggerNow();
            Thread.sleep(5L);
            chore.triggerNow();
            Thread.sleep(5L);
            Assert.assertTrue((String)("" + chore.getCountOfChoreCalls()), (chore.getCountOfChoreCalls() == 16 ? 1 : 0) != 0);
            Thread.sleep(1005L);
            Assert.assertTrue((String)("" + chore.getCountOfChoreCalls()), (chore.getCountOfChoreCalls() > 16 ? 1 : 0) != 0);
        }
        finally {
            this.shutdownService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testCorePoolIncrease() throws InterruptedException {
        int initialCorePoolSize = 3;
        ChoreService service = new ChoreService("testCorePoolIncrease", 3, false);
        try {
            Assert.assertEquals((String)"Should have a core pool of size: 3", (long)3L, (long)service.getCorePoolSize());
            int slowChorePeriod = 100;
            ScheduledChoreSamples.SlowChore slowChore1 = new ScheduledChoreSamples.SlowChore("slowChore1", 100);
            ScheduledChoreSamples.SlowChore slowChore2 = new ScheduledChoreSamples.SlowChore("slowChore2", 100);
            ScheduledChoreSamples.SlowChore slowChore3 = new ScheduledChoreSamples.SlowChore("slowChore3", 100);
            service.scheduleChore((ScheduledChore)slowChore1);
            service.scheduleChore((ScheduledChore)slowChore2);
            service.scheduleChore((ScheduledChore)slowChore3);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Should not create more pools than scheduled chores", (long)3L, (long)service.getCorePoolSize());
            ScheduledChoreSamples.SlowChore slowChore4 = new ScheduledChoreSamples.SlowChore("slowChore4", 100);
            service.scheduleChore((ScheduledChore)slowChore4);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)4L, (long)service.getCorePoolSize());
            ScheduledChoreSamples.SlowChore slowChore5 = new ScheduledChoreSamples.SlowChore("slowChore5", 100);
            service.scheduleChore((ScheduledChore)slowChore5);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)5L, (long)service.getCorePoolSize());
        }
        finally {
            this.shutdownService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCorePoolDecrease() throws InterruptedException {
        int initialCorePoolSize = 3;
        ChoreService service = new ChoreService("testCorePoolDecrease", 3, false);
        int chorePeriod = 100;
        try {
            ScheduledChoreSamples.SlowChore slowChore1 = new ScheduledChoreSamples.SlowChore("slowChore1", 100);
            ScheduledChoreSamples.SlowChore slowChore2 = new ScheduledChoreSamples.SlowChore("slowChore2", 100);
            ScheduledChoreSamples.SlowChore slowChore3 = new ScheduledChoreSamples.SlowChore("slowChore3", 100);
            service.scheduleChore((ScheduledChore)slowChore1);
            service.scheduleChore((ScheduledChore)slowChore2);
            service.scheduleChore((ScheduledChore)slowChore3);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Should not create more pools than scheduled chores", (long)service.getNumberOfScheduledChores(), (long)service.getCorePoolSize());
            ScheduledChoreSamples.SlowChore slowChore4 = new ScheduledChoreSamples.SlowChore("slowChore4", 100);
            service.scheduleChore((ScheduledChore)slowChore4);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)service.getNumberOfScheduledChores(), (long)service.getCorePoolSize());
            ScheduledChoreSamples.SlowChore slowChore5 = new ScheduledChoreSamples.SlowChore("slowChore5", 100);
            service.scheduleChore((ScheduledChore)slowChore5);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)service.getNumberOfScheduledChores(), (long)service.getCorePoolSize());
            Assert.assertEquals((long)service.getNumberOfChoresMissingStartTime(), (long)5L);
            slowChore5.cancel();
            Thread.sleep(1000L);
            Assert.assertEquals((long)Math.max(1, service.getNumberOfScheduledChores()), (long)service.getCorePoolSize());
            Assert.assertEquals((long)service.getNumberOfChoresMissingStartTime(), (long)4L);
            slowChore4.cancel();
            Thread.sleep(1000L);
            Assert.assertEquals((long)Math.max(1, service.getNumberOfScheduledChores()), (long)service.getCorePoolSize());
            Assert.assertEquals((long)service.getNumberOfChoresMissingStartTime(), (long)3L);
            slowChore3.cancel();
            Thread.sleep(1000L);
            Assert.assertEquals((long)Math.max(1, service.getNumberOfScheduledChores()), (long)service.getCorePoolSize());
            Assert.assertEquals((long)service.getNumberOfChoresMissingStartTime(), (long)2L);
            slowChore2.cancel();
            Thread.sleep(1000L);
            Assert.assertEquals((long)Math.max(1, service.getNumberOfScheduledChores()), (long)service.getCorePoolSize());
            Assert.assertEquals((long)service.getNumberOfChoresMissingStartTime(), (long)1L);
            slowChore1.cancel();
            Thread.sleep(1000L);
            Assert.assertEquals((long)Math.max(1, service.getNumberOfScheduledChores()), (long)service.getCorePoolSize());
            Assert.assertEquals((long)service.getNumberOfChoresMissingStartTime(), (long)0L);
        }
        finally {
            this.shutdownService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testNumberOfRunningChores() throws InterruptedException {
        ChoreService service = new ChoreService("testNumberOfRunningChores");
        int period = 100;
        int sleepTime = 5;
        try {
            ScheduledChoreSamples.DoNothingChore dn1 = new ScheduledChoreSamples.DoNothingChore("dn1", 100);
            ScheduledChoreSamples.DoNothingChore dn2 = new ScheduledChoreSamples.DoNothingChore("dn2", 100);
            ScheduledChoreSamples.DoNothingChore dn3 = new ScheduledChoreSamples.DoNothingChore("dn3", 100);
            ScheduledChoreSamples.DoNothingChore dn4 = new ScheduledChoreSamples.DoNothingChore("dn4", 100);
            ScheduledChoreSamples.DoNothingChore dn5 = new ScheduledChoreSamples.DoNothingChore("dn5", 100);
            service.scheduleChore((ScheduledChore)dn1);
            service.scheduleChore((ScheduledChore)dn2);
            service.scheduleChore((ScheduledChore)dn3);
            service.scheduleChore((ScheduledChore)dn4);
            service.scheduleChore((ScheduledChore)dn5);
            Thread.sleep(5L);
            Assert.assertEquals((String)"Scheduled chore mismatch", (long)5L, (long)service.getNumberOfScheduledChores());
            dn1.cancel();
            Thread.sleep(5L);
            Assert.assertEquals((String)"Scheduled chore mismatch", (long)4L, (long)service.getNumberOfScheduledChores());
            dn2.cancel();
            dn3.cancel();
            dn4.cancel();
            Thread.sleep(5L);
            Assert.assertEquals((String)"Scheduled chore mismatch", (long)1L, (long)service.getNumberOfScheduledChores());
            dn5.cancel();
            Thread.sleep(5L);
            Assert.assertEquals((String)"Scheduled chore mismatch", (long)0L, (long)service.getNumberOfScheduledChores());
        }
        finally {
            this.shutdownService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testNumberOfChoresMissingStartTime() throws InterruptedException {
        ChoreService service = new ChoreService("testNumberOfChoresMissingStartTime");
        int period = 100;
        int sleepTime = 500;
        try {
            ScheduledChoreSamples.SlowChore sc1 = new ScheduledChoreSamples.SlowChore("sc1", 100);
            ScheduledChoreSamples.SlowChore sc2 = new ScheduledChoreSamples.SlowChore("sc2", 100);
            ScheduledChoreSamples.SlowChore sc3 = new ScheduledChoreSamples.SlowChore("sc3", 100);
            ScheduledChoreSamples.SlowChore sc4 = new ScheduledChoreSamples.SlowChore("sc4", 100);
            ScheduledChoreSamples.SlowChore sc5 = new ScheduledChoreSamples.SlowChore("sc5", 100);
            service.scheduleChore((ScheduledChore)sc1);
            service.scheduleChore((ScheduledChore)sc2);
            service.scheduleChore((ScheduledChore)sc3);
            service.scheduleChore((ScheduledChore)sc4);
            service.scheduleChore((ScheduledChore)sc5);
            Thread.sleep(500L);
            Assert.assertEquals((long)5L, (long)service.getNumberOfChoresMissingStartTime());
            sc1.cancel();
            Thread.sleep(500L);
            Assert.assertEquals((long)4L, (long)service.getNumberOfChoresMissingStartTime());
            sc2.cancel();
            sc3.cancel();
            sc4.cancel();
            Thread.sleep(500L);
            Assert.assertEquals((long)1L, (long)service.getNumberOfChoresMissingStartTime());
            sc5.cancel();
            Thread.sleep(500L);
            Assert.assertEquals((long)0L, (long)service.getNumberOfChoresMissingStartTime());
        }
        finally {
            this.shutdownService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testMaximumChoreServiceThreads() throws InterruptedException {
        ChoreService service = new ChoreService("testMaximumChoreServiceThreads");
        int period = 100;
        int sleepTime = 500;
        try {
            ScheduledChoreSamples.SlowChore sc1 = new ScheduledChoreSamples.SlowChore("sc1", 100);
            ScheduledChoreSamples.SlowChore sc2 = new ScheduledChoreSamples.SlowChore("sc2", 100);
            ScheduledChoreSamples.SlowChore sc3 = new ScheduledChoreSamples.SlowChore("sc3", 100);
            ScheduledChoreSamples.SlowChore sc4 = new ScheduledChoreSamples.SlowChore("sc4", 100);
            ScheduledChoreSamples.SlowChore sc5 = new ScheduledChoreSamples.SlowChore("sc5", 100);
            service.scheduleChore((ScheduledChore)sc1);
            service.scheduleChore((ScheduledChore)sc2);
            service.scheduleChore((ScheduledChore)sc3);
            service.scheduleChore((ScheduledChore)sc4);
            service.scheduleChore((ScheduledChore)sc5);
            Thread.sleep(500L);
            Assert.assertTrue((service.getCorePoolSize() <= service.getNumberOfScheduledChores() ? 1 : 0) != 0);
            ScheduledChoreSamples.SlowChore sc6 = new ScheduledChoreSamples.SlowChore("sc6", 100);
            ScheduledChoreSamples.SlowChore sc7 = new ScheduledChoreSamples.SlowChore("sc7", 100);
            ScheduledChoreSamples.SlowChore sc8 = new ScheduledChoreSamples.SlowChore("sc8", 100);
            ScheduledChoreSamples.SlowChore sc9 = new ScheduledChoreSamples.SlowChore("sc9", 100);
            ScheduledChoreSamples.SlowChore sc10 = new ScheduledChoreSamples.SlowChore("sc10", 100);
            service.scheduleChore((ScheduledChore)sc6);
            service.scheduleChore((ScheduledChore)sc7);
            service.scheduleChore((ScheduledChore)sc8);
            service.scheduleChore((ScheduledChore)sc9);
            service.scheduleChore((ScheduledChore)sc10);
            Thread.sleep(500L);
            Assert.assertTrue((service.getCorePoolSize() <= service.getNumberOfScheduledChores() ? 1 : 0) != 0);
        }
        finally {
            this.shutdownService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testChangingChoreServices() throws InterruptedException {
        int period = 100;
        int sleepTime = 10;
        ChoreService service1 = new ChoreService("testChangingChoreServices_1");
        ChoreService service2 = new ChoreService("testChangingChoreServices_2");
        ScheduledChoreSamples.DoNothingChore chore = new ScheduledChoreSamples.DoNothingChore("sample", 100);
        try {
            Assert.assertFalse((boolean)chore.isScheduled());
            Assert.assertFalse((boolean)service1.isChoreScheduled((ScheduledChore)chore));
            Assert.assertFalse((boolean)service2.isChoreScheduled((ScheduledChore)chore));
            Assert.assertTrue((chore.getChoreServicer() == null ? 1 : 0) != 0);
            service1.scheduleChore((ScheduledChore)chore);
            Thread.sleep(10L);
            Assert.assertTrue((boolean)chore.isScheduled());
            Assert.assertTrue((boolean)service1.isChoreScheduled((ScheduledChore)chore));
            Assert.assertFalse((boolean)service2.isChoreScheduled((ScheduledChore)chore));
            Assert.assertFalse((chore.getChoreServicer() == null ? 1 : 0) != 0);
            service2.scheduleChore((ScheduledChore)chore);
            Thread.sleep(10L);
            Assert.assertTrue((boolean)chore.isScheduled());
            Assert.assertFalse((boolean)service1.isChoreScheduled((ScheduledChore)chore));
            Assert.assertTrue((boolean)service2.isChoreScheduled((ScheduledChore)chore));
            Assert.assertFalse((chore.getChoreServicer() == null ? 1 : 0) != 0);
            chore.cancel();
            Assert.assertFalse((boolean)chore.isScheduled());
            Assert.assertFalse((boolean)service1.isChoreScheduled((ScheduledChore)chore));
            Assert.assertFalse((boolean)service2.isChoreScheduled((ScheduledChore)chore));
            Assert.assertTrue((chore.getChoreServicer() == null ? 1 : 0) != 0);
        }
        finally {
            this.shutdownService(service1);
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testTriggerNowFailsWhenNotScheduled() throws InterruptedException {
        int period = 100;
        int sleep = 5;
        ChoreService service = new ChoreService("testTriggerNowFailsWhenNotScheduled");
        ScheduledChoreSamples.CountingChore chore = new ScheduledChoreSamples.CountingChore("dn", 100);
        try {
            Assert.assertFalse((boolean)chore.triggerNow());
            Assert.assertTrue((chore.getCountOfChoreCalls() == 0 ? 1 : 0) != 0);
            service.scheduleChore((ScheduledChore)chore);
            Thread.sleep(5L);
            Assert.assertEquals((long)1L, (long)chore.getCountOfChoreCalls());
            Thread.sleep(100L);
            Assert.assertEquals((long)2L, (long)chore.getCountOfChoreCalls());
            Assert.assertTrue((boolean)chore.triggerNow());
            Thread.sleep(5L);
            Assert.assertTrue((boolean)chore.triggerNow());
            Thread.sleep(5L);
            Assert.assertTrue((boolean)chore.triggerNow());
            Thread.sleep(5L);
            Assert.assertEquals((long)5L, (long)chore.getCountOfChoreCalls());
        }
        finally {
            this.shutdownService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testStopperForScheduledChores() throws InterruptedException {
        ChoreService service = ChoreService.getInstance((String)"testStopperForScheduledChores");
        ScheduledChoreSamples.SampleStopper stopperForGroup1 = new ScheduledChoreSamples.SampleStopper();
        ScheduledChoreSamples.SampleStopper stopperForGroup2 = new ScheduledChoreSamples.SampleStopper();
        int period = 100;
        int delta = 10;
        try {
            ScheduledChoreSamples.DoNothingChore chore1_group1 = new ScheduledChoreSamples.DoNothingChore("c1g1", stopperForGroup1, 100);
            ScheduledChoreSamples.DoNothingChore chore2_group1 = new ScheduledChoreSamples.DoNothingChore("c2g1", stopperForGroup1, 100);
            ScheduledChoreSamples.DoNothingChore chore3_group1 = new ScheduledChoreSamples.DoNothingChore("c3g1", stopperForGroup1, 100);
            ScheduledChoreSamples.DoNothingChore chore1_group2 = new ScheduledChoreSamples.DoNothingChore("c1g2", stopperForGroup2, 100);
            ScheduledChoreSamples.DoNothingChore chore2_group2 = new ScheduledChoreSamples.DoNothingChore("c2g2", stopperForGroup2, 100);
            ScheduledChoreSamples.DoNothingChore chore3_group2 = new ScheduledChoreSamples.DoNothingChore("c3g2", stopperForGroup2, 100);
            service.scheduleChore((ScheduledChore)chore1_group1);
            service.scheduleChore((ScheduledChore)chore2_group1);
            service.scheduleChore((ScheduledChore)chore3_group1);
            service.scheduleChore((ScheduledChore)chore1_group2);
            service.scheduleChore((ScheduledChore)chore2_group2);
            service.scheduleChore((ScheduledChore)chore3_group2);
            Thread.sleep(10L);
            Thread.sleep(1000L);
            Assert.assertTrue((boolean)chore1_group1.isScheduled());
            Assert.assertTrue((boolean)chore2_group1.isScheduled());
            Assert.assertTrue((boolean)chore3_group1.isScheduled());
            Assert.assertTrue((boolean)chore1_group2.isScheduled());
            Assert.assertTrue((boolean)chore2_group2.isScheduled());
            Assert.assertTrue((boolean)chore3_group2.isScheduled());
            stopperForGroup1.stop("test stopping group 1");
            Thread.sleep(100L);
            Assert.assertFalse((boolean)chore1_group1.isScheduled());
            Assert.assertFalse((boolean)chore2_group1.isScheduled());
            Assert.assertFalse((boolean)chore3_group1.isScheduled());
            Assert.assertTrue((boolean)chore1_group2.isScheduled());
            Assert.assertTrue((boolean)chore2_group2.isScheduled());
            Assert.assertTrue((boolean)chore3_group2.isScheduled());
            stopperForGroup2.stop("test stopping group 2");
            Thread.sleep(100L);
            Assert.assertFalse((boolean)chore1_group1.isScheduled());
            Assert.assertFalse((boolean)chore2_group1.isScheduled());
            Assert.assertFalse((boolean)chore3_group1.isScheduled());
            Assert.assertFalse((boolean)chore1_group2.isScheduled());
            Assert.assertFalse((boolean)chore2_group2.isScheduled());
            Assert.assertFalse((boolean)chore3_group2.isScheduled());
        }
        finally {
            this.shutdownService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testShutdownCancelsScheduledChores() throws InterruptedException {
        int period = 100;
        ChoreService service = new ChoreService("testShutdownCancelsScheduledChores");
        ScheduledChoreSamples.DoNothingChore successChore1 = new ScheduledChoreSamples.DoNothingChore("sc1", 100);
        ScheduledChoreSamples.DoNothingChore successChore2 = new ScheduledChoreSamples.DoNothingChore("sc2", 100);
        ScheduledChoreSamples.DoNothingChore successChore3 = new ScheduledChoreSamples.DoNothingChore("sc3", 100);
        try {
            Assert.assertTrue((boolean)service.scheduleChore((ScheduledChore)successChore1));
            Assert.assertTrue((boolean)successChore1.isScheduled());
            Assert.assertTrue((boolean)service.scheduleChore((ScheduledChore)successChore2));
            Assert.assertTrue((boolean)successChore2.isScheduled());
            Assert.assertTrue((boolean)service.scheduleChore((ScheduledChore)successChore3));
            Assert.assertTrue((boolean)successChore3.isScheduled());
        }
        finally {
            this.shutdownService(service);
        }
        Assert.assertFalse((boolean)successChore1.isScheduled());
        Assert.assertFalse((boolean)successChore2.isScheduled());
        Assert.assertFalse((boolean)successChore3.isScheduled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testShutdownWorksWhileChoresAreExecuting() throws InterruptedException {
        int period = 100;
        int sleep = 500;
        ChoreService service = new ChoreService("testShutdownWorksWhileChoresAreExecuting");
        ScheduledChoreSamples.SleepingChore slowChore1 = new ScheduledChoreSamples.SleepingChore("sc1", 100, 500);
        ScheduledChoreSamples.SleepingChore slowChore2 = new ScheduledChoreSamples.SleepingChore("sc2", 100, 500);
        ScheduledChoreSamples.SleepingChore slowChore3 = new ScheduledChoreSamples.SleepingChore("sc3", 100, 500);
        try {
            Assert.assertTrue((boolean)service.scheduleChore((ScheduledChore)slowChore1));
            Assert.assertTrue((boolean)service.scheduleChore((ScheduledChore)slowChore2));
            Assert.assertTrue((boolean)service.scheduleChore((ScheduledChore)slowChore3));
            Thread.sleep(250L);
            this.shutdownService(service);
            Assert.assertFalse((boolean)slowChore1.isScheduled());
            Assert.assertFalse((boolean)slowChore2.isScheduled());
            Assert.assertFalse((boolean)slowChore3.isScheduled());
            Assert.assertTrue((boolean)service.isShutdown());
            Thread.sleep(5L);
            Assert.assertTrue((boolean)service.isTerminated());
        }
        finally {
            this.shutdownService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testShutdownRejectsNewSchedules() throws InterruptedException {
        int period = 100;
        ChoreService service = new ChoreService("testShutdownRejectsNewSchedules");
        ScheduledChoreSamples.DoNothingChore successChore1 = new ScheduledChoreSamples.DoNothingChore("sc1", 100);
        ScheduledChoreSamples.DoNothingChore successChore2 = new ScheduledChoreSamples.DoNothingChore("sc2", 100);
        ScheduledChoreSamples.DoNothingChore successChore3 = new ScheduledChoreSamples.DoNothingChore("sc3", 100);
        ScheduledChoreSamples.DoNothingChore failChore1 = new ScheduledChoreSamples.DoNothingChore("fc1", 100);
        ScheduledChoreSamples.DoNothingChore failChore2 = new ScheduledChoreSamples.DoNothingChore("fc2", 100);
        ScheduledChoreSamples.DoNothingChore failChore3 = new ScheduledChoreSamples.DoNothingChore("fc3", 100);
        try {
            Assert.assertTrue((boolean)service.scheduleChore((ScheduledChore)successChore1));
            Assert.assertTrue((boolean)successChore1.isScheduled());
            Assert.assertTrue((boolean)service.scheduleChore((ScheduledChore)successChore2));
            Assert.assertTrue((boolean)successChore2.isScheduled());
            Assert.assertTrue((boolean)service.scheduleChore((ScheduledChore)successChore3));
            Assert.assertTrue((boolean)successChore3.isScheduled());
        }
        finally {
            this.shutdownService(service);
        }
        Assert.assertFalse((boolean)service.scheduleChore((ScheduledChore)failChore1));
        Assert.assertFalse((boolean)failChore1.isScheduled());
        Assert.assertFalse((boolean)service.scheduleChore((ScheduledChore)failChore2));
        Assert.assertFalse((boolean)failChore2.isScheduled());
        Assert.assertFalse((boolean)service.scheduleChore((ScheduledChore)failChore3));
        Assert.assertFalse((boolean)failChore3.isScheduled());
    }

    public static class ScheduledChoreSamples {

        public static class FailInitialChore
        extends ScheduledChore {
            private int numberOfFailures = 0;
            private int failureThreshold;

            public FailInitialChore(String name, int period, int failThreshold) {
                this(name, new SampleStopper(), period, failThreshold);
            }

            public FailInitialChore(String name, Stoppable stopper, int period, int failThreshold) {
                super(name, stopper, period);
                this.failureThreshold = failThreshold;
            }

            protected boolean initialChore() {
                if (this.numberOfFailures < this.failureThreshold) {
                    ++this.numberOfFailures;
                    return false;
                }
                return true;
            }

            protected void chore() {
                Assert.assertTrue((this.numberOfFailures == this.failureThreshold ? 1 : 0) != 0);
                this.cancel(false);
            }
        }

        public static class CountingChore
        extends ScheduledChore {
            private int countOfChoreCalls = 0;
            private boolean outputOnTicks = false;

            public CountingChore(String name, int period) {
                this(name, new SampleStopper(), period);
            }

            public CountingChore(String name, Stoppable stopper, int period) {
                this(name, stopper, period, false);
            }

            public CountingChore(String name, Stoppable stopper, int period, boolean outputOnTicks) {
                super(name, stopper, period);
                this.outputOnTicks = outputOnTicks;
            }

            protected boolean initialChore() {
                ++this.countOfChoreCalls;
                if (this.outputOnTicks) {
                    this.outputTickCount();
                }
                return true;
            }

            protected void chore() {
                ++this.countOfChoreCalls;
                if (this.outputOnTicks) {
                    this.outputTickCount();
                }
            }

            private void outputTickCount() {
                System.out.println("Chore: " + this.getName() + ". Count of chore calls: " + this.countOfChoreCalls);
            }

            public int getCountOfChoreCalls() {
                return this.countOfChoreCalls;
            }

            public boolean isOutputtingOnTicks() {
                return this.outputOnTicks;
            }

            public void setOutputOnTicks(boolean o) {
                this.outputOnTicks = o;
            }
        }

        public static class SleepingChore
        extends ScheduledChore {
            private int sleepTime;

            public SleepingChore(String name, int chorePeriod, int sleepTime) {
                this(name, new SampleStopper(), chorePeriod, sleepTime);
            }

            public SleepingChore(String name, Stoppable stopper, int period, int sleepTime) {
                super(name, stopper, period);
                this.sleepTime = sleepTime;
            }

            protected boolean initialChore() {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            protected void chore() {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception e) {
                    System.err.println(e.getStackTrace());
                }
            }
        }

        public static class DoNothingChore
        extends ScheduledChore {
            public DoNothingChore(String name, int period) {
                super(name, (Stoppable)new SampleStopper(), period);
            }

            public DoNothingChore(String name, Stoppable stopper, int period) {
                super(name, stopper, period);
            }

            protected void chore() {
            }
        }

        public static class SlowChore
        extends ScheduledChore {
            public SlowChore(String name, int period) {
                this(name, new SampleStopper(), period);
            }

            public SlowChore(String name, Stoppable stopper, int period) {
                super(name, stopper, period);
            }

            protected boolean initialChore() {
                try {
                    Thread.sleep(this.getPeriod() * 2);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            protected void chore() {
                try {
                    Thread.sleep(this.getPeriod() * 2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public static class SampleStopper
        implements Stoppable {
            private boolean stopped = false;

            public void stop(String why) {
                this.stopped = true;
            }

            public boolean isStopped() {
                return this.stopped;
            }
        }
    }
}

