/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.AbstractMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFile;

@InterfaceAudience.Private
public class DateTieredMultiFileWriter
extends AbstractMultiFileWriter {
    private final NavigableMap<Long, StoreFile.Writer> lowerBoundary2Writer = new TreeMap<Long, StoreFile.Writer>();
    private final boolean needEmptyFile;

    public DateTieredMultiFileWriter(List<Long> lowerBoundaries, boolean needEmptyFile) {
        for (Long lowerBoundary : lowerBoundaries) {
            this.lowerBoundary2Writer.put(lowerBoundary, null);
        }
        this.needEmptyFile = needEmptyFile;
    }

    @Override
    public void append(Cell cell) throws IOException {
        Map.Entry<Long, StoreFile.Writer> entry = this.lowerBoundary2Writer.floorEntry(cell.getTimestamp());
        StoreFile.Writer writer = entry.getValue();
        if (writer == null) {
            writer = this.writerFactory.createWriter();
            this.lowerBoundary2Writer.put(entry.getKey(), writer);
        }
        writer.append(cell);
    }

    @Override
    protected Collection<StoreFile.Writer> writers() {
        return this.lowerBoundary2Writer.values();
    }

    @Override
    protected void preCommitWriters() throws IOException {
        if (!this.needEmptyFile) {
            return;
        }
        for (StoreFile.Writer writer : this.lowerBoundary2Writer.values()) {
            if (writer == null) continue;
            return;
        }
        this.lowerBoundary2Writer.put((Long)this.lowerBoundary2Writer.firstKey(), this.writerFactory.createWriter());
    }
}

