/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;

@InterfaceAudience.Private
abstract class StoreFlusher {
    protected Configuration conf;
    protected Store store;

    public StoreFlusher(Configuration conf, Store store) {
        this.conf = conf;
        this.store = store;
    }

    public abstract List<Path> flushSnapshot(MemStoreSnapshot var1, long var2, MonitoredTask var4, ThroughputController var5) throws IOException;

    protected void finalizeWriter(StoreFile.Writer writer, long cacheFlushSeqNum, MonitoredTask status) throws IOException {
        status.setStatus("Flushing " + this.store + ": appending metadata");
        writer.appendMetadata(cacheFlushSeqNum, false);
        status.setStatus("Flushing " + this.store + ": closing flushed file");
        writer.close();
    }

    protected InternalScanner createScanner(KeyValueScanner snapshotScanner, long smallestReadPoint) throws IOException {
        InternalScanner scanner = null;
        if (this.store.getCoprocessorHost() != null) {
            scanner = this.store.getCoprocessorHost().preFlushScannerOpen(this.store, snapshotScanner);
        }
        if (scanner == null) {
            Scan scan = new Scan();
            scan.setMaxVersions(this.store.getScanInfo().getMaxVersions());
            scanner = new StoreScanner(this.store, this.store.getScanInfo(), scan, Collections.singletonList(snapshotScanner), ScanType.COMPACT_RETAIN_DELETES, smallestReadPoint, Long.MIN_VALUE);
        }
        assert (scanner != null);
        if (this.store.getCoprocessorHost() != null) {
            try {
                return this.store.getCoprocessorHost().preFlush(this.store, scanner);
            }
            catch (IOException ioe) {
                scanner.close();
                throw ioe;
            }
        }
        return scanner;
    }

    protected void performFlush(InternalScanner scanner, Compactor.CellSink sink, long smallestReadPoint, ThroughputController throughputController) throws IOException {
        boolean control;
        int compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(compactionKVMax).build();
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        String flushName = ThroughputControlUtil.getNameForThrottling(this.store, "flush");
        boolean bl = control = throughputController != null && !this.store.getRegionInfo().isSystemTable();
        if (control) {
            throughputController.start(flushName);
        }
        try {
            boolean hasMore;
            do {
                hasMore = scanner.next(kvs, scannerContext);
                if (kvs.isEmpty()) continue;
                for (Cell c : kvs) {
                    sink.append(c);
                    int len = KeyValueUtil.length((Cell)c);
                    if (!control) continue;
                    throughputController.control(flushName, len);
                }
                kvs.clear();
            } while (hasMore);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while control throughput of flushing " + flushName);
        }
        finally {
            if (control) {
                throughputController.finish(flushName);
            }
        }
    }
}

