/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;

@InterfaceAudience.Private
public class ExploringCompactionPolicy
extends RatioBasedCompactionPolicy {
    private static final Log LOG = LogFactory.getLog(ExploringCompactionPolicy.class);

    public ExploringCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
        super(conf, storeConfigInfo);
    }

    @Override
    protected final ArrayList<StoreFile> applyCompactionPolicy(ArrayList<StoreFile> candidates, boolean mayUseOffPeak, boolean mightBeStuck) throws IOException {
        return new ArrayList<StoreFile>(this.applyCompactionPolicy(candidates, mightBeStuck, mayUseOffPeak, this.comConf.getMinFilesToCompact(), this.comConf.getMaxFilesToCompact()));
    }

    public List<StoreFile> applyCompactionPolicy(List<StoreFile> candidates, boolean mightBeStuck, boolean mayUseOffPeak, int minFiles, int maxFiles) {
        double currentRatio = mayUseOffPeak ? this.comConf.getCompactionRatioOffPeak() : this.comConf.getCompactionRatio();
        List<StoreFile> bestSelection = new ArrayList<StoreFile>(0);
        List<Object> smallest = mightBeStuck ? new ArrayList(0) : null;
        long bestSize = 0L;
        long smallestSize = Long.MAX_VALUE;
        int opts = 0;
        int optsInRatio = 0;
        int bestStart = -1;
        for (int start = 0; start < candidates.size(); ++start) {
            for (int currentEnd = start + minFiles - 1; currentEnd < candidates.size(); ++currentEnd) {
                List<StoreFile> potentialMatchFiles = candidates.subList(start, currentEnd + 1);
                if (potentialMatchFiles.size() < minFiles || potentialMatchFiles.size() > maxFiles) continue;
                long size = this.getTotalStoreSize(potentialMatchFiles);
                if (mightBeStuck && size < smallestSize) {
                    smallest = potentialMatchFiles;
                    smallestSize = size;
                }
                if (size > this.comConf.getMaxCompactSize(mayUseOffPeak)) continue;
                ++opts;
                if (size >= this.comConf.getMinCompactSize() && !this.filesInRatio(potentialMatchFiles, currentRatio)) continue;
                ++optsInRatio;
                if (!this.isBetterSelection(bestSelection, bestSize, potentialMatchFiles, size, mightBeStuck)) continue;
                bestSelection = potentialMatchFiles;
                bestSize = size;
                bestStart = start;
            }
        }
        if (bestSelection.size() == 0 && mightBeStuck) {
            LOG.debug((Object)("Exploring compaction algorithm has selected " + smallest.size() + " files of size " + smallestSize + " because the store might be stuck"));
            return new ArrayList<StoreFile>(smallest);
        }
        LOG.debug((Object)("Exploring compaction algorithm has selected " + bestSelection.size() + " files of size " + bestSize + " starting at candidate #" + bestStart + " after considering " + opts + " permutations with " + optsInRatio + " in ratio"));
        return new ArrayList<StoreFile>(bestSelection);
    }

    private boolean isBetterSelection(List<StoreFile> bestSelection, long bestSize, List<StoreFile> selection, long size, boolean mightBeStuck) {
        if (mightBeStuck && bestSize > 0L && size > 0L) {
            double REPLACE_IF_BETTER_BY = 1.05;
            double thresholdQuality = (double)bestSelection.size() / (double)bestSize * 1.05;
            return thresholdQuality < (double)selection.size() / (double)size;
        }
        return selection.size() > bestSelection.size() || selection.size() == bestSelection.size() && size < bestSize;
    }

    private long getTotalStoreSize(List<StoreFile> potentialMatchFiles) {
        long size = 0L;
        for (StoreFile s : potentialMatchFiles) {
            size += s.getReader().length();
        }
        return size;
    }

    private boolean filesInRatio(List<StoreFile> files, double currentRatio) {
        if (files.size() < 2) {
            return true;
        }
        long totalFileSize = this.getTotalStoreSize(files);
        for (StoreFile file : files) {
            long sumAllOtherFileSizes;
            long singleFileSize = file.getReader().length();
            if (!((double)singleFileSize > (double)(sumAllOtherFileSizes = totalFileSize - singleFileSize) * currentRatio)) continue;
            return false;
        }
        return true;
    }
}

