/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;

@Deprecated
public class FSTableDescriptorMigrationToSubdir {
    private static final Log LOG = LogFactory.getLog(FSTableDescriptorMigrationToSubdir.class);

    public static void migrateFSTableDescriptorsIfNecessary(FileSystem fs, Path rootDir) throws IOException {
        if (FSTableDescriptorMigrationToSubdir.needsMigration(fs, rootDir)) {
            FSTableDescriptorMigrationToSubdir.migrateFsTableDescriptors(fs, rootDir);
            LOG.info((Object)"Migration complete.");
        }
    }

    private static boolean needsMigration(FileSystem fs, Path rootDir) throws IOException {
        Path metaTableDir = FSUtils.getTableDir(rootDir, TableName.META_TABLE_NAME);
        FileStatus metaTableInfoStatus = FSTableDescriptors.getTableInfoPath(fs, metaTableDir);
        return metaTableInfoStatus == null;
    }

    private static void migrateFsTableDescriptors(FileSystem fs, Path rootDir) throws IOException {
        Path snapshotsDir = SnapshotDescriptionUtils.getSnapshotsDir(rootDir);
        if (fs.exists(snapshotsDir)) {
            FileStatus[] snapshots;
            LOG.info((Object)"Migrating snapshots");
            for (FileStatus snapshot : snapshots = fs.listStatus(snapshotsDir, (PathFilter)new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(fs))) {
                FSTableDescriptorMigrationToSubdir.migrateTable(fs, snapshot.getPath());
            }
        }
        LOG.info((Object)"Migrating user tables");
        List<Path> userTableDirs = FSUtils.getTableDirs(fs, rootDir);
        for (Path userTableDir : userTableDirs) {
            FSTableDescriptorMigrationToSubdir.migrateTable(fs, userTableDir);
        }
        LOG.info((Object)"Migrating system tables");
        FSTableDescriptorMigrationToSubdir.migrateTableIfExists(fs, rootDir, TableName.META_TABLE_NAME);
    }

    private static void migrateTableIfExists(FileSystem fs, Path rootDir, TableName tableName) throws IOException {
        Path tableDir = FSUtils.getTableDir(rootDir, tableName);
        if (fs.exists(tableDir)) {
            FSTableDescriptorMigrationToSubdir.migrateTable(fs, tableDir);
        }
    }

    private static void migrateTable(FileSystem fs, Path tableDir) throws IOException {
        Path newTableInfoPath;
        boolean createdSubdir;
        FileStatus oldTableStatus = FSTableDescriptors.getCurrentTableInfoStatus(fs, tableDir, true);
        if (oldTableStatus == null) {
            LOG.debug((Object)("No table info file to migrate for " + tableDir));
            return;
        }
        Path tableInfoDir = new Path(tableDir, ".tabledesc");
        boolean removedExistingSubdir = FSUtils.deleteDirectory(fs, tableInfoDir);
        if (removedExistingSubdir) {
            LOG.info((Object)("Removed existing subdir at: " + tableInfoDir));
        }
        if (!(createdSubdir = fs.mkdirs(tableInfoDir))) {
            throw new IOException("Unable to create new table info directory: " + tableInfoDir);
        }
        Path oldTableInfoPath = oldTableStatus.getPath();
        boolean renamedInfoFile = fs.rename(oldTableInfoPath, newTableInfoPath = new Path(tableInfoDir, oldTableInfoPath.getName()));
        if (!renamedInfoFile) {
            throw new IOException("Failed to move table info file from old location: " + oldTableInfoPath + " to new location: " + newTableInfoPath);
        }
        LOG.info((Object)("Migrated table info from: " + oldTableInfoPath + " to new location: " + newTableInfoPath));
    }
}

